/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XrmQGetSearchResource(list, name, class, type_return, value)
 *   XrmHashTable *list;
 *   XrmName name;
 *   XrmClass class;
 *   XrmRepresentation *type_return;
 *   XrmValue *value;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmQGetSearchResource	1
char    *TestName = "XrmQGetSearchResource";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmQGetSearchResource function
 */
static XrmHashTable *list;
static XrmName name;
static XrmClass class;
static XrmRepresentation *type_return;
static XrmValue *value;


static	XrmRepresentation type;
static	XrmValue val;
static 	XrmDatabase	dbase;

#define XQGSR_ARRAY_SIZE 10
static	XrmHashTable	sl[XQGSR_ARRAY_SIZE];
static	XrmName	nl[XQGSR_ARRAY_SIZE];
static	XrmClass	cl[XQGSR_ARRAY_SIZE];

/* Database data */
#define XQGSR_T1_DATA	5
static	char	*t1_data[XQGSR_T1_DATA] = {
	"applic.window.background:blue",
	"Applic.window.BackGround:cyan",
	"applic.Window.background:magenta",
	"Applic.Window.BackGround:orange",
	"Applic.Window.Unimportant:pink" };

/* Searchlist data */
#define XQGSR_T1_SEARCH	2
static	char	*t1_search[XQGSR_T1_SEARCH][2] = {
	{ "applic", "Applic" },
	{ "window",	"Window" } };

/* SearchResource tests */
#define XQGSR_T1_TESTS	3
static char *t1_tests[XQGSR_T1_TESTS][3] = {
	{ "background",	"BackGround",	"blue"	},
	{ "border",	"BackGround",	"cyan"	},
	{ "misc",	"Unimportant",	"pink"	} };

#define XQGSR_T2_TESTS  1
static char *t2_tests[XQGSR_T2_TESTS][2] = {
	{ "nomatch", "Nomatch" } };


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	list = sl;
	name = 0;
	class = 0;
	type_return = &type;
	value = &val;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int a;
XrmRepresentation exp_type;
Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmQGetSearchResource-1.(A)");
	report_assertion("When name and class fully identify a resource which is");
	report_assertion("contained in the specified database levels list, then a");
	report_assertion("call to XrmQGetSearchResource shall return the type in");
	report_assertion("type_return and the value in value_return of the first");
	report_assertion("match, and return True.");

	report_strategy("Create a database containing testable resource/value pairs.");
	report_strategy("Call XrmQGetSearchList to build up the search list.");
	report_strategy("Call XrmQGetSearchResource to retrieve information.");
	report_strategy("Verify the retrieved information was correct.");

	tpstartup();
	setargs();
	/* Create a database containing testable resource/value pairs. */
	dbase=(XrmDatabase)NULL;
	for(a=0; a<XQGSR_T1_DATA; a++) {
		CHECK;
		XrmPutLineResource(&dbase, t1_data[a]);
	}

#ifdef TESTING
	XrmPutFileDatabase(dbase, "xqgsr_one");
#endif

	/* Call XrmQGetSearchList to build up the search list. */
	for(a=0; a<XQGSR_T1_SEARCH; a++) {
		CHECK;
		nl[a]=XrmStringToName(t1_search[a][0]);
		cl[a]=XrmStringToClass(t1_search[a][1]);
	}
	nl[XQGSR_T1_SEARCH]=(XrmName)0;
	cl[XQGSR_T1_SEARCH]=(XrmClass)0;

	if(!XrmQGetSearchList(dbase, nl, cl, sl, XQGSR_ARRAY_SIZE)) {
		delete("XrmQGetSearchList unexpectedly exhausted the allocated space for table.");
		return;
	}
	else
		CHECK;

	exp_type = XrmStringToRepresentation("String");
	for (a=0; a<XQGSR_T1_TESTS; a++)
	{

	/* Call xname to retrieve information. */
		name = XrmStringToName(t1_tests[a][0]);
		class= XrmStringToClass(t1_tests[a][1]);
		type = (XrmRepresentation)0;
		val.addr = NULL;
		val.size = 0;
		startcall(Dsp);
		if (isdeleted())
			return;
		ret = XrmQGetSearchResource(list, name, class, type_return, value);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

/* Verify the retrieved information was correct. */
		if(ret != True) {
			FAIL;
			report("%s returned False when expecting a database match.",
				TestName);
		} else {
			if (type != exp_type) {
				char *rt;

				FAIL;
				report("%s returned unexpected type.", TestName);
				report("Name (class): %s (%s)", t1_tests[a][0], t1_tests[a][1]);
				report("Expected type: String");
				rt=XrmRepresentationToString(type);
				report("Returned type: %s", (rt==NULL?"<NULL STRING":rt));
			} else
				CHECK;

			if (val.addr==NULL ||
				strncmp((char*)val.addr, t1_tests[a][2],
					strlen(t1_tests[a][2]))) {
				FAIL;
				report("%s returned unexpected value", TestName);
				report("Name (class): %s (%s)", t1_tests[a][0], t1_tests[a][1]);
				report("Expected value: %s", t1_tests[a][2]);
				if (val.addr==NULL) {
					report("Returned value: <NULL POINTER>");
				} else {
					report("Returned value: %.*s",
						val.size,
						(char *)val.addr);
				}
			}
			else
				CHECK;
		}
	}

	CHECKPASS(1+XQGSR_T1_DATA+XQGSR_T1_SEARCH+XQGSR_T1_TESTS*2);

	XrmDestroyDatabase(dbase);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int a;
Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmQGetSearchResource-2.(A)");
	report_assertion("When name and class fully identify a resource which is not");
	report_assertion("contained in the specified database levels list, then a");
	report_assertion("call to XrmQGetSearchResource shall return False.");

	report_strategy("Create a database containing testable resource/value pairs.");
	report_strategy("Call XrmQGetSearchList to build up the search list.");
	report_strategy("Call XrmQGetSearchResource to retrieve information.");
	report_strategy("Verify there was no match.");

	tpstartup();
	setargs();
/* Create a database containing testable resource/value pairs. */
	dbase=(XrmDatabase)NULL;
	for(a=0; a<XQGSR_T1_DATA; a++) {
		CHECK;
		XrmPutLineResource(&dbase, t1_data[a]);
	}

#ifdef TESTING
	XrmPutFileDatabase(dbase, "xqgsr_two");
#endif

/* Call XrmQGetSearchList to build up the search list. */
	for(a=0; a<XQGSR_T1_SEARCH; a++) {
		CHECK;
		nl[a]=XrmStringToName(t1_search[a][0]);
		cl[a]=XrmStringToClass(t1_search[a][1]);
	}
	nl[XQGSR_T1_SEARCH]=(XrmName)0;
	cl[XQGSR_T1_SEARCH]=(XrmClass)0;

	if (!XrmQGetSearchList(dbase, nl, cl, sl, XQGSR_ARRAY_SIZE))
	{
		delete("XrmQGetSearchList unexpectedly exhausted the allocated space for table.");
		return;
	}
	else
		CHECK;

	for (a=0; a < XQGSR_T2_TESTS; a++)
	{

		/* Call xname to retrieve information. */
		name = XrmStringToName(t2_tests[a][0]);
		class= XrmStringToClass(t2_tests[a][1]);
		type = (XrmRepresentation)0;
		val.addr = NULL;
		val.size = 0;
		startcall(Dsp);
		if (isdeleted())
			return;
		ret = XrmQGetSearchResource(list, name, class, type_return, value);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		/* Verify there was no match. */
		if (ret != False)
		{
			char *rt;

			FAIL;
			report("%s returned True when expecting no match.",
				TestName);
			report("Name (class): %s (%s)", t2_tests[a][0], t2_tests[a][1]);
			rt=XrmRepresentationToString(type);
			report("Returned type: %s", (rt==NULL?"<NULL STRING":rt));
			if (val.addr==NULL) {
				report("Returned value: <NULL POINTER>");
			} else {
				report("Returned value: %.*s",
					val.size,
					(char *)val.addr);
			}
		}
		else
			CHECK;
	}

	CHECKPASS(1+XQGSR_T1_DATA+XQGSR_T1_SEARCH+XQGSR_T2_TESTS);

	XrmDestroyDatabase(dbase);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
