/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAppProcessEvent()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
Widget labelw_msg;

extern char *event_names[];
XtInputId input_ret;
char *msg = "Hello World";
FILE *fid;
/* Procedure XtIOP_Proc */
void XtIOP_Proc(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	avs_set_event(3,1);
	XtRemoveInput(*id);
}

/*
** XtEVT_Proc
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event; 
Boolean *continue_to_dispatch;
{
	if (event->type == ButtonPress)
		avs_set_event(1,1);
	else {
		sprintf(ebuf, "ERROR: Expected ButtonPress event Received %s", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
void XtEVT_Proc2(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
XKeyEvent *tevent;

	tevent = (XKeyEvent *)event;

	tet_infoline("TEST: Event timestamp returned by XtLastTimestampProcessed");
	if (tevent->time != XtLastTimestampProcessed(XtDisplay(w))) {
		sprintf(ebuf, "ERROR: event->time = %ld, XtLastTimestampProcessed returned %ld", (unsigned long)tevent->time, (unsigned long)XtLastTimestampProcessed(XtDisplay(w)));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (event->type == ButtonPress )
		avs_set_event(1, 1); 
	if (event->type == ButtonRelease )
		avs_set_event(2, 1); 
	if (event->type == KeyPress )
		avs_set_event(3, 1); 
	if (event->type == KeyRelease )
		avs_set_event(4, 1); 
}
/* procedure XtTMO_Proc */
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	avs_set_event(2,1);
	exit(0);
}
void XtTMO_Proc1(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}
void XtTMO_Proc5(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("PREP: Send events");
	send_event_time(labelw_msg, ButtonPress, ButtonPressMask, TRUE, 1);
	send_event_time(labelw_msg, ButtonRelease, ButtonReleaseMask, TRUE, 2);
	send_event_time(labelw_msg, KeyRelease, KeyReleaseMask, TRUE, 3);
	send_event_time(labelw_msg, KeyPress, KeyPressMask, TRUE, 4);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc1, topLevel);
}


#define T_XtAppProcessEvent	1
char    *TestName = "XtAppProcessEvent";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *msg = "Event widget";
pid_t pid2;
int status;
Display *display;
XEvent loop_event;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppProcessEvent-1.(A)");
	report_assertion("A successful call to void XtAppProcessEvent(app_context,");
	report_assertion("mask) when mask has only the XtIMXEvent mask set, there is");
	report_assertion("at least one pending X event to be processed for the");
	report_assertion("specified application context, and the widget to which the");
	report_assertion("event is to be dispatched has no input method registered for");
	report_assertion("this event shall call the event handler for this widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapprcevt1", "XtAppProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 "some data"
	);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress to widget labelw_msg");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("PREP: Call XtAppProcessEvent to process it");
	while (XtAppPending(app_ctext) == XtIMXEvent)
		XtAppProcessEvent(app_ctext, XtIMXEvent);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Procedure XtEVT_Proc was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "XtEVT_Proc invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11390 */
/* End of included file Mdefcode.tmc.11390 */

/* Including from file Mdefcode.tmc.11390 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppProcessEvent-2.(B)");
	report_assertion("A successful call to void XtAppProcessEvent(app_context,");
	report_assertion("mask) when mask has only the XtIMXEvent mask set, there is");
	report_assertion("at least one pending X event to be processed for the");
	report_assertion("specified application context, and the widget to which the");
	report_assertion("event is to be dispatched has no event handler registered");
	report_assertion("shall ignore the event.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11390 */

static void t003(){

char *msg = "Event widget";
pid_t pid2;
int status;
Display *display;
XEvent loop_event;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppProcessEvent-3.(A)");
	report_assertion("A successful call to void XtAppProcessEvent(app_context,");
	report_assertion("mask) when mask has only the XtIMTimer mask set and there is");
	report_assertion("at least one pending timer to be processed for the specified");
	report_assertion("application context shall call the callback procedure");
	report_assertion("registered for the timer.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapprcevt1", "XtAppProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Call XtAppProcessEvent");
	XtAppProcessEvent(app_ctext, XtIMTimer);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Timeout procedure was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11390 */
/* End of included file Mdefcode.tmc.11390 */

static void t004(){

char *msg = "Event widget";
pid_t pid2;
int status;
Display *display;
XEvent loop_event;
char *data;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppProcessEvent-4.(A)");
	report_assertion("A successful call to void XtAppProcessEvent(app_context,");
	report_assertion("mask) when mask has only the XtIMAlternateInput mask set and");
	report_assertion("there is at least one pending input source to be processed");
	report_assertion("for the specified application context shall call the");
	report_assertion("callback procedure registered for the input source.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	data = "tapprcevt.dat";
	FORK(pid2);
	avs_xt_hier("Tapprcevt1", "XtAppProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	sprintf(ebuf, "PREP: Open file %s for write", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputWriteMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Call XtAppProcessEvent");
	XtAppProcessEvent(app_ctext, XtIMAlternateInput);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Procedure was invoked");
	status = avs_get_event(3);
	check_dec(1, status, "invocation count");
	unlink(data);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11390 */
/* End of included file Mdefcode.tmc.11390 */

static void t005(){

char *msg = "Event widget";
pid_t pid2;
int status;
Display *display;
XEvent loop_event;
char *data;
int i;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppProcessEvent-5.(A)");
	report_assertion("A successful call to void XtAppProcessEvent(app_context,");
	report_assertion("mask) when mask is the bitwise inclusive OR of any");
	report_assertion("combination of XtIMXEvent, XtIMTimer, and XtIMAlternateInput");
	report_assertion("shall process any one event or input of the specified types.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	data = "tapprcevt.dat";
	FORK(pid2);
	avs_xt_hier("Tapprcevt1", "XtAppProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	sprintf(ebuf, "PREP: Open file %s for write", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputWriteMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 "some data"
	);
	tet_infoline("PREP: Send ButtonPress to widget labelw_msg");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("PREP: Call XtAppProcessEvent");
	for (i=1;i==1;)
		XtAppProcessEvent(app_ctext, XtIMAlternateInput|XtIMXEvent|XtIMTimer);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Alternate input procedure was invoked");
	status = avs_get_event(3);
	check_dec(1, status, "invocation count");
	tet_infoline("TEST: Timeout procedure was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "invocation count");
	tet_infoline("TEST: Event handler was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "invocation count");
	unlink(data);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11390 */
/* End of included file Mdefcode.tmc.11390 */

static void t006(){

char *msg = "Event widget";
pid_t pid2;
int status;
Display *display;
XEvent loop_event;
char *data;
int i;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtAppProcessEvent-6.(A)");
	report_assertion("A successful call to void XtAppProcessEvent(app_context,");
	report_assertion("mask) when mask is XtIMAll shall be equivalent to a call");
	report_assertion("with mask set to a bitwise inclusive OR of XtIMXEvent,");
	report_assertion("XtIMTimer, and XtIMAlternateInput.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	data = "tapprcevt.dat";
	FORK(pid2);
	avs_xt_hier("Tapprcevt1", "XtAppProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	sprintf(ebuf, "PREP: Open file %s for write", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputWriteMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 "some data"
	);
	tet_infoline("PREP: Send ButtonPress to widget labelw_msg");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("PREP: Call XtAppProcessEvent");
	for (i=1;i==1;)
		XtAppProcessEvent(app_ctext, XtIMAll);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Alternate input procedure was invoked");
	status = avs_get_event(3);
	check_dec(1, status, "invocation count");
	tet_infoline("TEST: Timeout procedure was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "invocation count");
	tet_infoline("TEST: Event handler was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "invocation count");
	unlink(data);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11390 */
/* End of included file Mdefcode.tmc.11390 */

static void t007(){

char *msg = "Event widget";
pid_t pid2;
int status;
Display *display;
XEvent loop_event;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtAppProcessEvent-7.(A)");
	report_assertion("A successful call to void XtAppProcessEvent(app_context,");
	report_assertion("mask) when there are no events or inputs of the specified");
	report_assertion("types to be processed shall block until an appropriate event");
	report_assertion("or input is available.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapprcevt1", "XtAppProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: XtAppProcessEvent does not return until timer expiration");
	XtAppProcessEvent(app_ctext, XtIMTimer);
	tet_infoline("ERROR: XtAppProcessEvent returned before processing timeout");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Timeout procedure was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11390 */
/* End of included file Mdefcode.tmc.11390 */

/* Including from file Mdefcode.tmc.11390 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtAppProcessEvent-8.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to void XtAppProcessEvent(app_context, mask) when mask has");
	report_assertion("only the XtIMXEvent mask set, there is at least one pending");
	report_assertion("X event to be processed for the specified application");
	report_assertion("context, and the widget to which the event is to be");
	report_assertion("dispatched has an input method for this event shall not");
	report_assertion("dispatch the event to the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11390 */

static void t009(){

char *msg = "Event widget";
pid_t pid2;
int status;
Display *display;
XEvent loop_event;
int i;
int invoked;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtAppProcessEvent-9.(A)");
	report_assertion("When an event for a widget in the application context");
	report_assertion("app_context is a KeyPress, KeyRelease, ButtonPress,");
	report_assertion("ButtonRelease, MotionNotify, EnterNotify, LeaveNotify,");
	report_assertion("PropertyNotify or a SelectionClear event a call to void");
	report_assertion("XtAppProcessEvent(app_context, mask) shall record the");
	report_assertion("timestamp from the event as the last timestamp value that");
	report_assertion("will be returned by the next call to");
	report_assertion("XtLastTimestampProcessed.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapprcevt1", "XtAppProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc2 to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask|ButtonReleaseMask|KeyPressMask|KeyReleaseMask,
		 False,
		 XtEVT_Proc2,
		 "some data"
	);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure which will cause event");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc5, topLevel);
	tet_infoline("TEST: Call XtAppProcessEvent");
	for (i=1;i==1;)
		XtAppProcessEvent(app_ctext, XtIMAll);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Events were received");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "Handler invocation for ButtonPress count");
	invoked = avs_get_event(2);
	check_dec(1, invoked, "Handler invocation for ButtonRelease count");
	invoked = avs_get_event(3);
	check_dec(1, invoked, "Handler invocation for KeyPress count");
	invoked = avs_get_event(4);
	check_dec(1, invoked, "Handler invocation for KeyRelease count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11390 */
/* End of included file Mdefcode.tmc.11390 */

/* Including from file Mdefcode.tmc.11390 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtAppProcessEvent-10.(D)");
	report_assertion("If the implementation is X11R5 or later: When an event in");
	report_assertion("the application context app_context is a remap event, a");
	report_assertion("modal cascade exists that has a widget with spring_loaded");
	report_assertion("field set to True, and no event input filter has been");
	report_assertion("registered for the spring-loaded widget window on the");
	report_assertion("specified event a call to void");
	report_assertion("XtAppProcessEvent(app_context, mask) shall dispatch the");
	report_assertion("event to the spring-loaded widget after a dispatch to the");
	report_assertion("widget to which the event belonged.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11390 */

/* Including from file Mdefcode.tmc.11390 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtAppProcessEvent-11.(D)");
	report_assertion("If the implementation is X11R5 or later: When an event in");
	report_assertion("the application context app_context is a remap event, a");
	report_assertion("modal cascade exists that has a widget with spring_loaded");
	report_assertion("field set to True, and an event input filter has been");
	report_assertion("registered for the spring-loaded widget window on the");
	report_assertion("specified event a call to void");
	report_assertion("XtAppProcessEvent(app_context, mask) shall not dispatch the");
	report_assertion("event to the spring-loaded widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11390 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
