/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_RELEASE_MEM},
	{590, PKT3_ONE_REG_WRITE},
	{604, PKT3_ACQUIRE_MEM},
	{616, PKT3_SET_CONFIG_REG},
	{631, PKT3_SET_CONTEXT_REG},
	{647, PKT3_SET_SH_REG},
	{658, PKT3_SET_SH_REG_OFFSET},
	{676, PKT3_SET_UCONFIG_REG},
	{692, PKT3_LOAD_CONST_RAM},
	{707, PKT3_WRITE_CONST_RAM},
	{723, PKT3_DUMP_CONST_RAM},
	{738, PKT3_INCREMENT_CE_COUNTER},
	{759, PKT3_INCREMENT_DE_COUNTER},
	{780, PKT3_WAIT_ON_CE_COUNTER},
	{799, PKT3_IT_OPCODE_C},
	{811, PKT3_CP_DMA},
	{818, PKT3_DMA_DATA},
};

static const struct si_reg sid_reg_table[] = {
	{827, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{842, R_371_DST_ADDR_LO},
	{854, R_372_DST_ADDR_HI},
	{866, R_3F0_IB_BASE_LO},
	{877, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{888, R_410_CP_DMA_WORD0, 1, 9},
	{901, R_411_CP_DMA_WORD1, 5, 10},
	{914, R_412_CP_DMA_WORD2, 1, 15},
	{927, R_413_CP_DMA_WORD3, 1, 16},
	{940, R_414_COMMAND, 11, 17},
	{948, R_500_DMA_DATA_WORD0, 6, 28},
	{963, R_501_SRC_ADDR_LO},
	{975, R_502_SRC_ADDR_HI},
	{842, R_503_DST_ADDR_LO},
	{854, R_504_DST_ADDR_HI},
	{987, R_000E4C_SRBM_STATUS2, 21, 34},
	{1000, R_000E50_SRBM_STATUS, 20, 55},
	{1012, R_000E54_SRBM_STATUS3, 16, 75},
	{1025, R_00D034_SDMA0_STATUS_REG, 29, 91},
	{1042, R_00D834_SDMA1_STATUS_REG, 29, 91},
	{1059, R_008008_GRBM_STATUS2, 18, 120},
	{1072, R_008010_GRBM_STATUS, 24, 138},
	{1084, R_00802C_GRBM_GFX_INDEX, 6, 162},
	{1099, R_0084FC_CP_STRMOUT_CNTL, 1, 168},
	{1115, R_0085F0_CP_COHER_CNTL, 19, 169},
	{1129, R_0085F4_CP_COHER_SIZE},
	{1143, R_0085F8_CP_COHER_BASE},
	{1157, R_008014_GRBM_STATUS_SE0, 11, 188},
	{1173, R_008018_GRBM_STATUS_SE1, 11, 199},
	{1189, R_008038_GRBM_STATUS_SE2, 11, 210},
	{1205, R_00803C_GRBM_STATUS_SE3, 11, 221},
	{1099, R_0300FC_CP_STRMOUT_CNTL, 1, 232},
	{1221, R_0301E4_CP_COHER_BASE_HI, 1, 233},
	{1238, R_0301EC_CP_COHER_START_DELAY, 1, 234},
	{1115, R_0301F0_CP_COHER_CNTL, 27, 235},
	{1129, R_0301F4_CP_COHER_SIZE},
	{1143, R_0301F8_CP_COHER_BASE},
	{1259, R_0301FC_CP_COHER_STATUS, 4, 262},
	{1275, R_008210_CP_CPC_STATUS, 15, 266},
	{1289, R_008214_CP_CPC_BUSY_STAT, 28, 281},
	{1306, R_008218_CP_CPC_STALLED_STAT1, 14, 309},
	{1327, R_00821C_CP_CPF_STATUS, 21, 323},
	{1341, R_008220_CP_CPF_BUSY_STAT, 31, 344},
	{1358, R_008224_CP_CPF_STALLED_STAT1, 9, 375},
	{1379, R_030230_CP_COHER_SIZE_HI, 1, 384},
	{1396, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 385},
	{1419, R_0088C4_VGT_CACHE_INVALIDATION, 3, 386},
	{1442, R_0088C8_VGT_ESGS_RING_SIZE},
	{1461, R_0088CC_VGT_GSVS_RING_SIZE},
	{1480, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 389},
	{1500, R_008958_VGT_PRIMITIVE_TYPE, 1, 390},
	{1519, R_00895C_VGT_INDEX_TYPE, 1, 391},
	{1534, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1567, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1600, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1633, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1666, R_008970_VGT_NUM_INDICES},
	{1682, R_008974_VGT_NUM_INSTANCES},
	{1700, R_008988_VGT_TF_RING_SIZE, 1, 392},
	{1717, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 393},
	{1738, R_0089B8_VGT_TF_MEMORY_BASE},
	{1757, R_008A14_PA_CL_ENHANCE, 4, 394},
	{1771, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 398},
	{1796, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 399},
	{1821, R_008670_CP_STALLED_STAT3, 19, 401},
	{1838, R_008674_CP_STALLED_STAT1, 16, 420},
	{1855, R_008678_CP_STALLED_STAT2, 29, 436},
	{1872, R_008680_CP_STAT, 23, 465},
	{1084, R_030800_GRBM_GFX_INDEX, 6, 488},
	{1442, R_030900_VGT_ESGS_RING_SIZE},
	{1461, R_030904_VGT_GSVS_RING_SIZE},
	{1500, R_030908_VGT_PRIMITIVE_TYPE, 1, 494},
	{1519, R_03090C_VGT_INDEX_TYPE, 1, 495},
	{1534, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1567, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1600, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1633, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1666, R_030930_VGT_NUM_INDICES},
	{1682, R_030934_VGT_NUM_INSTANCES},
	{1700, R_030938_VGT_TF_RING_SIZE, 1, 496},
	{1717, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 497},
	{1738, R_030940_VGT_TF_MEMORY_BASE},
	{1771, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 499},
	{1796, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 500},
	{1880, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 502},
	{1906, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 504},
	{1932, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 506},
	{1958, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 508},
	{1984, R_008BF0_PA_SC_ENHANCE, 9, 510},
	{1998, R_008C08_SQC_CACHES, 2, 519},
	{1998, R_030D20_SQC_CACHES, 3, 521},
	{2009, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 524},
	{2028, R_008DFC_SQ_EXP_0, 6, 527},
	{2037, R_030E00_TA_CS_BC_BASE_ADDR},
	{2056, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 533},
	{2078, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{2102, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 534},
	{2125, R_008F00_SQ_BUF_RSRC_WORD0},
	{2143, R_008F04_SQ_BUF_RSRC_WORD1, 4, 535},
	{2161, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{2185, R_008F08_SQ_BUF_RSRC_WORD2},
	{2203, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 539},
	{2226, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 540},
	{2244, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{2268, R_008F10_SQ_IMG_RSRC_WORD0},
	{2286, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 554},
	{2309, R_008F14_SQ_IMG_RSRC_WORD1, 5, 555},
	{2327, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{2351, R_008F18_SQ_IMG_RSRC_WORD2, 4, 560},
	{2369, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 564},
	{2392, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 565},
	{2410, R_008F20_SQ_IMG_RSRC_WORD4, 2, 576},
	{2428, R_008F24_SQ_IMG_RSRC_WORD5, 2, 578},
	{2446, R_008F28_SQ_IMG_RSRC_WORD6, 8, 580},
	{2464, R_008F2C_SQ_IMG_RSRC_WORD7},
	{2482, R_008F30_SQ_IMG_SAMP_WORD0, 14, 588},
	{2500, R_008F34_SQ_IMG_SAMP_WORD1, 4, 602},
	{2518, R_008F38_SQ_IMG_SAMP_WORD2, 10, 606},
	{2536, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 616},
	{2554, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 619},
	{2574, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 624},
	{2599, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 626},
	{2624, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 628},
	{2649, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 629},
	{2649, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 630},
	{2668, R_0090F0_SPI_ARB_PRIORITY, 3, 631},
	{2668, R_00C700_SPI_ARB_PRIORITY, 8, 634},
	{2685, R_0090F4_SPI_ARB_CYCLES_0, 2, 642},
	{2702, R_0090F8_SPI_ARB_CYCLES_1, 1, 644},
	{2719, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 645},
	{2741, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 646},
	{2763, R_030FF8_DB_ZPASS_COUNT_LOW},
	{2782, R_030FFC_DB_ZPASS_COUNT_HI, 1, 647},
	{2800, R_009100_SPI_CONFIG_CNTL, 5, 648},
	{2816, R_00913C_SPI_CONFIG_CNTL_1, 5, 653},
	{2834, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 658},
	{2037, R_00950C_TA_CS_BC_BASE_ADDR},
	{2863, R_009858_DB_SUBTILE_CONTROL, 10, 670},
	{2882, R_0098F8_GB_ADDR_CONFIG, 9, 680},
	{2897, R_009910_GB_TILE_MODE0, 10, 689},
	{2911, R_009914_GB_TILE_MODE1, 10, 689},
	{2925, R_009918_GB_TILE_MODE2, 10, 689},
	{2939, R_00991C_GB_TILE_MODE3, 10, 689},
	{2953, R_009920_GB_TILE_MODE4, 10, 689},
	{2967, R_009924_GB_TILE_MODE5, 10, 689},
	{2981, R_009928_GB_TILE_MODE6, 10, 689},
	{2995, R_00992C_GB_TILE_MODE7, 10, 689},
	{3009, R_009930_GB_TILE_MODE8, 10, 689},
	{3023, R_009934_GB_TILE_MODE9, 10, 689},
	{3037, R_009938_GB_TILE_MODE10, 10, 689},
	{3052, R_00993C_GB_TILE_MODE11, 10, 689},
	{3067, R_009940_GB_TILE_MODE12, 10, 689},
	{3082, R_009944_GB_TILE_MODE13, 10, 689},
	{3097, R_009948_GB_TILE_MODE14, 10, 689},
	{3112, R_00994C_GB_TILE_MODE15, 10, 689},
	{3127, R_009950_GB_TILE_MODE16, 10, 689},
	{3142, R_009954_GB_TILE_MODE17, 10, 689},
	{3157, R_009958_GB_TILE_MODE18, 10, 689},
	{3172, R_00995C_GB_TILE_MODE19, 10, 689},
	{3187, R_009960_GB_TILE_MODE20, 10, 689},
	{3202, R_009964_GB_TILE_MODE21, 10, 689},
	{3217, R_009968_GB_TILE_MODE22, 10, 689},
	{3232, R_00996C_GB_TILE_MODE23, 10, 689},
	{3247, R_009970_GB_TILE_MODE24, 10, 689},
	{3262, R_009974_GB_TILE_MODE25, 10, 689},
	{3277, R_009978_GB_TILE_MODE26, 10, 689},
	{3292, R_00997C_GB_TILE_MODE27, 10, 689},
	{3307, R_009980_GB_TILE_MODE28, 10, 689},
	{3322, R_009984_GB_TILE_MODE29, 10, 689},
	{3337, R_009988_GB_TILE_MODE30, 10, 689},
	{3352, R_00998C_GB_TILE_MODE31, 10, 689},
	{3367, R_009990_GB_MACROTILE_MODE0, 4, 699},
	{3386, R_009994_GB_MACROTILE_MODE1, 4, 699},
	{3405, R_009998_GB_MACROTILE_MODE2, 4, 699},
	{3424, R_00999C_GB_MACROTILE_MODE3, 4, 699},
	{3443, R_0099A0_GB_MACROTILE_MODE4, 4, 699},
	{3462, R_0099A4_GB_MACROTILE_MODE5, 4, 699},
	{3481, R_0099A8_GB_MACROTILE_MODE6, 4, 699},
	{3500, R_0099AC_GB_MACROTILE_MODE7, 4, 699},
	{3519, R_0099B0_GB_MACROTILE_MODE8, 4, 699},
	{3538, R_0099B4_GB_MACROTILE_MODE9, 4, 699},
	{3557, R_0099B8_GB_MACROTILE_MODE10, 4, 699},
	{3577, R_0099BC_GB_MACROTILE_MODE11, 4, 699},
	{3597, R_0099C0_GB_MACROTILE_MODE12, 4, 699},
	{3617, R_0099C4_GB_MACROTILE_MODE13, 4, 699},
	{3637, R_0099C8_GB_MACROTILE_MODE14, 4, 699},
	{3657, R_0099CC_GB_MACROTILE_MODE15, 4, 699},
	{3677, R_00B000_SPI_SHADER_TBA_LO_PS},
	{3698, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 703},
	{3719, R_00B008_SPI_SHADER_TMA_LO_PS},
	{3740, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 704},
	{3761, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 705},
	{3785, R_00B020_SPI_SHADER_PGM_LO_PS},
	{3806, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 708},
	{3827, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 709},
	{3851, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 720},
	{3875, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{3901, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{3927, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{3953, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{3979, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{4005, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{4031, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{4057, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{4083, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{4109, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{4135, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{4162, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{4189, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{4216, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{4243, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{4270, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{4297, R_00B100_SPI_SHADER_TBA_LO_VS},
	{4318, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 727},
	{4339, R_00B108_SPI_SHADER_TMA_LO_VS},
	{4360, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 728},
	{4381, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 729},
	{4405, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 732},
	{4430, R_00B120_SPI_SHADER_PGM_LO_VS},
	{4451, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 733},
	{4472, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 734},
	{4496, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 746},
	{4520, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{4546, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{4572, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{4598, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{4624, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{4650, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{4676, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{4702, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{4728, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{4754, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{4780, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{4807, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{4834, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{4861, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{4888, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{4915, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{4942, R_00B200_SPI_SHADER_TBA_LO_GS},
	{4963, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 758},
	{4984, R_00B208_SPI_SHADER_TMA_LO_GS},
	{5005, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 759},
	{5026, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 760},
	{5050, R_00B220_SPI_SHADER_PGM_LO_GS},
	{5071, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 764},
	{5092, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 765},
	{5116, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 776},
	{5140, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{5166, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{5192, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{5218, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{5244, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{5270, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{5296, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{5322, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{5348, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{5374, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{5400, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{5427, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{5454, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{5481, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{5508, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{5535, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{5562, R_00B300_SPI_SHADER_TBA_LO_ES},
	{5583, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 781},
	{5604, R_00B308_SPI_SHADER_TMA_LO_ES},
	{5625, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 782},
	{5646, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 783},
	{5670, R_00B320_SPI_SHADER_PGM_LO_ES},
	{5691, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 787},
	{5712, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 788},
	{5736, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 7, 800},
	{5760, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{5786, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{5812, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{5838, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{5864, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{5890, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{5916, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{5942, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{5968, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{5994, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{6020, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{6047, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{6074, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{6101, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{6128, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{6155, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{6182, R_00B400_SPI_SHADER_TBA_LO_HS},
	{6203, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 807},
	{6224, R_00B408_SPI_SHADER_TMA_LO_HS},
	{6245, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 808},
	{6266, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 809},
	{6290, R_00B420_SPI_SHADER_PGM_LO_HS},
	{6311, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 812},
	{6332, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 813},
	{6356, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 823},
	{6380, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{6406, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{6432, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{6458, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{6484, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{6510, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{6536, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{6562, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{6588, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{6614, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{6640, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{6667, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{6694, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{6721, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{6748, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{6775, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{6802, R_00B500_SPI_SHADER_TBA_LO_LS},
	{6823, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 830},
	{6844, R_00B508_SPI_SHADER_TMA_LO_LS},
	{6865, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 831},
	{6886, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 832},
	{6910, R_00B520_SPI_SHADER_PGM_LO_LS},
	{6931, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 836},
	{6952, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 837},
	{6976, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 6, 848},
	{7000, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{7026, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{7052, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{7078, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{7104, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{7130, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{7156, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{7182, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{7208, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{7234, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{7260, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{7287, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{7314, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{7341, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{7368, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{7395, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{7422, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 854},
	{7449, R_00B804_COMPUTE_DIM_X},
	{7463, R_00B808_COMPUTE_DIM_Y},
	{7477, R_00B80C_COMPUTE_DIM_Z},
	{7491, R_00B810_COMPUTE_START_X},
	{7507, R_00B814_COMPUTE_START_Y},
	{7523, R_00B818_COMPUTE_START_Z},
	{7539, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 866},
	{7560, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 868},
	{7581, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 870},
	{7602, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 872},
	{7622, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 873},
	{7650, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 874},
	{7675, R_00B830_COMPUTE_PGM_LO},
	{7690, R_00B834_COMPUTE_PGM_HI, 2, 875},
	{7705, R_00B838_COMPUTE_TBA_LO},
	{7720, R_00B83C_COMPUTE_TBA_HI, 1, 877},
	{7735, R_00B840_COMPUTE_TMA_LO},
	{7750, R_00B844_COMPUTE_TMA_HI, 1, 878},
	{7765, R_00B848_COMPUTE_PGM_RSRC1, 10, 879},
	{7783, R_00B84C_COMPUTE_PGM_RSRC2, 11, 889},
	{7801, R_00B850_COMPUTE_VMID, 1, 900},
	{7814, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 901},
	{7838, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 908},
	{7869, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 910},
	{7900, R_00B860_COMPUTE_TMPRING_SIZE, 2, 912},
	{7921, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 914},
	{7952, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 916},
	{7983, R_00B86C_COMPUTE_RESTART_X},
	{8001, R_00B870_COMPUTE_RESTART_Y},
	{8019, R_00B874_COMPUTE_RESTART_Z},
	{8037, R_00B87C_COMPUTE_MISC_RESERVED, 5, 918},
	{8059, R_00B880_COMPUTE_DISPATCH_ID},
	{8079, R_00B884_COMPUTE_THREADGROUP_ID},
	{8102, R_00B888_COMPUTE_RELAUNCH, 3, 923},
	{8119, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{8148, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 926},
	{8177, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 927},
	{8206, R_00B900_COMPUTE_USER_DATA_0},
	{8226, R_00B904_COMPUTE_USER_DATA_1},
	{8246, R_00B908_COMPUTE_USER_DATA_2},
	{8266, R_00B90C_COMPUTE_USER_DATA_3},
	{8286, R_00B910_COMPUTE_USER_DATA_4},
	{8306, R_00B914_COMPUTE_USER_DATA_5},
	{8326, R_00B918_COMPUTE_USER_DATA_6},
	{8346, R_00B91C_COMPUTE_USER_DATA_7},
	{8366, R_00B920_COMPUTE_USER_DATA_8},
	{8386, R_00B924_COMPUTE_USER_DATA_9},
	{8406, R_00B928_COMPUTE_USER_DATA_10},
	{8427, R_00B92C_COMPUTE_USER_DATA_11},
	{8448, R_00B930_COMPUTE_USER_DATA_12},
	{8469, R_00B934_COMPUTE_USER_DATA_13},
	{8490, R_00B938_COMPUTE_USER_DATA_14},
	{8511, R_00B93C_COMPUTE_USER_DATA_15},
	{8532, R_00B9FC_COMPUTE_NOWHERE},
	{8548, R_034000_CPG_PERFCOUNTER1_LO},
	{8568, R_034004_CPG_PERFCOUNTER1_HI},
	{8588, R_034008_CPG_PERFCOUNTER0_LO},
	{8608, R_03400C_CPG_PERFCOUNTER0_HI},
	{8628, R_034010_CPC_PERFCOUNTER1_LO},
	{8648, R_034014_CPC_PERFCOUNTER1_HI},
	{8668, R_034018_CPC_PERFCOUNTER0_LO},
	{8688, R_03401C_CPC_PERFCOUNTER0_HI},
	{8708, R_034020_CPF_PERFCOUNTER1_LO},
	{8728, R_034024_CPF_PERFCOUNTER1_HI},
	{8748, R_034028_CPF_PERFCOUNTER0_LO},
	{8768, R_03402C_CPF_PERFCOUNTER0_HI},
	{8788, R_034100_GRBM_PERFCOUNTER0_LO},
	{8809, R_034104_GRBM_PERFCOUNTER0_HI},
	{8830, R_03410C_GRBM_PERFCOUNTER1_LO},
	{8851, R_034110_GRBM_PERFCOUNTER1_HI},
	{8872, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{8896, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{8920, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{8944, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{8968, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{8992, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{9016, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{9040, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{9064, R_034200_WD_PERFCOUNTER0_LO},
	{9083, R_034204_WD_PERFCOUNTER0_HI},
	{9102, R_034208_WD_PERFCOUNTER1_LO},
	{9121, R_03420C_WD_PERFCOUNTER1_HI},
	{9140, R_034210_WD_PERFCOUNTER2_LO},
	{9159, R_034214_WD_PERFCOUNTER2_HI},
	{9178, R_034218_WD_PERFCOUNTER3_LO},
	{9197, R_03421C_WD_PERFCOUNTER3_HI},
	{9216, R_034220_IA_PERFCOUNTER0_LO},
	{9235, R_034224_IA_PERFCOUNTER0_HI},
	{9254, R_034228_IA_PERFCOUNTER1_LO},
	{9273, R_03422C_IA_PERFCOUNTER1_HI},
	{9292, R_034230_IA_PERFCOUNTER2_LO},
	{9311, R_034234_IA_PERFCOUNTER2_HI},
	{9330, R_034238_IA_PERFCOUNTER3_LO},
	{9349, R_03423C_IA_PERFCOUNTER3_HI},
	{9368, R_034240_VGT_PERFCOUNTER0_LO},
	{9388, R_034244_VGT_PERFCOUNTER0_HI},
	{9408, R_034248_VGT_PERFCOUNTER1_LO},
	{9428, R_03424C_VGT_PERFCOUNTER1_HI},
	{9448, R_034250_VGT_PERFCOUNTER2_LO},
	{9468, R_034254_VGT_PERFCOUNTER2_HI},
	{9488, R_034258_VGT_PERFCOUNTER3_LO},
	{9508, R_03425C_VGT_PERFCOUNTER3_HI},
	{9528, R_034400_PA_SU_PERFCOUNTER0_LO},
	{9550, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 929},
	{9572, R_034408_PA_SU_PERFCOUNTER1_LO},
	{9594, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 929},
	{9616, R_034410_PA_SU_PERFCOUNTER2_LO},
	{9638, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 929},
	{9660, R_034418_PA_SU_PERFCOUNTER3_LO},
	{9682, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 929},
	{9704, R_034500_PA_SC_PERFCOUNTER0_LO},
	{9726, R_034504_PA_SC_PERFCOUNTER0_HI},
	{9748, R_034508_PA_SC_PERFCOUNTER1_LO},
	{9770, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{9792, R_034510_PA_SC_PERFCOUNTER2_LO},
	{9814, R_034514_PA_SC_PERFCOUNTER2_HI},
	{9836, R_034518_PA_SC_PERFCOUNTER3_LO},
	{9858, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{9880, R_034520_PA_SC_PERFCOUNTER4_LO},
	{9902, R_034524_PA_SC_PERFCOUNTER4_HI},
	{9924, R_034528_PA_SC_PERFCOUNTER5_LO},
	{9946, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{9968, R_034530_PA_SC_PERFCOUNTER6_LO},
	{9990, R_034534_PA_SC_PERFCOUNTER6_HI},
	{10012, R_034538_PA_SC_PERFCOUNTER7_LO},
	{10034, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{10056, R_034600_SPI_PERFCOUNTER0_HI},
	{10076, R_034604_SPI_PERFCOUNTER0_LO},
	{10096, R_034608_SPI_PERFCOUNTER1_HI},
	{10116, R_03460C_SPI_PERFCOUNTER1_LO},
	{10136, R_034610_SPI_PERFCOUNTER2_HI},
	{10156, R_034614_SPI_PERFCOUNTER2_LO},
	{10176, R_034618_SPI_PERFCOUNTER3_HI},
	{10196, R_03461C_SPI_PERFCOUNTER3_LO},
	{10216, R_034620_SPI_PERFCOUNTER4_HI},
	{10236, R_034624_SPI_PERFCOUNTER4_LO},
	{10256, R_034628_SPI_PERFCOUNTER5_HI},
	{10276, R_03462C_SPI_PERFCOUNTER5_LO},
	{10296, R_034700_SQ_PERFCOUNTER0_LO},
	{10315, R_034704_SQ_PERFCOUNTER0_HI},
	{10334, R_034708_SQ_PERFCOUNTER1_LO},
	{10353, R_03470C_SQ_PERFCOUNTER1_HI},
	{10372, R_034710_SQ_PERFCOUNTER2_LO},
	{10391, R_034714_SQ_PERFCOUNTER2_HI},
	{10410, R_034718_SQ_PERFCOUNTER3_LO},
	{10429, R_03471C_SQ_PERFCOUNTER3_HI},
	{10448, R_034720_SQ_PERFCOUNTER4_LO},
	{10467, R_034724_SQ_PERFCOUNTER4_HI},
	{10486, R_034728_SQ_PERFCOUNTER5_LO},
	{10505, R_03472C_SQ_PERFCOUNTER5_HI},
	{10524, R_034730_SQ_PERFCOUNTER6_LO},
	{10543, R_034734_SQ_PERFCOUNTER6_HI},
	{10562, R_034738_SQ_PERFCOUNTER7_LO},
	{10581, R_03473C_SQ_PERFCOUNTER7_HI},
	{10600, R_034740_SQ_PERFCOUNTER8_LO},
	{10619, R_034744_SQ_PERFCOUNTER8_HI},
	{10638, R_034748_SQ_PERFCOUNTER9_LO},
	{10657, R_03474C_SQ_PERFCOUNTER9_HI},
	{10676, R_034750_SQ_PERFCOUNTER10_LO},
	{10696, R_034754_SQ_PERFCOUNTER10_HI},
	{10716, R_034758_SQ_PERFCOUNTER11_LO},
	{10736, R_03475C_SQ_PERFCOUNTER11_HI},
	{10756, R_034760_SQ_PERFCOUNTER12_LO},
	{10776, R_034764_SQ_PERFCOUNTER12_HI},
	{10796, R_034768_SQ_PERFCOUNTER13_LO},
	{10816, R_03476C_SQ_PERFCOUNTER13_HI},
	{10836, R_034770_SQ_PERFCOUNTER14_LO},
	{10856, R_034774_SQ_PERFCOUNTER14_HI},
	{10876, R_034778_SQ_PERFCOUNTER15_LO},
	{10896, R_03477C_SQ_PERFCOUNTER15_HI},
	{10916, R_034900_SX_PERFCOUNTER0_LO},
	{10935, R_034904_SX_PERFCOUNTER0_HI},
	{10954, R_034908_SX_PERFCOUNTER1_LO},
	{10973, R_03490C_SX_PERFCOUNTER1_HI},
	{10992, R_034910_SX_PERFCOUNTER2_LO},
	{11011, R_034914_SX_PERFCOUNTER2_HI},
	{11030, R_034918_SX_PERFCOUNTER3_LO},
	{11049, R_03491C_SX_PERFCOUNTER3_HI},
	{11068, R_034A00_GDS_PERFCOUNTER0_LO},
	{11088, R_034A04_GDS_PERFCOUNTER0_HI},
	{11108, R_034A08_GDS_PERFCOUNTER1_LO},
	{11128, R_034A0C_GDS_PERFCOUNTER1_HI},
	{11148, R_034A10_GDS_PERFCOUNTER2_LO},
	{11168, R_034A14_GDS_PERFCOUNTER2_HI},
	{11188, R_034A18_GDS_PERFCOUNTER3_LO},
	{11208, R_034A1C_GDS_PERFCOUNTER3_HI},
	{11228, R_034B00_TA_PERFCOUNTER0_LO},
	{11247, R_034B04_TA_PERFCOUNTER0_HI},
	{11266, R_034B08_TA_PERFCOUNTER1_LO},
	{11285, R_034B0C_TA_PERFCOUNTER1_HI},
	{11304, R_034C00_TD_PERFCOUNTER0_LO},
	{11323, R_034C04_TD_PERFCOUNTER0_HI},
	{11342, R_034C08_TD_PERFCOUNTER1_LO},
	{11361, R_034C0C_TD_PERFCOUNTER1_HI},
	{11380, R_034D00_TCP_PERFCOUNTER0_LO},
	{11400, R_034D04_TCP_PERFCOUNTER0_HI},
	{11420, R_034D08_TCP_PERFCOUNTER1_LO},
	{11440, R_034D0C_TCP_PERFCOUNTER1_HI},
	{11460, R_034D10_TCP_PERFCOUNTER2_LO},
	{11480, R_034D14_TCP_PERFCOUNTER2_HI},
	{11500, R_034D18_TCP_PERFCOUNTER3_LO},
	{11520, R_034D1C_TCP_PERFCOUNTER3_HI},
	{11540, R_034E00_TCC_PERFCOUNTER0_LO},
	{11560, R_034E04_TCC_PERFCOUNTER0_HI},
	{11580, R_034E08_TCC_PERFCOUNTER1_LO},
	{11600, R_034E0C_TCC_PERFCOUNTER1_HI},
	{11620, R_034E10_TCC_PERFCOUNTER2_LO},
	{11640, R_034E14_TCC_PERFCOUNTER2_HI},
	{11660, R_034E18_TCC_PERFCOUNTER3_LO},
	{11680, R_034E1C_TCC_PERFCOUNTER3_HI},
	{11700, R_034E40_TCA_PERFCOUNTER0_LO},
	{11720, R_034E44_TCA_PERFCOUNTER0_HI},
	{11740, R_034E48_TCA_PERFCOUNTER1_LO},
	{11760, R_034E4C_TCA_PERFCOUNTER1_HI},
	{11780, R_034E50_TCA_PERFCOUNTER2_LO},
	{11800, R_034E54_TCA_PERFCOUNTER2_HI},
	{11820, R_034E58_TCA_PERFCOUNTER3_LO},
	{11840, R_034E5C_TCA_PERFCOUNTER3_HI},
	{11860, R_035018_CB_PERFCOUNTER0_LO},
	{11879, R_03501C_CB_PERFCOUNTER0_HI},
	{11898, R_035020_CB_PERFCOUNTER1_LO},
	{11917, R_035024_CB_PERFCOUNTER1_HI},
	{11936, R_035028_CB_PERFCOUNTER2_LO},
	{11955, R_03502C_CB_PERFCOUNTER2_HI},
	{11974, R_035030_CB_PERFCOUNTER3_LO},
	{11993, R_035034_CB_PERFCOUNTER3_HI},
	{12012, R_035100_DB_PERFCOUNTER0_LO},
	{12031, R_035104_DB_PERFCOUNTER0_HI},
	{12050, R_035108_DB_PERFCOUNTER1_LO},
	{12069, R_03510C_DB_PERFCOUNTER1_HI},
	{12088, R_035110_DB_PERFCOUNTER2_LO},
	{12107, R_035114_DB_PERFCOUNTER2_HI},
	{12126, R_035118_DB_PERFCOUNTER3_LO},
	{12145, R_03511C_DB_PERFCOUNTER3_HI},
	{12164, R_035200_RLC_PERFCOUNTER0_LO},
	{12184, R_035204_RLC_PERFCOUNTER0_HI},
	{12204, R_035208_RLC_PERFCOUNTER1_LO},
	{12224, R_03520C_RLC_PERFCOUNTER1_HI},
	{12244, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 930},
	{12268, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 933},
	{12293, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 930},
	{12317, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 935},
	{12341, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 938},
	{12366, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 940},
	{12390, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 943},
	{12415, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 940},
	{12439, R_036020_CP_PERFMON_CNTL, 4, 945},
	{12455, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 935},
	{12479, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 949},
	{12504, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 949},
	{12529, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 968},
	{12557, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 980},
	{12585, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 992},
	{12613, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 1004},
	{12641, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1016},
	{12664, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1016},
	{12687, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1016},
	{12710, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1016},
	{12733, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1018},
	{12756, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1018},
	{12779, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1018},
	{12802, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1018},
	{12825, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1023},
	{12849, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1027},
	{12873, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1027},
	{12897, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1027},
	{12921, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1027},
	{12945, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1032},
	{12970, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{12995, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1036},
	{13021, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1037},
	{13047, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1040},
	{13074, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1037},
	{13100, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{13127, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1037},
	{13153, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1037},
	{13179, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1042},
	{13205, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1045},
	{13232, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1042},
	{13258, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1042},
	{13284, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1042},
	{13310, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1042},
	{13336, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1042},
	{13362, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1042},
	{13388, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1042},
	{13414, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1047},
	{13438, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1047},
	{13462, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1047},
	{13486, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1047},
	{13510, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1050},
	{13535, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{13560, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{13585, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{13610, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1047},
	{13634, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1047},
	{13658, R_036628_SPI_PERFCOUNTER_BINS, 8, 1052},
	{13679, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1060},
	{13702, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1060},
	{13725, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1060},
	{13748, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1060},
	{13771, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1060},
	{13794, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1060},
	{13817, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1060},
	{13840, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1060},
	{13863, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1060},
	{13886, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1060},
	{13909, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1060},
	{13933, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1060},
	{13957, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1060},
	{13981, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1060},
	{14005, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1060},
	{14029, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1060},
	{14053, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1066},
	{14073, R_036784_SQ_PERFCOUNTER_MASK, 2, 1075},
	{14093, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1077},
	{14114, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1078},
	{14137, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1078},
	{14160, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1078},
	{14183, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1078},
	{14206, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1081},
	{14230, R_036914_SX_PERFCOUNTER1_SELECT1},
	{14254, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1083},
	{14278, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1083},
	{14302, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1083},
	{14326, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1083},
	{14350, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1086},
	{14375, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1088},
	{14398, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1093},
	{14422, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1088},
	{14445, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1097},
	{14468, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1102},
	{14492, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1097},
	{14515, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1106},
	{14539, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1111},
	{14564, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1106},
	{14588, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{14613, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1106},
	{14637, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1106},
	{14661, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1115},
	{14685, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1120},
	{14710, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1115},
	{14734, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{14759, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1115},
	{14783, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1115},
	{14807, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1124},
	{14831, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1129},
	{14856, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1124},
	{14880, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{14905, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1124},
	{14929, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1124},
	{14953, R_037000_CB_PERFCOUNTER_FILTER, 12, 1133},
	{14975, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1145},
	{14998, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1150},
	{15022, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1145},
	{15045, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1145},
	{15068, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1145},
	{15091, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1154},
	{15114, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1159},
	{15138, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1154},
	{15161, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{15185, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1154},
	{15208, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1154},
	{15231, R_028000_DB_RENDER_CONTROL, 10, 1163},
	{15249, R_028004_DB_COUNT_CONTROL, 9, 1173},
	{15266, R_028008_DB_DEPTH_VIEW, 4, 1182},
	{15280, R_02800C_DB_RENDER_OVERRIDE, 23, 1186},
	{15299, R_028010_DB_RENDER_OVERRIDE2, 15, 1209},
	{15319, R_028014_DB_HTILE_DATA_BASE},
	{15338, R_028020_DB_DEPTH_BOUNDS_MIN},
	{15358, R_028024_DB_DEPTH_BOUNDS_MAX},
	{15378, R_028028_DB_STENCIL_CLEAR, 1, 1224},
	{15395, R_02802C_DB_DEPTH_CLEAR},
	{15410, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1225},
	{15434, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1227},
	{15458, R_02803C_DB_DEPTH_INFO, 7, 1229},
	{15472, R_028040_DB_Z_INFO, 10, 1236},
	{15482, R_028044_DB_STENCIL_INFO, 6, 1246},
	{15498, R_028048_DB_Z_READ_BASE},
	{15513, R_02804C_DB_STENCIL_READ_BASE},
	{15534, R_028050_DB_Z_WRITE_BASE},
	{15550, R_028054_DB_STENCIL_WRITE_BASE},
	{15572, R_028058_DB_DEPTH_SIZE, 2, 1252},
	{15586, R_02805C_DB_DEPTH_SLICE, 1, 1254},
	{15601, R_028080_TA_BC_BASE_ADDR},
	{15617, R_028084_TA_BC_BASE_ADDR_HI, 1, 1255},
	{15636, R_0281E8_COHER_DEST_BASE_HI_0},
	{15657, R_0281EC_COHER_DEST_BASE_HI_1},
	{15678, R_0281F0_COHER_DEST_BASE_HI_2},
	{15699, R_0281F4_COHER_DEST_BASE_HI_3},
	{15720, R_0281F8_COHER_DEST_BASE_2},
	{15738, R_0281FC_COHER_DEST_BASE_3},
	{15756, R_028200_PA_SC_WINDOW_OFFSET, 2, 1256},
	{15776, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1258},
	{15800, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1261},
	{15824, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1263},
	{15844, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1264},
	{15864, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1266},
	{15884, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1264},
	{15904, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1266},
	{15924, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1264},
	{15944, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1266},
	{15964, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1264},
	{15984, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1266},
	{16004, R_028230_PA_SC_EDGERULE, 7, 1268},
	{16019, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1275},
	{16048, R_028238_CB_TARGET_MASK, 8, 1277},
	{16063, R_02823C_CB_SHADER_MASK, 8, 1285},
	{16078, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1293},
	{16103, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1296},
	{16128, R_028248_COHER_DEST_BASE_0},
	{16146, R_02824C_COHER_DEST_BASE_1},
	{16164, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1298},
	{16189, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1301},
	{16214, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1298},
	{16239, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1301},
	{16264, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1298},
	{16289, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1301},
	{16314, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1298},
	{16339, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1301},
	{16364, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1298},
	{16389, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1301},
	{16414, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1298},
	{16439, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1301},
	{16464, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1298},
	{16489, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1301},
	{16514, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1298},
	{16539, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1301},
	{16564, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1298},
	{16589, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1301},
	{16614, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1298},
	{16639, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1301},
	{16664, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1298},
	{16690, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1301},
	{16716, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1298},
	{16742, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1301},
	{16768, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1298},
	{16794, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1301},
	{16820, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1298},
	{16846, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1301},
	{16872, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1298},
	{16898, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1301},
	{16924, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1298},
	{16950, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1301},
	{16976, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{16995, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{17014, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{17033, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{17052, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{17071, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{17090, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{17109, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{17128, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{17147, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{17166, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{17185, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{17204, R_028300_PA_SC_VPORT_ZMIN_6},
	{17223, R_028304_PA_SC_VPORT_ZMAX_6},
	{17242, R_028308_PA_SC_VPORT_ZMIN_7},
	{17261, R_02830C_PA_SC_VPORT_ZMAX_7},
	{17280, R_028310_PA_SC_VPORT_ZMIN_8},
	{17299, R_028314_PA_SC_VPORT_ZMAX_8},
	{17318, R_028318_PA_SC_VPORT_ZMIN_9},
	{17337, R_02831C_PA_SC_VPORT_ZMAX_9},
	{17356, R_028320_PA_SC_VPORT_ZMIN_10},
	{17376, R_028324_PA_SC_VPORT_ZMAX_10},
	{17396, R_028328_PA_SC_VPORT_ZMIN_11},
	{17416, R_02832C_PA_SC_VPORT_ZMAX_11},
	{17436, R_028330_PA_SC_VPORT_ZMIN_12},
	{17456, R_028334_PA_SC_VPORT_ZMAX_12},
	{17476, R_028338_PA_SC_VPORT_ZMIN_13},
	{17496, R_02833C_PA_SC_VPORT_ZMAX_13},
	{17516, R_028340_PA_SC_VPORT_ZMIN_14},
	{17536, R_028344_PA_SC_VPORT_ZMAX_14},
	{17556, R_028348_PA_SC_VPORT_ZMIN_15},
	{17576, R_02834C_PA_SC_VPORT_ZMAX_15},
	{17596, R_028350_PA_SC_RASTER_CONFIG, 15, 1303},
	{17616, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1318},
	{17638, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1321},
	{17666, R_028400_VGT_MAX_VTX_INDX},
	{17683, R_028404_VGT_MIN_VTX_INDX},
	{17700, R_028408_VGT_INDX_OFFSET},
	{17716, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{17745, R_028414_CB_BLEND_RED},
	{17758, R_028418_CB_BLEND_GREEN},
	{17773, R_02841C_CB_BLEND_BLUE},
	{17787, R_028420_CB_BLEND_ALPHA},
	{17802, R_028424_CB_DCC_CONTROL, 3, 1323},
	{17817, R_02842C_DB_STENCIL_CONTROL, 6, 1326},
	{17836, R_028430_DB_STENCILREFMASK, 4, 1332},
	{17854, R_028434_DB_STENCILREFMASK_BF, 4, 1336},
	{17875, R_02843C_PA_CL_VPORT_XSCALE},
	{17894, R_028440_PA_CL_VPORT_XOFFSET},
	{17914, R_028444_PA_CL_VPORT_YSCALE},
	{17933, R_028448_PA_CL_VPORT_YOFFSET},
	{17953, R_02844C_PA_CL_VPORT_ZSCALE},
	{17972, R_028450_PA_CL_VPORT_ZOFFSET},
	{17992, R_028454_PA_CL_VPORT_XSCALE_1},
	{18013, R_028458_PA_CL_VPORT_XOFFSET_1},
	{18035, R_02845C_PA_CL_VPORT_YSCALE_1},
	{18056, R_028460_PA_CL_VPORT_YOFFSET_1},
	{18078, R_028464_PA_CL_VPORT_ZSCALE_1},
	{18099, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{18121, R_02846C_PA_CL_VPORT_XSCALE_2},
	{18142, R_028470_PA_CL_VPORT_XOFFSET_2},
	{18164, R_028474_PA_CL_VPORT_YSCALE_2},
	{18185, R_028478_PA_CL_VPORT_YOFFSET_2},
	{18207, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{18228, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{18250, R_028484_PA_CL_VPORT_XSCALE_3},
	{18271, R_028488_PA_CL_VPORT_XOFFSET_3},
	{18293, R_02848C_PA_CL_VPORT_YSCALE_3},
	{18314, R_028490_PA_CL_VPORT_YOFFSET_3},
	{18336, R_028494_PA_CL_VPORT_ZSCALE_3},
	{18357, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{18379, R_02849C_PA_CL_VPORT_XSCALE_4},
	{18400, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{18422, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{18443, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{18465, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{18486, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{18508, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{18529, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{18551, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{18572, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{18594, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{18615, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{18637, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{18658, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{18680, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{18701, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{18723, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{18744, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{18766, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{18787, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{18809, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{18830, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{18852, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{18873, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{18895, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{18916, R_028500_PA_CL_VPORT_XOFFSET_8},
	{18938, R_028504_PA_CL_VPORT_YSCALE_8},
	{18959, R_028508_PA_CL_VPORT_YOFFSET_8},
	{18981, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{19002, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{19024, R_028514_PA_CL_VPORT_XSCALE_9},
	{19045, R_028518_PA_CL_VPORT_XOFFSET_9},
	{19067, R_02851C_PA_CL_VPORT_YSCALE_9},
	{19088, R_028520_PA_CL_VPORT_YOFFSET_9},
	{19110, R_028524_PA_CL_VPORT_ZSCALE_9},
	{19131, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{19153, R_02852C_PA_CL_VPORT_XSCALE_10},
	{19175, R_028530_PA_CL_VPORT_XOFFSET_10},
	{19198, R_028534_PA_CL_VPORT_YSCALE_10},
	{19220, R_028538_PA_CL_VPORT_YOFFSET_10},
	{19243, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{19265, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{19288, R_028544_PA_CL_VPORT_XSCALE_11},
	{19310, R_028548_PA_CL_VPORT_XOFFSET_11},
	{19333, R_02854C_PA_CL_VPORT_YSCALE_11},
	{19355, R_028550_PA_CL_VPORT_YOFFSET_11},
	{19378, R_028554_PA_CL_VPORT_ZSCALE_11},
	{19400, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{19423, R_02855C_PA_CL_VPORT_XSCALE_12},
	{19445, R_028560_PA_CL_VPORT_XOFFSET_12},
	{19468, R_028564_PA_CL_VPORT_YSCALE_12},
	{19490, R_028568_PA_CL_VPORT_YOFFSET_12},
	{19513, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{19535, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{19558, R_028574_PA_CL_VPORT_XSCALE_13},
	{19580, R_028578_PA_CL_VPORT_XOFFSET_13},
	{19603, R_02857C_PA_CL_VPORT_YSCALE_13},
	{19625, R_028580_PA_CL_VPORT_YOFFSET_13},
	{19648, R_028584_PA_CL_VPORT_ZSCALE_13},
	{19670, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{19693, R_02858C_PA_CL_VPORT_XSCALE_14},
	{19715, R_028590_PA_CL_VPORT_XOFFSET_14},
	{19738, R_028594_PA_CL_VPORT_YSCALE_14},
	{19760, R_028598_PA_CL_VPORT_YOFFSET_14},
	{19783, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{19805, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{19828, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{19850, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{19873, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{19895, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{19918, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{19940, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{19963, R_0285BC_PA_CL_UCP_0_X},
	{19977, R_0285C0_PA_CL_UCP_0_Y},
	{19991, R_0285C4_PA_CL_UCP_0_Z},
	{20005, R_0285C8_PA_CL_UCP_0_W},
	{20019, R_0285CC_PA_CL_UCP_1_X},
	{20033, R_0285D0_PA_CL_UCP_1_Y},
	{20047, R_0285D4_PA_CL_UCP_1_Z},
	{20061, R_0285D8_PA_CL_UCP_1_W},
	{20075, R_0285DC_PA_CL_UCP_2_X},
	{20089, R_0285E0_PA_CL_UCP_2_Y},
	{20103, R_0285E4_PA_CL_UCP_2_Z},
	{20117, R_0285E8_PA_CL_UCP_2_W},
	{20131, R_0285EC_PA_CL_UCP_3_X},
	{20145, R_0285F0_PA_CL_UCP_3_Y},
	{20159, R_0285F4_PA_CL_UCP_3_Z},
	{20173, R_0285F8_PA_CL_UCP_3_W},
	{20187, R_0285FC_PA_CL_UCP_4_X},
	{20201, R_028600_PA_CL_UCP_4_Y},
	{20215, R_028604_PA_CL_UCP_4_Z},
	{20229, R_028608_PA_CL_UCP_4_W},
	{20243, R_02860C_PA_CL_UCP_5_X},
	{20257, R_028610_PA_CL_UCP_5_Y},
	{20271, R_028614_PA_CL_UCP_5_Z},
	{20285, R_028618_PA_CL_UCP_5_W},
	{20299, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1340},
	{20319, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1340},
	{20339, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1340},
	{20359, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1340},
	{20379, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1340},
	{20399, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1340},
	{20419, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1340},
	{20439, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1340},
	{20459, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1340},
	{20479, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1340},
	{20499, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1340},
	{20520, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1340},
	{20541, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1340},
	{20562, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1340},
	{20583, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1340},
	{20604, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1340},
	{20625, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1340},
	{20646, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1340},
	{20667, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1340},
	{20688, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1340},
	{20709, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1340},
	{20730, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1340},
	{20751, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1340},
	{20772, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1340},
	{20793, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1340},
	{20814, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1340},
	{20835, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1340},
	{20856, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1340},
	{20877, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1340},
	{20898, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1340},
	{20919, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1340},
	{20940, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1340},
	{20961, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1352},
	{20979, R_0286CC_SPI_PS_INPUT_ENA, 16, 1356},
	{20996, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1372},
	{21014, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1388},
	{21035, R_0286D8_SPI_PS_IN_CONTROL, 5, 1395},
	{21053, R_0286E0_SPI_BARYC_CNTL, 7, 1400},
	{21068, R_0286E8_SPI_TMPRING_SIZE, 2, 1407},
	{21085, R_028704_SPI_WAVE_MGMT_1, 5, 1409},
	{21101, R_028708_SPI_WAVE_MGMT_2, 1, 1414},
	{21117, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1415},
	{21139, R_028710_SPI_SHADER_Z_FORMAT, 1, 1419},
	{21159, R_028714_SPI_SHADER_COL_FORMAT, 8, 1420},
	{21181, R_028754_SX_PS_DOWNCONVERT, 8, 1428},
	{21199, R_028758_SX_BLEND_OPT_EPSILON, 8, 1436},
	{21220, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1444},
	{21241, R_028760_SX_MRT0_BLEND_OPT, 6, 1461},
	{21259, R_028764_SX_MRT1_BLEND_OPT, 6, 1467},
	{21277, R_028768_SX_MRT2_BLEND_OPT, 6, 1473},
	{21295, R_02876C_SX_MRT3_BLEND_OPT, 6, 1479},
	{21313, R_028770_SX_MRT4_BLEND_OPT, 6, 1485},
	{21331, R_028774_SX_MRT5_BLEND_OPT, 6, 1491},
	{21349, R_028778_SX_MRT6_BLEND_OPT, 6, 1497},
	{21367, R_02877C_SX_MRT7_BLEND_OPT, 6, 1503},
	{21385, R_028780_CB_BLEND0_CONTROL, 9, 1509},
	{21403, R_028784_CB_BLEND1_CONTROL, 9, 1509},
	{21421, R_028788_CB_BLEND2_CONTROL, 9, 1509},
	{21439, R_02878C_CB_BLEND3_CONTROL, 9, 1509},
	{21457, R_028790_CB_BLEND4_CONTROL, 9, 1509},
	{21475, R_028794_CB_BLEND5_CONTROL, 9, 1509},
	{21493, R_028798_CB_BLEND6_CONTROL, 9, 1509},
	{21511, R_02879C_CB_BLEND7_CONTROL, 9, 1509},
	{21529, R_0287CC_CS_COPY_STATE, 1, 1518},
	{21543, R_0287D4_PA_CL_POINT_X_RAD},
	{21561, R_0287D8_PA_CL_POINT_Y_RAD},
	{21579, R_0287DC_PA_CL_POINT_SIZE},
	{21596, R_0287E0_PA_CL_POINT_CULL_RAD},
	{21617, R_0287E4_VGT_DMA_BASE_HI, 1, 1519},
	{21633, R_0287E8_VGT_DMA_BASE},
	{21646, R_0287F0_VGT_DRAW_INITIATOR, 4, 1520},
	{21665, R_0287F4_VGT_IMMED_DATA},
	{21680, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1524},
	{21702, R_028800_DB_DEPTH_CONTROL, 10, 1525},
	{21719, R_028804_DB_EQAA, 12, 1535},
	{21727, R_028808_CB_COLOR_CONTROL, 4, 1547},
	{21744, R_02880C_DB_SHADER_CONTROL, 13, 1551},
	{21762, R_028810_PA_CL_CLIP_CNTL, 19, 1564},
	{21778, R_028814_PA_SU_SC_MODE_CNTL, 13, 1583},
	{21797, R_028818_PA_CL_VTE_CNTL, 9, 1596},
	{21812, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1605},
	{21830, R_028820_PA_CL_NANINF_CNTL, 16, 1632},
	{21848, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1648},
	{21872, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{21897, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1652},
	{21920, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 5, 1663},
	{21949, R_028A00_PA_SU_POINT_SIZE, 2, 1668},
	{21966, R_028A04_PA_SU_POINT_MINMAX, 2, 1670},
	{21985, R_028A08_PA_SU_LINE_CNTL, 1, 1672},
	{22001, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1673},
	{22020, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1677},
	{22041, R_028A14_VGT_HOS_CNTL, 1, 1678},
	{22054, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{22077, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{22100, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1679},
	{22120, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1680},
	{22140, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1684},
	{22161, R_028A2C_VGT_GROUP_DECR, 1, 1685},
	{22176, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1686},
	{22198, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1692},
	{22220, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1698},
	{22246, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1706},
	{22272, R_028A40_VGT_GS_MODE, 15, 1714},
	{22284, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1729},
	{22303, R_028A48_PA_SC_MODE_CNTL_0, 4, 1731},
	{22321, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1735},
	{22339, R_028A50_VGT_ENHANCE},
	{22351, R_028A54_VGT_GS_PER_ES, 1, 1759},
	{22365, R_028A58_VGT_ES_PER_GS, 1, 1760},
	{22379, R_028A5C_VGT_GS_PER_VS, 1, 1761},
	{22393, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1762},
	{22416, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1763},
	{22439, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1764},
	{22462, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1765},
	{22483, R_028A70_IA_ENHANCE},
	{22494, R_028A74_VGT_DMA_SIZE},
	{22507, R_028A78_VGT_DMA_MAX_SIZE},
	{22524, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1770},
	{22543, R_028A80_WD_ENHANCE},
	{22554, R_028A84_VGT_PRIMITIVEID_EN, 2, 1779},
	{22573, R_028A88_VGT_DMA_NUM_INSTANCES},
	{22595, R_028A8C_VGT_PRIMITIVEID_RESET},
	{22617, R_028A90_VGT_EVENT_INITIATOR, 3, 1781},
	{22637, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1784},
	{22664, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{22689, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{22714, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1785},
	{22733, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1792},
	{22756, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1793},
	{22779, R_028AB4_VGT_REUSE_OFF, 1, 1794},
	{22793, R_028AB8_VGT_VTX_CNT_EN, 1, 1795},
	{22808, R_028ABC_DB_HTILE_SURFACE, 8, 1796},
	{22825, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1804},
	{22852, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1808},
	{22879, R_028AC8_DB_PRELOAD_CONTROL, 4, 1812},
	{22898, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{22924, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1816},
	{22949, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{22977, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{23003, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1817},
	{23028, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{23056, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{23082, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1818},
	{23107, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{23135, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{23161, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1819},
	{23186, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{23214, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{23245, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{23288, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1820},
	{23326, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1821},
	{23346, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1822},
	{23368, R_028B54_VGT_SHADER_STAGES_EN, 10, 1827},
	{23389, R_028B58_VGT_LS_HS_CONFIG, 3, 1837},
	{23406, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1840},
	{23427, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1841},
	{23450, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1842},
	{23473, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1843},
	{23496, R_028B6C_VGT_TF_PARAM, 11, 1844},
	{23509, R_028B70_DB_ALPHA_TO_MASK, 6, 1855},
	{23526, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{23550, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1861},
	{23580, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{23604, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{23634, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{23665, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{23694, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{23724, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1863},
	{23744, R_028B94_VGT_STRMOUT_CONFIG, 7, 1865},
	{23763, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1872},
	{23789, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1876},
	{23815, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1884},
	{23841, R_028BDC_PA_SC_LINE_CNTL, 4, 1892},
	{23857, R_028BE0_PA_SC_AA_CONFIG, 5, 1896},
	{23873, R_028BE4_PA_SU_VTX_CNTL, 3, 1901},
	{23888, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{23911, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{23934, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{23957, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{23980, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1904},
	{24014, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1912},
	{24048, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1920},
	{24082, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1928},
	{24116, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1936},
	{24150, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1944},
	{24184, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1952},
	{24218, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1960},
	{24252, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1968},
	{24286, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1976},
	{24320, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1984},
	{24354, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 1992},
	{24388, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 2000},
	{24422, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 2008},
	{24456, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2016},
	{24490, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2024},
	{24524, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2032},
	{24548, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2034},
	{24572, R_028C40_PA_SC_SHADER_CONTROL, 1, 2036},
	{24593, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2037},
	{24621, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2038},
	{24642, R_028C60_CB_COLOR0_BASE},
	{24657, R_028C64_CB_COLOR0_PITCH, 2, 2039},
	{24673, R_028C68_CB_COLOR0_SLICE, 1, 2041},
	{24689, R_028C6C_CB_COLOR0_VIEW, 2, 2042},
	{24704, R_028C70_CB_COLOR0_INFO, 18, 2044},
	{24719, R_028C74_CB_COLOR0_ATTRIB, 6, 2062},
	{24736, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2068},
	{24758, R_028C7C_CB_COLOR0_CMASK},
	{24774, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2077},
	{24796, R_028C84_CB_COLOR0_FMASK},
	{24812, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2078},
	{24834, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{24856, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{24878, R_028C94_CB_COLOR0_DCC_BASE},
	{24897, R_028C9C_CB_COLOR1_BASE},
	{24912, R_028CA0_CB_COLOR1_PITCH, 2, 2039},
	{24928, R_028CA4_CB_COLOR1_SLICE, 1, 2041},
	{24944, R_028CA8_CB_COLOR1_VIEW, 2, 2042},
	{24959, R_028CAC_CB_COLOR1_INFO, 18, 2044},
	{24974, R_028CB0_CB_COLOR1_ATTRIB, 6, 2062},
	{24991, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2068},
	{25013, R_028CB8_CB_COLOR1_CMASK},
	{25029, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2077},
	{25051, R_028CC0_CB_COLOR1_FMASK},
	{25067, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2078},
	{25089, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{25111, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{25133, R_028CD0_CB_COLOR1_DCC_BASE},
	{25152, R_028CD8_CB_COLOR2_BASE},
	{25167, R_028CDC_CB_COLOR2_PITCH, 2, 2039},
	{25183, R_028CE0_CB_COLOR2_SLICE, 1, 2041},
	{25199, R_028CE4_CB_COLOR2_VIEW, 2, 2042},
	{25214, R_028CE8_CB_COLOR2_INFO, 18, 2044},
	{25229, R_028CEC_CB_COLOR2_ATTRIB, 6, 2062},
	{25246, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2068},
	{25268, R_028CF4_CB_COLOR2_CMASK},
	{25284, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2077},
	{25306, R_028CFC_CB_COLOR2_FMASK},
	{25322, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2078},
	{25344, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{25366, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{25388, R_028D0C_CB_COLOR2_DCC_BASE},
	{25407, R_028D14_CB_COLOR3_BASE},
	{25422, R_028D18_CB_COLOR3_PITCH, 2, 2039},
	{25438, R_028D1C_CB_COLOR3_SLICE, 1, 2041},
	{25454, R_028D20_CB_COLOR3_VIEW, 2, 2042},
	{25469, R_028D24_CB_COLOR3_INFO, 18, 2044},
	{25484, R_028D28_CB_COLOR3_ATTRIB, 6, 2062},
	{25501, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2068},
	{25523, R_028D30_CB_COLOR3_CMASK},
	{25539, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2077},
	{25561, R_028D38_CB_COLOR3_FMASK},
	{25577, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2078},
	{25599, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{25621, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{25643, R_028D48_CB_COLOR3_DCC_BASE},
	{25662, R_028D50_CB_COLOR4_BASE},
	{25677, R_028D54_CB_COLOR4_PITCH, 2, 2039},
	{25693, R_028D58_CB_COLOR4_SLICE, 1, 2041},
	{25709, R_028D5C_CB_COLOR4_VIEW, 2, 2042},
	{25724, R_028D60_CB_COLOR4_INFO, 18, 2044},
	{25739, R_028D64_CB_COLOR4_ATTRIB, 6, 2062},
	{25756, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2068},
	{25778, R_028D6C_CB_COLOR4_CMASK},
	{25794, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2077},
	{25816, R_028D74_CB_COLOR4_FMASK},
	{25832, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2078},
	{25854, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{25876, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{25898, R_028D84_CB_COLOR4_DCC_BASE},
	{25917, R_028D8C_CB_COLOR5_BASE},
	{25932, R_028D90_CB_COLOR5_PITCH, 2, 2039},
	{25948, R_028D94_CB_COLOR5_SLICE, 1, 2041},
	{25964, R_028D98_CB_COLOR5_VIEW, 2, 2042},
	{25979, R_028D9C_CB_COLOR5_INFO, 18, 2044},
	{25994, R_028DA0_CB_COLOR5_ATTRIB, 6, 2062},
	{26011, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2068},
	{26033, R_028DA8_CB_COLOR5_CMASK},
	{26049, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2077},
	{26071, R_028DB0_CB_COLOR5_FMASK},
	{26087, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2078},
	{26109, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{26131, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{26153, R_028DC0_CB_COLOR5_DCC_BASE},
	{26172, R_028DC8_CB_COLOR6_BASE},
	{26187, R_028DCC_CB_COLOR6_PITCH, 2, 2039},
	{26203, R_028DD0_CB_COLOR6_SLICE, 1, 2041},
	{26219, R_028DD4_CB_COLOR6_VIEW, 2, 2042},
	{26234, R_028DD8_CB_COLOR6_INFO, 18, 2044},
	{26249, R_028DDC_CB_COLOR6_ATTRIB, 6, 2062},
	{26266, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2068},
	{26288, R_028DE4_CB_COLOR6_CMASK},
	{26304, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2077},
	{26326, R_028DEC_CB_COLOR6_FMASK},
	{26342, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2078},
	{26364, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{26386, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{26408, R_028DFC_CB_COLOR6_DCC_BASE},
	{26427, R_028E04_CB_COLOR7_BASE},
	{26442, R_028E08_CB_COLOR7_PITCH, 2, 2039},
	{26458, R_028E0C_CB_COLOR7_SLICE, 1, 2041},
	{26474, R_028E10_CB_COLOR7_VIEW, 2, 2042},
	{26489, R_028E14_CB_COLOR7_INFO, 18, 2044},
	{26504, R_028E18_CB_COLOR7_ATTRIB, 6, 2062},
	{26521, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2068},
	{26543, R_028E20_CB_COLOR7_CMASK},
	{26559, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2077},
	{26581, R_028E28_CB_COLOR7_FMASK},
	{26597, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2078},
	{26619, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{26641, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{26663, R_028E38_CB_COLOR7_DCC_BASE},
};

static const struct si_reg gfx9d_reg_table[] = {
	{1059, R_008008_GRBM_STATUS2, 25, 2079},
	{1072, R_008010_GRBM_STATUS, 24, 2104},
	{1157, R_008014_GRBM_STATUS_SE0, 12, 2128},
	{1173, R_008018_GRBM_STATUS_SE1, 12, 2140},
	{1189, R_008038_GRBM_STATUS_SE2, 12, 2152},
	{1205, R_00803C_GRBM_STATUS_SE3, 12, 2164},
	{1115, R_0301F0_CP_COHER_CNTL, 13, 2176},
	{1259, R_0301FC_CP_COHER_STATUS, 2, 2189},
	{1275, R_008210_CP_CPC_STATUS, 16, 2191},
	{1306, R_008218_CP_CPC_STALLED_STAT1, 14, 2207},
	{1327, R_00821C_CP_CPF_STATUS, 21, 2221},
	{1358, R_008224_CP_CPF_STALLED_STAT1, 11, 2242},
	{1821, R_008670_CP_STALLED_STAT3, 19, 2253},
	{1872, R_008680_CP_STAT, 22, 2272},
	{1500, R_030908_VGT_PRIMITIVE_TYPE, 1, 2294},
	{1519, R_03090C_VGT_INDEX_TYPE, 2, 2295},
	{17666, R_030920_VGT_MAX_VTX_INDX},
	{17683, R_030924_VGT_MIN_VTX_INDX},
	{17700, R_030928_VGT_INDX_OFFSET},
	{22637, R_03092C_VGT_MULTI_PRIM_IB_RESET_EN, 2, 2297},
	{1717, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 2299},
	{26682, R_030944_VGT_TF_MEMORY_BASE_HI, 1, 2301},
	{26704, R_030948_WD_POS_BUF_BASE},
	{26720, R_03094C_WD_POS_BUF_BASE_HI, 1, 2302},
	{26739, R_030950_WD_CNTL_SB_BUF_BASE},
	{26759, R_030954_WD_CNTL_SB_BUF_BASE_HI, 1, 2303},
	{26782, R_030958_WD_INDEX_BUF_BASE},
	{26800, R_03095C_WD_INDEX_BUF_BASE_HI, 1, 2304},
	{22714, R_030960_IA_MULTI_VGT_PARAM, 9, 2305},
	{26821, R_030968_VGT_INSTANCE_BASE_ID},
	{1998, R_030D20_SQC_CACHES, 6, 2314},
	{26842, R_030D24_SQC_WRITEBACK, 2, 2320},
	{2226, R_008F0C_SQ_BUF_RSRC_WORD3, 12, 2322},
	{2309, R_008F14_SQ_IMG_RSRC_WORD1, 9, 2334},
	{2351, R_008F18_SQ_IMG_RSRC_WORD2, 3, 560},
	{2392, R_008F1C_SQ_IMG_RSRC_WORD3, 8, 2343},
	{2410, R_008F20_SQ_IMG_RSRC_WORD4, 3, 2351},
	{2428, R_008F24_SQ_IMG_RSRC_WORD5, 7, 2354},
	{2518, R_008F38_SQ_IMG_SAMP_WORD2, 10, 2361},
	{2536, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 2371},
	{2800, R_031100_SPI_CONFIG_CNTL, 9, 2374},
	{2816, R_031104_SPI_CONFIG_CNTL_1, 11, 2383},
	{26856, R_031108_SPI_CONFIG_CNTL_2, 2, 2394},
	{2882, R_0098F8_GB_ADDR_CONFIG, 13, 2396},
	{2897, R_009910_GB_TILE_MODE0, 5, 2409},
	{2911, R_009914_GB_TILE_MODE1, 5, 2409},
	{2925, R_009918_GB_TILE_MODE2, 5, 2409},
	{2939, R_00991C_GB_TILE_MODE3, 5, 2409},
	{2953, R_009920_GB_TILE_MODE4, 5, 2409},
	{2967, R_009924_GB_TILE_MODE5, 5, 2409},
	{2981, R_009928_GB_TILE_MODE6, 5, 2409},
	{2995, R_00992C_GB_TILE_MODE7, 5, 2409},
	{3009, R_009930_GB_TILE_MODE8, 5, 2409},
	{3023, R_009934_GB_TILE_MODE9, 5, 2409},
	{3037, R_009938_GB_TILE_MODE10, 5, 2409},
	{3052, R_00993C_GB_TILE_MODE11, 5, 2409},
	{3067, R_009940_GB_TILE_MODE12, 5, 2409},
	{3082, R_009944_GB_TILE_MODE13, 5, 2409},
	{3097, R_009948_GB_TILE_MODE14, 5, 2409},
	{3112, R_00994C_GB_TILE_MODE15, 5, 2409},
	{3127, R_009950_GB_TILE_MODE16, 5, 2409},
	{3142, R_009954_GB_TILE_MODE17, 5, 2409},
	{3157, R_009958_GB_TILE_MODE18, 5, 2409},
	{3172, R_00995C_GB_TILE_MODE19, 5, 2409},
	{3187, R_009960_GB_TILE_MODE20, 5, 2409},
	{3202, R_009964_GB_TILE_MODE21, 5, 2409},
	{3217, R_009968_GB_TILE_MODE22, 5, 2409},
	{3232, R_00996C_GB_TILE_MODE23, 5, 2409},
	{3247, R_009970_GB_TILE_MODE24, 5, 2409},
	{3262, R_009974_GB_TILE_MODE25, 5, 2409},
	{3277, R_009978_GB_TILE_MODE26, 5, 2409},
	{3292, R_00997C_GB_TILE_MODE27, 5, 2409},
	{3307, R_009980_GB_TILE_MODE28, 5, 2409},
	{3322, R_009984_GB_TILE_MODE29, 5, 2409},
	{3337, R_009988_GB_TILE_MODE30, 5, 2409},
	{3352, R_00998C_GB_TILE_MODE31, 5, 2409},
	{3761, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 4, 2414},
	{3827, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 2418},
	{3851, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 10, 2429},
	{26874, R_00B070_SPI_SHADER_USER_DATA_PS_16},
	{26901, R_00B074_SPI_SHADER_USER_DATA_PS_17},
	{26928, R_00B078_SPI_SHADER_USER_DATA_PS_18},
	{26955, R_00B07C_SPI_SHADER_USER_DATA_PS_19},
	{26982, R_00B080_SPI_SHADER_USER_DATA_PS_20},
	{27009, R_00B084_SPI_SHADER_USER_DATA_PS_21},
	{27036, R_00B088_SPI_SHADER_USER_DATA_PS_22},
	{27063, R_00B08C_SPI_SHADER_USER_DATA_PS_23},
	{27090, R_00B090_SPI_SHADER_USER_DATA_PS_24},
	{27117, R_00B094_SPI_SHADER_USER_DATA_PS_25},
	{27144, R_00B098_SPI_SHADER_USER_DATA_PS_26},
	{27171, R_00B09C_SPI_SHADER_USER_DATA_PS_27},
	{27198, R_00B0A0_SPI_SHADER_USER_DATA_PS_28},
	{27225, R_00B0A4_SPI_SHADER_USER_DATA_PS_29},
	{27252, R_00B0A8_SPI_SHADER_USER_DATA_PS_30},
	{27279, R_00B0AC_SPI_SHADER_USER_DATA_PS_31},
	{4381, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 4, 2439},
	{4472, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 2443},
	{4496, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 14, 2455},
	{27306, R_00B170_SPI_SHADER_USER_DATA_VS_16},
	{27333, R_00B174_SPI_SHADER_USER_DATA_VS_17},
	{27360, R_00B178_SPI_SHADER_USER_DATA_VS_18},
	{27387, R_00B17C_SPI_SHADER_USER_DATA_VS_19},
	{27414, R_00B180_SPI_SHADER_USER_DATA_VS_20},
	{27441, R_00B184_SPI_SHADER_USER_DATA_VS_21},
	{27468, R_00B188_SPI_SHADER_USER_DATA_VS_22},
	{27495, R_00B18C_SPI_SHADER_USER_DATA_VS_23},
	{27522, R_00B190_SPI_SHADER_USER_DATA_VS_24},
	{27549, R_00B194_SPI_SHADER_USER_DATA_VS_25},
	{27576, R_00B198_SPI_SHADER_USER_DATA_VS_26},
	{27603, R_00B19C_SPI_SHADER_USER_DATA_VS_27},
	{27630, R_00B1A0_SPI_SHADER_USER_DATA_VS_28},
	{27657, R_00B1A4_SPI_SHADER_USER_DATA_VS_29},
	{27684, R_00B1A8_SPI_SHADER_USER_DATA_VS_30},
	{27711, R_00B1AC_SPI_SHADER_USER_DATA_VS_31},
	{27738, R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS, 9, 2469},
	{27765, R_00B204_SPI_SHADER_PGM_RSRC4_GS, 2, 2478},
	{27789, R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS},
	{27821, R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS},
	{5670, R_00B210_SPI_SHADER_PGM_LO_ES},
	{5691, R_00B214_SPI_SHADER_PGM_HI_ES, 1, 2480},
	{5026, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 2481},
	{5092, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 12, 2485},
	{5116, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 9, 2497},
	{27853, R_00B370_SPI_SHADER_USER_DATA_ES_16},
	{27880, R_00B374_SPI_SHADER_USER_DATA_ES_17},
	{27907, R_00B378_SPI_SHADER_USER_DATA_ES_18},
	{27934, R_00B37C_SPI_SHADER_USER_DATA_ES_19},
	{27961, R_00B380_SPI_SHADER_USER_DATA_ES_20},
	{27988, R_00B384_SPI_SHADER_USER_DATA_ES_21},
	{28015, R_00B388_SPI_SHADER_USER_DATA_ES_22},
	{28042, R_00B38C_SPI_SHADER_USER_DATA_ES_23},
	{28069, R_00B390_SPI_SHADER_USER_DATA_ES_24},
	{28096, R_00B394_SPI_SHADER_USER_DATA_ES_25},
	{28123, R_00B398_SPI_SHADER_USER_DATA_ES_26},
	{28150, R_00B39C_SPI_SHADER_USER_DATA_ES_27},
	{28177, R_00B3A0_SPI_SHADER_USER_DATA_ES_28},
	{28204, R_00B3A4_SPI_SHADER_USER_DATA_ES_29},
	{28231, R_00B3A8_SPI_SHADER_USER_DATA_ES_30},
	{28258, R_00B3AC_SPI_SHADER_USER_DATA_ES_31},
	{28285, R_00B404_SPI_SHADER_PGM_RSRC4_HS, 1, 2506},
	{28309, R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS},
	{28341, R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS},
	{6910, R_00B410_SPI_SHADER_PGM_LO_LS},
	{6931, R_00B414_SPI_SHADER_PGM_HI_LS, 1, 2507},
	{6266, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 4, 2508},
	{6332, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 11, 2512},
	{6356, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 2523},
	{7000, R_00B430_SPI_SHADER_USER_DATA_LS_0},
	{7026, R_00B434_SPI_SHADER_USER_DATA_LS_1},
	{7052, R_00B438_SPI_SHADER_USER_DATA_LS_2},
	{7078, R_00B43C_SPI_SHADER_USER_DATA_LS_3},
	{7104, R_00B440_SPI_SHADER_USER_DATA_LS_4},
	{7130, R_00B444_SPI_SHADER_USER_DATA_LS_5},
	{7156, R_00B448_SPI_SHADER_USER_DATA_LS_6},
	{7182, R_00B44C_SPI_SHADER_USER_DATA_LS_7},
	{7208, R_00B450_SPI_SHADER_USER_DATA_LS_8},
	{7234, R_00B454_SPI_SHADER_USER_DATA_LS_9},
	{7260, R_00B458_SPI_SHADER_USER_DATA_LS_10},
	{7287, R_00B45C_SPI_SHADER_USER_DATA_LS_11},
	{7314, R_00B460_SPI_SHADER_USER_DATA_LS_12},
	{7341, R_00B464_SPI_SHADER_USER_DATA_LS_13},
	{7368, R_00B468_SPI_SHADER_USER_DATA_LS_14},
	{7395, R_00B46C_SPI_SHADER_USER_DATA_LS_15},
	{28373, R_00B470_SPI_SHADER_USER_DATA_LS_16},
	{28400, R_00B474_SPI_SHADER_USER_DATA_LS_17},
	{28427, R_00B478_SPI_SHADER_USER_DATA_LS_18},
	{28454, R_00B47C_SPI_SHADER_USER_DATA_LS_19},
	{28481, R_00B480_SPI_SHADER_USER_DATA_LS_20},
	{28508, R_00B484_SPI_SHADER_USER_DATA_LS_21},
	{28535, R_00B488_SPI_SHADER_USER_DATA_LS_22},
	{28562, R_00B48C_SPI_SHADER_USER_DATA_LS_23},
	{28589, R_00B490_SPI_SHADER_USER_DATA_LS_24},
	{28616, R_00B494_SPI_SHADER_USER_DATA_LS_25},
	{28643, R_00B498_SPI_SHADER_USER_DATA_LS_26},
	{28670, R_00B49C_SPI_SHADER_USER_DATA_LS_27},
	{28697, R_00B4A0_SPI_SHADER_USER_DATA_LS_28},
	{28724, R_00B4A4_SPI_SHADER_USER_DATA_LS_29},
	{28751, R_00B4A8_SPI_SHADER_USER_DATA_LS_30},
	{28778, R_00B4AC_SPI_SHADER_USER_DATA_LS_31},
	{28805, R_00B530_SPI_SHADER_USER_DATA_COMMON_0},
	{28835, R_00B534_SPI_SHADER_USER_DATA_COMMON_1},
	{28865, R_00B538_SPI_SHADER_USER_DATA_COMMON_2},
	{28895, R_00B53C_SPI_SHADER_USER_DATA_COMMON_3},
	{28925, R_00B540_SPI_SHADER_USER_DATA_COMMON_4},
	{28955, R_00B544_SPI_SHADER_USER_DATA_COMMON_5},
	{28985, R_00B548_SPI_SHADER_USER_DATA_COMMON_6},
	{29015, R_00B54C_SPI_SHADER_USER_DATA_COMMON_7},
	{29045, R_00B550_SPI_SHADER_USER_DATA_COMMON_8},
	{29075, R_00B554_SPI_SHADER_USER_DATA_COMMON_9},
	{29105, R_00B558_SPI_SHADER_USER_DATA_COMMON_10},
	{29136, R_00B55C_SPI_SHADER_USER_DATA_COMMON_11},
	{29167, R_00B560_SPI_SHADER_USER_DATA_COMMON_12},
	{29198, R_00B564_SPI_SHADER_USER_DATA_COMMON_13},
	{29229, R_00B568_SPI_SHADER_USER_DATA_COMMON_14},
	{29260, R_00B56C_SPI_SHADER_USER_DATA_COMMON_15},
	{29291, R_00B570_SPI_SHADER_USER_DATA_COMMON_16},
	{29322, R_00B574_SPI_SHADER_USER_DATA_COMMON_17},
	{29353, R_00B578_SPI_SHADER_USER_DATA_COMMON_18},
	{29384, R_00B57C_SPI_SHADER_USER_DATA_COMMON_19},
	{29415, R_00B580_SPI_SHADER_USER_DATA_COMMON_20},
	{29446, R_00B584_SPI_SHADER_USER_DATA_COMMON_21},
	{29477, R_00B588_SPI_SHADER_USER_DATA_COMMON_22},
	{29508, R_00B58C_SPI_SHADER_USER_DATA_COMMON_23},
	{29539, R_00B590_SPI_SHADER_USER_DATA_COMMON_24},
	{29570, R_00B594_SPI_SHADER_USER_DATA_COMMON_25},
	{29601, R_00B598_SPI_SHADER_USER_DATA_COMMON_26},
	{29632, R_00B59C_SPI_SHADER_USER_DATA_COMMON_27},
	{29663, R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28},
	{29694, R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29},
	{29725, R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30},
	{29756, R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31},
	{7422, R_00B800_COMPUTE_DISPATCH_INITIATOR, 11, 2530},
	{7690, R_00B834_COMPUTE_PGM_HI, 1, 875},
	{29787, R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO},
	{29816, R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI, 1, 877},
	{29845, R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO},
	{29878, R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI, 1, 878},
	{7765, R_00B848_COMPUTE_PGM_RSRC1, 11, 2541},
	{7783, R_00B84C_COMPUTE_PGM_RSRC2, 12, 2552},
	{7814, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 2564},
	{29911, R_034030_CPF_LATENCY_STATS_DATA},
	{29934, R_034034_CPG_LATENCY_STATS_DATA},
	{29957, R_034038_CPC_LATENCY_STATS_DATA},
	{12244, R_036000_CPG_PERFCOUNTER1_SELECT, 5, 2571},
	{12268, R_036004_CPG_PERFCOUNTER0_SELECT1, 4, 2576},
	{12293, R_036008_CPG_PERFCOUNTER0_SELECT, 5, 2571},
	{12317, R_03600C_CPC_PERFCOUNTER1_SELECT, 5, 2580},
	{12341, R_036010_CPC_PERFCOUNTER0_SELECT1, 4, 2585},
	{12366, R_036014_CPF_PERFCOUNTER1_SELECT, 5, 2589},
	{12390, R_036018_CPF_PERFCOUNTER0_SELECT1, 4, 2594},
	{12415, R_03601C_CPF_PERFCOUNTER0_SELECT, 5, 2589},
	{12455, R_036024_CPC_PERFCOUNTER0_SELECT, 5, 2580},
	{29980, R_036028_CPF_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2598},
	{30014, R_03602C_CPG_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2601},
	{30048, R_036030_CPF_LATENCY_STATS_SELECT, 3, 2604},
	{30073, R_036034_CPG_LATENCY_STATS_SELECT, 3, 2607},
	{30098, R_036038_CPC_LATENCY_STATS_SELECT, 3, 2610},
	{12479, R_036100_GRBM_PERFCOUNTER0_SELECT, 22, 2613},
	{12504, R_036104_GRBM_PERFCOUNTER1_SELECT, 22, 2613},
	{12529, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 13, 2635},
	{12557, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 13, 2648},
	{12585, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 13, 2661},
	{12613, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 13, 2674},
	{13414, R_036600_SPI_PERFCOUNTER0_SELECT, 5, 2687},
	{13438, R_036604_SPI_PERFCOUNTER1_SELECT, 5, 2687},
	{13462, R_036608_SPI_PERFCOUNTER2_SELECT, 5, 2687},
	{13486, R_03660C_SPI_PERFCOUNTER3_SELECT, 5, 2687},
	{13510, R_036610_SPI_PERFCOUNTER0_SELECT1, 4, 2692},
	{13610, R_036620_SPI_PERFCOUNTER4_SELECT, 5, 2687},
	{13634, R_036624_SPI_PERFCOUNTER5_SELECT, 5, 2687},
	{15266, R_028008_DB_DEPTH_VIEW, 5, 2696},
	{15299, R_028010_DB_RENDER_OVERRIDE2, 16, 2701},
	{30123, R_028018_DB_HTILE_DATA_BASE_HI, 1, 2717},
	{15572, R_02801C_DB_DEPTH_SIZE, 2, 2718},
	{15472, R_028038_DB_Z_INFO, 13, 2720},
	{15482, R_02803C_DB_STENCIL_INFO, 8, 2733},
	{15498, R_028040_DB_Z_READ_BASE},
	{30145, R_028044_DB_Z_READ_BASE_HI, 1, 2741},
	{15513, R_028048_DB_STENCIL_READ_BASE},
	{30163, R_02804C_DB_STENCIL_READ_BASE_HI, 1, 2742},
	{30187, R_028054_DB_Z_WRITE_BASE_HI, 1, 2743},
	{15550, R_028058_DB_STENCIL_WRITE_BASE},
	{30206, R_02805C_DB_STENCIL_WRITE_BASE_HI, 1, 2744},
	{30231, R_028060_DB_DFSM_CONTROL, 3, 2745},
	{30247, R_028068_DB_Z_INFO2, 1, 2748},
	{30258, R_02806C_DB_STENCIL_INFO2, 1, 2749},
	{15636, R_0281E8_COHER_DEST_BASE_HI_0, 1, 2750},
	{15657, R_0281EC_COHER_DEST_BASE_HI_1, 1, 2751},
	{15678, R_0281F0_COHER_DEST_BASE_HI_2, 1, 2752},
	{15699, R_0281F4_COHER_DEST_BASE_HI_3, 1, 2753},
	{17596, R_028350_PA_SC_RASTER_CONFIG, 15, 2754},
	{17616, R_028354_PA_SC_RASTER_CONFIG_1, 3, 2769},
	{30275, R_02835C_PA_SC_TILE_STEERING_OVERRIDE, 3, 2772},
	{30304, R_028360_CP_PERFMON_CNTX_CNTL, 1, 2775},
	{30325, R_0283A0_PA_SC_RIGHT_VERT_GRID, 4, 2776},
	{30347, R_0283A4_PA_SC_LEFT_VERT_GRID, 4, 2780},
	{30368, R_0283A8_PA_SC_HORIZ_GRID, 4, 2784},
	{17802, R_028424_CB_DCC_CONTROL, 4, 2788},
	{20961, R_0286C4_SPI_VS_OUT_CONFIG, 2, 1352},
	{21035, R_0286D8_SPI_PS_IN_CONTROL, 5, 2792},
	{30385, R_0287A0_CB_MRT0_EPITCH, 1, 2797},
	{30400, R_0287A4_CB_MRT1_EPITCH, 1, 2798},
	{30415, R_0287A8_CB_MRT2_EPITCH, 1, 2799},
	{30430, R_0287AC_CB_MRT3_EPITCH, 1, 2800},
	{30445, R_0287B0_CB_MRT4_EPITCH, 1, 2801},
	{30460, R_0287B4_CB_MRT5_EPITCH, 1, 2802},
	{30475, R_0287B8_CB_MRT6_EPITCH, 1, 2803},
	{30490, R_0287BC_CB_MRT7_EPITCH, 1, 2804},
	{21617, R_0287E4_VGT_DMA_BASE_HI, 1, 2805},
	{21646, R_0287F0_VGT_DRAW_INITIATOR, 8, 2806},
	{21744, R_02880C_DB_SHADER_CONTROL, 16, 2814},
	{21778, R_028814_PA_SU_SC_MODE_CNTL, 15, 2830},
	{21797, R_028818_PA_CL_VTE_CNTL, 10, 2845},
	{21812, R_02881C_PA_CL_VS_OUT_CNTL, 28, 2855},
	{30505, R_028834_PA_CL_OBJPRIM_ID_CNTL, 3, 2883},
	{30527, R_028838_PA_CL_NGG_CNTL, 2, 2886},
	{30542, R_02883C_PA_SU_OVER_RASTERIZATION_CNTL, 5, 2888},
	{30572, R_028840_PA_STEREO_CNTL},
	{22272, R_028A40_VGT_GS_MODE, 15, 2893},
	{22284, R_028A44_VGT_GS_ONCHIP_CNTL, 3, 2908},
	{22303, R_028A48_PA_SC_MODE_CNTL_0, 7, 2911},
	{22524, R_028A7C_VGT_DMA_INDEX_TYPE, 7, 2918},
	{22554, R_028A84_VGT_PRIMITIVEID_EN, 3, 2925},
	{22617, R_028A90_VGT_EVENT_INITIATOR, 3, 2928},
	{30587, R_028A94_VGT_GS_MAX_PRIMS_PER_SUBGROUP, 1, 2931},
	{30617, R_028A98_VGT_DRAW_PAYLOAD_CNTL, 4, 2932},
	{22808, R_028ABC_DB_HTILE_SURFACE, 8, 2936},
	{23368, R_028B54_VGT_SHADER_STAGES_EN, 13, 2944},
	{23496, R_028B6C_VGT_TF_PARAM, 8, 2957},
	{23744, R_028B94_VGT_STRMOUT_CONFIG, 8, 2965},
	{30639, R_028B9C_VGT_DMA_EVENT_INITIATOR, 3, 2973},
	{23857, R_028BE0_PA_SC_AA_CONFIG, 6, 2976},
	{24572, R_028C40_PA_SC_SHADER_CONTROL, 3, 2982},
	{30663, R_028C44_PA_SC_BINNER_CNTL_0, 10, 2985},
	{30683, R_028C48_PA_SC_BINNER_CNTL_1, 2, 2995},
	{30703, R_028C4C_PA_SC_CONSERVATIVE_RASTERIZATION_CNTL, 18, 2997},
	{30741, R_028C50_PA_SC_NGG_MODE_CNTL, 1, 3015},
	{30761, R_028C64_CB_COLOR0_BASE_EXT, 1, 3016},
	{30780, R_028C68_CB_COLOR0_ATTRIB2, 3, 3017},
	{24689, R_028C6C_CB_COLOR0_VIEW, 3, 3020},
	{24704, R_028C70_CB_COLOR0_INFO, 16, 3023},
	{24719, R_028C74_CB_COLOR0_ATTRIB, 10, 3039},
	{30798, R_028C80_CB_COLOR0_CMASK_BASE_EXT, 1, 3049},
	{30823, R_028C88_CB_COLOR0_FMASK_BASE_EXT, 1, 3050},
	{30848, R_028C98_CB_COLOR0_DCC_BASE_EXT, 1, 3051},
	{30871, R_028CA0_CB_COLOR1_BASE_EXT, 1, 3016},
	{30890, R_028CA4_CB_COLOR1_ATTRIB2},
	{24944, R_028CA8_CB_COLOR1_VIEW, 3, 3020},
	{24959, R_028CAC_CB_COLOR1_INFO, 16, 3023},
	{24974, R_028CB0_CB_COLOR1_ATTRIB, 10, 3039},
	{30908, R_028CBC_CB_COLOR1_CMASK_BASE_EXT, 1, 3049},
	{30933, R_028CC4_CB_COLOR1_FMASK_BASE_EXT, 1, 3050},
	{30958, R_028CD4_CB_COLOR1_DCC_BASE_EXT, 1, 3051},
	{30981, R_028CDC_CB_COLOR2_BASE_EXT, 1, 3016},
	{31000, R_028CE0_CB_COLOR2_ATTRIB2},
	{25199, R_028CE4_CB_COLOR2_VIEW, 3, 3020},
	{25214, R_028CE8_CB_COLOR2_INFO, 16, 3023},
	{25229, R_028CEC_CB_COLOR2_ATTRIB, 10, 3039},
	{31018, R_028CF8_CB_COLOR2_CMASK_BASE_EXT, 1, 3049},
	{31043, R_028D00_CB_COLOR2_FMASK_BASE_EXT, 1, 3050},
	{31068, R_028D10_CB_COLOR2_DCC_BASE_EXT, 1, 3051},
	{31091, R_028D18_CB_COLOR3_BASE_EXT, 1, 3016},
	{31110, R_028D1C_CB_COLOR3_ATTRIB2},
	{25454, R_028D20_CB_COLOR3_VIEW, 3, 3020},
	{25469, R_028D24_CB_COLOR3_INFO, 16, 3023},
	{25484, R_028D28_CB_COLOR3_ATTRIB, 10, 3039},
	{31128, R_028D34_CB_COLOR3_CMASK_BASE_EXT, 1, 3049},
	{31153, R_028D3C_CB_COLOR3_FMASK_BASE_EXT, 1, 3050},
	{31178, R_028D4C_CB_COLOR3_DCC_BASE_EXT, 1, 3051},
	{31201, R_028D54_CB_COLOR4_BASE_EXT, 1, 3016},
	{31220, R_028D58_CB_COLOR4_ATTRIB2},
	{25709, R_028D5C_CB_COLOR4_VIEW, 3, 3020},
	{25724, R_028D60_CB_COLOR4_INFO, 16, 3023},
	{25739, R_028D64_CB_COLOR4_ATTRIB, 10, 3039},
	{31238, R_028D70_CB_COLOR4_CMASK_BASE_EXT, 1, 3049},
	{31263, R_028D78_CB_COLOR4_FMASK_BASE_EXT, 1, 3050},
	{31288, R_028D88_CB_COLOR4_DCC_BASE_EXT, 1, 3051},
	{31311, R_028D90_CB_COLOR5_BASE_EXT, 1, 3016},
	{31330, R_028D94_CB_COLOR5_ATTRIB2},
	{25964, R_028D98_CB_COLOR5_VIEW, 3, 3020},
	{25979, R_028D9C_CB_COLOR5_INFO, 16, 3023},
	{25994, R_028DA0_CB_COLOR5_ATTRIB, 10, 3039},
	{31348, R_028DAC_CB_COLOR5_CMASK_BASE_EXT, 1, 3049},
	{31373, R_028DB4_CB_COLOR5_FMASK_BASE_EXT, 1, 3050},
	{31398, R_028DC4_CB_COLOR5_DCC_BASE_EXT, 1, 3051},
	{31421, R_028DCC_CB_COLOR6_BASE_EXT, 1, 3016},
	{31440, R_028DD0_CB_COLOR6_ATTRIB2},
	{26219, R_028DD4_CB_COLOR6_VIEW, 3, 3020},
	{26234, R_028DD8_CB_COLOR6_INFO, 16, 3023},
	{26249, R_028DDC_CB_COLOR6_ATTRIB, 10, 3039},
	{31458, R_028DE8_CB_COLOR6_CMASK_BASE_EXT, 1, 3049},
	{31483, R_028DF0_CB_COLOR6_FMASK_BASE_EXT, 1, 3050},
	{31508, R_028E00_CB_COLOR6_DCC_BASE_EXT, 1, 3051},
	{31531, R_028E08_CB_COLOR7_BASE_EXT, 1, 3016},
	{31550, R_028E0C_CB_COLOR7_ATTRIB2},
	{26474, R_028E10_CB_COLOR7_VIEW, 3, 3020},
	{26489, R_028E14_CB_COLOR7_INFO, 16, 3023},
	{26504, R_028E18_CB_COLOR7_ATTRIB, 10, 3039},
	{31568, R_028E24_CB_COLOR7_CMASK_BASE_EXT, 1, 3049},
	{31593, R_028E2C_CB_COLOR7_FMASK_BASE_EXT, 1, 3050},
	{31618, R_028E3C_CB_COLOR7_DCC_BASE_EXT, 1, 3051},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{31641, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{31663, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{31685, S_370_ENGINE_SEL(~0u), 4, 0},
	{31696, S_370_WR_CONFIRM(~0u)},
	{31707, S_370_WR_ONE_ADDR(~0u)},
	{31771, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{31779, S_3F2_IB_SIZE(~0u)},
	{31787, S_3F2_CHAIN(~0u)},
	{31793, S_3F2_VALID(~0u)},
	/* 9 */
	{963, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{31799, S_411_CP_SYNC(~0u)},
	{31831, S_411_SRC_SEL(~0u), 4, 10},
	{31839, S_411_ENGINE(~0u), 2, 0},
	{31771, S_411_DST_SEL(~0u), 4, 14},
	{975, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{842, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{854, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{31870, S_414_BYTE_COUNT_GFX6(~0u)},
	{31886, S_414_BYTE_COUNT_GFX9(~0u)},
	{31902, S_414_DISABLE_WR_CONFIRM_GFX6(~0u)},
	{31955, S_414_SRC_SWAP(~0u), 4, 18},
	{31964, S_414_DST_SWAP(~0u), 4, 18},
	{31980, S_414_SAS(~0u), 2, 22},
	{31984, S_414_DAS(~0u), 2, 22},
	{32011, S_414_SAIC(~0u), 2, 24},
	{32016, S_414_DAIC(~0u), 2, 24},
	{32021, S_414_RAW_WAIT(~0u)},
	{32030, S_414_DISABLE_WR_CONFIRM_GFX9(~0u)},
	/* 28 */
	{31799, S_500_CP_SYNC(~0u)},
	{31831, S_500_SRC_SEL(~0u), 4, 10},
	{32054, S_500_DST_CACHE_POLICY(~0u)},
	{31771, S_500_DST_SEL(~0u), 4, 14},
	{32071, S_500_SRC_CACHE_POLICY(~0u)},
	{31839, S_500_ENGINE(~0u), 2, 0},
	/* 34 */
	{32088, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{32104, S_000E4C_TST_RQ_PENDING(~0u)},
	{32119, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{32136, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{32152, S_000E4C_VP8_BUSY(~0u)},
	{32161, S_000E4C_SDMA_BUSY(~0u)},
	{32171, S_000E4C_SDMA1_BUSY(~0u)},
	{32182, S_000E4C_VCE0_BUSY(~0u)},
	{32192, S_000E4C_XDMA_BUSY(~0u)},
	{32202, S_000E4C_CHUB_BUSY(~0u)},
	{32212, S_000E4C_SDMA2_BUSY(~0u)},
	{32223, S_000E4C_SDMA3_BUSY(~0u)},
	{32234, S_000E4C_SAMSCP_BUSY(~0u)},
	{32246, S_000E4C_ISP_BUSY(~0u)},
	{32255, S_000E4C_VCE1_BUSY(~0u)},
	{32265, S_000E4C_ODE_BUSY(~0u)},
	{32274, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{32291, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{32308, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{32326, S_000E4C_ISP_RQ_PENDING(~0u)},
	{32341, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 55 */
	{32357, S_000E50_UVD_RQ_PENDING(~0u)},
	{32372, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{32390, S_000E50_ACP_RQ_PENDING(~0u)},
	{32405, S_000E50_SMU_RQ_PENDING(~0u)},
	{32420, S_000E50_GRBM_RQ_PENDING(~0u)},
	{32436, S_000E50_HI_RQ_PENDING(~0u)},
	{32450, S_000E50_VMC_BUSY(~0u)},
	{32459, S_000E50_MCB_BUSY(~0u)},
	{32468, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{32489, S_000E50_MCC_BUSY(~0u)},
	{32498, S_000E50_MCD_BUSY(~0u)},
	{32507, S_000E50_VMC1_BUSY(~0u)},
	{32517, S_000E50_SEM_BUSY(~0u)},
	{32526, S_000E50_ACP_BUSY(~0u)},
	{32535, S_000E50_IH_BUSY(~0u)},
	{32543, S_000E50_UVD_BUSY(~0u)},
	{32552, S_000E50_SAMMSP_BUSY(~0u)},
	{32564, S_000E50_GCATCL2_BUSY(~0u)},
	{32577, S_000E50_OSATCL2_BUSY(~0u)},
	{32590, S_000E50_BIF_BUSY(~0u)},
	/* 75 */
	{32599, S_000E54_MCC0_BUSY(~0u)},
	{32609, S_000E54_MCC1_BUSY(~0u)},
	{32619, S_000E54_MCC2_BUSY(~0u)},
	{32629, S_000E54_MCC3_BUSY(~0u)},
	{32639, S_000E54_MCC4_BUSY(~0u)},
	{32649, S_000E54_MCC5_BUSY(~0u)},
	{32659, S_000E54_MCC6_BUSY(~0u)},
	{32669, S_000E54_MCC7_BUSY(~0u)},
	{32679, S_000E54_MCD0_BUSY(~0u)},
	{32689, S_000E54_MCD1_BUSY(~0u)},
	{32699, S_000E54_MCD2_BUSY(~0u)},
	{32709, S_000E54_MCD3_BUSY(~0u)},
	{32719, S_000E54_MCD4_BUSY(~0u)},
	{32729, S_000E54_MCD5_BUSY(~0u)},
	{32739, S_000E54_MCD6_BUSY(~0u)},
	{32749, S_000E54_MCD7_BUSY(~0u)},
	/* 91 */
	{32759, S_00D034_IDLE(~0u)},
	{32764, S_00D034_REG_IDLE(~0u)},
	{32773, S_00D034_RB_EMPTY(~0u)},
	{32782, S_00D034_RB_FULL(~0u)},
	{32790, S_00D034_RB_CMD_IDLE(~0u)},
	{32802, S_00D034_RB_CMD_FULL(~0u)},
	{32814, S_00D034_IB_CMD_IDLE(~0u)},
	{32826, S_00D034_IB_CMD_FULL(~0u)},
	{32838, S_00D034_BLOCK_IDLE(~0u)},
	{32849, S_00D034_INSIDE_IB(~0u)},
	{32859, S_00D034_EX_IDLE(~0u)},
	{32867, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{32893, S_00D034_PACKET_READY(~0u)},
	{32906, S_00D034_MC_WR_IDLE(~0u)},
	{32917, S_00D034_SRBM_IDLE(~0u)},
	{32927, S_00D034_CONTEXT_EMPTY(~0u)},
	{32941, S_00D034_DELTA_RPTR_FULL(~0u)},
	{32957, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{32973, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{32989, S_00D034_MC_RD_IDLE(~0u)},
	{33000, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{33017, S_00D034_MC_RD_RET_STALL(~0u)},
	{33033, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{33052, S_00D034_PREV_CMD_IDLE(~0u)},
	{33066, S_00D034_SEM_IDLE(~0u)},
	{33075, S_00D034_SEM_REQ_STALL(~0u)},
	{33089, S_00D034_SEM_RESP_STATE(~0u)},
	{33104, S_00D034_INT_IDLE(~0u)},
	{33113, S_00D034_INT_REQ_STALL(~0u)},
	/* 120 */
	{33127, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33150, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33173, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33196, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33216, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33236, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33256, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33276, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33296, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33316, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33336, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33356, S_008008_RLC_RQ_PENDING(~0u)},
	{33371, S_008008_RLC_BUSY(~0u)},
	{33380, S_008008_TC_BUSY(~0u)},
	{33388, S_008008_TCC_CC_RESIDENT(~0u)},
	{33404, S_008008_CPF_BUSY(~0u)},
	{33413, S_008008_CPC_BUSY(~0u)},
	{33422, S_008008_CPG_BUSY(~0u)},
	/* 138 */
	{33431, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{33454, S_008010_SRBM_RQ_PENDING(~0u)},
	{33470, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33493, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33516, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33535, S_008010_DB_CLEAN(~0u)},
	{33544, S_008010_CB_CLEAN(~0u)},
	{33553, S_008010_TA_BUSY(~0u)},
	{33561, S_008010_GDS_BUSY(~0u)},
	{33570, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33585, S_008010_VGT_BUSY(~0u)},
	{33594, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33609, S_008010_IA_BUSY(~0u)},
	{33617, S_008010_SX_BUSY(~0u)},
	{33625, S_008010_WD_BUSY(~0u)},
	{33633, S_008010_SPI_BUSY(~0u)},
	{33642, S_008010_BCI_BUSY(~0u)},
	{33651, S_008010_SC_BUSY(~0u)},
	{33659, S_008010_PA_BUSY(~0u)},
	{33667, S_008010_DB_BUSY(~0u)},
	{33675, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32238, S_008010_CP_BUSY(~0u)},
	{32460, S_008010_CB_BUSY(~0u)},
	{33693, S_008010_GUI_ACTIVE(~0u)},
	/* 162 */
	{33704, S_00802C_INSTANCE_INDEX(~0u)},
	{33719, S_00802C_SH_INDEX(~0u)},
	{33728, S_00802C_SE_INDEX(~0u)},
	{33737, S_00802C_SH_BROADCAST_WRITES(~0u)},
	{33757, S_00802C_INSTANCE_BROADCAST_WRITES(~0u)},
	{33783, S_00802C_SE_BROADCAST_WRITES(~0u)},
	/* 168 */
	{33803, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 169 */
	{33822, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{33838, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{33854, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{33872, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{33890, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{33908, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{33926, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{33944, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{33962, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{33980, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{33998, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{34015, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{34031, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{34047, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{34063, S_0085F0_TC_ACTION_ENA(~0u)},
	{34077, S_0085F0_CB_ACTION_ENA(~0u)},
	{34091, S_0085F0_DB_ACTION_ENA(~0u)},
	{34105, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34126, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 188 */
	{33535, S_008014_DB_CLEAN(~0u)},
	{33544, S_008014_CB_CLEAN(~0u)},
	{33642, S_008014_BCI_BUSY(~0u)},
	{33585, S_008014_VGT_BUSY(~0u)},
	{33659, S_008014_PA_BUSY(~0u)},
	{33553, S_008014_TA_BUSY(~0u)},
	{33617, S_008014_SX_BUSY(~0u)},
	{33633, S_008014_SPI_BUSY(~0u)},
	{33651, S_008014_SC_BUSY(~0u)},
	{33667, S_008014_DB_BUSY(~0u)},
	{32460, S_008014_CB_BUSY(~0u)},
	/* 199 */
	{33535, S_008018_DB_CLEAN(~0u)},
	{33544, S_008018_CB_CLEAN(~0u)},
	{33642, S_008018_BCI_BUSY(~0u)},
	{33585, S_008018_VGT_BUSY(~0u)},
	{33659, S_008018_PA_BUSY(~0u)},
	{33553, S_008018_TA_BUSY(~0u)},
	{33617, S_008018_SX_BUSY(~0u)},
	{33633, S_008018_SPI_BUSY(~0u)},
	{33651, S_008018_SC_BUSY(~0u)},
	{33667, S_008018_DB_BUSY(~0u)},
	{32460, S_008018_CB_BUSY(~0u)},
	/* 210 */
	{33535, S_008038_DB_CLEAN(~0u)},
	{33544, S_008038_CB_CLEAN(~0u)},
	{33642, S_008038_BCI_BUSY(~0u)},
	{33585, S_008038_VGT_BUSY(~0u)},
	{33659, S_008038_PA_BUSY(~0u)},
	{33553, S_008038_TA_BUSY(~0u)},
	{33617, S_008038_SX_BUSY(~0u)},
	{33633, S_008038_SPI_BUSY(~0u)},
	{33651, S_008038_SC_BUSY(~0u)},
	{33667, S_008038_DB_BUSY(~0u)},
	{32460, S_008038_CB_BUSY(~0u)},
	/* 221 */
	{33535, S_00803C_DB_CLEAN(~0u)},
	{33544, S_00803C_CB_CLEAN(~0u)},
	{33642, S_00803C_BCI_BUSY(~0u)},
	{33585, S_00803C_VGT_BUSY(~0u)},
	{33659, S_00803C_PA_BUSY(~0u)},
	{33553, S_00803C_TA_BUSY(~0u)},
	{33617, S_00803C_SX_BUSY(~0u)},
	{33633, S_00803C_SPI_BUSY(~0u)},
	{33651, S_00803C_SC_BUSY(~0u)},
	{33667, S_00803C_DB_BUSY(~0u)},
	{32460, S_00803C_CB_BUSY(~0u)},
	/* 232 */
	{33803, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 233 */
	{34147, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 234 */
	{34166, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 235 */
	{33822, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{33838, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{34184, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{34201, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{33854, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{33872, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{33890, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{33908, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{33926, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{33944, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{33962, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{33980, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{33998, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{34218, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34238, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{34256, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34015, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{34031, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{34047, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34063, S_0301F0_TC_ACTION_ENA(~0u)},
	{34077, S_0301F0_CB_ACTION_ENA(~0u)},
	{34091, S_0301F0_DB_ACTION_ENA(~0u)},
	{34105, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34273, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34126, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34298, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{34322, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 262 */
	{34339, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{34357, S_0301FC_MEID(~0u)},
	{34362, S_0301FC_PHASE1_STATUS(~0u)},
	{1005, S_0301FC_STATUS(~0u)},
	/* 266 */
	{34376, S_008210_MEC1_BUSY(~0u)},
	{34386, S_008210_MEC2_BUSY(~0u)},
	{34396, S_008210_DC0_BUSY(~0u)},
	{34405, S_008210_DC1_BUSY(~0u)},
	{34414, S_008210_RCIU1_BUSY(~0u)},
	{34425, S_008210_RCIU2_BUSY(~0u)},
	{34436, S_008210_ROQ1_BUSY(~0u)},
	{34446, S_008210_ROQ2_BUSY(~0u)},
	{34456, S_008210_TCIU_BUSY(~0u)},
	{34466, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34483, S_008210_QU_BUSY(~0u)},
	{34491, S_008210_ATCL2IU_BUSY(~0u)},
	{34504, S_008210_CPG_CPC_BUSY(~0u)},
	{34517, S_008210_CPF_CPC_BUSY(~0u)},
	{33413, S_008210_CPC_BUSY(~0u)},
	/* 281 */
	{34530, S_008214_MEC1_LOAD_BUSY(~0u)},
	{34545, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{34565, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{34581, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{34599, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{34619, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{34638, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{34657, S_008214_MEC1_TC_BUSY(~0u)},
	{34670, S_008214_MEC1_DMA_BUSY(~0u)},
	{34684, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{34708, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{34724, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{34740, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{34756, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{34772, S_008214_MEC2_LOAD_BUSY(~0u)},
	{34787, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{34807, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{34823, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{34841, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{34861, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{34880, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{34899, S_008214_MEC2_TC_BUSY(~0u)},
	{34912, S_008214_MEC2_DMA_BUSY(~0u)},
	{34926, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{34950, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{34966, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{34982, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{34998, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 309 */
	{35014, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{35033, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35053, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35072, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35093, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35111, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35134, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35156, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35177, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35195, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35218, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{35240, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35264, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35288, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 323 */
	{35311, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35330, S_00821C_CSF_BUSY(~0u)},
	{35339, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35354, S_00821C_ROQ_RING_BUSY(~0u)},
	{35368, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35387, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35406, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35421, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35438, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35460, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35482, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35497, S_00821C_INTERRUPT_BUSY(~0u)},
	{34456, S_00821C_TCIU_BUSY(~0u)},
	{35512, S_00821C_HQD_BUSY(~0u)},
	{35521, S_00821C_PRT_BUSY(~0u)},
	{34491, S_00821C_ATCL2IU_BUSY(~0u)},
	{35530, S_00821C_CPF_GFX_BUSY(~0u)},
	{35543, S_00821C_CPF_CMP_BUSY(~0u)},
	{35556, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35575, S_00821C_CPC_CPF_BUSY(~0u)},
	{33404, S_00821C_CPF_BUSY(~0u)},
	/* 344 */
	{35588, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{35606, S_008220_CSF_RING_BUSY(~0u)},
	{35620, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{35639, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{35658, S_008220_CSF_STATE_BUSY(~0u)},
	{35673, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{35691, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{35709, S_008220_CSF_ARBITER_BUSY(~0u)},
	{35726, S_008220_CSF_INPUT_BUSY(~0u)},
	{35741, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{35763, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{35787, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{35805, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{35823, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{35844, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{35868, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{35894, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{35911, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{35931, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{35951, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{35971, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{35992, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{36015, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{36036, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{36055, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{36072, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{36088, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{36104, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{36120, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{36139, S_008220_HQD_PQ_BUSY(~0u)},
	{36151, S_008220_HQD_IB_BUSY(~0u)},
	/* 375 */
	{36163, S_008224_RING_FETCHING_DATA(~0u)},
	{36182, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36202, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36222, S_008224_STATE_FETCHING_DATA(~0u)},
	{36242, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36263, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{35240, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35264, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35288, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 384 */
	{36284, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 385 */
	{36303, S_0088B0_PRIM_COUNT(~0u)},
	/* 386 */
	{36314, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{36333, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{36354, S_0088C4_ES_LIMIT(~0u)},
	/* 389 */
	{36363, S_0088D4_VERT_REUSE(~0u)},
	/* 390 */
	{22130, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 391 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 392 */
	{38, S_008988_SIZE(~0u)},
	/* 393 */
	{36932, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 394 */
	{36950, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{36971, S_008A14_NUM_CLIP_SEQ(~0u)},
	{36984, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{37007, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 398 */
	{1777, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 399 */
	{37027, S_008B10_CURRENT_PTR(~0u)},
	{37039, S_008B10_CURRENT_COUNT(~0u)},
	/* 401 */
	{37053, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37078, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37116, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37157, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37180, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37203, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37227, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37257, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37286, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37312, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37341, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37366, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36242, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36263, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37401, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37429, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{35240, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35264, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35288, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 420 */
	{37459, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{37486, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{37513, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{37542, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{37571, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{37600, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37628, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{37658, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{37685, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{37713, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{37738, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{37764, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{37789, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{37813, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{37838, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{37866, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 436 */
	{37895, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37921, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{37947, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{37974, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{38000, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{38022, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{38049, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{38071, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{38095, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{38120, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{38143, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{38170, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{38195, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{38223, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38248, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38273, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{38298, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{38327, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{38358, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{38386, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{38413, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{38443, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{38470, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{38497, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{38524, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{38550, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{38574, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{38606, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{38633, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 465 */
	{35354, S_008680_ROQ_RING_BUSY(~0u)},
	{35368, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35387, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35406, S_008680_ROQ_STATE_BUSY(~0u)},
	{38659, S_008680_DC_BUSY(~0u)},
	{34491, S_008680_ATCL2IU_BUSY(~0u)},
	{38667, S_008680_PFP_BUSY(~0u)},
	{38676, S_008680_MEQ_BUSY(~0u)},
	{38685, S_008680_ME_BUSY(~0u)},
	{38693, S_008680_QUERY_BUSY(~0u)},
	{35482, S_008680_SEMAPHORE_BUSY(~0u)},
	{35497, S_008680_INTERRUPT_BUSY(~0u)},
	{38704, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32162, S_008680_DMA_BUSY(~0u)},
	{38722, S_008680_RCIU_BUSY(~0u)},
	{34466, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38732, S_008680_CPC_CPG_BUSY(~0u)},
	{38745, S_008680_CE_BUSY(~0u)},
	{34456, S_008680_TCIU_BUSY(~0u)},
	{35421, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35438, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35460, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32238, S_008680_CP_BUSY(~0u)},
	/* 488 */
	{33704, S_030800_INSTANCE_INDEX(~0u)},
	{33719, S_030800_SH_INDEX(~0u)},
	{33728, S_030800_SE_INDEX(~0u)},
	{33737, S_030800_SH_BROADCAST_WRITES(~0u)},
	{33757, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{33783, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 494 */
	{22130, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 495 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 496 */
	{38, S_030938_SIZE(~0u)},
	/* 497 */
	{36932, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38801, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 499 */
	{1777, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 500 */
	{37027, S_030A04_CURRENT_PTR(~0u)},
	{37039, S_030A04_CURRENT_COUNT(~0u)},
	/* 502 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 504 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 506 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 508 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 510 */
	{38821, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{38847, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{38870, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{38895, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{38926, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{38960, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{38980, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{39007, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{39035, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 519 */
	{39070, S_008C08_INST_INVALIDATE(~0u)},
	{39086, S_008C08_DATA_INVALIDATE(~0u)},
	/* 521 */
	{39070, S_030D20_INST_INVALIDATE(~0u)},
	{39086, S_030D20_DATA_INVALIDATE(~0u)},
	{39102, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 524 */
	{39122, S_008C0C_RET(~0u)},
	{39126, S_008C0C_RUI(~0u)},
	{39130, S_008C0C_RNG(~0u)},
	/* 527 */
	{2571, S_008DFC_EN(~0u)},
	{39193, S_008DFC_TGT(~0u), 33, 90},
	{39197, S_008DFC_COMPR(~0u)},
	{33817, S_008DFC_DONE(~0u)},
	{39203, S_008DFC_VM(~0u)},
	{39223, S_008DFC_ENCODING(~0u), 63, 123},
	/* 533 */
	{39232, S_030E04_ADDRESS(~0u)},
	/* 534 */
	{2791, S_030F04_COUNT_HI(~0u)},
	/* 535 */
	{39240, S_008F04_BASE_ADDRESS_HI(~0u)},
	{23319, S_008F04_STRIDE(~0u)},
	{39256, S_008F04_CACHE_SWIZZLE(~0u)},
	{39270, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 539 */
	{2791, S_030F0C_COUNT_HI(~0u)},
	/* 540 */
	{39375, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39385, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39395, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39405, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39589, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{39981, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{39993, S_008F0C_ELEMENT_SIZE(~0u)},
	{40006, S_008F0C_INDEX_STRIDE(~0u)},
	{40019, S_008F0C_ADD_TID_ENABLE(~0u)},
	{40034, S_008F0C_ATC(~0u)},
	{40038, S_008F0C_HASH_ENABLE(~0u)},
	{40050, S_008F0C_HEAP(~0u)},
	{40055, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 554 */
	{2791, S_030F14_COUNT_HI(~0u)},
	/* 555 */
	{39240, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40130, S_008F14_MIN_LOD(~0u)},
	{41763, S_008F14_DATA_FORMAT_GFX6(~0u), 64, 222},
	{42147, S_008F14_NUM_FORMAT_GFX6(~0u), 16, 286},
	{40055, S_008F14_MTYPE(~0u)},
	/* 560 */
	{42163, S_008F18_WIDTH(~0u)},
	{42169, S_008F18_HEIGHT(~0u)},
	{42176, S_008F18_PERF_MOD(~0u)},
	{42185, S_008F18_INTERLACED(~0u)},
	/* 564 */
	{2791, S_030F1C_COUNT_HI(~0u)},
	/* 565 */
	{39375, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39385, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39395, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39405, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42196, S_008F1C_BASE_LEVEL(~0u)},
	{42207, S_008F1C_LAST_LEVEL(~0u)},
	{42218, S_008F1C_TILING_INDEX(~0u)},
	{42231, S_008F1C_POW2_PAD(~0u)},
	{40055, S_008F1C_MTYPE(~0u)},
	{40034, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 576 */
	{22114, S_008F20_DEPTH(~0u)},
	{42542, S_008F20_PITCH_GFX6(~0u)},
	/* 578 */
	{42553, S_008F24_BASE_ARRAY(~0u)},
	{42564, S_008F24_LAST_ARRAY(~0u)},
	/* 580 */
	{42575, S_008F28_MIN_LOD_WARN(~0u)},
	{42588, S_008F28_COUNTER_BANK_ID(~0u)},
	{42604, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{42619, S_008F28_COMPRESSION_EN(~0u)},
	{42634, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{42650, S_008F28_COLOR_TRANSFORM(~0u)},
	{42666, S_008F28_LOST_ALPHA_BITS(~0u)},
	{42682, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 588 */
	{42880, S_008F30_CLAMP_X(~0u), 8, 318},
	{42888, S_008F30_CLAMP_Y(~0u), 8, 318},
	{42896, S_008F30_CLAMP_Z(~0u), 8, 318},
	{42904, S_008F30_MAX_ANISO_RATIO(~0u)},
	{43152, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{43171, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{43190, S_008F30_ANISO_THRESHOLD(~0u)},
	{43206, S_008F30_MC_COORD_TRUNC(~0u)},
	{43221, S_008F30_FORCE_DEGAMMA(~0u)},
	{43235, S_008F30_ANISO_BIAS(~0u)},
	{43246, S_008F30_TRUNC_COORD(~0u)},
	{43258, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{43276, S_008F30_FILTER_MODE(~0u)},
	{43288, S_008F30_COMPAT_MODE(~0u)},
	/* 602 */
	{40130, S_008F34_MIN_LOD(~0u)},
	{43300, S_008F34_MAX_LOD(~0u)},
	{43308, S_008F34_PERF_MIP(~0u)},
	{43317, S_008F34_PERF_Z(~0u)},
	/* 606 */
	{43324, S_008F38_LOD_BIAS(~0u)},
	{43333, S_008F38_LOD_BIAS_SEC(~0u)},
	{43395, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{43470, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{43550, S_008F38_Z_FILTER(~0u), 3, 340},
	{43559, S_008F38_MIP_FILTER(~0u), 3, 340},
	{43570, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{43589, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{43606, S_008F38_FILTER_PREC_FIX(~0u)},
	{43622, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 616 */
	{43637, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{43654, S_008F3C_UPGRADED_DEPTH(~0u)},
	{43796, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 619 */
	{43814, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{43831, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{43848, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{43865, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{43882, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 624 */
	{43899, S_0090E0_PS_CU_EN(~0u)},
	{43908, S_0090E0_VS_CU_EN(~0u)},
	/* 626 */
	{43917, S_0090E4_GS_CU_EN(~0u)},
	{43926, S_0090E4_ES_CU_EN(~0u)},
	/* 628 */
	{43935, S_0090E8_LSHS_CU_EN(~0u)},
	/* 629 */
	{2656, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 630 */
	{2656, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 631 */
	{43951, S_0090F0_RING_ORDER_TS0(~0u), 1, 347},
	{43966, S_0090F0_RING_ORDER_TS1(~0u)},
	{43981, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 634 */
	{43996, S_00C700_PIPE_ORDER_TS0(~0u)},
	{44011, S_00C700_PIPE_ORDER_TS1(~0u)},
	{44026, S_00C700_PIPE_ORDER_TS2(~0u)},
	{44041, S_00C700_PIPE_ORDER_TS3(~0u)},
	{44056, S_00C700_TS0_DUR_MULT(~0u)},
	{44069, S_00C700_TS1_DUR_MULT(~0u)},
	{44082, S_00C700_TS2_DUR_MULT(~0u)},
	{44095, S_00C700_TS3_DUR_MULT(~0u)},
	/* 642 */
	{44108, S_0090F4_TS0_DURATION(~0u)},
	{44121, S_0090F4_TS1_DURATION(~0u)},
	/* 644 */
	{44134, S_0090F8_TS2_DURATION(~0u)},
	/* 645 */
	{38, S_008F40_SIZE(~0u)},
	/* 646 */
	{669, S_008F44_OFFSET(~0u)},
	/* 647 */
	{2791, S_030FFC_COUNT_HI(~0u)},
	/* 648 */
	{44147, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{44166, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{44185, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44207, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44229, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 653 */
	{44498, S_00913C_VTX_DONE_DELAY(~0u), 16, 348},
	{44513, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{44537, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{44553, S_00913C_PC_LIMIT_STRICT(~0u)},
	{44569, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 658 */
	{44583, S_00936C_TYPE_A(~0u)},
	{44590, S_00936C_VGPR_A(~0u)},
	{44597, S_00936C_SGPR_A(~0u)},
	{44604, S_00936C_LDS_A(~0u)},
	{44610, S_00936C_WAVES_A(~0u)},
	{44618, S_00936C_EN_A(~0u)},
	{44623, S_00936C_TYPE_B(~0u)},
	{44630, S_00936C_VGPR_B(~0u)},
	{44637, S_00936C_SGPR_B(~0u)},
	{44644, S_00936C_LDS_B(~0u)},
	{44650, S_00936C_WAVES_B(~0u)},
	{44658, S_00936C_EN_B(~0u)},
	/* 670 */
	{44663, S_009858_MSAA1_X(~0u)},
	{44671, S_009858_MSAA1_Y(~0u)},
	{44679, S_009858_MSAA2_X(~0u)},
	{44687, S_009858_MSAA2_Y(~0u)},
	{44695, S_009858_MSAA4_X(~0u)},
	{44703, S_009858_MSAA4_Y(~0u)},
	{44711, S_009858_MSAA8_X(~0u)},
	{44719, S_009858_MSAA8_Y(~0u)},
	{44727, S_009858_MSAA16_X(~0u)},
	{44736, S_009858_MSAA16_Y(~0u)},
	/* 680 */
	{44745, S_0098F8_NUM_PIPES(~0u)},
	{44755, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(~0u)},
	{44781, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{44802, S_0098F8_NUM_SHADER_ENGINES_GFX6(~0u)},
	{44826, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{44850, S_0098F8_NUM_GPUS_GFX6(~0u)},
	{44864, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{44884, S_0098F8_ROW_SIZE(~0u)},
	{44893, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 689 */
	{45026, S_009910_MICRO_TILE_MODE(~0u), 4, 364},
	{45271, S_009910_ARRAY_MODE(~0u), 16, 368},
	{45633, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{45823, S_009910_TILE_SPLIT(~0u), 7, 399},
	{45926, S_009910_BANK_WIDTH(~0u), 4, 406},
	{46033, S_009910_BANK_HEIGHT(~0u), 4, 410},
	{46145, S_009910_MACRO_TILE_ASPECT(~0u), 4, 414},
	{46232, S_009910_NUM_BANKS(~0u), 4, 418},
	{46273, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{46293, S_009910_SAMPLE_SPLIT(~0u)},
	/* 699 */
	{45926, S_009990_BANK_WIDTH(~0u)},
	{46033, S_009990_BANK_HEIGHT(~0u)},
	{46145, S_009990_MACRO_TILE_ASPECT(~0u)},
	{46232, S_009990_NUM_BANKS(~0u)},
	/* 703 */
	{46306, S_00B004_MEM_BASE(~0u)},
	/* 704 */
	{46306, S_00B00C_MEM_BASE(~0u)},
	/* 705 */
	{43902, S_00B01C_CU_EN(~0u)},
	{46315, S_00B01C_WAVE_LIMIT(~0u)},
	{46326, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 708 */
	{46306, S_00B024_MEM_BASE(~0u)},
	/* 709 */
	{46345, S_00B028_VGPRS(~0u)},
	{46351, S_00B028_SGPRS(~0u)},
	{2676, S_00B028_PRIORITY(~0u)},
	{46400, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{46411, S_00B028_PRIV(~0u)},
	{46416, S_00B028_DX10_CLAMP(~0u)},
	{46427, S_00B028_DEBUG_MODE(~0u)},
	{46438, S_00B028_IEEE_MODE(~0u)},
	{46448, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46465, S_00B028_CACHE_CTL(~0u)},
	{46475, S_00B028_CDBG_USER(~0u)},
	/* 720 */
	{46485, S_00B02C_SCRATCH_EN(~0u)},
	{46496, S_00B02C_USER_SGPR(~0u)},
	{46506, S_00B02C_TRAP_PRESENT(~0u)},
	{46519, S_00B02C_WAVE_CNT_EN(~0u)},
	{46531, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46546, S_00B02C_EXCP_EN_SI(~0u)},
	{46557, S_00B02C_EXCP_EN(~0u)},
	/* 727 */
	{46306, S_00B104_MEM_BASE(~0u)},
	/* 728 */
	{46306, S_00B10C_MEM_BASE(~0u)},
	/* 729 */
	{43902, S_00B118_CU_EN(~0u)},
	{46315, S_00B118_WAVE_LIMIT(~0u)},
	{46326, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 732 */
	{36357, S_00B11C_LIMIT(~0u)},
	/* 733 */
	{46306, S_00B124_MEM_BASE(~0u)},
	/* 734 */
	{46345, S_00B128_VGPRS(~0u)},
	{46351, S_00B128_SGPRS(~0u)},
	{2676, S_00B128_PRIORITY(~0u)},
	{46400, S_00B128_FLOAT_MODE(~0u)},
	{46411, S_00B128_PRIV(~0u)},
	{46416, S_00B128_DX10_CLAMP(~0u)},
	{46427, S_00B128_DEBUG_MODE(~0u)},
	{46438, S_00B128_IEEE_MODE(~0u)},
	{46565, S_00B128_VGPR_COMP_CNT(~0u)},
	{46579, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46465, S_00B128_CACHE_CTL(~0u)},
	{46475, S_00B128_CDBG_USER(~0u)},
	/* 746 */
	{46485, S_00B12C_SCRATCH_EN(~0u)},
	{46496, S_00B12C_USER_SGPR(~0u)},
	{46506, S_00B12C_TRAP_PRESENT(~0u)},
	{46595, S_00B12C_OC_LDS_EN(~0u)},
	{46605, S_00B12C_SO_BASE0_EN(~0u)},
	{46617, S_00B12C_SO_BASE1_EN(~0u)},
	{46629, S_00B12C_SO_BASE2_EN(~0u)},
	{46641, S_00B12C_SO_BASE3_EN(~0u)},
	{46653, S_00B12C_SO_EN(~0u)},
	{46546, S_00B12C_EXCP_EN_SI(~0u)},
	{46557, S_00B12C_EXCP_EN(~0u)},
	{46659, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 758 */
	{46306, S_00B204_MEM_BASE(~0u)},
	/* 759 */
	{46306, S_00B20C_MEM_BASE(~0u)},
	/* 760 */
	{43902, S_00B21C_CU_EN(~0u)},
	{46315, S_00B21C_WAVE_LIMIT(~0u)},
	{46326, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{46676, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 764 */
	{46306, S_00B224_MEM_BASE(~0u)},
	/* 765 */
	{46345, S_00B228_VGPRS(~0u)},
	{46351, S_00B228_SGPRS(~0u)},
	{2676, S_00B228_PRIORITY(~0u)},
	{46400, S_00B228_FLOAT_MODE(~0u)},
	{46411, S_00B228_PRIV(~0u)},
	{46416, S_00B228_DX10_CLAMP(~0u)},
	{46427, S_00B228_DEBUG_MODE(~0u)},
	{46438, S_00B228_IEEE_MODE(~0u)},
	{46579, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46465, S_00B228_CACHE_CTL(~0u)},
	{46475, S_00B228_CDBG_USER(~0u)},
	/* 776 */
	{46485, S_00B22C_SCRATCH_EN(~0u)},
	{46496, S_00B22C_USER_SGPR(~0u)},
	{46506, S_00B22C_TRAP_PRESENT(~0u)},
	{46546, S_00B22C_EXCP_EN_SI(~0u)},
	{46557, S_00B22C_EXCP_EN(~0u)},
	/* 781 */
	{46306, S_00B304_MEM_BASE(~0u)},
	/* 782 */
	{46306, S_00B30C_MEM_BASE(~0u)},
	/* 783 */
	{43902, S_00B31C_CU_EN(~0u)},
	{46315, S_00B31C_WAVE_LIMIT(~0u)},
	{46326, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{46676, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 787 */
	{46306, S_00B324_MEM_BASE(~0u)},
	/* 788 */
	{46345, S_00B328_VGPRS(~0u)},
	{46351, S_00B328_SGPRS(~0u)},
	{2676, S_00B328_PRIORITY(~0u)},
	{46400, S_00B328_FLOAT_MODE(~0u)},
	{46411, S_00B328_PRIV(~0u)},
	{46416, S_00B328_DX10_CLAMP(~0u)},
	{46427, S_00B328_DEBUG_MODE(~0u)},
	{46438, S_00B328_IEEE_MODE(~0u)},
	{46565, S_00B328_VGPR_COMP_CNT(~0u)},
	{46579, S_00B328_CU_GROUP_ENABLE(~0u)},
	{46465, S_00B328_CACHE_CTL(~0u)},
	{46475, S_00B328_CDBG_USER(~0u)},
	/* 800 */
	{46485, S_00B32C_SCRATCH_EN(~0u)},
	{46496, S_00B32C_USER_SGPR(~0u)},
	{46506, S_00B32C_TRAP_PRESENT(~0u)},
	{46595, S_00B32C_OC_LDS_EN(~0u)},
	{46546, S_00B32C_EXCP_EN_SI(~0u)},
	{46557, S_00B32C_EXCP_EN(~0u)},
	{46537, S_00B32C_LDS_SIZE(~0u)},
	/* 807 */
	{46306, S_00B404_MEM_BASE(~0u)},
	/* 808 */
	{46306, S_00B40C_MEM_BASE(~0u)},
	/* 809 */
	{46315, S_00B41C_WAVE_LIMIT(~0u)},
	{46326, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{46676, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 812 */
	{46306, S_00B424_MEM_BASE(~0u)},
	/* 813 */
	{46345, S_00B428_VGPRS(~0u)},
	{46351, S_00B428_SGPRS(~0u)},
	{2676, S_00B428_PRIORITY(~0u)},
	{46400, S_00B428_FLOAT_MODE(~0u)},
	{46411, S_00B428_PRIV(~0u)},
	{46416, S_00B428_DX10_CLAMP(~0u)},
	{46427, S_00B428_DEBUG_MODE(~0u)},
	{46438, S_00B428_IEEE_MODE(~0u)},
	{46465, S_00B428_CACHE_CTL(~0u)},
	{46475, S_00B428_CDBG_USER(~0u)},
	/* 823 */
	{46485, S_00B42C_SCRATCH_EN(~0u)},
	{46496, S_00B42C_USER_SGPR(~0u)},
	{46506, S_00B42C_TRAP_PRESENT(~0u)},
	{46595, S_00B42C_OC_LDS_EN(~0u)},
	{46693, S_00B42C_TG_SIZE_EN(~0u)},
	{46546, S_00B42C_EXCP_EN_SI(~0u)},
	{46704, S_00B42C_EXCP_EN_CIK_VI(~0u)},
	/* 830 */
	{46306, S_00B504_MEM_BASE(~0u)},
	/* 831 */
	{46306, S_00B50C_MEM_BASE(~0u)},
	/* 832 */
	{43902, S_00B51C_CU_EN(~0u)},
	{46315, S_00B51C_WAVE_LIMIT(~0u)},
	{46326, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{46676, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 836 */
	{46306, S_00B524_MEM_BASE(~0u)},
	/* 837 */
	{46345, S_00B528_VGPRS(~0u)},
	{46351, S_00B528_SGPRS(~0u)},
	{2676, S_00B528_PRIORITY(~0u)},
	{46400, S_00B528_FLOAT_MODE(~0u)},
	{46411, S_00B528_PRIV(~0u)},
	{46416, S_00B528_DX10_CLAMP(~0u)},
	{46427, S_00B528_DEBUG_MODE(~0u)},
	{46438, S_00B528_IEEE_MODE(~0u)},
	{46565, S_00B528_VGPR_COMP_CNT(~0u)},
	{46465, S_00B528_CACHE_CTL(~0u)},
	{46475, S_00B528_CDBG_USER(~0u)},
	/* 848 */
	{46485, S_00B52C_SCRATCH_EN(~0u)},
	{46496, S_00B52C_USER_SGPR(~0u)},
	{46506, S_00B52C_TRAP_PRESENT(~0u)},
	{46537, S_00B52C_LDS_SIZE(~0u)},
	{46546, S_00B52C_EXCP_EN_SI(~0u)},
	{46557, S_00B52C_EXCP_EN(~0u)},
	/* 854 */
	{46719, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46737, S_00B800_PARTIAL_TG_EN(~0u)},
	{46751, S_00B800_FORCE_START_AT_000(~0u)},
	{46770, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{46790, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{46810, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{46832, S_00B800_ORDER_MODE(~0u)},
	{46843, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{46863, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{46881, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{46899, S_00B800_DATA_ATC(~0u)},
	{46908, S_00B800_RESTORE(~0u)},
	/* 866 */
	{46916, S_00B81C_NUM_THREAD_FULL(~0u)},
	{46932, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 868 */
	{46916, S_00B820_NUM_THREAD_FULL(~0u)},
	{46932, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 870 */
	{46916, S_00B824_NUM_THREAD_FULL(~0u)},
	{46932, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 872 */
	{2656, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 873 */
	{7630, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 874 */
	{7658, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 875 */
	{391, S_00B834_DATA(~0u)},
	{46951, S_00B834_INST_ATC(~0u)},
	/* 877 */
	{391, S_00B83C_DATA(~0u)},
	/* 878 */
	{391, S_00B844_DATA(~0u)},
	/* 879 */
	{46345, S_00B848_VGPRS(~0u)},
	{46351, S_00B848_SGPRS(~0u)},
	{2676, S_00B848_PRIORITY(~0u)},
	{46400, S_00B848_FLOAT_MODE(~0u)},
	{46411, S_00B848_PRIV(~0u)},
	{46416, S_00B848_DX10_CLAMP(~0u)},
	{46427, S_00B848_DEBUG_MODE(~0u)},
	{46438, S_00B848_IEEE_MODE(~0u)},
	{46960, S_00B848_BULKY(~0u)},
	{46475, S_00B848_CDBG_USER(~0u)},
	/* 889 */
	{46485, S_00B84C_SCRATCH_EN(~0u)},
	{46496, S_00B84C_USER_SGPR(~0u)},
	{46506, S_00B84C_TRAP_PRESENT(~0u)},
	{46966, S_00B84C_TGID_X_EN(~0u)},
	{46976, S_00B84C_TGID_Y_EN(~0u)},
	{46986, S_00B84C_TGID_Z_EN(~0u)},
	{46693, S_00B84C_TG_SIZE_EN(~0u)},
	{46996, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{47011, S_00B84C_EXCP_EN_MSB(~0u)},
	{46537, S_00B84C_LDS_SIZE(~0u)},
	{46557, S_00B84C_EXCP_EN(~0u)},
	/* 900 */
	{391, S_00B850_DATA(~0u)},
	/* 901 */
	{47023, S_00B854_WAVES_PER_SH_SI(~0u)},
	{47039, S_00B854_WAVES_PER_SH(~0u)},
	{47052, S_00B854_TG_PER_CU(~0u)},
	{47062, S_00B854_LOCK_THRESHOLD(~0u)},
	{47077, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47092, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47108, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 908 */
	{47123, S_00B858_SH0_CU_EN(~0u)},
	{47133, S_00B858_SH1_CU_EN(~0u)},
	/* 910 */
	{47123, S_00B85C_SH0_CU_EN(~0u)},
	{47133, S_00B85C_SH1_CU_EN(~0u)},
	/* 912 */
	{47143, S_00B860_WAVES(~0u)},
	{47149, S_00B860_WAVESIZE(~0u)},
	/* 914 */
	{47123, S_00B864_SH0_CU_EN(~0u)},
	{47133, S_00B864_SH1_CU_EN(~0u)},
	/* 916 */
	{47123, S_00B868_SH0_CU_EN(~0u)},
	{47133, S_00B868_SH1_CU_EN(~0u)},
	/* 918 */
	{47158, S_00B87C_SEND_SEID(~0u)},
	{45354, S_00B87C_RESERVED2(~0u)},
	{47168, S_00B87C_RESERVED3(~0u)},
	{47178, S_00B87C_RESERVED4(~0u)},
	{47188, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 923 */
	{47201, S_00B888_PAYLOAD(~0u)},
	{47209, S_00B888_IS_EVENT(~0u)},
	{47218, S_00B888_IS_STATE(~0u)},
	/* 926 */
	{2051, S_00B890_ADDR(~0u)},
	/* 927 */
	{40034, S_00B894_ATC(~0u)},
	{40055, S_00B894_MTYPE(~0u)},
	/* 929 */
	{8905, S_034404_PERFCOUNTER_HI(~0u)},
	/* 930 */
	{47227, S_036008_PERF_SEL(~0u)},
	{47236, S_036008_PERF_SEL1(~0u)},
	{47246, S_036008_CNTR_MODE(~0u)},
	/* 933 */
	{47256, S_036004_PERF_SEL2(~0u)},
	{47266, S_036004_PERF_SEL3(~0u)},
	/* 935 */
	{47227, S_036024_PERF_SEL(~0u)},
	{47236, S_036024_PERF_SEL1(~0u)},
	{47246, S_036024_CNTR_MODE(~0u)},
	/* 938 */
	{47256, S_036010_PERF_SEL2(~0u)},
	{47266, S_036010_PERF_SEL3(~0u)},
	/* 940 */
	{47227, S_03601C_PERF_SEL(~0u)},
	{47236, S_03601C_PERF_SEL1(~0u)},
	{47246, S_03601C_CNTR_MODE(~0u)},
	/* 943 */
	{47256, S_036018_PERF_SEL2(~0u)},
	{47266, S_036018_PERF_SEL3(~0u)},
	/* 945 */
	{47323, S_036020_PERFMON_STATE(~0u), 3, 667},
	{47337, S_036020_SPM_PERFMON_STATE(~0u)},
	{47355, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{47375, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 949 */
	{47227, S_036100_PERF_SEL(~0u)},
	{47397, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47451, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47478, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47609, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47689, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47715, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47741, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{47795, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{47822, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{47848, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 968 */
	{47227, S_036108_PERF_SEL(~0u)},
	{47397, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47478, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47451, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 980 */
	{47227, S_03610C_PERF_SEL(~0u)},
	{47397, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47478, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47451, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 992 */
	{47227, S_036110_PERF_SEL(~0u)},
	{47397, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47478, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47451, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1004 */
	{47227, S_036114_PERF_SEL(~0u)},
	{47397, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47478, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47451, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1016 */
	{47227, S_036200_PERF_SEL(~0u)},
	{47874, S_036200_PERF_MODE(~0u)},
	/* 1018 */
	{47227, S_036210_PERF_SEL(~0u)},
	{47236, S_036210_PERF_SEL1(~0u)},
	{47246, S_036210_CNTR_MODE(~0u)},
	{47884, S_036210_PERF_MODE1(~0u)},
	{47874, S_036210_PERF_MODE(~0u)},
	/* 1023 */
	{47256, S_036220_PERF_SEL2(~0u)},
	{47266, S_036220_PERF_SEL3(~0u)},
	{47895, S_036220_PERF_MODE3(~0u)},
	{47906, S_036220_PERF_MODE2(~0u)},
	/* 1027 */
	{47227, S_036230_PERF_SEL(~0u)},
	{47236, S_036230_PERF_SEL1(~0u)},
	{47246, S_036230_CNTR_MODE(~0u)},
	{47884, S_036230_PERF_MODE1(~0u)},
	{47874, S_036230_PERF_MODE(~0u)},
	/* 1032 */
	{47256, S_036240_PERF_SEL2(~0u)},
	{47266, S_036240_PERF_SEL3(~0u)},
	{47895, S_036240_PERF_MODE3(~0u)},
	{47906, S_036240_PERF_MODE2(~0u)},
	/* 1036 */
	{47917, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1037 */
	{47227, S_036400_PERF_SEL(~0u)},
	{47236, S_036400_PERF_SEL1(~0u)},
	{47246, S_036400_CNTR_MODE(~0u)},
	/* 1040 */
	{47256, S_036404_PERF_SEL2(~0u)},
	{47266, S_036404_PERF_SEL3(~0u)},
	/* 1042 */
	{47227, S_036500_PERF_SEL(~0u)},
	{47236, S_036500_PERF_SEL1(~0u)},
	{47246, S_036500_CNTR_MODE(~0u)},
	/* 1045 */
	{47256, S_036504_PERF_SEL2(~0u)},
	{47266, S_036504_PERF_SEL3(~0u)},
	/* 1047 */
	{47227, S_036600_PERF_SEL(~0u)},
	{47236, S_036600_PERF_SEL1(~0u)},
	{47246, S_036600_CNTR_MODE(~0u)},
	/* 1050 */
	{47256, S_036610_PERF_SEL2(~0u)},
	{47266, S_036610_PERF_SEL3(~0u)},
	/* 1052 */
	{47939, S_036628_BIN0_MIN(~0u)},
	{47948, S_036628_BIN0_MAX(~0u)},
	{47957, S_036628_BIN1_MIN(~0u)},
	{47966, S_036628_BIN1_MAX(~0u)},
	{47975, S_036628_BIN2_MIN(~0u)},
	{47984, S_036628_BIN2_MAX(~0u)},
	{47993, S_036628_BIN3_MIN(~0u)},
	{48002, S_036628_BIN3_MAX(~0u)},
	/* 1060 */
	{47227, S_036700_PERF_SEL(~0u)},
	{48011, S_036700_SQC_BANK_MASK(~0u)},
	{48025, S_036700_SQC_CLIENT_MASK(~0u)},
	{48041, S_036700_SPM_MODE(~0u)},
	{48050, S_036700_SIMD_MASK(~0u)},
	{47874, S_036700_PERF_MODE(~0u)},
	/* 1066 */
	{48060, S_036780_PS_EN(~0u)},
	{48066, S_036780_VS_EN(~0u)},
	{48072, S_036780_GS_EN(~0u)},
	{23383, S_036780_ES_EN(~0u)},
	{48078, S_036780_HS_EN(~0u)},
	{48084, S_036780_LS_EN(~0u)},
	{48090, S_036780_CS_EN(~0u)},
	{48096, S_036780_CNTR_RATE(~0u)},
	{48106, S_036780_DISABLE_FLUSH(~0u)},
	/* 1075 */
	{48120, S_036784_SH0_MASK(~0u)},
	{48129, S_036784_SH1_MASK(~0u)},
	/* 1077 */
	{48138, S_036788_FORCE_EN(~0u)},
	/* 1078 */
	{12538, S_036900_PERFCOUNTER_SELECT(~0u)},
	{48147, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{47246, S_036900_CNTR_MODE(~0u)},
	/* 1081 */
	{48167, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{48187, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1083 */
	{12538, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{48147, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{47246, S_036A00_CNTR_MODE(~0u)},
	/* 1086 */
	{48167, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{48187, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1088 */
	{47227, S_036B00_PERF_SEL(~0u)},
	{47236, S_036B00_PERF_SEL1(~0u)},
	{47246, S_036B00_CNTR_MODE(~0u)},
	{47884, S_036B00_PERF_MODE1(~0u)},
	{47874, S_036B00_PERF_MODE(~0u)},
	/* 1093 */
	{47256, S_036B04_PERF_SEL2(~0u)},
	{47266, S_036B04_PERF_SEL3(~0u)},
	{47895, S_036B04_PERF_MODE3(~0u)},
	{47906, S_036B04_PERF_MODE2(~0u)},
	/* 1097 */
	{47227, S_036C00_PERF_SEL(~0u)},
	{47236, S_036C00_PERF_SEL1(~0u)},
	{47246, S_036C00_CNTR_MODE(~0u)},
	{47884, S_036C00_PERF_MODE1(~0u)},
	{47874, S_036C00_PERF_MODE(~0u)},
	/* 1102 */
	{47256, S_036C04_PERF_SEL2(~0u)},
	{47266, S_036C04_PERF_SEL3(~0u)},
	{47895, S_036C04_PERF_MODE3(~0u)},
	{47906, S_036C04_PERF_MODE2(~0u)},
	/* 1106 */
	{47227, S_036D00_PERF_SEL(~0u)},
	{47236, S_036D00_PERF_SEL1(~0u)},
	{47246, S_036D00_CNTR_MODE(~0u)},
	{47884, S_036D00_PERF_MODE1(~0u)},
	{47874, S_036D00_PERF_MODE(~0u)},
	/* 1111 */
	{47256, S_036D04_PERF_SEL2(~0u)},
	{47266, S_036D04_PERF_SEL3(~0u)},
	{47895, S_036D04_PERF_MODE3(~0u)},
	{47906, S_036D04_PERF_MODE2(~0u)},
	/* 1115 */
	{47227, S_036E00_PERF_SEL(~0u)},
	{47236, S_036E00_PERF_SEL1(~0u)},
	{47246, S_036E00_CNTR_MODE(~0u)},
	{47884, S_036E00_PERF_MODE1(~0u)},
	{47874, S_036E00_PERF_MODE(~0u)},
	/* 1120 */
	{47256, S_036E04_PERF_SEL2(~0u)},
	{47266, S_036E04_PERF_SEL3(~0u)},
	{47906, S_036E04_PERF_MODE2(~0u)},
	{47895, S_036E04_PERF_MODE3(~0u)},
	/* 1124 */
	{47227, S_036E40_PERF_SEL(~0u)},
	{47236, S_036E40_PERF_SEL1(~0u)},
	{47246, S_036E40_CNTR_MODE(~0u)},
	{47884, S_036E40_PERF_MODE1(~0u)},
	{47874, S_036E40_PERF_MODE(~0u)},
	/* 1129 */
	{47256, S_036E44_PERF_SEL2(~0u)},
	{47266, S_036E44_PERF_SEL3(~0u)},
	{47906, S_036E44_PERF_MODE2(~0u)},
	{47895, S_036E44_PERF_MODE3(~0u)},
	/* 1133 */
	{48207, S_037000_OP_FILTER_ENABLE(~0u)},
	{48224, S_037000_OP_FILTER_SEL(~0u)},
	{48238, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{48259, S_037000_FORMAT_FILTER_SEL(~0u)},
	{48277, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{48297, S_037000_CLEAR_FILTER_SEL(~0u)},
	{48314, S_037000_MRT_FILTER_ENABLE(~0u)},
	{48332, S_037000_MRT_FILTER_SEL(~0u)},
	{48347, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{48373, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{48396, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{48424, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1145 */
	{47227, S_037004_PERF_SEL(~0u)},
	{47236, S_037004_PERF_SEL1(~0u)},
	{47246, S_037004_CNTR_MODE(~0u)},
	{47884, S_037004_PERF_MODE1(~0u)},
	{47874, S_037004_PERF_MODE(~0u)},
	/* 1150 */
	{47256, S_037008_PERF_SEL2(~0u)},
	{47266, S_037008_PERF_SEL3(~0u)},
	{47895, S_037008_PERF_MODE3(~0u)},
	{47906, S_037008_PERF_MODE2(~0u)},
	/* 1154 */
	{47227, S_037100_PERF_SEL(~0u)},
	{47236, S_037100_PERF_SEL1(~0u)},
	{47246, S_037100_CNTR_MODE(~0u)},
	{47884, S_037100_PERF_MODE1(~0u)},
	{47874, S_037100_PERF_MODE(~0u)},
	/* 1159 */
	{47256, S_037104_PERF_SEL2(~0u)},
	{47266, S_037104_PERF_SEL3(~0u)},
	{47895, S_037104_PERF_MODE3(~0u)},
	{47906, S_037104_PERF_MODE2(~0u)},
	/* 1163 */
	{48449, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{48468, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{48489, S_028000_DEPTH_COPY(~0u)},
	{48500, S_028000_STENCIL_COPY(~0u)},
	{48513, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{48532, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{48557, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{48580, S_028000_COPY_CENTROID(~0u)},
	{48594, S_028000_COPY_SAMPLE(~0u)},
	{48606, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1173 */
	{48624, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{48648, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{48669, S_028004_SAMPLE_RATE(~0u)},
	{48681, S_028004_ZPASS_ENABLE(~0u)},
	{48694, S_028004_ZFAIL_ENABLE(~0u)},
	{48707, S_028004_SFAIL_ENABLE(~0u)},
	{48720, S_028004_DBFAIL_ENABLE(~0u)},
	{48734, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{48752, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1182 */
	{48769, S_028008_SLICE_START(~0u)},
	{48781, S_028008_SLICE_MAX(~0u)},
	{48791, S_028008_Z_READ_ONLY(~0u)},
	{48803, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1186 */
	{48873, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 670},
	{48890, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 670},
	{48908, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 670},
	{48926, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{48947, S_02800C_FAST_Z_DISABLE(~0u)},
	{48962, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{48983, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{49001, S_02800C_FORCE_COLOR_KILL(~0u)},
	{49018, S_02800C_FORCE_Z_READ(~0u)},
	{49031, S_02800C_FORCE_STENCIL_READ(~0u)},
	{49050, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 670},
	{49069, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{49093, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{49116, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{49133, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{49218, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 674},
	{49237, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{49254, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{49278, S_02800C_FORCE_Z_DIRTY(~0u)},
	{49292, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{49312, S_02800C_FORCE_Z_VALID(~0u)},
	{49326, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{49346, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1209 */
	{49420, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{49449, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49480, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49516, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49551, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49579, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49601, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49619, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49651, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49677, S_028010_HIZ_ZFUNC(~0u)},
	{49687, S_028010_HIS_SFUNC_FF(~0u)},
	{49700, S_028010_HIS_SFUNC_BF(~0u)},
	{49713, S_028010_PRESERVE_ZRANGE(~0u)},
	{49729, S_028010_PRESERVE_SRESULTS(~0u)},
	{49747, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1224 */
	{15389, S_028028_CLEAR(~0u)},
	/* 1225 */
	{49765, S_028030_TL_X(~0u)},
	{49770, S_028030_TL_Y(~0u)},
	/* 1227 */
	{49775, S_028034_BR_X(~0u)},
	{49780, S_028034_BR_Y(~0u)},
	/* 1229 */
	{49785, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{45271, S_02803C_ARRAY_MODE(~0u), 7, 682},
	{45633, S_02803C_PIPE_CONFIG(~0u), 18, 689},
	{45926, S_02803C_BANK_WIDTH(~0u), 4, 406},
	{46033, S_02803C_BANK_HEIGHT(~0u), 4, 410},
	{46145, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 414},
	{46232, S_02803C_NUM_BANKS(~0u), 4, 418},
	/* 1236 */
	{21132, S_028040_FORMAT(~0u), 4, 707},
	{49937, S_028040_NUM_SAMPLES(~0u)},
	{45823, S_028040_TILE_SPLIT(~0u), 7, 399},
	{49949, S_028040_TILE_MODE_INDEX(~0u)},
	{49965, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{49989, S_028040_ALLOW_EXPCLEAR(~0u)},
	{50004, S_028040_READ_SIZE(~0u)},
	{50014, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{50034, S_028040_CLEAR_DISALLOWED(~0u)},
	{50051, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1246 */
	{21132, S_028044_FORMAT(~0u), 2, 711},
	{45823, S_028044_TILE_SPLIT(~0u), 7, 399},
	{49949, S_028044_TILE_MODE_INDEX(~0u)},
	{49989, S_028044_ALLOW_EXPCLEAR(~0u)},
	{50094, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{50034, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1252 */
	{50115, S_028058_PITCH_TILE_MAX(~0u)},
	{50130, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1254 */
	{50146, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1255 */
	{39232, S_028084_ADDRESS(~0u)},
	/* 1256 */
	{50161, S_028200_WINDOW_X_OFFSET(~0u)},
	{50177, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1258 */
	{49765, S_028204_TL_X(~0u)},
	{49770, S_028204_TL_Y(~0u)},
	{50193, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1261 */
	{49775, S_028208_BR_X(~0u)},
	{49780, S_028208_BR_Y(~0u)},
	/* 1263 */
	{50275, S_02820C_CLIP_RULE(~0u), 32769, 713},
	/* 1264 */
	{49765, S_028210_TL_X(~0u)},
	{49770, S_028210_TL_Y(~0u)},
	/* 1266 */
	{49775, S_028214_BR_X(~0u)},
	{49780, S_028214_BR_Y(~0u)},
	/* 1268 */
	{50285, S_028230_ER_TRI(~0u)},
	{43360, S_028230_ER_POINT(~0u)},
	{50292, S_028230_ER_RECT(~0u)},
	{50300, S_028230_ER_LINE_LR(~0u)},
	{50311, S_028230_ER_LINE_RL(~0u)},
	{50322, S_028230_ER_LINE_TB(~0u)},
	{50333, S_028230_ER_LINE_BT(~0u)},
	/* 1275 */
	{50344, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{50363, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1277 */
	{50382, S_028238_TARGET0_ENABLE(~0u)},
	{50397, S_028238_TARGET1_ENABLE(~0u)},
	{50412, S_028238_TARGET2_ENABLE(~0u)},
	{50427, S_028238_TARGET3_ENABLE(~0u)},
	{50442, S_028238_TARGET4_ENABLE(~0u)},
	{50457, S_028238_TARGET5_ENABLE(~0u)},
	{50472, S_028238_TARGET6_ENABLE(~0u)},
	{50487, S_028238_TARGET7_ENABLE(~0u)},
	/* 1285 */
	{50502, S_02823C_OUTPUT0_ENABLE(~0u)},
	{50517, S_02823C_OUTPUT1_ENABLE(~0u)},
	{50532, S_02823C_OUTPUT2_ENABLE(~0u)},
	{50547, S_02823C_OUTPUT3_ENABLE(~0u)},
	{50562, S_02823C_OUTPUT4_ENABLE(~0u)},
	{50577, S_02823C_OUTPUT5_ENABLE(~0u)},
	{50592, S_02823C_OUTPUT6_ENABLE(~0u)},
	{50607, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1293 */
	{49765, S_028240_TL_X(~0u)},
	{49770, S_028240_TL_Y(~0u)},
	{50193, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1296 */
	{49775, S_028244_BR_X(~0u)},
	{49780, S_028244_BR_Y(~0u)},
	/* 1298 */
	{49765, S_028250_TL_X(~0u)},
	{49770, S_028250_TL_Y(~0u)},
	{50193, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1301 */
	{49775, S_028254_BR_X(~0u)},
	{49780, S_028254_BR_Y(~0u)},
	/* 1303 */
	{50714, S_028350_RB_MAP_PKR0(~0u), 4, 33482},
	{50726, S_028350_RB_MAP_PKR1(~0u), 4, 33482},
	{50838, S_028350_RB_XSEL2(~0u), 4, 33486},
	{50847, S_028350_RB_XSEL(~0u)},
	{50855, S_028350_RB_YSEL(~0u)},
	{50959, S_028350_PKR_MAP(~0u), 4, 33490},
	{51067, S_028350_PKR_XSEL(~0u), 4, 33494},
	{51176, S_028350_PKR_YSEL(~0u), 4, 33498},
	{51289, S_028350_PKR_XSEL2(~0u), 4, 33502},
	{51391, S_028350_SC_MAP(~0u), 4, 33506},
	{51537, S_028350_SC_XSEL(~0u), 4, 33510},
	{51684, S_028350_SC_YSEL(~0u), 4, 33514},
	{51784, S_028350_SE_MAP(~0u), 4, 33518},
	{51930, S_028350_SE_XSEL_GFX6(~0u), 4, 33522},
	{52082, S_028350_SE_YSEL_GFX6(~0u), 4, 33526},
	/* 1318 */
	{52207, S_028354_SE_PAIR_MAP(~0u), 4, 33530},
	{52378, S_028354_SE_PAIR_XSEL_GFX6(~0u), 4, 33534},
	{52555, S_028354_SE_PAIR_YSEL_GFX6(~0u), 4, 33538},
	/* 1321 */
	{48734, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{48752, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1323 */
	{52573, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{52600, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{52639, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1326 */
	{52905, S_02842C_STENCILFAIL(~0u), 16, 33542},
	{52917, S_02842C_STENCILZPASS(~0u), 16, 33542},
	{52930, S_02842C_STENCILZFAIL(~0u), 16, 33542},
	{52943, S_02842C_STENCILFAIL_BF(~0u), 16, 33542},
	{52958, S_02842C_STENCILZPASS_BF(~0u), 16, 33542},
	{52974, S_02842C_STENCILZFAIL_BF(~0u), 16, 33542},
	/* 1332 */
	{52990, S_028430_STENCILTESTVAL(~0u)},
	{53005, S_028430_STENCILMASK(~0u)},
	{53017, S_028430_STENCILWRITEMASK(~0u)},
	{53034, S_028430_STENCILOPVAL(~0u)},
	/* 1336 */
	{53047, S_028434_STENCILTESTVAL_BF(~0u)},
	{53065, S_028434_STENCILMASK_BF(~0u)},
	{53080, S_028434_STENCILWRITEMASK_BF(~0u)},
	{53100, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1340 */
	{669, S_028644_OFFSET(~0u)},
	{53123, S_028644_DEFAULT_VAL(~0u), 1, 33558},
	{53135, S_028644_FLAT_SHADE(~0u)},
	{53146, S_028644_CYL_WRAP(~0u)},
	{53155, S_028644_PT_SPRITE_TEX(~0u)},
	{53169, S_028644_DUP(~0u)},
	{53173, S_028644_FP16_INTERP_MODE(~0u)},
	{53190, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{53208, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{53226, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{53246, S_028644_ATTR0_VALID(~0u)},
	{53258, S_028644_ATTR1_VALID(~0u)},
	/* 1352 */
	{53270, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{53286, S_0286C4_VS_HALF_PACK(~0u)},
	{53299, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{53314, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1356 */
	{53334, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{53351, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{53368, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{53387, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{53408, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{53426, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{53444, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{53464, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{53485, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{53501, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{53517, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{53533, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{53549, S_0286CC_FRONT_FACE_ENA(~0u)},
	{53564, S_0286CC_ANCILLARY_ENA(~0u)},
	{53578, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{53598, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1372 */
	{53334, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{53351, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{53368, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{53387, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{53408, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{53426, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{53444, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{53464, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{53485, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{53501, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{53517, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{53533, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{53549, S_0286D0_FRONT_FACE_ENA(~0u)},
	{53564, S_0286D0_ANCILLARY_ENA(~0u)},
	{53578, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{53598, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1388 */
	{53615, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{53630, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{53753, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 33559},
	{53771, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 33559},
	{53789, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 33559},
	{53807, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 33559},
	{53825, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1395 */
	{53842, S_0286D8_NUM_INTERP(~0u)},
	{53853, S_0286D8_PARAM_GEN(~0u)},
	{53863, S_0286D8_FOG_ADDR(~0u)},
	{53872, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{53892, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1400 */
	{53912, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{53930, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{53950, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{53969, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{54039, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 33564},
	{54058, S_0286E0_POS_FLOAT_ULC(~0u)},
	{54072, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1407 */
	{47143, S_0286E8_WAVES(~0u)},
	{47149, S_0286E8_WAVESIZE(~0u)},
	/* 1409 */
	{54092, S_028704_NUM_PS_WAVES(~0u)},
	{54105, S_028704_NUM_VS_WAVES(~0u)},
	{54118, S_028704_NUM_GS_WAVES(~0u)},
	{54131, S_028704_NUM_ES_WAVES(~0u)},
	{54144, S_028704_NUM_HS_WAVES(~0u)},
	/* 1414 */
	{54157, S_028708_NUM_LS_WAVES(~0u)},
	/* 1415 */
	{54258, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 33565},
	{54277, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 33565},
	{54296, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 33565},
	{54315, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 33565},
	/* 1419 */
	{54534, S_028710_Z_EXPORT_FORMAT(~0u), 10, 33570},
	/* 1420 */
	{54550, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 33570},
	{54569, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 33570},
	{54588, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 33570},
	{54607, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 33570},
	{54626, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 33570},
	{54645, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 33570},
	{54664, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 33570},
	{54683, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 33570},
	/* 1428 */
	{54937, S_028754_MRT0(~0u), 11, 33580},
	{54942, S_028754_MRT1(~0u)},
	{54947, S_028754_MRT2(~0u)},
	{54952, S_028754_MRT3(~0u)},
	{54957, S_028754_MRT4(~0u)},
	{54962, S_028754_MRT5(~0u)},
	{54967, S_028754_MRT6(~0u)},
	{54972, S_028754_MRT7(~0u)},
	/* 1436 */
	{55057, S_028758_MRT0_EPSILON(~0u), 16, 33591},
	{55070, S_028758_MRT1_EPSILON(~0u)},
	{55083, S_028758_MRT2_EPSILON(~0u)},
	{55096, S_028758_MRT3_EPSILON(~0u)},
	{55109, S_028758_MRT4_EPSILON(~0u)},
	{55122, S_028758_MRT5_EPSILON(~0u)},
	{55135, S_028758_MRT6_EPSILON(~0u)},
	{55148, S_028758_MRT7_EPSILON(~0u)},
	/* 1444 */
	{55161, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{55184, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{55207, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{55230, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{55253, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{55276, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{55299, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{55322, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{55345, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{55368, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{55391, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{55414, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{55437, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{55460, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{55483, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{55506, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{55529, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1461 */
	{55820, S_028760_COLOR_SRC_OPT(~0u), 8, 33607},
	{55834, S_028760_COLOR_DST_OPT(~0u)},
	{55982, S_028760_COLOR_COMB_FCN(~0u), 8, 33615},
	{55997, S_028760_ALPHA_SRC_OPT(~0u)},
	{56011, S_028760_ALPHA_DST_OPT(~0u)},
	{56025, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1467 */
	{55820, S_028764_COLOR_SRC_OPT(~0u)},
	{55834, S_028764_COLOR_DST_OPT(~0u)},
	{55982, S_028764_COLOR_COMB_FCN(~0u)},
	{55997, S_028764_ALPHA_SRC_OPT(~0u)},
	{56011, S_028764_ALPHA_DST_OPT(~0u)},
	{56025, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1473 */
	{55820, S_028768_COLOR_SRC_OPT(~0u)},
	{55834, S_028768_COLOR_DST_OPT(~0u)},
	{55982, S_028768_COLOR_COMB_FCN(~0u)},
	{55997, S_028768_ALPHA_SRC_OPT(~0u)},
	{56011, S_028768_ALPHA_DST_OPT(~0u)},
	{56025, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1479 */
	{55820, S_02876C_COLOR_SRC_OPT(~0u)},
	{55834, S_02876C_COLOR_DST_OPT(~0u)},
	{55982, S_02876C_COLOR_COMB_FCN(~0u)},
	{55997, S_02876C_ALPHA_SRC_OPT(~0u)},
	{56011, S_02876C_ALPHA_DST_OPT(~0u)},
	{56025, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1485 */
	{55820, S_028770_COLOR_SRC_OPT(~0u)},
	{55834, S_028770_COLOR_DST_OPT(~0u)},
	{55982, S_028770_COLOR_COMB_FCN(~0u)},
	{55997, S_028770_ALPHA_SRC_OPT(~0u)},
	{56011, S_028770_ALPHA_DST_OPT(~0u)},
	{56025, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1491 */
	{55820, S_028774_COLOR_SRC_OPT(~0u)},
	{55834, S_028774_COLOR_DST_OPT(~0u)},
	{55982, S_028774_COLOR_COMB_FCN(~0u)},
	{55997, S_028774_ALPHA_SRC_OPT(~0u)},
	{56011, S_028774_ALPHA_DST_OPT(~0u)},
	{56025, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1497 */
	{55820, S_028778_COLOR_SRC_OPT(~0u)},
	{55834, S_028778_COLOR_DST_OPT(~0u)},
	{55982, S_028778_COLOR_COMB_FCN(~0u)},
	{55997, S_028778_ALPHA_SRC_OPT(~0u)},
	{56011, S_028778_ALPHA_DST_OPT(~0u)},
	{56025, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1503 */
	{55820, S_02877C_COLOR_SRC_OPT(~0u)},
	{55834, S_02877C_COLOR_DST_OPT(~0u)},
	{55982, S_02877C_COLOR_COMB_FCN(~0u)},
	{55997, S_02877C_ALPHA_SRC_OPT(~0u)},
	{56011, S_02877C_ALPHA_DST_OPT(~0u)},
	{56025, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1509 */
	{56434, S_028780_COLOR_SRCBLEND(~0u), 21, 33623},
	{55982, S_028780_COLOR_COMB_FCN(~0u), 5, 33644},
	{56539, S_028780_COLOR_DESTBLEND(~0u), 21, 33623},
	{56555, S_028780_ALPHA_SRCBLEND(~0u), 21, 33623},
	{56025, S_028780_ALPHA_COMB_FCN(~0u), 5, 33644},
	{56570, S_028780_ALPHA_DESTBLEND(~0u), 21, 33623},
	{56586, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{7643, S_028780_ENABLE(~0u)},
	{56607, S_028780_DISABLE_ROP3(~0u)},
	/* 1518 */
	{56620, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1519 */
	{56633, S_0287E4_BASE_ADDR_GFX6(~0u)},
	/* 1520 */
	{56726, S_0287F0_SOURCE_SELECT(~0u), 4, 33649},
	{56772, S_0287F0_MAJOR_MODE(~0u), 2, 33653},
	{56783, S_0287F0_NOT_EOP(~0u)},
	{56791, S_0287F0_USE_OPAQUE(~0u)},
	/* 1524 */
	{56802, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1525 */
	{56814, S_028800_STENCIL_ENABLE(~0u)},
	{48881, S_028800_Z_ENABLE(~0u)},
	{56829, S_028800_Z_WRITE_ENABLE(~0u)},
	{56844, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{49681, S_028800_ZFUNC(~0u), 8, 33655},
	{56959, S_028800_BACKFACE_ENABLE(~0u)},
	{57062, S_028800_STENCILFUNC(~0u), 8, 33663},
	{57074, S_028800_STENCILFUNC_BF(~0u), 8, 33663},
	{57089, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{57123, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1535 */
	{57158, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{57177, S_028804_PS_ITER_SAMPLES(~0u)},
	{57193, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{57217, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{57243, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{57270, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{57292, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{57311, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{57329, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{57356, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{57383, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{57408, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1547 */
	{57439, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{57457, S_028808_DEGAMMA_ENABLE(~0u)},
	{22279, S_028808_MODE(~0u), 7, 33671},
	{56615, S_028808_ROP3(~0u), 256, 33678},
	/* 1551 */
	{57767, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{57783, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{57814, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{48939, S_02880C_Z_ORDER(~0u), 4, 33934},
	{57893, S_02880C_KILL_ENABLE(~0u)},
	{57905, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{57929, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{57948, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{57966, S_02880C_EXEC_ON_NOOP(~0u)},
	{57979, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{58001, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{58091, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 33938},
	{58113, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1564 */
	{58131, S_028810_UCP_ENA_0(~0u)},
	{58141, S_028810_UCP_ENA_1(~0u)},
	{58151, S_028810_UCP_ENA_2(~0u)},
	{58161, S_028810_UCP_ENA_3(~0u)},
	{58171, S_028810_UCP_ENA_4(~0u)},
	{58181, S_028810_UCP_ENA_5(~0u)},
	{58191, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{58210, S_028810_PS_UCP_MODE(~0u)},
	{58222, S_028810_CLIP_DISABLE(~0u)},
	{58235, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{58253, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{58276, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{58294, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{58314, S_028810_VTX_KILL_OR(~0u)},
	{58326, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{58348, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{58372, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{58398, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{58417, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1583 */
	{58435, S_028814_CULL_FRONT(~0u)},
	{58446, S_028814_CULL_BACK(~0u)},
	{22820, S_028814_FACE(~0u)},
	{58466, S_028814_POLY_MODE(~0u), 2, 33942},
	{58532, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 33944},
	{58553, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 33944},
	{58573, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58598, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58622, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58646, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58671, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58690, S_028814_PERSP_CORR_DIS(~0u)},
	{58705, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1596 */
	{58723, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58741, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58760, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{58778, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{58797, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{58815, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{58834, S_028818_VTX_XY_FMT(~0u)},
	{58845, S_028818_VTX_Z_FMT(~0u)},
	{58855, S_028818_VTX_W0_FMT(~0u)},
	/* 1605 */
	{58866, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{58882, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{58898, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{58914, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{58930, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{58946, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{58962, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{58978, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{58994, S_02881C_CULL_DIST_ENA_0(~0u)},
	{59010, S_02881C_CULL_DIST_ENA_1(~0u)},
	{59026, S_02881C_CULL_DIST_ENA_2(~0u)},
	{59042, S_02881C_CULL_DIST_ENA_3(~0u)},
	{59058, S_02881C_CULL_DIST_ENA_4(~0u)},
	{59074, S_02881C_CULL_DIST_ENA_5(~0u)},
	{59090, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59106, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59122, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59141, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59159, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59186, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59208, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59226, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59246, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59269, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59292, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59317, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59337, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1632 */
	{59356, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{59375, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{59393, S_028820_VTE_W_INF_DISCARD(~0u)},
	{59411, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{59429, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{59447, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{59464, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{59481, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{59502, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{59519, S_028820_VS_XY_INF_RETAIN(~0u)},
	{59536, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{59552, S_028820_VS_Z_INF_RETAIN(~0u)},
	{59568, S_028820_VS_W_NAN_TO_INF(~0u)},
	{59584, S_028820_VS_W_INF_RETAIN(~0u)},
	{59600, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{59625, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1648 */
	{59645, S_028824_LINE_STIPPLE_RESET(~0u)},
	{59664, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{59683, S_028824_FRACTIONAL_ACCUM(~0u)},
	{59700, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1652 */
	{59715, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{59739, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{59759, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{59780, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{59805, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{59825, S_02882C_LINE_EXPAND_ENA(~0u)},
	{59841, S_02882C_POINT_EXPAND_ENA(~0u)},
	{59858, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{59879, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{59900, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{59921, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1663 */
	{59943, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{59715, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{59739, S_028830_LINE_FILTER_DISABLE(~0u)},
	{59759, S_028830_POINT_FILTER_DISABLE(~0u)},
	{59780, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	/* 1668 */
	{42169, S_028A00_HEIGHT(~0u)},
	{42163, S_028A00_WIDTH(~0u)},
	/* 1670 */
	{59968, S_028A04_MIN_SIZE(~0u)},
	{22515, S_028A04_MAX_SIZE(~0u)},
	/* 1672 */
	{42163, S_028A08_WIDTH(~0u)},
	/* 1673 */
	{59977, S_028A0C_LINE_PATTERN(~0u)},
	{59990, S_028A0C_REPEAT_COUNT(~0u)},
	{60003, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{60021, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1677 */
	{60142, S_028A10_PATH_SELECT(~0u), 5, 33947},
	/* 1678 */
	{60154, S_028A14_TESS_MODE(~0u)},
	/* 1679 */
	{22108, S_028A20_REUSE_DEPTH(~0u)},
	/* 1680 */
	{22130, S_028A24_PRIM_TYPE(~0u), 18, 33952},
	{60519, S_028A24_RETAIN_ORDER(~0u)},
	{60532, S_028A24_RETAIN_QUADS(~0u)},
	{60613, S_028A24_PRIM_ORDER(~0u), 5, 33970},
	/* 1684 */
	{22150, S_028A28_FIRST_DECR(~0u)},
	/* 1685 */
	{22156, S_028A2C_DECR(~0u)},
	/* 1686 */
	{60624, S_028A30_COMP_X_EN(~0u)},
	{60634, S_028A30_COMP_Y_EN(~0u)},
	{60644, S_028A30_COMP_Z_EN(~0u)},
	{60654, S_028A30_COMP_W_EN(~0u)},
	{23319, S_028A30_STRIDE(~0u)},
	{60664, S_028A30_SHIFT(~0u)},
	/* 1692 */
	{60624, S_028A34_COMP_X_EN(~0u)},
	{60634, S_028A34_COMP_Y_EN(~0u)},
	{60644, S_028A34_COMP_Z_EN(~0u)},
	{60654, S_028A34_COMP_W_EN(~0u)},
	{23319, S_028A34_STRIDE(~0u)},
	{60664, S_028A34_SHIFT(~0u)},
	/* 1698 */
	{60829, S_028A38_X_CONV(~0u), 9, 33975},
	{17707, S_028A38_X_OFFSET(~0u)},
	{60836, S_028A38_Y_CONV(~0u), 9, 33975},
	{50184, S_028A38_Y_OFFSET(~0u)},
	{60843, S_028A38_Z_CONV(~0u), 9, 33975},
	{60850, S_028A38_Z_OFFSET(~0u)},
	{60859, S_028A38_W_CONV(~0u), 9, 33975},
	{15767, S_028A38_W_OFFSET(~0u)},
	/* 1706 */
	{60829, S_028A3C_X_CONV(~0u), 9, 33975},
	{17707, S_028A3C_X_OFFSET(~0u)},
	{60836, S_028A3C_Y_CONV(~0u), 9, 33975},
	{50184, S_028A3C_Y_OFFSET(~0u)},
	{60843, S_028A3C_Z_CONV(~0u), 9, 33975},
	{60850, S_028A3C_Z_OFFSET(~0u)},
	{60859, S_028A3C_W_CONV(~0u), 9, 33975},
	{15767, S_028A3C_W_OFFSET(~0u)},
	/* 1714 */
	{22279, S_028A40_MODE(~0u), 6, 33984},
	{39310, S_028A40_RESERVED_0(~0u)},
	{60984, S_028A40_CUT_MODE(~0u), 4, 33990},
	{39328, S_028A40_RESERVED_1(~0u)},
	{60993, S_028A40_GS_C_PACK_EN(~0u)},
	{61006, S_028A40_RESERVED_2(~0u)},
	{61017, S_028A40_ES_PASSTHRU(~0u)},
	{61029, S_028A40_COMPUTE_MODE(~0u)},
	{61042, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{61060, S_028A40_ELEMENT_INFO_EN(~0u)},
	{61076, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61095, S_028A40_SUPPRESS_CUTS(~0u)},
	{61109, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61127, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61178, S_028A40_ONCHIP(~0u), 4, 33994},
	/* 1729 */
	{61185, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61205, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1731 */
	{61225, S_028A48_MSAA_ENABLE(~0u)},
	{61237, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61258, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61278, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1735 */
	{61303, S_028A4C_WALK_SIZE(~0u)},
	{61313, S_028A4C_WALK_ALIGNMENT(~0u)},
	{61328, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{61353, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{61371, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{61387, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{61392, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{61415, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{61434, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{61456, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{61472, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{61488, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{61504, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{61523, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{61549, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{61564, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{61604, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{61631, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{61654, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{61670, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{61700, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{61724, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{61745, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{61775, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1759 */
	{22355, S_028A54_GS_PER_ES(~0u)},
	/* 1760 */
	{22369, S_028A58_ES_PER_GS(~0u)},
	/* 1761 */
	{22383, S_028A5C_GS_PER_VS(~0u)},
	/* 1762 */
	{669, S_028A60_OFFSET(~0u)},
	/* 1763 */
	{669, S_028A64_OFFSET(~0u)},
	/* 1764 */
	{669, S_028A68_OFFSET(~0u)},
	/* 1765 */
	{61867, S_028A6C_OUTPRIM_TYPE(~0u), 3, 33998},
	{61880, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{61895, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{61910, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{61925, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1770 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 34001},
	{62062, S_028A7C_SWAP_MODE(~0u), 4, 34004},
	{62123, S_028A7C_BUF_TYPE(~0u), 3, 34008},
	{62165, S_028A7C_RDREQ_POLICY_CIK(~0u), 2, 34011},
	{62182, S_028A7C_RDREQ_POLICY(~0u)},
	{40034, S_028A7C_ATC(~0u)},
	{56783, S_028A7C_NOT_EOP(~0u)},
	{62195, S_028A7C_REQ_PATH(~0u)},
	{40055, S_028A7C_MTYPE(~0u)},
	/* 1779 */
	{22558, S_028A84_PRIMITIVEID_EN(~0u)},
	{62204, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1781 */
	{63160, S_028A90_EVENT_TYPE(~0u), 59, 34013},
	{63171, S_028A90_ADDRESS_HI_GFX6(~0u)},
	{63187, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1784 */
	{22655, S_028A94_RESET_EN(~0u)},
	/* 1785 */
	{63202, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{63217, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{63236, S_028AA8_SWITCH_ON_EOP(~0u)},
	{63250, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{63269, S_028AA8_SWITCH_ON_EOI(~0u)},
	{63283, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{63300, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1792 */
	{22747, S_028AAC_ITEMSIZE(~0u)},
	/* 1793 */
	{22747, S_028AB0_ITEMSIZE(~0u)},
	/* 1794 */
	{22783, S_028AB4_REUSE_OFF(~0u)},
	/* 1795 */
	{22797, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1796 */
	{43388, S_028ABC_LINEAR(~0u)},
	{63320, S_028ABC_FULL_CACHE(~0u)},
	{63331, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63354, S_028ABC_PRELOAD(~0u)},
	{63362, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63377, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63393, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{63417, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1804 */
	{63431, S_028AC0_COMPAREFUNC0(~0u), 8, 33663},
	{63444, S_028AC0_COMPAREVALUE0(~0u)},
	{63458, S_028AC0_COMPAREMASK0(~0u)},
	{48900, S_028AC0_ENABLE0(~0u)},
	/* 1808 */
	{63471, S_028AC4_COMPAREFUNC1(~0u), 8, 33663},
	{63484, S_028AC4_COMPAREVALUE1(~0u)},
	{63498, S_028AC4_COMPAREMASK1(~0u)},
	{48918, S_028AC4_ENABLE1(~0u)},
	/* 1812 */
	{7499, S_028AC8_START_X(~0u)},
	{7515, S_028AC8_START_Y(~0u)},
	{63511, S_028AC8_MAX_X(~0u)},
	{63517, S_028AC8_MAX_Y(~0u)},
	/* 1816 */
	{23319, S_028AD4_STRIDE(~0u)},
	/* 1817 */
	{23319, S_028AE4_STRIDE(~0u)},
	/* 1818 */
	{23319, S_028AF4_STRIDE(~0u)},
	/* 1819 */
	{23319, S_028B04_STRIDE(~0u)},
	/* 1820 */
	{23312, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1821 */
	{23333, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1822 */
	{63523, S_028B50_ACCUM_ISOLINE(~0u)},
	{63537, S_028B50_ACCUM_TRI(~0u)},
	{63547, S_028B50_ACCUM_QUAD(~0u)},
	{63558, S_028B50_DONUT_SPLIT(~0u)},
	{63570, S_028B50_TRAP_SPLIT(~0u)},
	/* 1827 */
	{48084, S_028B54_LS_EN(~0u), 3, 34072},
	{48078, S_028B54_HS_EN(~0u)},
	{23383, S_028B54_ES_EN(~0u), 3, 34075},
	{48072, S_028B54_GS_EN(~0u)},
	{48066, S_028B54_VS_EN(~0u), 3, 34078},
	{63704, S_028B54_DYNAMIC_HS(~0u)},
	{46659, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63715, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63735, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63755, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1837 */
	{63769, S_028B58_NUM_PATCHES(~0u)},
	{63781, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{63797, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1840 */
	{22747, S_028B5C_ITEMSIZE(~0u)},
	/* 1841 */
	{22747, S_028B60_ITEMSIZE(~0u)},
	/* 1842 */
	{22747, S_028B64_ITEMSIZE(~0u)},
	/* 1843 */
	{22747, S_028B68_ITEMSIZE(~0u)},
	/* 1844 */
	{209, S_028B6C_TYPE(~0u), 3, 34081},
	{63903, S_028B6C_PARTITIONING(~0u), 4, 34084},
	{63980, S_028B6C_TOPOLOGY(~0u), 4, 34088},
	{63989, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{64009, S_028B6C_DEPRECATED(~0u)},
	{64020, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{64042, S_028B6C_DISABLE_DONUTS(~0u)},
	{62165, S_028B6C_RDREQ_POLICY_CIK(~0u), 3, 34092},
	{62182, S_028B6C_RDREQ_POLICY(~0u)},
	{64181, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 34095},
	{40055, S_028B6C_MTYPE(~0u)},
	/* 1855 */
	{64199, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{64220, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{64242, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{64264, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{64286, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{64308, S_028B70_OFFSET_ROUND(~0u)},
	/* 1861 */
	{64321, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{64349, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1863 */
	{7643, S_028B90_ENABLE(~0u)},
	{23740, S_028B90_CNT(~0u)},
	/* 1865 */
	{64377, S_028B94_STREAMOUT_0_EN(~0u)},
	{64392, S_028B94_STREAMOUT_1_EN(~0u)},
	{64407, S_028B94_STREAMOUT_2_EN(~0u)},
	{64422, S_028B94_STREAMOUT_3_EN(~0u)},
	{64437, S_028B94_RAST_STREAM(~0u)},
	{64449, S_028B94_RAST_STREAM_MASK(~0u)},
	{64466, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1872 */
	{64487, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{64506, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{64525, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{64544, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1876 */
	{64563, S_028BD4_DISTANCE_0(~0u)},
	{64574, S_028BD4_DISTANCE_1(~0u)},
	{64585, S_028BD4_DISTANCE_2(~0u)},
	{64596, S_028BD4_DISTANCE_3(~0u)},
	{64607, S_028BD4_DISTANCE_4(~0u)},
	{64618, S_028BD4_DISTANCE_5(~0u)},
	{64629, S_028BD4_DISTANCE_6(~0u)},
	{64640, S_028BD4_DISTANCE_7(~0u)},
	/* 1884 */
	{64651, S_028BD8_DISTANCE_8(~0u)},
	{64662, S_028BD8_DISTANCE_9(~0u)},
	{64673, S_028BD8_DISTANCE_10(~0u)},
	{64685, S_028BD8_DISTANCE_11(~0u)},
	{64697, S_028BD8_DISTANCE_12(~0u)},
	{64709, S_028BD8_DISTANCE_13(~0u)},
	{64721, S_028BD8_DISTANCE_14(~0u)},
	{64733, S_028BD8_DISTANCE_15(~0u)},
	/* 1892 */
	{64745, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{64763, S_028BDC_LAST_PIXEL(~0u)},
	{64774, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{64799, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1896 */
	{64821, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{64838, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{64860, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{64876, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{64897, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1901 */
	{64920, S_028BE4_PIX_CENTER(~0u)},
	{64981, S_028BE4_ROUND_MODE(~0u), 4, 34099},
	{65197, S_028BE4_QUANT_MODE(~0u), 8, 34103},
	/* 1904 */
	{65208, S_028BF8_S0_X(~0u)},
	{65213, S_028BF8_S0_Y(~0u)},
	{65218, S_028BF8_S1_X(~0u)},
	{65223, S_028BF8_S1_Y(~0u)},
	{65228, S_028BF8_S2_X(~0u)},
	{65233, S_028BF8_S2_Y(~0u)},
	{65238, S_028BF8_S3_X(~0u)},
	{65243, S_028BF8_S3_Y(~0u)},
	/* 1912 */
	{65248, S_028BFC_S4_X(~0u)},
	{65253, S_028BFC_S4_Y(~0u)},
	{65258, S_028BFC_S5_X(~0u)},
	{65263, S_028BFC_S5_Y(~0u)},
	{65268, S_028BFC_S6_X(~0u)},
	{65273, S_028BFC_S6_Y(~0u)},
	{65278, S_028BFC_S7_X(~0u)},
	{65283, S_028BFC_S7_Y(~0u)},
	/* 1920 */
	{65288, S_028C00_S8_X(~0u)},
	{65293, S_028C00_S8_Y(~0u)},
	{65298, S_028C00_S9_X(~0u)},
	{65303, S_028C00_S9_Y(~0u)},
	{65308, S_028C00_S10_X(~0u)},
	{65314, S_028C00_S10_Y(~0u)},
	{65320, S_028C00_S11_X(~0u)},
	{65326, S_028C00_S11_Y(~0u)},
	/* 1928 */
	{65332, S_028C04_S12_X(~0u)},
	{65338, S_028C04_S12_Y(~0u)},
	{65344, S_028C04_S13_X(~0u)},
	{65350, S_028C04_S13_Y(~0u)},
	{65356, S_028C04_S14_X(~0u)},
	{65362, S_028C04_S14_Y(~0u)},
	{65368, S_028C04_S15_X(~0u)},
	{65374, S_028C04_S15_Y(~0u)},
	/* 1936 */
	{65208, S_028C08_S0_X(~0u)},
	{65213, S_028C08_S0_Y(~0u)},
	{65218, S_028C08_S1_X(~0u)},
	{65223, S_028C08_S1_Y(~0u)},
	{65228, S_028C08_S2_X(~0u)},
	{65233, S_028C08_S2_Y(~0u)},
	{65238, S_028C08_S3_X(~0u)},
	{65243, S_028C08_S3_Y(~0u)},
	/* 1944 */
	{65248, S_028C0C_S4_X(~0u)},
	{65253, S_028C0C_S4_Y(~0u)},
	{65258, S_028C0C_S5_X(~0u)},
	{65263, S_028C0C_S5_Y(~0u)},
	{65268, S_028C0C_S6_X(~0u)},
	{65273, S_028C0C_S6_Y(~0u)},
	{65278, S_028C0C_S7_X(~0u)},
	{65283, S_028C0C_S7_Y(~0u)},
	/* 1952 */
	{65288, S_028C10_S8_X(~0u)},
	{65293, S_028C10_S8_Y(~0u)},
	{65298, S_028C10_S9_X(~0u)},
	{65303, S_028C10_S9_Y(~0u)},
	{65308, S_028C10_S10_X(~0u)},
	{65314, S_028C10_S10_Y(~0u)},
	{65320, S_028C10_S11_X(~0u)},
	{65326, S_028C10_S11_Y(~0u)},
	/* 1960 */
	{65332, S_028C14_S12_X(~0u)},
	{65338, S_028C14_S12_Y(~0u)},
	{65344, S_028C14_S13_X(~0u)},
	{65350, S_028C14_S13_Y(~0u)},
	{65356, S_028C14_S14_X(~0u)},
	{65362, S_028C14_S14_Y(~0u)},
	{65368, S_028C14_S15_X(~0u)},
	{65374, S_028C14_S15_Y(~0u)},
	/* 1968 */
	{65208, S_028C18_S0_X(~0u)},
	{65213, S_028C18_S0_Y(~0u)},
	{65218, S_028C18_S1_X(~0u)},
	{65223, S_028C18_S1_Y(~0u)},
	{65228, S_028C18_S2_X(~0u)},
	{65233, S_028C18_S2_Y(~0u)},
	{65238, S_028C18_S3_X(~0u)},
	{65243, S_028C18_S3_Y(~0u)},
	/* 1976 */
	{65248, S_028C1C_S4_X(~0u)},
	{65253, S_028C1C_S4_Y(~0u)},
	{65258, S_028C1C_S5_X(~0u)},
	{65263, S_028C1C_S5_Y(~0u)},
	{65268, S_028C1C_S6_X(~0u)},
	{65273, S_028C1C_S6_Y(~0u)},
	{65278, S_028C1C_S7_X(~0u)},
	{65283, S_028C1C_S7_Y(~0u)},
	/* 1984 */
	{65288, S_028C20_S8_X(~0u)},
	{65293, S_028C20_S8_Y(~0u)},
	{65298, S_028C20_S9_X(~0u)},
	{65303, S_028C20_S9_Y(~0u)},
	{65308, S_028C20_S10_X(~0u)},
	{65314, S_028C20_S10_Y(~0u)},
	{65320, S_028C20_S11_X(~0u)},
	{65326, S_028C20_S11_Y(~0u)},
	/* 1992 */
	{65332, S_028C24_S12_X(~0u)},
	{65338, S_028C24_S12_Y(~0u)},
	{65344, S_028C24_S13_X(~0u)},
	{65350, S_028C24_S13_Y(~0u)},
	{65356, S_028C24_S14_X(~0u)},
	{65362, S_028C24_S14_Y(~0u)},
	{65368, S_028C24_S15_X(~0u)},
	{65374, S_028C24_S15_Y(~0u)},
	/* 2000 */
	{65208, S_028C28_S0_X(~0u)},
	{65213, S_028C28_S0_Y(~0u)},
	{65218, S_028C28_S1_X(~0u)},
	{65223, S_028C28_S1_Y(~0u)},
	{65228, S_028C28_S2_X(~0u)},
	{65233, S_028C28_S2_Y(~0u)},
	{65238, S_028C28_S3_X(~0u)},
	{65243, S_028C28_S3_Y(~0u)},
	/* 2008 */
	{65248, S_028C2C_S4_X(~0u)},
	{65253, S_028C2C_S4_Y(~0u)},
	{65258, S_028C2C_S5_X(~0u)},
	{65263, S_028C2C_S5_Y(~0u)},
	{65268, S_028C2C_S6_X(~0u)},
	{65273, S_028C2C_S6_Y(~0u)},
	{65278, S_028C2C_S7_X(~0u)},
	{65283, S_028C2C_S7_Y(~0u)},
	/* 2016 */
	{65288, S_028C30_S8_X(~0u)},
	{65293, S_028C30_S8_Y(~0u)},
	{65298, S_028C30_S9_X(~0u)},
	{65303, S_028C30_S9_Y(~0u)},
	{65308, S_028C30_S10_X(~0u)},
	{65314, S_028C30_S10_Y(~0u)},
	{65320, S_028C30_S11_X(~0u)},
	{65326, S_028C30_S11_Y(~0u)},
	/* 2024 */
	{65332, S_028C34_S12_X(~0u)},
	{65338, S_028C34_S12_Y(~0u)},
	{65344, S_028C34_S13_X(~0u)},
	{65350, S_028C34_S13_Y(~0u)},
	{65356, S_028C34_S14_X(~0u)},
	{65362, S_028C34_S14_Y(~0u)},
	{65368, S_028C34_S15_X(~0u)},
	{65374, S_028C34_S15_Y(~0u)},
	/* 2032 */
	{65380, S_028C38_AA_MASK_X0Y0(~0u)},
	{65393, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2034 */
	{65406, S_028C3C_AA_MASK_X0Y1(~0u)},
	{65419, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2036 */
	{65432, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2037 */
	{65461, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2038 */
	{65477, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2039 */
	{50121, S_028C64_TILE_MAX(~0u)},
	{65490, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2041 */
	{50121, S_028C68_TILE_MAX(~0u)},
	/* 2042 */
	{48769, S_028C6C_SLICE_START(~0u)},
	{48781, S_028C6C_SLICE_MAX(~0u)},
	/* 2044 */
	{65556, S_028C70_ENDIAN(~0u), 4, 34111},
	{21132, S_028C70_FORMAT(~0u), 23, 34115},
	{45048, S_028C70_LINEAR_GENERAL(~0u)},
	{65923, S_028C70_NUMBER_TYPE(~0u), 8, 34138},
	{65979, S_028C70_COMP_SWAP(~0u), 4, 34146},
	{57506, S_028C70_FAST_CLEAR(~0u)},
	{49355, S_028C70_COMPRESSION(~0u)},
	{65989, S_028C70_BLEND_CLAMP(~0u)},
	{66001, S_028C70_BLEND_BYPASS(~0u)},
	{66014, S_028C70_SIMPLE_FLOAT(~0u)},
	{64981, S_028C70_ROUND_MODE(~0u)},
	{66027, S_028C70_CMASK_IS_LINEAR(~0u)},
	{66254, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 34150},
	{66276, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 34150},
	{66300, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66326, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66352, S_028C70_DCC_ENABLE(~0u)},
	{66363, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2062 */
	{49949, S_028C74_TILE_MODE_INDEX(~0u)},
	{66379, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{66401, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{49937, S_028C74_NUM_SAMPLES(~0u)},
	{66419, S_028C74_NUM_FRAGMENTS(~0u)},
	{66433, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2068 */
	{52573, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{66451, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{66527, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u), 3, 34158},
	{66593, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u), 2, 34161},
	{66619, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{42650, S_028C78_COLOR_TRANSFORM(~0u)},
	{66645, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{66668, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{66688, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2077 */
	{50121, S_028C80_TILE_MAX(~0u)},
	/* 2078 */
	{50121, S_028C88_TILE_MAX(~0u)},
	/* 2079 */
	{33127, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33150, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33173, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33196, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33216, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33236, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33256, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33276, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33296, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33316, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33336, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33356, S_008008_RLC_RQ_PENDING(~0u)},
	{66710, S_008008_UTCL2_BUSY(~0u)},
	{66721, S_008008_EA_BUSY(~0u)},
	{66729, S_008008_RMI_BUSY(~0u)},
	{66738, S_008008_UTCL2_RQ_PENDING(~0u)},
	{66755, S_008008_CPF_RQ_PENDING(~0u)},
	{66770, S_008008_EA_LINK_BUSY(~0u)},
	{33371, S_008008_RLC_BUSY(~0u)},
	{33380, S_008008_TC_BUSY(~0u)},
	{33388, S_008008_TCC_CC_RESIDENT(~0u)},
	{33404, S_008008_CPF_BUSY(~0u)},
	{33413, S_008008_CPC_BUSY(~0u)},
	{33422, S_008008_CPG_BUSY(~0u)},
	{66783, S_008008_CPAXI_BUSY(~0u)},
	/* 2104 */
	{33431, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{66794, S_008010_RSMU_RQ_PENDING(~0u)},
	{33470, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33493, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33516, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33535, S_008010_DB_CLEAN(~0u)},
	{33544, S_008010_CB_CLEAN(~0u)},
	{33553, S_008010_TA_BUSY(~0u)},
	{33561, S_008010_GDS_BUSY(~0u)},
	{33570, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33585, S_008010_VGT_BUSY(~0u)},
	{33594, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33609, S_008010_IA_BUSY(~0u)},
	{33617, S_008010_SX_BUSY(~0u)},
	{33625, S_008010_WD_BUSY(~0u)},
	{33633, S_008010_SPI_BUSY(~0u)},
	{33642, S_008010_BCI_BUSY(~0u)},
	{33651, S_008010_SC_BUSY(~0u)},
	{33659, S_008010_PA_BUSY(~0u)},
	{33667, S_008010_DB_BUSY(~0u)},
	{33675, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32238, S_008010_CP_BUSY(~0u)},
	{32460, S_008010_CB_BUSY(~0u)},
	{33693, S_008010_GUI_ACTIVE(~0u)},
	/* 2128 */
	{33535, S_008014_DB_CLEAN(~0u)},
	{33544, S_008014_CB_CLEAN(~0u)},
	{66729, S_008014_RMI_BUSY(~0u)},
	{33642, S_008014_BCI_BUSY(~0u)},
	{33585, S_008014_VGT_BUSY(~0u)},
	{33659, S_008014_PA_BUSY(~0u)},
	{33553, S_008014_TA_BUSY(~0u)},
	{33617, S_008014_SX_BUSY(~0u)},
	{33633, S_008014_SPI_BUSY(~0u)},
	{33651, S_008014_SC_BUSY(~0u)},
	{33667, S_008014_DB_BUSY(~0u)},
	{32460, S_008014_CB_BUSY(~0u)},
	/* 2140 */
	{33535, S_008018_DB_CLEAN(~0u)},
	{33544, S_008018_CB_CLEAN(~0u)},
	{66729, S_008018_RMI_BUSY(~0u)},
	{33642, S_008018_BCI_BUSY(~0u)},
	{33585, S_008018_VGT_BUSY(~0u)},
	{33659, S_008018_PA_BUSY(~0u)},
	{33553, S_008018_TA_BUSY(~0u)},
	{33617, S_008018_SX_BUSY(~0u)},
	{33633, S_008018_SPI_BUSY(~0u)},
	{33651, S_008018_SC_BUSY(~0u)},
	{33667, S_008018_DB_BUSY(~0u)},
	{32460, S_008018_CB_BUSY(~0u)},
	/* 2152 */
	{33535, S_008038_DB_CLEAN(~0u)},
	{33544, S_008038_CB_CLEAN(~0u)},
	{66729, S_008038_RMI_BUSY(~0u)},
	{33642, S_008038_BCI_BUSY(~0u)},
	{33585, S_008038_VGT_BUSY(~0u)},
	{33659, S_008038_PA_BUSY(~0u)},
	{33553, S_008038_TA_BUSY(~0u)},
	{33617, S_008038_SX_BUSY(~0u)},
	{33633, S_008038_SPI_BUSY(~0u)},
	{33651, S_008038_SC_BUSY(~0u)},
	{33667, S_008038_DB_BUSY(~0u)},
	{32460, S_008038_CB_BUSY(~0u)},
	/* 2164 */
	{33535, S_00803C_DB_CLEAN(~0u)},
	{33544, S_00803C_CB_CLEAN(~0u)},
	{66729, S_00803C_RMI_BUSY(~0u)},
	{33642, S_00803C_BCI_BUSY(~0u)},
	{33585, S_00803C_VGT_BUSY(~0u)},
	{33659, S_00803C_PA_BUSY(~0u)},
	{33553, S_00803C_TA_BUSY(~0u)},
	{33617, S_00803C_SX_BUSY(~0u)},
	{33633, S_00803C_SPI_BUSY(~0u)},
	{33651, S_00803C_SC_BUSY(~0u)},
	{33667, S_00803C_DB_BUSY(~0u)},
	{32460, S_00803C_CB_BUSY(~0u)},
	/* 2176 */
	{34201, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{66810, S_0301F0_TC_WC_ACTION_ENA(~0u)},
	{66827, S_0301F0_TC_INV_METADATA_ACTION_ENA(~0u)},
	{34218, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34256, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34047, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34063, S_0301F0_TC_ACTION_ENA(~0u)},
	{34077, S_0301F0_CB_ACTION_ENA(~0u)},
	{34091, S_0301F0_DB_ACTION_ENA(~0u)},
	{34105, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34273, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34126, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34298, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	/* 2189 */
	{34357, S_0301FC_MEID(~0u)},
	{1005, S_0301FC_STATUS(~0u)},
	/* 2191 */
	{34376, S_008210_MEC1_BUSY(~0u)},
	{34386, S_008210_MEC2_BUSY(~0u)},
	{34396, S_008210_DC0_BUSY(~0u)},
	{34405, S_008210_DC1_BUSY(~0u)},
	{34414, S_008210_RCIU1_BUSY(~0u)},
	{34425, S_008210_RCIU2_BUSY(~0u)},
	{34436, S_008210_ROQ1_BUSY(~0u)},
	{34446, S_008210_ROQ2_BUSY(~0u)},
	{34456, S_008210_TCIU_BUSY(~0u)},
	{34466, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34483, S_008210_QU_BUSY(~0u)},
	{66854, S_008210_UTCL2IU_BUSY(~0u)},
	{66867, S_008210_SAVE_RESTORE_BUSY(~0u)},
	{34504, S_008210_CPG_CPC_BUSY(~0u)},
	{34517, S_008210_CPF_CPC_BUSY(~0u)},
	{33413, S_008210_CPC_BUSY(~0u)},
	/* 2207 */
	{35014, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{35033, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35053, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35072, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35093, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35111, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35134, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35156, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35177, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35195, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35218, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{66885, S_008218_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66909, S_008218_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66933, S_008218_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2221 */
	{35311, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35330, S_00821C_CSF_BUSY(~0u)},
	{35339, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35354, S_00821C_ROQ_RING_BUSY(~0u)},
	{35368, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35387, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35406, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35421, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35438, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35460, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35482, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35497, S_00821C_INTERRUPT_BUSY(~0u)},
	{34456, S_00821C_TCIU_BUSY(~0u)},
	{35512, S_00821C_HQD_BUSY(~0u)},
	{35521, S_00821C_PRT_BUSY(~0u)},
	{66854, S_00821C_UTCL2IU_BUSY(~0u)},
	{35530, S_00821C_CPF_GFX_BUSY(~0u)},
	{35543, S_00821C_CPF_CMP_BUSY(~0u)},
	{35556, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35575, S_00821C_CPC_CPF_BUSY(~0u)},
	{33404, S_00821C_CPF_BUSY(~0u)},
	/* 2242 */
	{36163, S_008224_RING_FETCHING_DATA(~0u)},
	{36182, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36202, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36222, S_008224_STATE_FETCHING_DATA(~0u)},
	{36242, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36263, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{66885, S_008224_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66909, S_008224_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66956, S_008224_GFX_UTCL1_WAITING_ON_TRANS(~0u)},
	{66983, S_008224_CMP_UTCL1_WAITING_ON_TRANS(~0u)},
	{67010, S_008224_RCIU_WAITING_ON_FREE(~0u)},
	/* 2253 */
	{37053, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37078, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37116, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37157, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37180, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37203, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37227, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37257, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37286, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37312, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37341, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37366, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36242, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36263, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37401, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37429, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{66885, S_008670_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66909, S_008670_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66933, S_008670_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2272 */
	{35354, S_008680_ROQ_RING_BUSY(~0u)},
	{35368, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35387, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35406, S_008680_ROQ_STATE_BUSY(~0u)},
	{38659, S_008680_DC_BUSY(~0u)},
	{66854, S_008680_UTCL2IU_BUSY(~0u)},
	{38667, S_008680_PFP_BUSY(~0u)},
	{38676, S_008680_MEQ_BUSY(~0u)},
	{38685, S_008680_ME_BUSY(~0u)},
	{38693, S_008680_QUERY_BUSY(~0u)},
	{35482, S_008680_SEMAPHORE_BUSY(~0u)},
	{35497, S_008680_INTERRUPT_BUSY(~0u)},
	{38704, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32162, S_008680_DMA_BUSY(~0u)},
	{38722, S_008680_RCIU_BUSY(~0u)},
	{34466, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38745, S_008680_CE_BUSY(~0u)},
	{34456, S_008680_TCIU_BUSY(~0u)},
	{35421, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35438, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35460, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32238, S_008680_CP_BUSY(~0u)},
	/* 2294 */
	{22130, S_030908_PRIM_TYPE(~0u), 29, 26},
	/* 2295 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	{67031, S_03090C_PRIMGEN_EN(~0u)},
	/* 2297 */
	{22655, S_03092C_RESET_EN(~0u)},
	{67042, S_03092C_MATCH_ALL_BITS(~0u)},
	/* 2299 */
	{36932, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38801, S_03093C_OFFCHIP_GRANULARITY(~0u)},
	/* 2301 */
	{880, S_030944_BASE_HI(~0u)},
	/* 2302 */
	{880, S_03094C_BASE_HI(~0u)},
	/* 2303 */
	{880, S_030954_BASE_HI(~0u)},
	/* 2304 */
	{880, S_03095C_BASE_HI(~0u)},
	/* 2305 */
	{63202, S_030960_PRIMGROUP_SIZE(~0u)},
	{63217, S_030960_PARTIAL_VS_WAVE_ON(~0u)},
	{63236, S_030960_SWITCH_ON_EOP(~0u)},
	{63250, S_030960_PARTIAL_ES_WAVE_ON(~0u)},
	{63269, S_030960_SWITCH_ON_EOI(~0u)},
	{63283, S_030960_WD_SWITCH_ON_EOP(~0u)},
	{67057, S_030960_EN_INST_OPT_BASIC(~0u)},
	{67075, S_030960_EN_INST_OPT_ADV(~0u)},
	{67091, S_030960_HW_USE_ONLY(~0u)},
	/* 2314 */
	{67103, S_030D20_TARGET_INST(~0u)},
	{67115, S_030D20_TARGET_DATA(~0u)},
	{39075, S_030D20_INVALIDATE(~0u)},
	{26846, S_030D20_WRITEBACK(~0u)},
	{46877, S_030D20_VOL(~0u)},
	{67127, S_030D20_COMPLETE(~0u)},
	/* 2320 */
	{67136, S_030D24_DWB(~0u)},
	{49286, S_030D24_DIRTY(~0u)},
	/* 2322 */
	{39375, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39385, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39395, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39405, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39589, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{39981, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{67140, S_008F0C_USER_VM_ENABLE(~0u)},
	{67155, S_008F0C_USER_VM_MODE(~0u)},
	{40006, S_008F0C_INDEX_STRIDE(~0u)},
	{40019, S_008F0C_ADD_TID_ENABLE(~0u)},
	{60833, S_008F0C_NV(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 2334 */
	{39240, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40130, S_008F14_MIN_LOD(~0u)},
	{67740, S_008F14_DATA_FORMAT_GFX9(~0u), 64, 34163},
	{67833, S_008F14_NUM_FORMAT_GFX9(~0u), 11, 34227},
	{68068, S_008F14_NUM_FORMAT_FMASK(~0u), 13, 34238},
	{68318, S_008F14_NUM_FORMAT_ASTC_2D(~0u), 14, 34251},
	{68517, S_008F14_NUM_FORMAT_ASTC_3D(~0u), 10, 34265},
	{60833, S_008F14_NV(~0u)},
	{68536, S_008F14_META_DIRECT(~0u)},
	/* 2343 */
	{39375, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39385, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39395, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39405, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42196, S_008F1C_BASE_LEVEL(~0u)},
	{42207, S_008F1C_LAST_LEVEL(~0u)},
	{68548, S_008F1C_SW_MODE(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 2351 */
	{22114, S_008F20_DEPTH(~0u)},
	{68556, S_008F20_PITCH_GFX9(~0u)},
	{68663, S_008F20_BC_SWIZZLE(~0u), 6, 34275},
	/* 2354 */
	{42553, S_008F24_BASE_ARRAY(~0u)},
	{68674, S_008F24_ARRAY_PITCH(~0u)},
	{68686, S_008F24_META_DATA_ADDRESS(~0u)},
	{68704, S_008F24_META_LINEAR(~0u)},
	{68716, S_008F24_META_PIPE_ALIGNED(~0u)},
	{68734, S_008F24_META_RB_ALIGNED(~0u)},
	{68750, S_008F24_MAX_MIP(~0u)},
	/* 2361 */
	{43324, S_008F38_LOD_BIAS(~0u)},
	{43333, S_008F38_LOD_BIAS_SEC(~0u)},
	{43395, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{43470, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{43550, S_008F38_Z_FILTER(~0u), 3, 340},
	{43559, S_008F38_MIP_FILTER(~0u), 3, 340},
	{43570, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{68758, S_008F38_BLEND_ZERO_PRT(~0u)},
	{43606, S_008F38_FILTER_PREC_FIX(~0u)},
	{43622, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 2371 */
	{43637, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{68773, S_008F3C_SKIP_DEGAMMA(~0u)},
	{43796, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 2374 */
	{44147, S_031100_GPR_WRITE_PRIORITY(~0u)},
	{44166, S_031100_EXP_PRIORITY_ORDER(~0u)},
	{44185, S_031100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44207, S_031100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44229, S_031100_RSRC_MGMT_RESET(~0u)},
	{68786, S_031100_TTRACE_STALL_ALL(~0u)},
	{68803, S_031100_ALLOC_ARB_LRU_ENA(~0u)},
	{68821, S_031100_EXP_ARB_LRU_ENA(~0u)},
	{68837, S_031100_PS_PKR_PRIORITY_CNTL(~0u)},
	/* 2383 */
	{44498, S_031104_VTX_DONE_DELAY(~0u), 16, 348},
	{44513, S_031104_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{68858, S_031104_BATON_RESET_DISABLE(~0u)},
	{44537, S_031104_PC_LIMIT_ENABLE(~0u)},
	{44553, S_031104_PC_LIMIT_STRICT(~0u)},
	{68878, S_031104_CRC_SIMD_ID_WADDR_DISABLE(~0u)},
	{68904, S_031104_LBPW_CU_CHK_MODE(~0u)},
	{68921, S_031104_LBPW_CU_CHK_CNT(~0u)},
	{68937, S_031104_CSC_PWR_SAVE_DISABLE(~0u)},
	{68958, S_031104_CSG_PWR_SAVE_DISABLE(~0u)},
	{44569, S_031104_PC_LIMIT_SIZE(~0u)},
	/* 2394 */
	{68979, S_031108_CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD(~0u)},
	{69020, S_031108_CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD(~0u)},
	/* 2396 */
	{44745, S_0098F8_NUM_PIPES(~0u)},
	{69059, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(~0u)},
	{69085, S_0098F8_MAX_COMPRESSED_FRAGS(~0u)},
	{44781, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{46232, S_0098F8_NUM_BANKS(~0u)},
	{44826, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{69106, S_0098F8_NUM_SHADER_ENGINES_GFX9(~0u)},
	{69130, S_0098F8_NUM_GPUS_GFX9(~0u)},
	{44864, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{69144, S_0098F8_NUM_RB_PER_SE(~0u)},
	{44884, S_0098F8_ROW_SIZE(~0u)},
	{44893, S_0098F8_NUM_LOWER_PIPES(~0u)},
	{69158, S_0098F8_SE_ENABLE(~0u)},
	/* 2409 */
	{45271, S_009910_ARRAY_MODE(~0u), 16, 368},
	{45633, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{45823, S_009910_TILE_SPLIT(~0u), 7, 399},
	{46273, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{46293, S_009910_SAMPLE_SPLIT(~0u)},
	/* 2414 */
	{43902, S_00B01C_CU_EN(~0u)},
	{46315, S_00B01C_WAVE_LIMIT(~0u)},
	{46326, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	{69168, S_00B01C_SIMD_DISABLE(~0u)},
	/* 2418 */
	{46345, S_00B028_VGPRS(~0u)},
	{46351, S_00B028_SGPRS(~0u)},
	{2676, S_00B028_PRIORITY(~0u)},
	{46400, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{46411, S_00B028_PRIV(~0u)},
	{46416, S_00B028_DX10_CLAMP(~0u)},
	{46427, S_00B028_DEBUG_MODE(~0u)},
	{46438, S_00B028_IEEE_MODE(~0u)},
	{46448, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46475, S_00B028_CDBG_USER(~0u)},
	{69181, S_00B028_FP16_OVFL(~0u)},
	/* 2429 */
	{46485, S_00B02C_SCRATCH_EN(~0u)},
	{46496, S_00B02C_USER_SGPR(~0u)},
	{46506, S_00B02C_TRAP_PRESENT(~0u)},
	{46519, S_00B02C_WAVE_CNT_EN(~0u)},
	{46531, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46557, S_00B02C_EXCP_EN(~0u)},
	{69191, S_00B02C_LOAD_COLLISION_WAVEID(~0u)},
	{69213, S_00B02C_LOAD_INTRAWAVE_COLLISION(~0u)},
	{69238, S_00B02C_SKIP_USGPR0(~0u)},
	{69250, S_00B02C_USER_SGPR_MSB(~0u)},
	/* 2439 */
	{43902, S_00B118_CU_EN(~0u)},
	{46315, S_00B118_WAVE_LIMIT(~0u)},
	{46326, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	{69168, S_00B118_SIMD_DISABLE(~0u)},
	/* 2443 */
	{46345, S_00B128_VGPRS(~0u)},
	{46351, S_00B128_SGPRS(~0u)},
	{2676, S_00B128_PRIORITY(~0u)},
	{46400, S_00B128_FLOAT_MODE(~0u)},
	{46411, S_00B128_PRIV(~0u)},
	{46416, S_00B128_DX10_CLAMP(~0u)},
	{46427, S_00B128_DEBUG_MODE(~0u)},
	{46438, S_00B128_IEEE_MODE(~0u)},
	{46565, S_00B128_VGPR_COMP_CNT(~0u)},
	{46579, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46475, S_00B128_CDBG_USER(~0u)},
	{69181, S_00B128_FP16_OVFL(~0u)},
	/* 2455 */
	{46485, S_00B12C_SCRATCH_EN(~0u)},
	{46496, S_00B12C_USER_SGPR(~0u)},
	{46506, S_00B12C_TRAP_PRESENT(~0u)},
	{46595, S_00B12C_OC_LDS_EN(~0u)},
	{46605, S_00B12C_SO_BASE0_EN(~0u)},
	{46617, S_00B12C_SO_BASE1_EN(~0u)},
	{46629, S_00B12C_SO_BASE2_EN(~0u)},
	{46641, S_00B12C_SO_BASE3_EN(~0u)},
	{46653, S_00B12C_SO_EN(~0u)},
	{46557, S_00B12C_EXCP_EN(~0u)},
	{69264, S_00B12C_PC_BASE_EN(~0u)},
	{46659, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	{69238, S_00B12C_SKIP_USGPR0(~0u)},
	{69250, S_00B12C_USER_SGPR_MSB(~0u)},
	/* 2469 */
	{46485, S_00B1F0_SCRATCH_EN(~0u)},
	{46496, S_00B1F0_USER_SGPR(~0u)},
	{46506, S_00B1F0_TRAP_PRESENT(~0u)},
	{46557, S_00B1F0_EXCP_EN(~0u)},
	{46565, S_00B1F0_VGPR_COMP_CNT(~0u)},
	{46595, S_00B1F0_OC_LDS_EN(~0u)},
	{46537, S_00B1F0_LDS_SIZE(~0u)},
	{69238, S_00B1F0_SKIP_USGPR0(~0u)},
	{69250, S_00B1F0_USER_SGPR_MSB(~0u)},
	/* 2478 */
	{46676, S_00B204_GROUP_FIFO_DEPTH(~0u)},
	{69275, S_00B204_SPI_SHADER_LATE_ALLOC_GS(~0u)},
	/* 2480 */
	{46306, S_00B214_MEM_BASE(~0u)},
	/* 2481 */
	{43902, S_00B21C_CU_EN(~0u)},
	{46315, S_00B21C_WAVE_LIMIT(~0u)},
	{46326, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{69168, S_00B21C_SIMD_DISABLE(~0u)},
	/* 2485 */
	{46345, S_00B228_VGPRS(~0u)},
	{46351, S_00B228_SGPRS(~0u)},
	{2676, S_00B228_PRIORITY(~0u)},
	{46400, S_00B228_FLOAT_MODE(~0u)},
	{46411, S_00B228_PRIV(~0u)},
	{46416, S_00B228_DX10_CLAMP(~0u)},
	{46427, S_00B228_DEBUG_MODE(~0u)},
	{46438, S_00B228_IEEE_MODE(~0u)},
	{46579, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46475, S_00B228_CDBG_USER(~0u)},
	{69300, S_00B228_GS_VGPR_COMP_CNT(~0u)},
	{69181, S_00B228_FP16_OVFL(~0u)},
	/* 2497 */
	{46485, S_00B22C_SCRATCH_EN(~0u)},
	{46496, S_00B22C_USER_SGPR(~0u)},
	{46506, S_00B22C_TRAP_PRESENT(~0u)},
	{46557, S_00B22C_EXCP_EN(~0u)},
	{69317, S_00B22C_ES_VGPR_COMP_CNT(~0u)},
	{46595, S_00B22C_OC_LDS_EN(~0u)},
	{46537, S_00B22C_LDS_SIZE(~0u)},
	{69238, S_00B22C_SKIP_USGPR0(~0u)},
	{69250, S_00B22C_USER_SGPR_MSB(~0u)},
	/* 2506 */
	{46676, S_00B404_GROUP_FIFO_DEPTH(~0u)},
	/* 2507 */
	{46306, S_00B414_MEM_BASE(~0u)},
	/* 2508 */
	{46315, S_00B41C_WAVE_LIMIT(~0u)},
	{46326, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{69168, S_00B41C_SIMD_DISABLE(~0u)},
	{43902, S_00B41C_CU_EN(~0u)},
	/* 2512 */
	{46345, S_00B428_VGPRS(~0u)},
	{46351, S_00B428_SGPRS(~0u)},
	{2676, S_00B428_PRIORITY(~0u)},
	{46400, S_00B428_FLOAT_MODE(~0u)},
	{46411, S_00B428_PRIV(~0u)},
	{46416, S_00B428_DX10_CLAMP(~0u)},
	{46427, S_00B428_DEBUG_MODE(~0u)},
	{46438, S_00B428_IEEE_MODE(~0u)},
	{46475, S_00B428_CDBG_USER(~0u)},
	{69334, S_00B428_LS_VGPR_COMP_CNT(~0u)},
	{69181, S_00B428_FP16_OVFL(~0u)},
	/* 2523 */
	{46485, S_00B42C_SCRATCH_EN(~0u)},
	{46496, S_00B42C_USER_SGPR(~0u)},
	{46506, S_00B42C_TRAP_PRESENT(~0u)},
	{46557, S_00B42C_EXCP_EN(~0u)},
	{46537, S_00B42C_LDS_SIZE(~0u)},
	{69238, S_00B42C_SKIP_USGPR0(~0u)},
	{69250, S_00B42C_USER_SGPR_MSB(~0u)},
	/* 2530 */
	{46719, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46737, S_00B800_PARTIAL_TG_EN(~0u)},
	{46751, S_00B800_FORCE_START_AT_000(~0u)},
	{46770, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{46790, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{46810, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{46832, S_00B800_ORDER_MODE(~0u)},
	{46863, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{46881, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{8050, S_00B800_RESERVED(~0u)},
	{46908, S_00B800_RESTORE(~0u)},
	/* 2541 */
	{46345, S_00B848_VGPRS(~0u)},
	{46351, S_00B848_SGPRS(~0u)},
	{2676, S_00B848_PRIORITY(~0u)},
	{46400, S_00B848_FLOAT_MODE(~0u)},
	{46411, S_00B848_PRIV(~0u)},
	{46416, S_00B848_DX10_CLAMP(~0u)},
	{46427, S_00B848_DEBUG_MODE(~0u)},
	{46438, S_00B848_IEEE_MODE(~0u)},
	{46960, S_00B848_BULKY(~0u)},
	{46475, S_00B848_CDBG_USER(~0u)},
	{69181, S_00B848_FP16_OVFL(~0u)},
	/* 2552 */
	{46485, S_00B84C_SCRATCH_EN(~0u)},
	{46496, S_00B84C_USER_SGPR(~0u)},
	{46506, S_00B84C_TRAP_PRESENT(~0u)},
	{46966, S_00B84C_TGID_X_EN(~0u)},
	{46976, S_00B84C_TGID_Y_EN(~0u)},
	{46986, S_00B84C_TGID_Z_EN(~0u)},
	{46693, S_00B84C_TG_SIZE_EN(~0u)},
	{46996, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{47011, S_00B84C_EXCP_EN_MSB(~0u)},
	{46537, S_00B84C_LDS_SIZE(~0u)},
	{46557, S_00B84C_EXCP_EN(~0u)},
	{69238, S_00B84C_SKIP_USGPR0(~0u)},
	/* 2564 */
	{47039, S_00B854_WAVES_PER_SH(~0u)},
	{47052, S_00B854_TG_PER_CU(~0u)},
	{47062, S_00B854_LOCK_THRESHOLD(~0u)},
	{47077, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47092, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47108, S_00B854_CU_GROUP_COUNT(~0u)},
	{69168, S_00B854_SIMD_DISABLE(~0u)},
	/* 2571 */
	{69351, S_036008_CNTR_SEL0(~0u)},
	{69361, S_036008_CNTR_SEL1(~0u)},
	{48041, S_036008_SPM_MODE(~0u)},
	{69371, S_036008_CNTR_MODE1(~0u)},
	{69382, S_036008_CNTR_MODE0(~0u)},
	/* 2576 */
	{69393, S_036004_CNTR_SEL2(~0u)},
	{69403, S_036004_CNTR_SEL3(~0u)},
	{69413, S_036004_CNTR_MODE3(~0u)},
	{69424, S_036004_CNTR_MODE2(~0u)},
	/* 2580 */
	{69351, S_036024_CNTR_SEL0(~0u)},
	{69361, S_036024_CNTR_SEL1(~0u)},
	{48041, S_036024_SPM_MODE(~0u)},
	{69371, S_036024_CNTR_MODE1(~0u)},
	{69382, S_036024_CNTR_MODE0(~0u)},
	/* 2585 */
	{69393, S_036010_CNTR_SEL2(~0u)},
	{69403, S_036010_CNTR_SEL3(~0u)},
	{69413, S_036010_CNTR_MODE3(~0u)},
	{69424, S_036010_CNTR_MODE2(~0u)},
	/* 2589 */
	{69351, S_03601C_CNTR_SEL0(~0u)},
	{69361, S_03601C_CNTR_SEL1(~0u)},
	{48041, S_03601C_SPM_MODE(~0u)},
	{69371, S_03601C_CNTR_MODE1(~0u)},
	{69382, S_03601C_CNTR_MODE0(~0u)},
	/* 2594 */
	{69393, S_036018_CNTR_SEL2(~0u)},
	{69403, S_036018_CNTR_SEL3(~0u)},
	{69413, S_036018_CNTR_MODE3(~0u)},
	{69424, S_036018_CNTR_MODE2(~0u)},
	/* 2598 */
	{441, S_036028_INDEX(~0u)},
	{43145, S_036028_ALWAYS(~0u)},
	{7643, S_036028_ENABLE(~0u)},
	/* 2601 */
	{441, S_03602C_INDEX(~0u)},
	{43145, S_03602C_ALWAYS(~0u)},
	{7643, S_03602C_ENABLE(~0u)},
	/* 2604 */
	{441, S_036030_INDEX(~0u)},
	{15389, S_036030_CLEAR(~0u)},
	{7643, S_036030_ENABLE(~0u)},
	/* 2607 */
	{441, S_036034_INDEX(~0u)},
	{15389, S_036034_CLEAR(~0u)},
	{7643, S_036034_ENABLE(~0u)},
	/* 2610 */
	{441, S_036038_INDEX(~0u)},
	{15389, S_036038_CLEAR(~0u)},
	{7643, S_036038_ENABLE(~0u)},
	/* 2613 */
	{47227, S_036100_PERF_SEL(~0u)},
	{47397, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47451, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47478, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47609, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47689, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47715, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47741, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{47795, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{47822, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{47848, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	{69435, S_036100_UTCL2_BUSY_USER_DEFINED_MASK(~0u)},
	{69464, S_036100_EA_BUSY_USER_DEFINED_MASK(~0u)},
	{69490, S_036100_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2635 */
	{47227, S_036108_PERF_SEL(~0u)},
	{47397, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47478, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47451, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69490, S_036108_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2648 */
	{47227, S_03610C_PERF_SEL(~0u)},
	{47397, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47478, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47451, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69490, S_03610C_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2661 */
	{47227, S_036110_PERF_SEL(~0u)},
	{47397, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47478, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47451, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69490, S_036110_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2674 */
	{47227, S_036114_PERF_SEL(~0u)},
	{47397, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47424, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47478, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47504, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47530, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47557, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47637, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47663, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47451, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47583, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47768, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69490, S_036114_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2687 */
	{47227, S_036600_PERF_SEL(~0u)},
	{47236, S_036600_PERF_SEL1(~0u)},
	{47246, S_036600_CNTR_MODE(~0u)},
	{47884, S_036600_PERF_MODE1(~0u)},
	{47874, S_036600_PERF_MODE(~0u)},
	/* 2692 */
	{47256, S_036610_PERF_SEL2(~0u)},
	{47266, S_036610_PERF_SEL3(~0u)},
	{47895, S_036610_PERF_MODE3(~0u)},
	{47906, S_036610_PERF_MODE2(~0u)},
	/* 2696 */
	{48769, S_028008_SLICE_START(~0u)},
	{48781, S_028008_SLICE_MAX(~0u)},
	{48791, S_028008_Z_READ_ONLY(~0u)},
	{48803, S_028008_STENCIL_READ_ONLY(~0u)},
	{69517, S_028008_MIPID(~0u)},
	/* 2701 */
	{49420, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{49449, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49480, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49516, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49551, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49579, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49601, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49619, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49651, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49677, S_028010_HIZ_ZFUNC(~0u)},
	{49687, S_028010_HIS_SFUNC_FF(~0u)},
	{49700, S_028010_HIS_SFUNC_BF(~0u)},
	{49713, S_028010_PRESERVE_ZRANGE(~0u)},
	{49729, S_028010_PRESERVE_SRESULTS(~0u)},
	{49747, S_028010_DISABLE_FAST_PASS(~0u)},
	{69523, S_028010_ALLOW_PARTIAL_RES_HIER_KILL(~0u)},
	/* 2717 */
	{880, S_028018_BASE_HI(~0u)},
	/* 2718 */
	{69551, S_02801C_X_MAX(~0u)},
	{69557, S_02801C_Y_MAX(~0u)},
	/* 2720 */
	{21132, S_028038_FORMAT(~0u), 4, 707},
	{49937, S_028038_NUM_SAMPLES(~0u)},
	{68548, S_028038_SW_MODE(~0u)},
	{69563, S_028038_PARTIALLY_RESIDENT(~0u)},
	{69582, S_028038_FAULT_BEHAVIOR(~0u)},
	{69597, S_028038_ITERATE_FLUSH(~0u)},
	{69611, S_028038_MAXMIP(~0u)},
	{49965, S_028038_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{49989, S_028038_ALLOW_EXPCLEAR(~0u)},
	{50004, S_028038_READ_SIZE(~0u)},
	{50014, S_028038_TILE_SURFACE_ENABLE(~0u)},
	{50034, S_028038_CLEAR_DISALLOWED(~0u)},
	{50051, S_028038_ZRANGE_PRECISION(~0u)},
	/* 2733 */
	{21132, S_02803C_FORMAT(~0u), 2, 711},
	{68548, S_02803C_SW_MODE(~0u)},
	{69563, S_02803C_PARTIALLY_RESIDENT(~0u)},
	{69582, S_02803C_FAULT_BEHAVIOR(~0u)},
	{69597, S_02803C_ITERATE_FLUSH(~0u)},
	{49989, S_02803C_ALLOW_EXPCLEAR(~0u)},
	{50094, S_02803C_TILE_STENCIL_DISABLE(~0u)},
	{50034, S_02803C_CLEAR_DISALLOWED(~0u)},
	/* 2741 */
	{880, S_028044_BASE_HI(~0u)},
	/* 2742 */
	{880, S_02804C_BASE_HI(~0u)},
	/* 2743 */
	{880, S_028054_BASE_HI(~0u)},
	/* 2744 */
	{880, S_02805C_BASE_HI(~0u)},
	/* 2745 */
	{69627, S_028060_PUNCHOUT_MODE(~0u), 4, 34281},
	{69641, S_028060_POPS_DRAIN_PS_ON_OVERLAP(~0u)},
	{69666, S_028060_DISALLOW_OVERFLOW(~0u)},
	/* 2748 */
	{30393, S_028068_EPITCH(~0u)},
	/* 2749 */
	{30393, S_02806C_EPITCH(~0u)},
	/* 2750 */
	{69684, S_0281E8_DEST_BASE_HI_256B(~0u)},
	/* 2751 */
	{69684, S_0281EC_DEST_BASE_HI_256B(~0u)},
	/* 2752 */
	{69684, S_0281F0_DEST_BASE_HI_256B(~0u)},
	/* 2753 */
	{69684, S_0281F4_DEST_BASE_HI_256B(~0u)},
	/* 2754 */
	{50714, S_028350_RB_MAP_PKR0(~0u), 4, 33482},
	{50726, S_028350_RB_MAP_PKR1(~0u), 4, 33482},
	{50838, S_028350_RB_XSEL2(~0u), 4, 33486},
	{50847, S_028350_RB_XSEL(~0u)},
	{50855, S_028350_RB_YSEL(~0u)},
	{50959, S_028350_PKR_MAP(~0u), 4, 33490},
	{51067, S_028350_PKR_XSEL(~0u), 4, 33494},
	{51176, S_028350_PKR_YSEL(~0u), 4, 33498},
	{51289, S_028350_PKR_XSEL2(~0u), 4, 33502},
	{51391, S_028350_SC_MAP(~0u), 4, 33506},
	{51537, S_028350_SC_XSEL(~0u), 4, 33510},
	{51684, S_028350_SC_YSEL(~0u), 4, 33514},
	{51784, S_028350_SE_MAP(~0u), 4, 33518},
	{69702, S_028350_SE_XSEL_GFX9(~0u)},
	{69715, S_028350_SE_YSEL_GFX9(~0u)},
	/* 2769 */
	{52207, S_028354_SE_PAIR_MAP(~0u), 4, 33530},
	{69728, S_028354_SE_PAIR_XSEL_GFX9(~0u)},
	{69746, S_028354_SE_PAIR_YSEL_GFX9(~0u)},
	/* 2772 */
	{7643, S_02835C_ENABLE(~0u)},
	{69764, S_02835C_NUM_SE(~0u)},
	{69144, S_02835C_NUM_RB_PER_SE(~0u)},
	/* 2775 */
	{69771, S_028360_PERFMON_ENABLE(~0u)},
	/* 2776 */
	{69786, S_0283A0_LEFT_QTR(~0u)},
	{69795, S_0283A0_LEFT_HALF(~0u)},
	{69805, S_0283A0_RIGHT_HALF(~0u)},
	{69816, S_0283A0_RIGHT_QTR(~0u)},
	/* 2780 */
	{69786, S_0283A4_LEFT_QTR(~0u)},
	{69795, S_0283A4_LEFT_HALF(~0u)},
	{69805, S_0283A4_RIGHT_HALF(~0u)},
	{69816, S_0283A4_RIGHT_QTR(~0u)},
	/* 2784 */
	{69826, S_0283A8_TOP_QTR(~0u)},
	{69834, S_0283A8_TOP_HALF(~0u)},
	{69843, S_0283A8_BOT_HALF(~0u)},
	{69852, S_0283A8_BOT_QTR(~0u)},
	/* 2788 */
	{52573, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{52600, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{52639, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	{69860, S_028424_DISABLE_CONSTANT_ENCODE_REG(~0u)},
	/* 2792 */
	{53842, S_0286D8_NUM_INTERP(~0u)},
	{53853, S_0286D8_PARAM_GEN(~0u)},
	{69888, S_0286D8_OFFCHIP_PARAM_EN(~0u)},
	{69905, S_0286D8_LATE_PC_DEALLOC(~0u)},
	{53872, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	/* 2797 */
	{30393, S_0287A0_EPITCH(~0u)},
	/* 2798 */
	{30393, S_0287A4_EPITCH(~0u)},
	/* 2799 */
	{30393, S_0287A8_EPITCH(~0u)},
	/* 2800 */
	{30393, S_0287AC_EPITCH(~0u)},
	/* 2801 */
	{30393, S_0287B0_EPITCH(~0u)},
	/* 2802 */
	{30393, S_0287B4_EPITCH(~0u)},
	/* 2803 */
	{30393, S_0287B8_EPITCH(~0u)},
	/* 2804 */
	{30393, S_0287BC_EPITCH(~0u)},
	/* 2805 */
	{69921, S_0287E4_BASE_ADDR_GFX9(~0u)},
	/* 2806 */
	{56726, S_0287F0_SOURCE_SELECT(~0u), 4, 33649},
	{56772, S_0287F0_MAJOR_MODE(~0u), 2, 33653},
	{69936, S_0287F0_SPRITE_EN_R6XX(~0u)},
	{56783, S_0287F0_NOT_EOP(~0u)},
	{56791, S_0287F0_USE_OPAQUE(~0u)},
	{69951, S_0287F0_UNROLLED_INST(~0u)},
	{69965, S_0287F0_GRBM_SKEW_NO_DEC(~0u)},
	{69982, S_0287F0_REG_RT_INDEX(~0u)},
	/* 2814 */
	{57767, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{57783, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{57814, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{48939, S_02880C_Z_ORDER(~0u), 4, 33934},
	{57893, S_02880C_KILL_ENABLE(~0u)},
	{57905, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{57929, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{57948, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{57966, S_02880C_EXEC_ON_NOOP(~0u)},
	{57979, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{58001, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{58091, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 33938},
	{58113, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	{69995, S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(~0u)},
	{70026, S_02880C_EXEC_IF_OVERLAPPED(~0u)},
	{70045, S_02880C_POPS_OVERLAP_NUM_SAMPLES(~0u)},
	/* 2830 */
	{58435, S_028814_CULL_FRONT(~0u)},
	{58446, S_028814_CULL_BACK(~0u)},
	{22820, S_028814_FACE(~0u)},
	{58466, S_028814_POLY_MODE(~0u), 2, 33942},
	{58532, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 33944},
	{58553, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 33944},
	{58573, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58598, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58622, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58646, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58671, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58690, S_028814_PERSP_CORR_DIS(~0u)},
	{58705, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	{70070, S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(~0u)},
	{70108, S_028814_NEW_QUAD_DECOMPOSITION(~0u)},
	/* 2845 */
	{58723, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58741, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58760, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{58778, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{58797, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{58815, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{58834, S_028818_VTX_XY_FMT(~0u)},
	{58845, S_028818_VTX_Z_FMT(~0u)},
	{58855, S_028818_VTX_W0_FMT(~0u)},
	{70131, S_028818_PERFCOUNTER_REF(~0u)},
	/* 2855 */
	{58866, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{58882, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{58898, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{58914, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{58930, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{58946, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{58962, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{58978, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{58994, S_02881C_CULL_DIST_ENA_0(~0u)},
	{59010, S_02881C_CULL_DIST_ENA_1(~0u)},
	{59026, S_02881C_CULL_DIST_ENA_2(~0u)},
	{59042, S_02881C_CULL_DIST_ENA_3(~0u)},
	{59058, S_02881C_CULL_DIST_ENA_4(~0u)},
	{59074, S_02881C_CULL_DIST_ENA_5(~0u)},
	{59090, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59106, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59122, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59141, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59159, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59186, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59208, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59226, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59246, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59269, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59292, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59317, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59337, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	{70147, S_02881C_USE_VTX_SHD_OBJPRIM_ID(~0u)},
	/* 2883 */
	{70170, S_028834_OBJ_ID_SEL(~0u)},
	{70181, S_028834_ADD_PIPED_PRIM_ID(~0u)},
	{70199, S_028834_EN_32BIT_OBJPRIMID(~0u)},
	/* 2886 */
	{70218, S_028838_VERTEX_REUSE_OFF(~0u)},
	{70235, S_028838_INDEX_BUF_EDGE_FLAG_ENA(~0u)},
	/* 2888 */
	{70259, S_02883C_DISCARD_0_AREA_TRIANGLES(~0u)},
	{70284, S_02883C_DISCARD_0_AREA_LINES(~0u)},
	{70305, S_02883C_DISCARD_0_AREA_POINTS(~0u)},
	{70327, S_02883C_DISCARD_0_AREA_RECTANGLES(~0u)},
	{70353, S_02883C_USE_PROVOKING_ZW(~0u)},
	/* 2893 */
	{22279, S_028A40_MODE(~0u), 6, 33984},
	{39310, S_028A40_RESERVED_0(~0u)},
	{60984, S_028A40_CUT_MODE(~0u), 4, 33990},
	{39328, S_028A40_RESERVED_1(~0u)},
	{60993, S_028A40_GS_C_PACK_EN(~0u)},
	{61006, S_028A40_RESERVED_2(~0u)},
	{61017, S_028A40_ES_PASSTHRU(~0u)},
	{70370, S_028A40_RESERVED_3(~0u)},
	{70381, S_028A40_RESERVED_4(~0u)},
	{70392, S_028A40_RESERVED_5(~0u)},
	{61076, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61095, S_028A40_SUPPRESS_CUTS(~0u)},
	{61109, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61127, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61178, S_028A40_ONCHIP(~0u), 4, 33994},
	/* 2908 */
	{61185, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61205, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	{70403, S_028A44_GS_INST_PRIMS_IN_SUBGRP(~0u)},
	/* 2911 */
	{61225, S_028A48_MSAA_ENABLE(~0u)},
	{61237, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61258, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61278, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	{70427, S_028A48_SCALE_LINE_WIDTH_PAD(~0u)},
	{70448, S_028A48_ALTERNATE_RBS_PER_TILE(~0u)},
	{70471, S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(~0u)},
	/* 2918 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 34001},
	{62062, S_028A7C_SWAP_MODE(~0u), 4, 34004},
	{62123, S_028A7C_BUF_TYPE(~0u), 3, 34008},
	{62182, S_028A7C_RDREQ_POLICY(~0u)},
	{67031, S_028A7C_PRIMGEN_EN(~0u)},
	{56783, S_028A7C_NOT_EOP(~0u)},
	{62195, S_028A7C_REQ_PATH(~0u)},
	/* 2925 */
	{22558, S_028A84_PRIMITIVEID_EN(~0u)},
	{62204, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	{70501, S_028A84_NGG_DISABLE_PROVOK_REUSE(~0u)},
	/* 2928 */
	{63160, S_028A90_EVENT_TYPE(~0u), 63, 34285},
	{70626, S_028A90_ADDRESS_HI_GFX9(~0u)},
	{63187, S_028A90_EXTENDED_EVENT(~0u)},
	/* 2931 */
	{30594, S_028A94_MAX_PRIMS_PER_SUBGROUP(~0u)},
	/* 2932 */
	{70642, S_028A98_OBJPRIM_ID_EN(~0u)},
	{70656, S_028A98_EN_REG_RT_INDEX(~0u)},
	{70672, S_028A98_EN_PIPELINE_PRIMID(~0u)},
	{70691, S_028A98_OBJECT_ID_INST_EN(~0u)},
	/* 2936 */
	{63320, S_028ABC_FULL_CACHE(~0u)},
	{63331, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63354, S_028ABC_PRELOAD(~0u)},
	{63362, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63377, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63393, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{68721, S_028ABC_PIPE_ALIGNED(~0u)},
	{68739, S_028ABC_RB_ALIGNED(~0u)},
	/* 2944 */
	{48084, S_028B54_LS_EN(~0u), 3, 34072},
	{48078, S_028B54_HS_EN(~0u)},
	{23383, S_028B54_ES_EN(~0u), 3, 34075},
	{48072, S_028B54_GS_EN(~0u)},
	{48066, S_028B54_VS_EN(~0u), 3, 34078},
	{46659, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63715, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63735, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63755, S_028B54_VS_WAVE_ID_EN(~0u)},
	{67031, S_028B54_PRIMGEN_EN(~0u)},
	{70709, S_028B54_ORDERED_ID_MODE(~0u)},
	{63300, S_028B54_MAX_PRIMGRP_IN_WAVE(~0u)},
	{70725, S_028B54_GS_FAST_LAUNCH(~0u)},
	/* 2957 */
	{209, S_028B6C_TYPE(~0u), 3, 34081},
	{63903, S_028B6C_PARTITIONING(~0u), 4, 34084},
	{63980, S_028B6C_TOPOLOGY(~0u), 4, 34088},
	{63989, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{64009, S_028B6C_DEPRECATED(~0u)},
	{64042, S_028B6C_DISABLE_DONUTS(~0u)},
	{62182, S_028B6C_RDREQ_POLICY(~0u)},
	{64181, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 34095},
	/* 2965 */
	{64377, S_028B94_STREAMOUT_0_EN(~0u)},
	{64392, S_028B94_STREAMOUT_1_EN(~0u)},
	{64407, S_028B94_STREAMOUT_2_EN(~0u)},
	{64422, S_028B94_STREAMOUT_3_EN(~0u)},
	{64437, S_028B94_RAST_STREAM(~0u)},
	{70740, S_028B94_EN_PRIMS_NEEDED_CNT(~0u)},
	{64449, S_028B94_RAST_STREAM_MASK(~0u)},
	{64466, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 2973 */
	{63160, S_028B9C_EVENT_TYPE(~0u)},
	{39245, S_028B9C_ADDRESS_HI(~0u)},
	{63187, S_028B9C_EXTENDED_EVENT(~0u)},
	/* 2976 */
	{64821, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{64838, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{64860, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{64876, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{64897, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{70760, S_028BE0_COVERAGE_TO_SHADER_SELECT(~0u)},
	/* 2982 */
	{65432, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	{69191, S_028C40_LOAD_COLLISION_WAVEID(~0u)},
	{69213, S_028C40_LOAD_INTRAWAVE_COLLISION(~0u)},
	/* 2985 */
	{70876, S_028C44_BINNING_MODE(~0u), 4, 34348},
	{70889, S_028C44_BIN_SIZE_X(~0u)},
	{70900, S_028C44_BIN_SIZE_Y(~0u)},
	{70911, S_028C44_BIN_SIZE_X_EXTEND(~0u)},
	{70929, S_028C44_BIN_SIZE_Y_EXTEND(~0u)},
	{70947, S_028C44_CONTEXT_STATES_PER_BIN(~0u)},
	{70970, S_028C44_PERSISTENT_STATES_PER_BIN(~0u)},
	{70996, S_028C44_DISABLE_START_OF_PRIM(~0u)},
	{71018, S_028C44_FPOVS_PER_BATCH(~0u)},
	{71034, S_028C44_OPTIMAL_BIN_SELECTION(~0u)},
	/* 2995 */
	{71056, S_028C48_MAX_ALLOC_COUNT(~0u)},
	{71072, S_028C48_MAX_PRIM_PER_BATCH(~0u)},
	/* 2997 */
	{71091, S_028C4C_OVER_RAST_ENABLE(~0u)},
	{71108, S_028C4C_OVER_RAST_SAMPLE_SELECT(~0u)},
	{71132, S_028C4C_UNDER_RAST_ENABLE(~0u)},
	{71150, S_028C4C_UNDER_RAST_SAMPLE_SELECT(~0u)},
	{71175, S_028C4C_PBB_UNCERTAINTY_REGION_ENABLE(~0u)},
	{71205, S_028C4C_ZMM_TRI_EXTENT(~0u)},
	{71220, S_028C4C_ZMM_TRI_OFFSET(~0u)},
	{71235, S_028C4C_OVERRIDE_OVER_RAST_INNER_TO_NORMAL(~0u)},
	{71270, S_028C4C_OVERRIDE_UNDER_RAST_INNER_TO_NORMAL(~0u)},
	{71306, S_028C4C_DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE(~0u)},
	{71350, S_028C4C_UNCERTAINTY_REGION_MODE(~0u)},
	{71374, S_028C4C_OUTER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71410, S_028C4C_INNER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71446, S_028C4C_NULL_SQUAD_AA_MASK_ENABLE(~0u)},
	{71472, S_028C4C_COVERAGE_AA_MASK_ENABLE(~0u)},
	{71496, S_028C4C_PREZ_AA_MASK_ENABLE(~0u)},
	{71516, S_028C4C_POSTZ_AA_MASK_ENABLE(~0u)},
	{71537, S_028C4C_CENTROID_SAMPLE_OVERRIDE(~0u)},
	/* 3015 */
	{71562, S_028C50_MAX_DEALLOCS_IN_WAVE(~0u)},
	/* 3016 */
	{71583, S_028C64_BASE_256B(~0u)},
	/* 3017 */
	{71593, S_028C68_MIP0_HEIGHT(~0u)},
	{71605, S_028C68_MIP0_WIDTH(~0u)},
	{68750, S_028C68_MAX_MIP(~0u)},
	/* 3020 */
	{48769, S_028C6C_SLICE_START(~0u)},
	{48781, S_028C6C_SLICE_MAX(~0u)},
	{71616, S_028C6C_MIP_LEVEL(~0u)},
	/* 3023 */
	{65556, S_028C70_ENDIAN(~0u), 4, 34111},
	{21132, S_028C70_FORMAT(~0u), 23, 34115},
	{65923, S_028C70_NUMBER_TYPE(~0u), 8, 34138},
	{65979, S_028C70_COMP_SWAP(~0u), 4, 34146},
	{57506, S_028C70_FAST_CLEAR(~0u)},
	{49355, S_028C70_COMPRESSION(~0u)},
	{65989, S_028C70_BLEND_CLAMP(~0u)},
	{66001, S_028C70_BLEND_BYPASS(~0u)},
	{66014, S_028C70_SIMPLE_FLOAT(~0u)},
	{64981, S_028C70_ROUND_MODE(~0u)},
	{66254, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 34150},
	{66276, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 34150},
	{66300, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66326, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66352, S_028C70_DCC_ENABLE(~0u)},
	{66363, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 3039 */
	{71626, S_028C74_MIP0_DEPTH(~0u)},
	{68704, S_028C74_META_LINEAR(~0u)},
	{49937, S_028C74_NUM_SAMPLES(~0u)},
	{66419, S_028C74_NUM_FRAGMENTS(~0u)},
	{66433, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	{71637, S_028C74_COLOR_SW_MODE(~0u)},
	{71651, S_028C74_FMASK_SW_MODE(~0u)},
	{71665, S_028C74_RESOURCE_TYPE(~0u), 4, 34352},
	{68739, S_028C74_RB_ALIGNED(~0u)},
	{68721, S_028C74_PIPE_ALIGNED(~0u)},
	/* 3049 */
	{71583, S_028C80_BASE_256B(~0u)},
	/* 3050 */
	{71583, S_028C88_BASE_256B(~0u)},
	/* 3051 */
	{71583, S_028C98_BASE_256B(~0u)},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 77, 91 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 203, 209 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234, 245 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 436, 441, 445 */
	"WAIT_REG_MEM\0" /* 447 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"RELEASE_MEM\0" /* 578 */
	"ONE_REG_WRITE\0" /* 590 */
	"ACQUIRE_MEM\0" /* 604 */
	"SET_CONFIG_REG\0" /* 616 */
	"SET_CONTEXT_REG\0" /* 631 */
	"SET_SH_REG\0" /* 647 */
	"SET_SH_REG_OFFSET\0" /* 658, 669 */
	"SET_UCONFIG_REG\0" /* 676 */
	"LOAD_CONST_RAM\0" /* 692 */
	"WRITE_CONST_RAM\0" /* 707 */
	"DUMP_CONST_RAM\0" /* 723 */
	"INCREMENT_CE_COUNTER\0" /* 738 */
	"INCREMENT_DE_COUNTER\0" /* 759 */
	"WAIT_ON_CE_COUNTER\0" /* 780 */
	"IT_OPCODE_C\0" /* 799 */
	"CP_DMA\0" /* 811 */
	"DMA_DATA\0" /* 818 */
	"DRAW_INDEX_LOC\0" /* 827 */
	"DST_ADDR_LO\0" /* 842 */
	"DST_ADDR_HI\0" /* 854 */
	"IB_BASE_LO\0" /* 866 */
	"IB_BASE_HI\0" /* 877, 880 */
	"CP_DMA_WORD0\0" /* 888 */
	"CP_DMA_WORD1\0" /* 901 */
	"CP_DMA_WORD2\0" /* 914 */
	"CP_DMA_WORD3\0" /* 927 */
	"COMMAND\0" /* 940 */
	"DMA_DATA_WORD0\0" /* 948 */
	"SRC_ADDR_LO\0" /* 963 */
	"SRC_ADDR_HI\0" /* 975 */
	"SRBM_STATUS2\0" /* 987 */
	"SRBM_STATUS\0" /* 1000, 1005 */
	"SRBM_STATUS3\0" /* 1012 */
	"SDMA0_STATUS_REG\0" /* 1025 */
	"SDMA1_STATUS_REG\0" /* 1042 */
	"GRBM_STATUS2\0" /* 1059 */
	"GRBM_STATUS\0" /* 1072 */
	"GRBM_GFX_INDEX\0" /* 1084 */
	"CP_STRMOUT_CNTL\0" /* 1099 */
	"CP_COHER_CNTL\0" /* 1115 */
	"CP_COHER_SIZE\0" /* 1129 */
	"CP_COHER_BASE\0" /* 1143 */
	"GRBM_STATUS_SE0\0" /* 1157 */
	"GRBM_STATUS_SE1\0" /* 1173 */
	"GRBM_STATUS_SE2\0" /* 1189 */
	"GRBM_STATUS_SE3\0" /* 1205 */
	"CP_COHER_BASE_HI\0" /* 1221 */
	"CP_COHER_START_DELAY\0" /* 1238 */
	"CP_COHER_STATUS\0" /* 1259 */
	"CP_CPC_STATUS\0" /* 1275 */
	"CP_CPC_BUSY_STAT\0" /* 1289 */
	"CP_CPC_STALLED_STAT1\0" /* 1306 */
	"CP_CPF_STATUS\0" /* 1327 */
	"CP_CPF_BUSY_STAT\0" /* 1341 */
	"CP_CPF_STALLED_STAT1\0" /* 1358 */
	"CP_COHER_SIZE_HI\0" /* 1379 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 1396 */
	"VGT_CACHE_INVALIDATION\0" /* 1419 */
	"VGT_ESGS_RING_SIZE\0" /* 1442 */
	"VGT_GSVS_RING_SIZE\0" /* 1461 */
	"VGT_GS_VERTEX_REUSE\0" /* 1480 */
	"VGT_PRIMITIVE_TYPE\0" /* 1500 */
	"VGT_INDEX_TYPE\0" /* 1519 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 1534 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 1567 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 1600 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 1633 */
	"VGT_NUM_INDICES\0" /* 1666 */
	"VGT_NUM_INSTANCES\0" /* 1682 */
	"VGT_TF_RING_SIZE\0" /* 1700 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 1717 */
	"VGT_TF_MEMORY_BASE\0" /* 1738 */
	"PA_CL_ENHANCE\0" /* 1757, 1768 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 1771, 1777 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 1796 */
	"CP_STALLED_STAT3\0" /* 1821 */
	"CP_STALLED_STAT1\0" /* 1838 */
	"CP_STALLED_STAT2\0" /* 1855 */
	"CP_STAT\0" /* 1872 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 1880, 1901 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 1906 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 1932, 1953 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 1958 */
	"PA_SC_ENHANCE\0" /* 1984 */
	"SQC_CACHES\0" /* 1998 */
	"SQ_RANDOM_WAVE_PRI\0" /* 2009 */
	"SQ_EXP_0\0" /* 2028 */
	"TA_CS_BC_BASE_ADDR\0" /* 2037, 2051 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 2056 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 2078 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 2102 */
	"SQ_BUF_RSRC_WORD0\0" /* 2125 */
	"SQ_BUF_RSRC_WORD1\0" /* 2143 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 2161 */
	"SQ_BUF_RSRC_WORD2\0" /* 2185 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 2203 */
	"SQ_BUF_RSRC_WORD3\0" /* 2226 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 2244 */
	"SQ_IMG_RSRC_WORD0\0" /* 2268 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 2286 */
	"SQ_IMG_RSRC_WORD1\0" /* 2309 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 2327 */
	"SQ_IMG_RSRC_WORD2\0" /* 2351 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 2369 */
	"SQ_IMG_RSRC_WORD3\0" /* 2392 */
	"SQ_IMG_RSRC_WORD4\0" /* 2410 */
	"SQ_IMG_RSRC_WORD5\0" /* 2428 */
	"SQ_IMG_RSRC_WORD6\0" /* 2446 */
	"SQ_IMG_RSRC_WORD7\0" /* 2464 */
	"SQ_IMG_SAMP_WORD0\0" /* 2482 */
	"SQ_IMG_SAMP_WORD1\0" /* 2500 */
	"SQ_IMG_SAMP_WORD2\0" /* 2518 */
	"SQ_IMG_SAMP_WORD3\0" /* 2536 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 2554, 2571 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 2574 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 2599 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 2624 */
	"SPI_PS_MAX_WAVE_ID\0" /* 2649, 2656 */
	"SPI_ARB_PRIORITY\0" /* 2668, 2676 */
	"SPI_ARB_CYCLES_0\0" /* 2685 */
	"SPI_ARB_CYCLES_1\0" /* 2702 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 2719 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 2741 */
	"DB_ZPASS_COUNT_LOW\0" /* 2763 */
	"DB_ZPASS_COUNT_HI\0" /* 2782, 2791 */
	"SPI_CONFIG_CNTL\0" /* 2800 */
	"SPI_CONFIG_CNTL_1\0" /* 2816 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 2834 */
	"DB_SUBTILE_CONTROL\0" /* 2863 */
	"GB_ADDR_CONFIG\0" /* 2882 */
	"GB_TILE_MODE0\0" /* 2897 */
	"GB_TILE_MODE1\0" /* 2911 */
	"GB_TILE_MODE2\0" /* 2925 */
	"GB_TILE_MODE3\0" /* 2939 */
	"GB_TILE_MODE4\0" /* 2953 */
	"GB_TILE_MODE5\0" /* 2967 */
	"GB_TILE_MODE6\0" /* 2981 */
	"GB_TILE_MODE7\0" /* 2995 */
	"GB_TILE_MODE8\0" /* 3009 */
	"GB_TILE_MODE9\0" /* 3023 */
	"GB_TILE_MODE10\0" /* 3037 */
	"GB_TILE_MODE11\0" /* 3052 */
	"GB_TILE_MODE12\0" /* 3067 */
	"GB_TILE_MODE13\0" /* 3082 */
	"GB_TILE_MODE14\0" /* 3097 */
	"GB_TILE_MODE15\0" /* 3112 */
	"GB_TILE_MODE16\0" /* 3127 */
	"GB_TILE_MODE17\0" /* 3142 */
	"GB_TILE_MODE18\0" /* 3157 */
	"GB_TILE_MODE19\0" /* 3172 */
	"GB_TILE_MODE20\0" /* 3187 */
	"GB_TILE_MODE21\0" /* 3202 */
	"GB_TILE_MODE22\0" /* 3217 */
	"GB_TILE_MODE23\0" /* 3232 */
	"GB_TILE_MODE24\0" /* 3247 */
	"GB_TILE_MODE25\0" /* 3262 */
	"GB_TILE_MODE26\0" /* 3277 */
	"GB_TILE_MODE27\0" /* 3292 */
	"GB_TILE_MODE28\0" /* 3307 */
	"GB_TILE_MODE29\0" /* 3322 */
	"GB_TILE_MODE30\0" /* 3337 */
	"GB_TILE_MODE31\0" /* 3352 */
	"GB_MACROTILE_MODE0\0" /* 3367 */
	"GB_MACROTILE_MODE1\0" /* 3386 */
	"GB_MACROTILE_MODE2\0" /* 3405 */
	"GB_MACROTILE_MODE3\0" /* 3424 */
	"GB_MACROTILE_MODE4\0" /* 3443 */
	"GB_MACROTILE_MODE5\0" /* 3462 */
	"GB_MACROTILE_MODE6\0" /* 3481 */
	"GB_MACROTILE_MODE7\0" /* 3500 */
	"GB_MACROTILE_MODE8\0" /* 3519 */
	"GB_MACROTILE_MODE9\0" /* 3538 */
	"GB_MACROTILE_MODE10\0" /* 3557 */
	"GB_MACROTILE_MODE11\0" /* 3577 */
	"GB_MACROTILE_MODE12\0" /* 3597 */
	"GB_MACROTILE_MODE13\0" /* 3617 */
	"GB_MACROTILE_MODE14\0" /* 3637 */
	"GB_MACROTILE_MODE15\0" /* 3657 */
	"SPI_SHADER_TBA_LO_PS\0" /* 3677 */
	"SPI_SHADER_TBA_HI_PS\0" /* 3698 */
	"SPI_SHADER_TMA_LO_PS\0" /* 3719 */
	"SPI_SHADER_TMA_HI_PS\0" /* 3740 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 3761 */
	"SPI_SHADER_PGM_LO_PS\0" /* 3785 */
	"SPI_SHADER_PGM_HI_PS\0" /* 3806 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 3827 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 3851 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 3875 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 3901 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 3927 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 3953 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 3979 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 4005 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 4031 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 4057 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 4083 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 4109 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 4135 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 4162 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 4189 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 4216 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 4243 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 4270 */
	"SPI_SHADER_TBA_LO_VS\0" /* 4297 */
	"SPI_SHADER_TBA_HI_VS\0" /* 4318 */
	"SPI_SHADER_TMA_LO_VS\0" /* 4339 */
	"SPI_SHADER_TMA_HI_VS\0" /* 4360 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 4381 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 4405 */
	"SPI_SHADER_PGM_LO_VS\0" /* 4430 */
	"SPI_SHADER_PGM_HI_VS\0" /* 4451 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 4472 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 4496 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 4520 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 4546 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 4572 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 4598 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 4624 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 4650 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 4676 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 4702 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 4728 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 4754 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 4780 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 4807 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 4834 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 4861 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 4888 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 4915 */
	"SPI_SHADER_TBA_LO_GS\0" /* 4942 */
	"SPI_SHADER_TBA_HI_GS\0" /* 4963 */
	"SPI_SHADER_TMA_LO_GS\0" /* 4984 */
	"SPI_SHADER_TMA_HI_GS\0" /* 5005 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 5026 */
	"SPI_SHADER_PGM_LO_GS\0" /* 5050 */
	"SPI_SHADER_PGM_HI_GS\0" /* 5071 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 5092 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 5116 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 5140 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 5166 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 5192 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 5218 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 5244 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 5270 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 5296 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 5322 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 5348 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 5374 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 5400 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 5427 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 5454 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 5481 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 5508 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 5535 */
	"SPI_SHADER_TBA_LO_ES\0" /* 5562 */
	"SPI_SHADER_TBA_HI_ES\0" /* 5583 */
	"SPI_SHADER_TMA_LO_ES\0" /* 5604 */
	"SPI_SHADER_TMA_HI_ES\0" /* 5625 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 5646 */
	"SPI_SHADER_PGM_LO_ES\0" /* 5670 */
	"SPI_SHADER_PGM_HI_ES\0" /* 5691 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 5712 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 5736 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 5760 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 5786 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 5812 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 5838 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 5864 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 5890 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 5916 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 5942 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 5968 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 5994 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 6020 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 6047 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 6074 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 6101 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 6128 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 6155 */
	"SPI_SHADER_TBA_LO_HS\0" /* 6182 */
	"SPI_SHADER_TBA_HI_HS\0" /* 6203 */
	"SPI_SHADER_TMA_LO_HS\0" /* 6224 */
	"SPI_SHADER_TMA_HI_HS\0" /* 6245 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 6266 */
	"SPI_SHADER_PGM_LO_HS\0" /* 6290 */
	"SPI_SHADER_PGM_HI_HS\0" /* 6311 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 6332 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 6356 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 6380 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 6406 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 6432 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 6458 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 6484 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 6510 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 6536 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 6562 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 6588 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 6614 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 6640 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 6667 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 6694 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 6721 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 6748 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 6775 */
	"SPI_SHADER_TBA_LO_LS\0" /* 6802 */
	"SPI_SHADER_TBA_HI_LS\0" /* 6823 */
	"SPI_SHADER_TMA_LO_LS\0" /* 6844 */
	"SPI_SHADER_TMA_HI_LS\0" /* 6865 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 6886 */
	"SPI_SHADER_PGM_LO_LS\0" /* 6910 */
	"SPI_SHADER_PGM_HI_LS\0" /* 6931 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 6952 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 6976 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 7000 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 7026 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 7052 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 7078 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 7104 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 7130 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 7156 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 7182 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 7208 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 7234 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 7260 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 7287 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 7314 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 7341 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 7368 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 7395 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 7422 */
	"COMPUTE_DIM_X\0" /* 7449 */
	"COMPUTE_DIM_Y\0" /* 7463 */
	"COMPUTE_DIM_Z\0" /* 7477 */
	"COMPUTE_START_X\0" /* 7491, 7499 */
	"COMPUTE_START_Y\0" /* 7507, 7515 */
	"COMPUTE_START_Z\0" /* 7523 */
	"COMPUTE_NUM_THREAD_X\0" /* 7539 */
	"COMPUTE_NUM_THREAD_Y\0" /* 7560 */
	"COMPUTE_NUM_THREAD_Z\0" /* 7581 */
	"COMPUTE_MAX_WAVE_ID\0" /* 7602 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 7622, 7630, 7643 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 7650, 7658 */
	"COMPUTE_PGM_LO\0" /* 7675 */
	"COMPUTE_PGM_HI\0" /* 7690 */
	"COMPUTE_TBA_LO\0" /* 7705 */
	"COMPUTE_TBA_HI\0" /* 7720 */
	"COMPUTE_TMA_LO\0" /* 7735 */
	"COMPUTE_TMA_HI\0" /* 7750 */
	"COMPUTE_PGM_RSRC1\0" /* 7765 */
	"COMPUTE_PGM_RSRC2\0" /* 7783 */
	"COMPUTE_VMID\0" /* 7801 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 7814 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 7838 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 7869 */
	"COMPUTE_TMPRING_SIZE\0" /* 7900 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 7921 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 7952 */
	"COMPUTE_RESTART_X\0" /* 7983 */
	"COMPUTE_RESTART_Y\0" /* 8001 */
	"COMPUTE_RESTART_Z\0" /* 8019 */
	"COMPUTE_MISC_RESERVED\0" /* 8037, 8050 */
	"COMPUTE_DISPATCH_ID\0" /* 8059 */
	"COMPUTE_THREADGROUP_ID\0" /* 8079 */
	"COMPUTE_RELAUNCH\0" /* 8102 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 8119 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 8148 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 8177 */
	"COMPUTE_USER_DATA_0\0" /* 8206 */
	"COMPUTE_USER_DATA_1\0" /* 8226 */
	"COMPUTE_USER_DATA_2\0" /* 8246 */
	"COMPUTE_USER_DATA_3\0" /* 8266 */
	"COMPUTE_USER_DATA_4\0" /* 8286 */
	"COMPUTE_USER_DATA_5\0" /* 8306 */
	"COMPUTE_USER_DATA_6\0" /* 8326 */
	"COMPUTE_USER_DATA_7\0" /* 8346 */
	"COMPUTE_USER_DATA_8\0" /* 8366 */
	"COMPUTE_USER_DATA_9\0" /* 8386 */
	"COMPUTE_USER_DATA_10\0" /* 8406 */
	"COMPUTE_USER_DATA_11\0" /* 8427 */
	"COMPUTE_USER_DATA_12\0" /* 8448 */
	"COMPUTE_USER_DATA_13\0" /* 8469 */
	"COMPUTE_USER_DATA_14\0" /* 8490 */
	"COMPUTE_USER_DATA_15\0" /* 8511 */
	"COMPUTE_NOWHERE\0" /* 8532, 8540 */
	"CPG_PERFCOUNTER1_LO\0" /* 8548 */
	"CPG_PERFCOUNTER1_HI\0" /* 8568 */
	"CPG_PERFCOUNTER0_LO\0" /* 8588 */
	"CPG_PERFCOUNTER0_HI\0" /* 8608 */
	"CPC_PERFCOUNTER1_LO\0" /* 8628 */
	"CPC_PERFCOUNTER1_HI\0" /* 8648 */
	"CPC_PERFCOUNTER0_LO\0" /* 8668 */
	"CPC_PERFCOUNTER0_HI\0" /* 8688 */
	"CPF_PERFCOUNTER1_LO\0" /* 8708 */
	"CPF_PERFCOUNTER1_HI\0" /* 8728 */
	"CPF_PERFCOUNTER0_LO\0" /* 8748 */
	"CPF_PERFCOUNTER0_HI\0" /* 8768 */
	"GRBM_PERFCOUNTER0_LO\0" /* 8788 */
	"GRBM_PERFCOUNTER0_HI\0" /* 8809 */
	"GRBM_PERFCOUNTER1_LO\0" /* 8830 */
	"GRBM_PERFCOUNTER1_HI\0" /* 8851 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 8872 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 8896, 8905 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 8920 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 8944 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 8968 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 8992 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 9016 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 9040 */
	"WD_PERFCOUNTER0_LO\0" /* 9064 */
	"WD_PERFCOUNTER0_HI\0" /* 9083 */
	"WD_PERFCOUNTER1_LO\0" /* 9102 */
	"WD_PERFCOUNTER1_HI\0" /* 9121 */
	"WD_PERFCOUNTER2_LO\0" /* 9140 */
	"WD_PERFCOUNTER2_HI\0" /* 9159 */
	"WD_PERFCOUNTER3_LO\0" /* 9178 */
	"WD_PERFCOUNTER3_HI\0" /* 9197 */
	"IA_PERFCOUNTER0_LO\0" /* 9216 */
	"IA_PERFCOUNTER0_HI\0" /* 9235 */
	"IA_PERFCOUNTER1_LO\0" /* 9254 */
	"IA_PERFCOUNTER1_HI\0" /* 9273 */
	"IA_PERFCOUNTER2_LO\0" /* 9292 */
	"IA_PERFCOUNTER2_HI\0" /* 9311 */
	"IA_PERFCOUNTER3_LO\0" /* 9330 */
	"IA_PERFCOUNTER3_HI\0" /* 9349 */
	"VGT_PERFCOUNTER0_LO\0" /* 9368 */
	"VGT_PERFCOUNTER0_HI\0" /* 9388 */
	"VGT_PERFCOUNTER1_LO\0" /* 9408 */
	"VGT_PERFCOUNTER1_HI\0" /* 9428 */
	"VGT_PERFCOUNTER2_LO\0" /* 9448 */
	"VGT_PERFCOUNTER2_HI\0" /* 9468 */
	"VGT_PERFCOUNTER3_LO\0" /* 9488 */
	"VGT_PERFCOUNTER3_HI\0" /* 9508 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 9528 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 9550 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 9572 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 9594 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 9616 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 9638 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 9660 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 9682 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 9704 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 9726 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 9748 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 9770 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 9792 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 9814 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 9836 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 9858 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 9880 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 9902 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 9924 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 9946 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 9968 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 9990 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 10012 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 10034 */
	"SPI_PERFCOUNTER0_HI\0" /* 10056 */
	"SPI_PERFCOUNTER0_LO\0" /* 10076 */
	"SPI_PERFCOUNTER1_HI\0" /* 10096 */
	"SPI_PERFCOUNTER1_LO\0" /* 10116 */
	"SPI_PERFCOUNTER2_HI\0" /* 10136 */
	"SPI_PERFCOUNTER2_LO\0" /* 10156 */
	"SPI_PERFCOUNTER3_HI\0" /* 10176 */
	"SPI_PERFCOUNTER3_LO\0" /* 10196 */
	"SPI_PERFCOUNTER4_HI\0" /* 10216 */
	"SPI_PERFCOUNTER4_LO\0" /* 10236 */
	"SPI_PERFCOUNTER5_HI\0" /* 10256 */
	"SPI_PERFCOUNTER5_LO\0" /* 10276 */
	"SQ_PERFCOUNTER0_LO\0" /* 10296 */
	"SQ_PERFCOUNTER0_HI\0" /* 10315 */
	"SQ_PERFCOUNTER1_LO\0" /* 10334 */
	"SQ_PERFCOUNTER1_HI\0" /* 10353 */
	"SQ_PERFCOUNTER2_LO\0" /* 10372 */
	"SQ_PERFCOUNTER2_HI\0" /* 10391 */
	"SQ_PERFCOUNTER3_LO\0" /* 10410 */
	"SQ_PERFCOUNTER3_HI\0" /* 10429 */
	"SQ_PERFCOUNTER4_LO\0" /* 10448 */
	"SQ_PERFCOUNTER4_HI\0" /* 10467 */
	"SQ_PERFCOUNTER5_LO\0" /* 10486 */
	"SQ_PERFCOUNTER5_HI\0" /* 10505 */
	"SQ_PERFCOUNTER6_LO\0" /* 10524 */
	"SQ_PERFCOUNTER6_HI\0" /* 10543 */
	"SQ_PERFCOUNTER7_LO\0" /* 10562 */
	"SQ_PERFCOUNTER7_HI\0" /* 10581 */
	"SQ_PERFCOUNTER8_LO\0" /* 10600 */
	"SQ_PERFCOUNTER8_HI\0" /* 10619 */
	"SQ_PERFCOUNTER9_LO\0" /* 10638 */
	"SQ_PERFCOUNTER9_HI\0" /* 10657 */
	"SQ_PERFCOUNTER10_LO\0" /* 10676 */
	"SQ_PERFCOUNTER10_HI\0" /* 10696 */
	"SQ_PERFCOUNTER11_LO\0" /* 10716 */
	"SQ_PERFCOUNTER11_HI\0" /* 10736 */
	"SQ_PERFCOUNTER12_LO\0" /* 10756 */
	"SQ_PERFCOUNTER12_HI\0" /* 10776 */
	"SQ_PERFCOUNTER13_LO\0" /* 10796 */
	"SQ_PERFCOUNTER13_HI\0" /* 10816 */
	"SQ_PERFCOUNTER14_LO\0" /* 10836 */
	"SQ_PERFCOUNTER14_HI\0" /* 10856 */
	"SQ_PERFCOUNTER15_LO\0" /* 10876 */
	"SQ_PERFCOUNTER15_HI\0" /* 10896 */
	"SX_PERFCOUNTER0_LO\0" /* 10916 */
	"SX_PERFCOUNTER0_HI\0" /* 10935 */
	"SX_PERFCOUNTER1_LO\0" /* 10954 */
	"SX_PERFCOUNTER1_HI\0" /* 10973 */
	"SX_PERFCOUNTER2_LO\0" /* 10992 */
	"SX_PERFCOUNTER2_HI\0" /* 11011 */
	"SX_PERFCOUNTER3_LO\0" /* 11030 */
	"SX_PERFCOUNTER3_HI\0" /* 11049 */
	"GDS_PERFCOUNTER0_LO\0" /* 11068 */
	"GDS_PERFCOUNTER0_HI\0" /* 11088 */
	"GDS_PERFCOUNTER1_LO\0" /* 11108 */
	"GDS_PERFCOUNTER1_HI\0" /* 11128 */
	"GDS_PERFCOUNTER2_LO\0" /* 11148 */
	"GDS_PERFCOUNTER2_HI\0" /* 11168 */
	"GDS_PERFCOUNTER3_LO\0" /* 11188 */
	"GDS_PERFCOUNTER3_HI\0" /* 11208 */
	"TA_PERFCOUNTER0_LO\0" /* 11228 */
	"TA_PERFCOUNTER0_HI\0" /* 11247 */
	"TA_PERFCOUNTER1_LO\0" /* 11266 */
	"TA_PERFCOUNTER1_HI\0" /* 11285 */
	"TD_PERFCOUNTER0_LO\0" /* 11304 */
	"TD_PERFCOUNTER0_HI\0" /* 11323 */
	"TD_PERFCOUNTER1_LO\0" /* 11342 */
	"TD_PERFCOUNTER1_HI\0" /* 11361 */
	"TCP_PERFCOUNTER0_LO\0" /* 11380 */
	"TCP_PERFCOUNTER0_HI\0" /* 11400 */
	"TCP_PERFCOUNTER1_LO\0" /* 11420 */
	"TCP_PERFCOUNTER1_HI\0" /* 11440 */
	"TCP_PERFCOUNTER2_LO\0" /* 11460 */
	"TCP_PERFCOUNTER2_HI\0" /* 11480 */
	"TCP_PERFCOUNTER3_LO\0" /* 11500 */
	"TCP_PERFCOUNTER3_HI\0" /* 11520 */
	"TCC_PERFCOUNTER0_LO\0" /* 11540 */
	"TCC_PERFCOUNTER0_HI\0" /* 11560 */
	"TCC_PERFCOUNTER1_LO\0" /* 11580 */
	"TCC_PERFCOUNTER1_HI\0" /* 11600 */
	"TCC_PERFCOUNTER2_LO\0" /* 11620 */
	"TCC_PERFCOUNTER2_HI\0" /* 11640 */
	"TCC_PERFCOUNTER3_LO\0" /* 11660 */
	"TCC_PERFCOUNTER3_HI\0" /* 11680 */
	"TCA_PERFCOUNTER0_LO\0" /* 11700 */
	"TCA_PERFCOUNTER0_HI\0" /* 11720 */
	"TCA_PERFCOUNTER1_LO\0" /* 11740 */
	"TCA_PERFCOUNTER1_HI\0" /* 11760 */
	"TCA_PERFCOUNTER2_LO\0" /* 11780 */
	"TCA_PERFCOUNTER2_HI\0" /* 11800 */
	"TCA_PERFCOUNTER3_LO\0" /* 11820 */
	"TCA_PERFCOUNTER3_HI\0" /* 11840 */
	"CB_PERFCOUNTER0_LO\0" /* 11860 */
	"CB_PERFCOUNTER0_HI\0" /* 11879 */
	"CB_PERFCOUNTER1_LO\0" /* 11898 */
	"CB_PERFCOUNTER1_HI\0" /* 11917 */
	"CB_PERFCOUNTER2_LO\0" /* 11936 */
	"CB_PERFCOUNTER2_HI\0" /* 11955 */
	"CB_PERFCOUNTER3_LO\0" /* 11974 */
	"CB_PERFCOUNTER3_HI\0" /* 11993 */
	"DB_PERFCOUNTER0_LO\0" /* 12012 */
	"DB_PERFCOUNTER0_HI\0" /* 12031 */
	"DB_PERFCOUNTER1_LO\0" /* 12050 */
	"DB_PERFCOUNTER1_HI\0" /* 12069 */
	"DB_PERFCOUNTER2_LO\0" /* 12088 */
	"DB_PERFCOUNTER2_HI\0" /* 12107 */
	"DB_PERFCOUNTER3_LO\0" /* 12126 */
	"DB_PERFCOUNTER3_HI\0" /* 12145 */
	"RLC_PERFCOUNTER0_LO\0" /* 12164 */
	"RLC_PERFCOUNTER0_HI\0" /* 12184 */
	"RLC_PERFCOUNTER1_LO\0" /* 12204 */
	"RLC_PERFCOUNTER1_HI\0" /* 12224 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 12244 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 12268 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 12293 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 12317 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 12341 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 12366 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 12390 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 12415 */
	"CP_PERFMON_CNTL\0" /* 12439 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 12455 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 12479 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 12504 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 12529, 12538 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 12557 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 12585 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 12613 */
	"WD_PERFCOUNTER0_SELECT\0" /* 12641 */
	"WD_PERFCOUNTER1_SELECT\0" /* 12664 */
	"WD_PERFCOUNTER2_SELECT\0" /* 12687 */
	"WD_PERFCOUNTER3_SELECT\0" /* 12710 */
	"IA_PERFCOUNTER0_SELECT\0" /* 12733 */
	"IA_PERFCOUNTER1_SELECT\0" /* 12756 */
	"IA_PERFCOUNTER2_SELECT\0" /* 12779 */
	"IA_PERFCOUNTER3_SELECT\0" /* 12802 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 12825 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 12849 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 12873 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 12897 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 12921 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 12945 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 12970 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 12995 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 13021 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 13047 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 13074 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 13100 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 13127 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 13153 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 13179 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 13205 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 13232 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 13258 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 13284 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 13310 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 13336 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 13362 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 13388 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 13414 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 13438 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 13462 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 13486 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 13510 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 13535 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 13560 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 13585 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 13610 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 13634 */
	"SPI_PERFCOUNTER_BINS\0" /* 13658 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 13679 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 13702 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 13725 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 13748 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 13771 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 13794 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 13817 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 13840 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 13863 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 13886 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 13909 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 13933 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 13957 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 13981 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 14005 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 14029 */
	"SQ_PERFCOUNTER_CTRL\0" /* 14053 */
	"SQ_PERFCOUNTER_MASK\0" /* 14073 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 14093 */
	"SX_PERFCOUNTER0_SELECT\0" /* 14114 */
	"SX_PERFCOUNTER1_SELECT\0" /* 14137 */
	"SX_PERFCOUNTER2_SELECT\0" /* 14160 */
	"SX_PERFCOUNTER3_SELECT\0" /* 14183 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 14206 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 14230 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 14254 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 14278 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 14302 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 14326 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 14350 */
	"TA_PERFCOUNTER0_SELECT\0" /* 14375 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 14398 */
	"TA_PERFCOUNTER1_SELECT\0" /* 14422 */
	"TD_PERFCOUNTER0_SELECT\0" /* 14445 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 14468 */
	"TD_PERFCOUNTER1_SELECT\0" /* 14492 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 14515 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 14539 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 14564 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 14588 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 14613 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 14637 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 14661 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 14685 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 14710 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 14734 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 14759 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 14783 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 14807 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 14831 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 14856 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 14880 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 14905 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 14929 */
	"CB_PERFCOUNTER_FILTER\0" /* 14953 */
	"CB_PERFCOUNTER0_SELECT\0" /* 14975 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 14998 */
	"CB_PERFCOUNTER1_SELECT\0" /* 15022 */
	"CB_PERFCOUNTER2_SELECT\0" /* 15045 */
	"CB_PERFCOUNTER3_SELECT\0" /* 15068 */
	"DB_PERFCOUNTER0_SELECT\0" /* 15091 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 15114 */
	"DB_PERFCOUNTER1_SELECT\0" /* 15138 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 15161 */
	"DB_PERFCOUNTER2_SELECT\0" /* 15185 */
	"DB_PERFCOUNTER3_SELECT\0" /* 15208 */
	"DB_RENDER_CONTROL\0" /* 15231 */
	"DB_COUNT_CONTROL\0" /* 15249 */
	"DB_DEPTH_VIEW\0" /* 15266 */
	"DB_RENDER_OVERRIDE\0" /* 15280, 15296 */
	"DB_RENDER_OVERRIDE2\0" /* 15299 */
	"DB_HTILE_DATA_BASE\0" /* 15319 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 15338 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 15358 */
	"DB_STENCIL_CLEAR\0" /* 15378, 15389 */
	"DB_DEPTH_CLEAR\0" /* 15395 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 15410 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 15434 */
	"DB_DEPTH_INFO\0" /* 15458 */
	"DB_Z_INFO\0" /* 15472 */
	"DB_STENCIL_INFO\0" /* 15482 */
	"DB_Z_READ_BASE\0" /* 15498 */
	"DB_STENCIL_READ_BASE\0" /* 15513 */
	"DB_Z_WRITE_BASE\0" /* 15534 */
	"DB_STENCIL_WRITE_BASE\0" /* 15550 */
	"DB_DEPTH_SIZE\0" /* 15572 */
	"DB_DEPTH_SLICE\0" /* 15586 */
	"TA_BC_BASE_ADDR\0" /* 15601 */
	"TA_BC_BASE_ADDR_HI\0" /* 15617 */
	"COHER_DEST_BASE_HI_0\0" /* 15636 */
	"COHER_DEST_BASE_HI_1\0" /* 15657 */
	"COHER_DEST_BASE_HI_2\0" /* 15678 */
	"COHER_DEST_BASE_HI_3\0" /* 15699 */
	"COHER_DEST_BASE_2\0" /* 15720 */
	"COHER_DEST_BASE_3\0" /* 15738 */
	"PA_SC_WINDOW_OFFSET\0" /* 15756, 15767 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 15776 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 15800 */
	"PA_SC_CLIPRECT_RULE\0" /* 15824 */
	"PA_SC_CLIPRECT_0_TL\0" /* 15844 */
	"PA_SC_CLIPRECT_0_BR\0" /* 15864 */
	"PA_SC_CLIPRECT_1_TL\0" /* 15884 */
	"PA_SC_CLIPRECT_1_BR\0" /* 15904 */
	"PA_SC_CLIPRECT_2_TL\0" /* 15924 */
	"PA_SC_CLIPRECT_2_BR\0" /* 15944 */
	"PA_SC_CLIPRECT_3_TL\0" /* 15964 */
	"PA_SC_CLIPRECT_3_BR\0" /* 15984 */
	"PA_SC_EDGERULE\0" /* 16004 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 16019 */
	"CB_TARGET_MASK\0" /* 16048 */
	"CB_SHADER_MASK\0" /* 16063 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 16078 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 16103 */
	"COHER_DEST_BASE_0\0" /* 16128 */
	"COHER_DEST_BASE_1\0" /* 16146 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 16164 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 16189 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 16214 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 16239 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 16264 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 16289 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 16314 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 16339 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 16364 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 16389 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 16414 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 16439 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 16464 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 16489 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 16514 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 16539 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 16564 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 16589 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 16614 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 16639 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 16664 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 16690 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 16716 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 16742 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 16768 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 16794 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 16820 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 16846 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 16872 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 16898 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 16924 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 16950 */
	"PA_SC_VPORT_ZMIN_0\0" /* 16976 */
	"PA_SC_VPORT_ZMAX_0\0" /* 16995 */
	"PA_SC_VPORT_ZMIN_1\0" /* 17014 */
	"PA_SC_VPORT_ZMAX_1\0" /* 17033 */
	"PA_SC_VPORT_ZMIN_2\0" /* 17052, 17066 */
	"PA_SC_VPORT_ZMAX_2\0" /* 17071 */
	"PA_SC_VPORT_ZMIN_3\0" /* 17090, 17104 */
	"PA_SC_VPORT_ZMAX_3\0" /* 17109 */
	"PA_SC_VPORT_ZMIN_4\0" /* 17128 */
	"PA_SC_VPORT_ZMAX_4\0" /* 17147 */
	"PA_SC_VPORT_ZMIN_5\0" /* 17166 */
	"PA_SC_VPORT_ZMAX_5\0" /* 17185 */
	"PA_SC_VPORT_ZMIN_6\0" /* 17204 */
	"PA_SC_VPORT_ZMAX_6\0" /* 17223 */
	"PA_SC_VPORT_ZMIN_7\0" /* 17242 */
	"PA_SC_VPORT_ZMAX_7\0" /* 17261 */
	"PA_SC_VPORT_ZMIN_8\0" /* 17280 */
	"PA_SC_VPORT_ZMAX_8\0" /* 17299 */
	"PA_SC_VPORT_ZMIN_9\0" /* 17318 */
	"PA_SC_VPORT_ZMAX_9\0" /* 17337 */
	"PA_SC_VPORT_ZMIN_10\0" /* 17356, 17370 */
	"PA_SC_VPORT_ZMAX_10\0" /* 17376 */
	"PA_SC_VPORT_ZMIN_11\0" /* 17396 */
	"PA_SC_VPORT_ZMAX_11\0" /* 17416 */
	"PA_SC_VPORT_ZMIN_12\0" /* 17436 */
	"PA_SC_VPORT_ZMAX_12\0" /* 17456 */
	"PA_SC_VPORT_ZMIN_13\0" /* 17476 */
	"PA_SC_VPORT_ZMAX_13\0" /* 17496 */
	"PA_SC_VPORT_ZMIN_14\0" /* 17516 */
	"PA_SC_VPORT_ZMAX_14\0" /* 17536 */
	"PA_SC_VPORT_ZMIN_15\0" /* 17556 */
	"PA_SC_VPORT_ZMAX_15\0" /* 17576 */
	"PA_SC_RASTER_CONFIG\0" /* 17596 */
	"PA_SC_RASTER_CONFIG_1\0" /* 17616 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 17638 */
	"VGT_MAX_VTX_INDX\0" /* 17666 */
	"VGT_MIN_VTX_INDX\0" /* 17683 */
	"VGT_INDX_OFFSET\0" /* 17700, 17707 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 17716 */
	"CB_BLEND_RED\0" /* 17745 */
	"CB_BLEND_GREEN\0" /* 17758 */
	"CB_BLEND_BLUE\0" /* 17773 */
	"CB_BLEND_ALPHA\0" /* 17787 */
	"CB_DCC_CONTROL\0" /* 17802 */
	"DB_STENCIL_CONTROL\0" /* 17817 */
	"DB_STENCILREFMASK\0" /* 17836 */
	"DB_STENCILREFMASK_BF\0" /* 17854 */
	"PA_CL_VPORT_XSCALE\0" /* 17875 */
	"PA_CL_VPORT_XOFFSET\0" /* 17894 */
	"PA_CL_VPORT_YSCALE\0" /* 17914 */
	"PA_CL_VPORT_YOFFSET\0" /* 17933 */
	"PA_CL_VPORT_ZSCALE\0" /* 17953 */
	"PA_CL_VPORT_ZOFFSET\0" /* 17972 */
	"PA_CL_VPORT_XSCALE_1\0" /* 17992 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 18013 */
	"PA_CL_VPORT_YSCALE_1\0" /* 18035 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 18056 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 18078 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 18099 */
	"PA_CL_VPORT_XSCALE_2\0" /* 18121 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 18142 */
	"PA_CL_VPORT_YSCALE_2\0" /* 18164 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 18185 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 18207 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 18228 */
	"PA_CL_VPORT_XSCALE_3\0" /* 18250 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 18271 */
	"PA_CL_VPORT_YSCALE_3\0" /* 18293 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 18314 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 18336 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 18357 */
	"PA_CL_VPORT_XSCALE_4\0" /* 18379 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 18400 */
	"PA_CL_VPORT_YSCALE_4\0" /* 18422 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 18443 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 18465 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 18486 */
	"PA_CL_VPORT_XSCALE_5\0" /* 18508 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 18529 */
	"PA_CL_VPORT_YSCALE_5\0" /* 18551 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 18572 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 18594 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 18615 */
	"PA_CL_VPORT_XSCALE_6\0" /* 18637 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 18658 */
	"PA_CL_VPORT_YSCALE_6\0" /* 18680 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 18701 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 18723 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 18744 */
	"PA_CL_VPORT_XSCALE_7\0" /* 18766 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 18787 */
	"PA_CL_VPORT_YSCALE_7\0" /* 18809 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 18830 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 18852 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 18873 */
	"PA_CL_VPORT_XSCALE_8\0" /* 18895 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 18916 */
	"PA_CL_VPORT_YSCALE_8\0" /* 18938 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 18959 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 18981 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 19002 */
	"PA_CL_VPORT_XSCALE_9\0" /* 19024 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 19045 */
	"PA_CL_VPORT_YSCALE_9\0" /* 19067 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 19088 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 19110 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 19131 */
	"PA_CL_VPORT_XSCALE_10\0" /* 19153 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 19175 */
	"PA_CL_VPORT_YSCALE_10\0" /* 19198 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 19220 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 19243 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 19265 */
	"PA_CL_VPORT_XSCALE_11\0" /* 19288 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 19310 */
	"PA_CL_VPORT_YSCALE_11\0" /* 19333 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 19355 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 19378 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 19400 */
	"PA_CL_VPORT_XSCALE_12\0" /* 19423 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 19445 */
	"PA_CL_VPORT_YSCALE_12\0" /* 19468 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 19490 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 19513 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 19535 */
	"PA_CL_VPORT_XSCALE_13\0" /* 19558 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 19580 */
	"PA_CL_VPORT_YSCALE_13\0" /* 19603 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 19625 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 19648 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 19670 */
	"PA_CL_VPORT_XSCALE_14\0" /* 19693 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 19715 */
	"PA_CL_VPORT_YSCALE_14\0" /* 19738 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 19760 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 19783 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 19805 */
	"PA_CL_VPORT_XSCALE_15\0" /* 19828 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 19850 */
	"PA_CL_VPORT_YSCALE_15\0" /* 19873 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 19895 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 19918 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 19940 */
	"PA_CL_UCP_0_X\0" /* 19963 */
	"PA_CL_UCP_0_Y\0" /* 19977 */
	"PA_CL_UCP_0_Z\0" /* 19991 */
	"PA_CL_UCP_0_W\0" /* 20005 */
	"PA_CL_UCP_1_X\0" /* 20019 */
	"PA_CL_UCP_1_Y\0" /* 20033 */
	"PA_CL_UCP_1_Z\0" /* 20047 */
	"PA_CL_UCP_1_W\0" /* 20061 */
	"PA_CL_UCP_2_X\0" /* 20075 */
	"PA_CL_UCP_2_Y\0" /* 20089 */
	"PA_CL_UCP_2_Z\0" /* 20103 */
	"PA_CL_UCP_2_W\0" /* 20117 */
	"PA_CL_UCP_3_X\0" /* 20131 */
	"PA_CL_UCP_3_Y\0" /* 20145 */
	"PA_CL_UCP_3_Z\0" /* 20159 */
	"PA_CL_UCP_3_W\0" /* 20173 */
	"PA_CL_UCP_4_X\0" /* 20187 */
	"PA_CL_UCP_4_Y\0" /* 20201 */
	"PA_CL_UCP_4_Z\0" /* 20215 */
	"PA_CL_UCP_4_W\0" /* 20229 */
	"PA_CL_UCP_5_X\0" /* 20243 */
	"PA_CL_UCP_5_Y\0" /* 20257 */
	"PA_CL_UCP_5_Z\0" /* 20271 */
	"PA_CL_UCP_5_W\0" /* 20285 */
	"SPI_PS_INPUT_CNTL_0\0" /* 20299 */
	"SPI_PS_INPUT_CNTL_1\0" /* 20319 */
	"SPI_PS_INPUT_CNTL_2\0" /* 20339 */
	"SPI_PS_INPUT_CNTL_3\0" /* 20359 */
	"SPI_PS_INPUT_CNTL_4\0" /* 20379 */
	"SPI_PS_INPUT_CNTL_5\0" /* 20399 */
	"SPI_PS_INPUT_CNTL_6\0" /* 20419 */
	"SPI_PS_INPUT_CNTL_7\0" /* 20439 */
	"SPI_PS_INPUT_CNTL_8\0" /* 20459 */
	"SPI_PS_INPUT_CNTL_9\0" /* 20479 */
	"SPI_PS_INPUT_CNTL_10\0" /* 20499 */
	"SPI_PS_INPUT_CNTL_11\0" /* 20520 */
	"SPI_PS_INPUT_CNTL_12\0" /* 20541 */
	"SPI_PS_INPUT_CNTL_13\0" /* 20562 */
	"SPI_PS_INPUT_CNTL_14\0" /* 20583 */
	"SPI_PS_INPUT_CNTL_15\0" /* 20604 */
	"SPI_PS_INPUT_CNTL_16\0" /* 20625 */
	"SPI_PS_INPUT_CNTL_17\0" /* 20646 */
	"SPI_PS_INPUT_CNTL_18\0" /* 20667 */
	"SPI_PS_INPUT_CNTL_19\0" /* 20688 */
	"SPI_PS_INPUT_CNTL_20\0" /* 20709 */
	"SPI_PS_INPUT_CNTL_21\0" /* 20730 */
	"SPI_PS_INPUT_CNTL_22\0" /* 20751 */
	"SPI_PS_INPUT_CNTL_23\0" /* 20772 */
	"SPI_PS_INPUT_CNTL_24\0" /* 20793 */
	"SPI_PS_INPUT_CNTL_25\0" /* 20814 */
	"SPI_PS_INPUT_CNTL_26\0" /* 20835 */
	"SPI_PS_INPUT_CNTL_27\0" /* 20856 */
	"SPI_PS_INPUT_CNTL_28\0" /* 20877 */
	"SPI_PS_INPUT_CNTL_29\0" /* 20898 */
	"SPI_PS_INPUT_CNTL_30\0" /* 20919 */
	"SPI_PS_INPUT_CNTL_31\0" /* 20940 */
	"SPI_VS_OUT_CONFIG\0" /* 20961 */
	"SPI_PS_INPUT_ENA\0" /* 20979 */
	"SPI_PS_INPUT_ADDR\0" /* 20996 */
	"SPI_INTERP_CONTROL_0\0" /* 21014 */
	"SPI_PS_IN_CONTROL\0" /* 21035 */
	"SPI_BARYC_CNTL\0" /* 21053 */
	"SPI_TMPRING_SIZE\0" /* 21068 */
	"SPI_WAVE_MGMT_1\0" /* 21085 */
	"SPI_WAVE_MGMT_2\0" /* 21101 */
	"SPI_SHADER_POS_FORMAT\0" /* 21117, 21132 */
	"SPI_SHADER_Z_FORMAT\0" /* 21139 */
	"SPI_SHADER_COL_FORMAT\0" /* 21159 */
	"SX_PS_DOWNCONVERT\0" /* 21181 */
	"SX_BLEND_OPT_EPSILON\0" /* 21199 */
	"SX_BLEND_OPT_CONTROL\0" /* 21220 */
	"SX_MRT0_BLEND_OPT\0" /* 21241 */
	"SX_MRT1_BLEND_OPT\0" /* 21259 */
	"SX_MRT2_BLEND_OPT\0" /* 21277 */
	"SX_MRT3_BLEND_OPT\0" /* 21295 */
	"SX_MRT4_BLEND_OPT\0" /* 21313 */
	"SX_MRT5_BLEND_OPT\0" /* 21331 */
	"SX_MRT6_BLEND_OPT\0" /* 21349 */
	"SX_MRT7_BLEND_OPT\0" /* 21367 */
	"CB_BLEND0_CONTROL\0" /* 21385 */
	"CB_BLEND1_CONTROL\0" /* 21403 */
	"CB_BLEND2_CONTROL\0" /* 21421 */
	"CB_BLEND3_CONTROL\0" /* 21439 */
	"CB_BLEND4_CONTROL\0" /* 21457 */
	"CB_BLEND5_CONTROL\0" /* 21475 */
	"CB_BLEND6_CONTROL\0" /* 21493 */
	"CB_BLEND7_CONTROL\0" /* 21511 */
	"CS_COPY_STATE\0" /* 21529 */
	"PA_CL_POINT_X_RAD\0" /* 21543 */
	"PA_CL_POINT_Y_RAD\0" /* 21561 */
	"PA_CL_POINT_SIZE\0" /* 21579 */
	"PA_CL_POINT_CULL_RAD\0" /* 21596 */
	"VGT_DMA_BASE_HI\0" /* 21617 */
	"VGT_DMA_BASE\0" /* 21633 */
	"VGT_DRAW_INITIATOR\0" /* 21646 */
	"VGT_IMMED_DATA\0" /* 21665 */
	"VGT_EVENT_ADDRESS_REG\0" /* 21680 */
	"DB_DEPTH_CONTROL\0" /* 21702 */
	"DB_EQAA\0" /* 21719 */
	"CB_COLOR_CONTROL\0" /* 21727 */
	"DB_SHADER_CONTROL\0" /* 21744 */
	"PA_CL_CLIP_CNTL\0" /* 21762 */
	"PA_SU_SC_MODE_CNTL\0" /* 21778 */
	"PA_CL_VTE_CNTL\0" /* 21797 */
	"PA_CL_VS_OUT_CNTL\0" /* 21812 */
	"PA_CL_NANINF_CNTL\0" /* 21830 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 21848 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 21872 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 21897 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 21920 */
	"PA_SU_POINT_SIZE\0" /* 21949 */
	"PA_SU_POINT_MINMAX\0" /* 21966 */
	"PA_SU_LINE_CNTL\0" /* 21985 */
	"PA_SC_LINE_STIPPLE\0" /* 22001 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 22020 */
	"VGT_HOS_CNTL\0" /* 22041 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 22054 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 22077 */
	"VGT_HOS_REUSE_DEPTH\0" /* 22100, 22108, 22114 */
	"VGT_GROUP_PRIM_TYPE\0" /* 22120, 22130 */
	"VGT_GROUP_FIRST_DECR\0" /* 22140, 22150, 22156 */
	"VGT_GROUP_DECR\0" /* 22161 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 22176 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 22198 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 22220 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 22246 */
	"VGT_GS_MODE\0" /* 22272, 22279 */
	"VGT_GS_ONCHIP_CNTL\0" /* 22284 */
	"PA_SC_MODE_CNTL_0\0" /* 22303 */
	"PA_SC_MODE_CNTL_1\0" /* 22321 */
	"VGT_ENHANCE\0" /* 22339 */
	"VGT_GS_PER_ES\0" /* 22351, 22355 */
	"VGT_ES_PER_GS\0" /* 22365, 22369 */
	"VGT_GS_PER_VS\0" /* 22379, 22383 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 22393 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 22416 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 22439 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 22462 */
	"IA_ENHANCE\0" /* 22483 */
	"VGT_DMA_SIZE\0" /* 22494 */
	"VGT_DMA_MAX_SIZE\0" /* 22507, 22515 */
	"VGT_DMA_INDEX_TYPE\0" /* 22524 */
	"WD_ENHANCE\0" /* 22543 */
	"VGT_PRIMITIVEID_EN\0" /* 22554, 22558 */
	"VGT_DMA_NUM_INSTANCES\0" /* 22573 */
	"VGT_PRIMITIVEID_RESET\0" /* 22595 */
	"VGT_EVENT_INITIATOR\0" /* 22617 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 22637, 22655 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 22664 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 22689 */
	"IA_MULTI_VGT_PARAM\0" /* 22714 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 22733, 22747 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 22756 */
	"VGT_REUSE_OFF\0" /* 22779, 22783 */
	"VGT_VTX_CNT_EN\0" /* 22793, 22797 */
	"DB_HTILE_SURFACE\0" /* 22808, 22820 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 22825 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 22852 */
	"DB_PRELOAD_CONTROL\0" /* 22879 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 22898 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 22924 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 22949 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 22977 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 23003 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 23028 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 23056 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 23082 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 23107 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 23135 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 23161 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 23186 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 23214 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 23245 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 23288, 23312, 23319 */
	"VGT_GS_MAX_VERT_OUT\0" /* 23326, 23333, 23342 */
	"VGT_TESS_DISTRIBUTION\0" /* 23346 */
	"VGT_SHADER_STAGES_EN\0" /* 23368, 23383 */
	"VGT_LS_HS_CONFIG\0" /* 23389 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 23406 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 23427 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 23450 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 23473 */
	"VGT_TF_PARAM\0" /* 23496 */
	"DB_ALPHA_TO_MASK\0" /* 23509 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 23526 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 23550 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 23580 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 23604 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 23634 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 23665 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 23694 */
	"VGT_GS_INSTANCE_CNT\0" /* 23724, 23740 */
	"VGT_STRMOUT_CONFIG\0" /* 23744 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 23763 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 23789 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 23815 */
	"PA_SC_LINE_CNTL\0" /* 23841 */
	"PA_SC_AA_CONFIG\0" /* 23857 */
	"PA_SU_VTX_CNTL\0" /* 23873 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 23888 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 23911 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 23934 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 23957 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 23980 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 24014 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 24048 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 24082 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 24116 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 24150 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 24184 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 24218 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 24252 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 24286 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 24320 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 24354 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 24388 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 24422 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 24456 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 24490 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 24524 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 24548 */
	"PA_SC_SHADER_CONTROL\0" /* 24572 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 24593 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 24621 */
	"CB_COLOR0_BASE\0" /* 24642 */
	"CB_COLOR0_PITCH\0" /* 24657 */
	"CB_COLOR0_SLICE\0" /* 24673 */
	"CB_COLOR0_VIEW\0" /* 24689 */
	"CB_COLOR0_INFO\0" /* 24704 */
	"CB_COLOR0_ATTRIB\0" /* 24719 */
	"CB_COLOR0_DCC_CONTROL\0" /* 24736 */
	"CB_COLOR0_CMASK\0" /* 24758 */
	"CB_COLOR0_CMASK_SLICE\0" /* 24774 */
	"CB_COLOR0_FMASK\0" /* 24796 */
	"CB_COLOR0_FMASK_SLICE\0" /* 24812 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 24834 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 24856 */
	"CB_COLOR0_DCC_BASE\0" /* 24878 */
	"CB_COLOR1_BASE\0" /* 24897 */
	"CB_COLOR1_PITCH\0" /* 24912 */
	"CB_COLOR1_SLICE\0" /* 24928 */
	"CB_COLOR1_VIEW\0" /* 24944 */
	"CB_COLOR1_INFO\0" /* 24959 */
	"CB_COLOR1_ATTRIB\0" /* 24974 */
	"CB_COLOR1_DCC_CONTROL\0" /* 24991 */
	"CB_COLOR1_CMASK\0" /* 25013 */
	"CB_COLOR1_CMASK_SLICE\0" /* 25029 */
	"CB_COLOR1_FMASK\0" /* 25051 */
	"CB_COLOR1_FMASK_SLICE\0" /* 25067 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 25089 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 25111 */
	"CB_COLOR1_DCC_BASE\0" /* 25133 */
	"CB_COLOR2_BASE\0" /* 25152 */
	"CB_COLOR2_PITCH\0" /* 25167 */
	"CB_COLOR2_SLICE\0" /* 25183 */
	"CB_COLOR2_VIEW\0" /* 25199 */
	"CB_COLOR2_INFO\0" /* 25214 */
	"CB_COLOR2_ATTRIB\0" /* 25229 */
	"CB_COLOR2_DCC_CONTROL\0" /* 25246 */
	"CB_COLOR2_CMASK\0" /* 25268 */
	"CB_COLOR2_CMASK_SLICE\0" /* 25284 */
	"CB_COLOR2_FMASK\0" /* 25306 */
	"CB_COLOR2_FMASK_SLICE\0" /* 25322 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 25344 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 25366 */
	"CB_COLOR2_DCC_BASE\0" /* 25388 */
	"CB_COLOR3_BASE\0" /* 25407 */
	"CB_COLOR3_PITCH\0" /* 25422 */
	"CB_COLOR3_SLICE\0" /* 25438 */
	"CB_COLOR3_VIEW\0" /* 25454 */
	"CB_COLOR3_INFO\0" /* 25469 */
	"CB_COLOR3_ATTRIB\0" /* 25484 */
	"CB_COLOR3_DCC_CONTROL\0" /* 25501 */
	"CB_COLOR3_CMASK\0" /* 25523 */
	"CB_COLOR3_CMASK_SLICE\0" /* 25539 */
	"CB_COLOR3_FMASK\0" /* 25561 */
	"CB_COLOR3_FMASK_SLICE\0" /* 25577 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 25599 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 25621 */
	"CB_COLOR3_DCC_BASE\0" /* 25643 */
	"CB_COLOR4_BASE\0" /* 25662 */
	"CB_COLOR4_PITCH\0" /* 25677 */
	"CB_COLOR4_SLICE\0" /* 25693 */
	"CB_COLOR4_VIEW\0" /* 25709 */
	"CB_COLOR4_INFO\0" /* 25724 */
	"CB_COLOR4_ATTRIB\0" /* 25739 */
	"CB_COLOR4_DCC_CONTROL\0" /* 25756 */
	"CB_COLOR4_CMASK\0" /* 25778 */
	"CB_COLOR4_CMASK_SLICE\0" /* 25794 */
	"CB_COLOR4_FMASK\0" /* 25816 */
	"CB_COLOR4_FMASK_SLICE\0" /* 25832 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 25854 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 25876 */
	"CB_COLOR4_DCC_BASE\0" /* 25898 */
	"CB_COLOR5_BASE\0" /* 25917 */
	"CB_COLOR5_PITCH\0" /* 25932 */
	"CB_COLOR5_SLICE\0" /* 25948 */
	"CB_COLOR5_VIEW\0" /* 25964 */
	"CB_COLOR5_INFO\0" /* 25979 */
	"CB_COLOR5_ATTRIB\0" /* 25994 */
	"CB_COLOR5_DCC_CONTROL\0" /* 26011 */
	"CB_COLOR5_CMASK\0" /* 26033 */
	"CB_COLOR5_CMASK_SLICE\0" /* 26049 */
	"CB_COLOR5_FMASK\0" /* 26071 */
	"CB_COLOR5_FMASK_SLICE\0" /* 26087 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 26109 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 26131 */
	"CB_COLOR5_DCC_BASE\0" /* 26153 */
	"CB_COLOR6_BASE\0" /* 26172 */
	"CB_COLOR6_PITCH\0" /* 26187 */
	"CB_COLOR6_SLICE\0" /* 26203 */
	"CB_COLOR6_VIEW\0" /* 26219 */
	"CB_COLOR6_INFO\0" /* 26234 */
	"CB_COLOR6_ATTRIB\0" /* 26249 */
	"CB_COLOR6_DCC_CONTROL\0" /* 26266 */
	"CB_COLOR6_CMASK\0" /* 26288 */
	"CB_COLOR6_CMASK_SLICE\0" /* 26304 */
	"CB_COLOR6_FMASK\0" /* 26326 */
	"CB_COLOR6_FMASK_SLICE\0" /* 26342 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 26364 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 26386 */
	"CB_COLOR6_DCC_BASE\0" /* 26408 */
	"CB_COLOR7_BASE\0" /* 26427 */
	"CB_COLOR7_PITCH\0" /* 26442 */
	"CB_COLOR7_SLICE\0" /* 26458 */
	"CB_COLOR7_VIEW\0" /* 26474 */
	"CB_COLOR7_INFO\0" /* 26489 */
	"CB_COLOR7_ATTRIB\0" /* 26504 */
	"CB_COLOR7_DCC_CONTROL\0" /* 26521 */
	"CB_COLOR7_CMASK\0" /* 26543 */
	"CB_COLOR7_CMASK_SLICE\0" /* 26559 */
	"CB_COLOR7_FMASK\0" /* 26581 */
	"CB_COLOR7_FMASK_SLICE\0" /* 26597 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 26619 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 26641 */
	"CB_COLOR7_DCC_BASE\0" /* 26663 */
	"VGT_TF_MEMORY_BASE_HI\0" /* 26682 */
	"WD_POS_BUF_BASE\0" /* 26704 */
	"WD_POS_BUF_BASE_HI\0" /* 26720 */
	"WD_CNTL_SB_BUF_BASE\0" /* 26739 */
	"WD_CNTL_SB_BUF_BASE_HI\0" /* 26759 */
	"WD_INDEX_BUF_BASE\0" /* 26782 */
	"WD_INDEX_BUF_BASE_HI\0" /* 26800 */
	"VGT_INSTANCE_BASE_ID\0" /* 26821 */
	"SQC_WRITEBACK\0" /* 26842, 26846 */
	"SPI_CONFIG_CNTL_2\0" /* 26856 */
	"SPI_SHADER_USER_DATA_PS_16\0" /* 26874 */
	"SPI_SHADER_USER_DATA_PS_17\0" /* 26901 */
	"SPI_SHADER_USER_DATA_PS_18\0" /* 26928 */
	"SPI_SHADER_USER_DATA_PS_19\0" /* 26955 */
	"SPI_SHADER_USER_DATA_PS_20\0" /* 26982 */
	"SPI_SHADER_USER_DATA_PS_21\0" /* 27009 */
	"SPI_SHADER_USER_DATA_PS_22\0" /* 27036 */
	"SPI_SHADER_USER_DATA_PS_23\0" /* 27063 */
	"SPI_SHADER_USER_DATA_PS_24\0" /* 27090 */
	"SPI_SHADER_USER_DATA_PS_25\0" /* 27117 */
	"SPI_SHADER_USER_DATA_PS_26\0" /* 27144 */
	"SPI_SHADER_USER_DATA_PS_27\0" /* 27171 */
	"SPI_SHADER_USER_DATA_PS_28\0" /* 27198 */
	"SPI_SHADER_USER_DATA_PS_29\0" /* 27225 */
	"SPI_SHADER_USER_DATA_PS_30\0" /* 27252 */
	"SPI_SHADER_USER_DATA_PS_31\0" /* 27279 */
	"SPI_SHADER_USER_DATA_VS_16\0" /* 27306 */
	"SPI_SHADER_USER_DATA_VS_17\0" /* 27333 */
	"SPI_SHADER_USER_DATA_VS_18\0" /* 27360 */
	"SPI_SHADER_USER_DATA_VS_19\0" /* 27387 */
	"SPI_SHADER_USER_DATA_VS_20\0" /* 27414 */
	"SPI_SHADER_USER_DATA_VS_21\0" /* 27441 */
	"SPI_SHADER_USER_DATA_VS_22\0" /* 27468 */
	"SPI_SHADER_USER_DATA_VS_23\0" /* 27495 */
	"SPI_SHADER_USER_DATA_VS_24\0" /* 27522 */
	"SPI_SHADER_USER_DATA_VS_25\0" /* 27549 */
	"SPI_SHADER_USER_DATA_VS_26\0" /* 27576 */
	"SPI_SHADER_USER_DATA_VS_27\0" /* 27603 */
	"SPI_SHADER_USER_DATA_VS_28\0" /* 27630 */
	"SPI_SHADER_USER_DATA_VS_29\0" /* 27657 */
	"SPI_SHADER_USER_DATA_VS_30\0" /* 27684 */
	"SPI_SHADER_USER_DATA_VS_31\0" /* 27711 */
	"SPI_SHADER_PGM_RSRC2_GS_VS\0" /* 27738 */
	"SPI_SHADER_PGM_RSRC4_GS\0" /* 27765 */
	"SPI_SHADER_USER_DATA_ADDR_LO_GS\0" /* 27789 */
	"SPI_SHADER_USER_DATA_ADDR_HI_GS\0" /* 27821 */
	"SPI_SHADER_USER_DATA_ES_16\0" /* 27853 */
	"SPI_SHADER_USER_DATA_ES_17\0" /* 27880 */
	"SPI_SHADER_USER_DATA_ES_18\0" /* 27907 */
	"SPI_SHADER_USER_DATA_ES_19\0" /* 27934 */
	"SPI_SHADER_USER_DATA_ES_20\0" /* 27961 */
	"SPI_SHADER_USER_DATA_ES_21\0" /* 27988 */
	"SPI_SHADER_USER_DATA_ES_22\0" /* 28015 */
	"SPI_SHADER_USER_DATA_ES_23\0" /* 28042 */
	"SPI_SHADER_USER_DATA_ES_24\0" /* 28069 */
	"SPI_SHADER_USER_DATA_ES_25\0" /* 28096 */
	"SPI_SHADER_USER_DATA_ES_26\0" /* 28123 */
	"SPI_SHADER_USER_DATA_ES_27\0" /* 28150 */
	"SPI_SHADER_USER_DATA_ES_28\0" /* 28177 */
	"SPI_SHADER_USER_DATA_ES_29\0" /* 28204 */
	"SPI_SHADER_USER_DATA_ES_30\0" /* 28231 */
	"SPI_SHADER_USER_DATA_ES_31\0" /* 28258 */
	"SPI_SHADER_PGM_RSRC4_HS\0" /* 28285 */
	"SPI_SHADER_USER_DATA_ADDR_LO_HS\0" /* 28309 */
	"SPI_SHADER_USER_DATA_ADDR_HI_HS\0" /* 28341 */
	"SPI_SHADER_USER_DATA_LS_16\0" /* 28373 */
	"SPI_SHADER_USER_DATA_LS_17\0" /* 28400 */
	"SPI_SHADER_USER_DATA_LS_18\0" /* 28427 */
	"SPI_SHADER_USER_DATA_LS_19\0" /* 28454 */
	"SPI_SHADER_USER_DATA_LS_20\0" /* 28481 */
	"SPI_SHADER_USER_DATA_LS_21\0" /* 28508 */
	"SPI_SHADER_USER_DATA_LS_22\0" /* 28535 */
	"SPI_SHADER_USER_DATA_LS_23\0" /* 28562 */
	"SPI_SHADER_USER_DATA_LS_24\0" /* 28589 */
	"SPI_SHADER_USER_DATA_LS_25\0" /* 28616 */
	"SPI_SHADER_USER_DATA_LS_26\0" /* 28643 */
	"SPI_SHADER_USER_DATA_LS_27\0" /* 28670 */
	"SPI_SHADER_USER_DATA_LS_28\0" /* 28697 */
	"SPI_SHADER_USER_DATA_LS_29\0" /* 28724 */
	"SPI_SHADER_USER_DATA_LS_30\0" /* 28751 */
	"SPI_SHADER_USER_DATA_LS_31\0" /* 28778 */
	"SPI_SHADER_USER_DATA_COMMON_0\0" /* 28805 */
	"SPI_SHADER_USER_DATA_COMMON_1\0" /* 28835 */
	"SPI_SHADER_USER_DATA_COMMON_2\0" /* 28865 */
	"SPI_SHADER_USER_DATA_COMMON_3\0" /* 28895 */
	"SPI_SHADER_USER_DATA_COMMON_4\0" /* 28925 */
	"SPI_SHADER_USER_DATA_COMMON_5\0" /* 28955 */
	"SPI_SHADER_USER_DATA_COMMON_6\0" /* 28985 */
	"SPI_SHADER_USER_DATA_COMMON_7\0" /* 29015 */
	"SPI_SHADER_USER_DATA_COMMON_8\0" /* 29045 */
	"SPI_SHADER_USER_DATA_COMMON_9\0" /* 29075 */
	"SPI_SHADER_USER_DATA_COMMON_10\0" /* 29105 */
	"SPI_SHADER_USER_DATA_COMMON_11\0" /* 29136 */
	"SPI_SHADER_USER_DATA_COMMON_12\0" /* 29167 */
	"SPI_SHADER_USER_DATA_COMMON_13\0" /* 29198 */
	"SPI_SHADER_USER_DATA_COMMON_14\0" /* 29229 */
	"SPI_SHADER_USER_DATA_COMMON_15\0" /* 29260 */
	"SPI_SHADER_USER_DATA_COMMON_16\0" /* 29291 */
	"SPI_SHADER_USER_DATA_COMMON_17\0" /* 29322 */
	"SPI_SHADER_USER_DATA_COMMON_18\0" /* 29353 */
	"SPI_SHADER_USER_DATA_COMMON_19\0" /* 29384 */
	"SPI_SHADER_USER_DATA_COMMON_20\0" /* 29415 */
	"SPI_SHADER_USER_DATA_COMMON_21\0" /* 29446 */
	"SPI_SHADER_USER_DATA_COMMON_22\0" /* 29477 */
	"SPI_SHADER_USER_DATA_COMMON_23\0" /* 29508 */
	"SPI_SHADER_USER_DATA_COMMON_24\0" /* 29539 */
	"SPI_SHADER_USER_DATA_COMMON_25\0" /* 29570 */
	"SPI_SHADER_USER_DATA_COMMON_26\0" /* 29601 */
	"SPI_SHADER_USER_DATA_COMMON_27\0" /* 29632 */
	"SPI_SHADER_USER_DATA_COMMON_28\0" /* 29663 */
	"SPI_SHADER_USER_DATA_COMMON_29\0" /* 29694 */
	"SPI_SHADER_USER_DATA_COMMON_30\0" /* 29725 */
	"SPI_SHADER_USER_DATA_COMMON_31\0" /* 29756 */
	"COMPUTE_DISPATCH_PKT_ADDR_LO\0" /* 29787 */
	"COMPUTE_DISPATCH_PKT_ADDR_HI\0" /* 29816 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_LO\0" /* 29845 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_HI\0" /* 29878 */
	"CPF_LATENCY_STATS_DATA\0" /* 29911 */
	"CPG_LATENCY_STATS_DATA\0" /* 29934 */
	"CPC_LATENCY_STATS_DATA\0" /* 29957 */
	"CPF_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 29980 */
	"CPG_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 30014 */
	"CPF_LATENCY_STATS_SELECT\0" /* 30048 */
	"CPG_LATENCY_STATS_SELECT\0" /* 30073 */
	"CPC_LATENCY_STATS_SELECT\0" /* 30098 */
	"DB_HTILE_DATA_BASE_HI\0" /* 30123 */
	"DB_Z_READ_BASE_HI\0" /* 30145 */
	"DB_STENCIL_READ_BASE_HI\0" /* 30163 */
	"DB_Z_WRITE_BASE_HI\0" /* 30187 */
	"DB_STENCIL_WRITE_BASE_HI\0" /* 30206 */
	"DB_DFSM_CONTROL\0" /* 30231 */
	"DB_Z_INFO2\0" /* 30247 */
	"DB_STENCIL_INFO2\0" /* 30258 */
	"PA_SC_TILE_STEERING_OVERRIDE\0" /* 30275 */
	"CP_PERFMON_CNTX_CNTL\0" /* 30304 */
	"PA_SC_RIGHT_VERT_GRID\0" /* 30325 */
	"PA_SC_LEFT_VERT_GRID\0" /* 30347 */
	"PA_SC_HORIZ_GRID\0" /* 30368 */
	"CB_MRT0_EPITCH\0" /* 30385, 30393 */
	"CB_MRT1_EPITCH\0" /* 30400 */
	"CB_MRT2_EPITCH\0" /* 30415 */
	"CB_MRT3_EPITCH\0" /* 30430 */
	"CB_MRT4_EPITCH\0" /* 30445 */
	"CB_MRT5_EPITCH\0" /* 30460 */
	"CB_MRT6_EPITCH\0" /* 30475 */
	"CB_MRT7_EPITCH\0" /* 30490 */
	"PA_CL_OBJPRIM_ID_CNTL\0" /* 30505 */
	"PA_CL_NGG_CNTL\0" /* 30527 */
	"PA_SU_OVER_RASTERIZATION_CNTL\0" /* 30542 */
	"PA_STEREO_CNTL\0" /* 30572 */
	"VGT_GS_MAX_PRIMS_PER_SUBGROUP\0" /* 30587, 30594 */
	"VGT_DRAW_PAYLOAD_CNTL\0" /* 30617 */
	"VGT_DMA_EVENT_INITIATOR\0" /* 30639 */
	"PA_SC_BINNER_CNTL_0\0" /* 30663 */
	"PA_SC_BINNER_CNTL_1\0" /* 30683 */
	"PA_SC_CONSERVATIVE_RASTERIZATION_CNTL\0" /* 30703 */
	"PA_SC_NGG_MODE_CNTL\0" /* 30741 */
	"CB_COLOR0_BASE_EXT\0" /* 30761 */
	"CB_COLOR0_ATTRIB2\0" /* 30780 */
	"CB_COLOR0_CMASK_BASE_EXT\0" /* 30798 */
	"CB_COLOR0_FMASK_BASE_EXT\0" /* 30823 */
	"CB_COLOR0_DCC_BASE_EXT\0" /* 30848 */
	"CB_COLOR1_BASE_EXT\0" /* 30871 */
	"CB_COLOR1_ATTRIB2\0" /* 30890 */
	"CB_COLOR1_CMASK_BASE_EXT\0" /* 30908 */
	"CB_COLOR1_FMASK_BASE_EXT\0" /* 30933 */
	"CB_COLOR1_DCC_BASE_EXT\0" /* 30958 */
	"CB_COLOR2_BASE_EXT\0" /* 30981 */
	"CB_COLOR2_ATTRIB2\0" /* 31000 */
	"CB_COLOR2_CMASK_BASE_EXT\0" /* 31018 */
	"CB_COLOR2_FMASK_BASE_EXT\0" /* 31043 */
	"CB_COLOR2_DCC_BASE_EXT\0" /* 31068 */
	"CB_COLOR3_BASE_EXT\0" /* 31091 */
	"CB_COLOR3_ATTRIB2\0" /* 31110 */
	"CB_COLOR3_CMASK_BASE_EXT\0" /* 31128 */
	"CB_COLOR3_FMASK_BASE_EXT\0" /* 31153 */
	"CB_COLOR3_DCC_BASE_EXT\0" /* 31178 */
	"CB_COLOR4_BASE_EXT\0" /* 31201 */
	"CB_COLOR4_ATTRIB2\0" /* 31220 */
	"CB_COLOR4_CMASK_BASE_EXT\0" /* 31238 */
	"CB_COLOR4_FMASK_BASE_EXT\0" /* 31263 */
	"CB_COLOR4_DCC_BASE_EXT\0" /* 31288 */
	"CB_COLOR5_BASE_EXT\0" /* 31311 */
	"CB_COLOR5_ATTRIB2\0" /* 31330 */
	"CB_COLOR5_CMASK_BASE_EXT\0" /* 31348 */
	"CB_COLOR5_FMASK_BASE_EXT\0" /* 31373 */
	"CB_COLOR5_DCC_BASE_EXT\0" /* 31398 */
	"CB_COLOR6_BASE_EXT\0" /* 31421 */
	"CB_COLOR6_ATTRIB2\0" /* 31440 */
	"CB_COLOR6_CMASK_BASE_EXT\0" /* 31458 */
	"CB_COLOR6_FMASK_BASE_EXT\0" /* 31483 */
	"CB_COLOR6_DCC_BASE_EXT\0" /* 31508 */
	"CB_COLOR7_BASE_EXT\0" /* 31531 */
	"CB_COLOR7_ATTRIB2\0" /* 31550 */
	"CB_COLOR7_CMASK_BASE_EXT\0" /* 31568 */
	"CB_COLOR7_FMASK_BASE_EXT\0" /* 31593 */
	"CB_COLOR7_DCC_BASE_EXT\0" /* 31618 */
	"COUNT_INDIRECT_ENABLE\0" /* 31641 */
	"DRAW_INDEX_ENABLE\0" /* 31663 */
	"PFP\0" /* 31681 */
	"ENGINE_SEL\0" /* 31685 */
	"WR_CONFIRM\0" /* 31696 */
	"WR_ONE_ADDR\0" /* 31707 */
	"MEM_MAPPED_REGISTER\0" /* 31719, 31730 */
	"MEMORY_SYNC\0" /* 31739 */
	"TC_L2\0" /* 31751 */
	"GDS\0" /* 31757 */
	"MEM_ASYNC\0" /* 31761 */
	"DST_SEL\0" /* 31771 */
	"IB_SIZE\0" /* 31779 */
	"CHAIN\0" /* 31787 */
	"VALID\0" /* 31793 */
	"CP_SYNC\0" /* 31799 */
	"SRC_ADDR\0" /* 31807 */
	"SRC_ADDR_TC_L2\0" /* 31816 */
	"SRC_SEL\0" /* 31831 */
	"ENGINE\0" /* 31839 */
	"DST_ADDR\0" /* 31846 */
	"DST_ADDR_TC_L2\0" /* 31855 */
	"BYTE_COUNT_GFX6\0" /* 31870 */
	"BYTE_COUNT_GFX9\0" /* 31886 */
	"DISABLE_WR_CONFIRM_GFX6\0" /* 31902 */
	"NONE\0" /* 31926 */
	"8_IN_16\0" /* 31931 */
	"8_IN_32\0" /* 31939, 31941 */
	"8_IN_64\0" /* 31947 */
	"SRC_SWAP\0" /* 31955 */
	"DST_SWAP\0" /* 31964 */
	"MEMORY\0" /* 31973 */
	"SAS\0" /* 31980 */
	"DAS\0" /* 31984 */
	"INCREMENT\0" /* 31988 */
	"NO_INCREMENT\0" /* 31998 */
	"SAIC\0" /* 32011 */
	"DAIC\0" /* 32016 */
	"RAW_WAIT\0" /* 32021 */
	"DISABLE_WR_CONFIRM_GFX9\0" /* 32030 */
	"DST_CACHE_POLICY\0" /* 32054 */
	"SRC_CACHE_POLICY\0" /* 32071 */
	"SDMA_RQ_PENDING\0" /* 32088 */
	"TST_RQ_PENDING\0" /* 32104 */
	"SDMA1_RQ_PENDING\0" /* 32119 */
	"VCE0_RQ_PENDING\0" /* 32136 */
	"VP8_BUSY\0" /* 32152 */
	"SDMA_BUSY\0" /* 32161, 32162 */
	"SDMA1_BUSY\0" /* 32171 */
	"VCE0_BUSY\0" /* 32182 */
	"XDMA_BUSY\0" /* 32192 */
	"CHUB_BUSY\0" /* 32202 */
	"SDMA2_BUSY\0" /* 32212 */
	"SDMA3_BUSY\0" /* 32223 */
	"SAMSCP_BUSY\0" /* 32234, 32238 */
	"ISP_BUSY\0" /* 32246 */
	"VCE1_BUSY\0" /* 32255 */
	"ODE_BUSY\0" /* 32265 */
	"SDMA2_RQ_PENDING\0" /* 32274 */
	"SDMA3_RQ_PENDING\0" /* 32291 */
	"SAMSCP_RQ_PENDING\0" /* 32308 */
	"ISP_RQ_PENDING\0" /* 32326 */
	"VCE1_RQ_PENDING\0" /* 32341 */
	"UVD_RQ_PENDING\0" /* 32357 */
	"SAMMSP_RQ_PENDING\0" /* 32372 */
	"ACP_RQ_PENDING\0" /* 32390 */
	"SMU_RQ_PENDING\0" /* 32405 */
	"GRBM_RQ_PENDING\0" /* 32420 */
	"HI_RQ_PENDING\0" /* 32436 */
	"VMC_BUSY\0" /* 32450 */
	"MCB_BUSY\0" /* 32459, 32460 */
	"MCB_NON_DISPLAY_BUSY\0" /* 32468 */
	"MCC_BUSY\0" /* 32489 */
	"MCD_BUSY\0" /* 32498 */
	"VMC1_BUSY\0" /* 32507 */
	"SEM_BUSY\0" /* 32517 */
	"ACP_BUSY\0" /* 32526 */
	"IH_BUSY\0" /* 32535 */
	"UVD_BUSY\0" /* 32543 */
	"SAMMSP_BUSY\0" /* 32552 */
	"GCATCL2_BUSY\0" /* 32564 */
	"OSATCL2_BUSY\0" /* 32577 */
	"BIF_BUSY\0" /* 32590 */
	"MCC0_BUSY\0" /* 32599 */
	"MCC1_BUSY\0" /* 32609 */
	"MCC2_BUSY\0" /* 32619 */
	"MCC3_BUSY\0" /* 32629 */
	"MCC4_BUSY\0" /* 32639 */
	"MCC5_BUSY\0" /* 32649 */
	"MCC6_BUSY\0" /* 32659 */
	"MCC7_BUSY\0" /* 32669 */
	"MCD0_BUSY\0" /* 32679 */
	"MCD1_BUSY\0" /* 32689 */
	"MCD2_BUSY\0" /* 32699 */
	"MCD3_BUSY\0" /* 32709 */
	"MCD4_BUSY\0" /* 32719 */
	"MCD5_BUSY\0" /* 32729 */
	"MCD6_BUSY\0" /* 32739 */
	"MCD7_BUSY\0" /* 32749 */
	"IDLE\0" /* 32759 */
	"REG_IDLE\0" /* 32764 */
	"RB_EMPTY\0" /* 32773 */
	"RB_FULL\0" /* 32782 */
	"RB_CMD_IDLE\0" /* 32790 */
	"RB_CMD_FULL\0" /* 32802 */
	"IB_CMD_IDLE\0" /* 32814 */
	"IB_CMD_FULL\0" /* 32826 */
	"BLOCK_IDLE\0" /* 32838 */
	"INSIDE_IB\0" /* 32849 */
	"EX_IDLE\0" /* 32859 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 32867 */
	"PACKET_READY\0" /* 32893 */
	"MC_WR_IDLE\0" /* 32906 */
	"SRBM_IDLE\0" /* 32917 */
	"CONTEXT_EMPTY\0" /* 32927 */
	"DELTA_RPTR_FULL\0" /* 32941 */
	"RB_MC_RREQ_IDLE\0" /* 32957 */
	"IB_MC_RREQ_IDLE\0" /* 32973 */
	"MC_RD_IDLE\0" /* 32989 */
	"DELTA_RPTR_EMPTY\0" /* 33000 */
	"MC_RD_RET_STALL\0" /* 33017 */
	"MC_RD_NO_POLL_IDLE\0" /* 33033 */
	"PREV_CMD_IDLE\0" /* 33052 */
	"SEM_IDLE\0" /* 33066 */
	"SEM_REQ_STALL\0" /* 33075 */
	"SEM_RESP_STATE\0" /* 33089 */
	"INT_IDLE\0" /* 33104 */
	"INT_REQ_STALL\0" /* 33113 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 33127 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 33150 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 33173 */
	"ME1PIPE0_RQ_PENDING\0" /* 33196 */
	"ME1PIPE1_RQ_PENDING\0" /* 33216 */
	"ME1PIPE2_RQ_PENDING\0" /* 33236 */
	"ME1PIPE3_RQ_PENDING\0" /* 33256 */
	"ME2PIPE0_RQ_PENDING\0" /* 33276 */
	"ME2PIPE1_RQ_PENDING\0" /* 33296 */
	"ME2PIPE2_RQ_PENDING\0" /* 33316 */
	"ME2PIPE3_RQ_PENDING\0" /* 33336 */
	"RLC_RQ_PENDING\0" /* 33356 */
	"RLC_BUSY\0" /* 33371 */
	"TC_BUSY\0" /* 33380 */
	"TCC_CC_RESIDENT\0" /* 33388 */
	"CPF_BUSY\0" /* 33404 */
	"CPC_BUSY\0" /* 33413 */
	"CPG_BUSY\0" /* 33422 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 33431 */
	"SRBM_RQ_PENDING\0" /* 33454 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 33470 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 33493 */
	"GDS_DMA_RQ_PENDING\0" /* 33516 */
	"DB_CLEAN\0" /* 33535 */
	"CB_CLEAN\0" /* 33544 */
	"TA_BUSY\0" /* 33553 */
	"GDS_BUSY\0" /* 33561 */
	"WD_BUSY_NO_DMA\0" /* 33570 */
	"VGT_BUSY\0" /* 33585 */
	"IA_BUSY_NO_DMA\0" /* 33594 */
	"IA_BUSY\0" /* 33609 */
	"SX_BUSY\0" /* 33617 */
	"WD_BUSY\0" /* 33625 */
	"SPI_BUSY\0" /* 33633 */
	"BCI_BUSY\0" /* 33642 */
	"SC_BUSY\0" /* 33651 */
	"PA_BUSY\0" /* 33659 */
	"DB_BUSY\0" /* 33667 */
	"CP_COHERENCY_BUSY\0" /* 33675 */
	"GUI_ACTIVE\0" /* 33693 */
	"INSTANCE_INDEX\0" /* 33704 */
	"SH_INDEX\0" /* 33719 */
	"SE_INDEX\0" /* 33728 */
	"SH_BROADCAST_WRITES\0" /* 33737 */
	"INSTANCE_BROADCAST_WRITES\0" /* 33757 */
	"SE_BROADCAST_WRITES\0" /* 33783 */
	"OFFSET_UPDATE_DONE\0" /* 33803, 33817 */
	"DEST_BASE_0_ENA\0" /* 33822 */
	"DEST_BASE_1_ENA\0" /* 33838 */
	"CB0_DEST_BASE_ENA\0" /* 33854 */
	"CB1_DEST_BASE_ENA\0" /* 33872 */
	"CB2_DEST_BASE_ENA\0" /* 33890 */
	"CB3_DEST_BASE_ENA\0" /* 33908 */
	"CB4_DEST_BASE_ENA\0" /* 33926 */
	"CB5_DEST_BASE_ENA\0" /* 33944 */
	"CB6_DEST_BASE_ENA\0" /* 33962 */
	"CB7_DEST_BASE_ENA\0" /* 33980 */
	"DB_DEST_BASE_ENA\0" /* 33998 */
	"DEST_BASE_2_ENA\0" /* 34015 */
	"DEST_BASE_3_ENA\0" /* 34031 */
	"TCL1_ACTION_ENA\0" /* 34047 */
	"TC_ACTION_ENA\0" /* 34063 */
	"CB_ACTION_ENA\0" /* 34077 */
	"DB_ACTION_ENA\0" /* 34091 */
	"SH_KCACHE_ACTION_ENA\0" /* 34105 */
	"SH_ICACHE_ACTION_ENA\0" /* 34126 */
	"COHER_BASE_HI_256B\0" /* 34147 */
	"START_DELAY_COUNT\0" /* 34166 */
	"TC_SD_ACTION_ENA\0" /* 34184 */
	"TC_NC_ACTION_ENA\0" /* 34201 */
	"TCL1_VOL_ACTION_ENA\0" /* 34218 */
	"TC_VOL_ACTION_ENA\0" /* 34238 */
	"TC_WB_ACTION_ENA\0" /* 34256 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 34273 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 34298 */
	"SH_SD_ACTION_ENA\0" /* 34322 */
	"MATCHING_GFX_CNTX\0" /* 34339 */
	"MEID\0" /* 34357 */
	"PHASE1_STATUS\0" /* 34362 */
	"MEC1_BUSY\0" /* 34376 */
	"MEC2_BUSY\0" /* 34386 */
	"DC0_BUSY\0" /* 34396 */
	"DC1_BUSY\0" /* 34405 */
	"RCIU1_BUSY\0" /* 34414 */
	"RCIU2_BUSY\0" /* 34425 */
	"ROQ1_BUSY\0" /* 34436 */
	"ROQ2_BUSY\0" /* 34446 */
	"TCIU_BUSY\0" /* 34456 */
	"SCRATCH_RAM_BUSY\0" /* 34466 */
	"QU_BUSY\0" /* 34483 */
	"ATCL2IU_BUSY\0" /* 34491 */
	"CPG_CPC_BUSY\0" /* 34504 */
	"CPF_CPC_BUSY\0" /* 34517 */
	"MEC1_LOAD_BUSY\0" /* 34530 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 34545 */
	"MEC1_MUTEX_BUSY\0" /* 34565 */
	"MEC1_MESSAGE_BUSY\0" /* 34581 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 34599 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 34619 */
	"MEC1_IB_QUEUE_BUSY\0" /* 34638 */
	"MEC1_TC_BUSY\0" /* 34657 */
	"MEC1_DMA_BUSY\0" /* 34670 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 34684 */
	"MEC1_PIPE0_BUSY\0" /* 34708 */
	"MEC1_PIPE1_BUSY\0" /* 34724 */
	"MEC1_PIPE2_BUSY\0" /* 34740 */
	"MEC1_PIPE3_BUSY\0" /* 34756 */
	"MEC2_LOAD_BUSY\0" /* 34772 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 34787 */
	"MEC2_MUTEX_BUSY\0" /* 34807 */
	"MEC2_MESSAGE_BUSY\0" /* 34823 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 34841 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 34861 */
	"MEC2_IB_QUEUE_BUSY\0" /* 34880 */
	"MEC2_TC_BUSY\0" /* 34899 */
	"MEC2_DMA_BUSY\0" /* 34912 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 34926 */
	"MEC2_PIPE0_BUSY\0" /* 34950 */
	"MEC2_PIPE1_BUSY\0" /* 34966 */
	"MEC2_PIPE2_BUSY\0" /* 34982 */
	"MEC2_PIPE3_BUSY\0" /* 34998 */
	"RCIU_TX_FREE_STALL\0" /* 35014 */
	"RCIU_PRIV_VIOLATION\0" /* 35033 */
	"TCIU_TX_FREE_STALL\0" /* 35053 */
	"MEC1_DECODING_PACKET\0" /* 35072 */
	"MEC1_WAIT_ON_RCIU\0" /* 35093 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 35111 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 35134 */
	"MEC2_DECODING_PACKET\0" /* 35156 */
	"MEC2_WAIT_ON_RCIU\0" /* 35177 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 35195 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 35218 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 35240 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 35264 */
	"ATCL1_WAITING_ON_TRANS\0" /* 35288 */
	"POST_WPTR_GFX_BUSY\0" /* 35311 */
	"CSF_BUSY\0" /* 35330 */
	"ROQ_ALIGN_BUSY\0" /* 35339 */
	"ROQ_RING_BUSY\0" /* 35354 */
	"ROQ_INDIRECT1_BUSY\0" /* 35368 */
	"ROQ_INDIRECT2_BUSY\0" /* 35387 */
	"ROQ_STATE_BUSY\0" /* 35406 */
	"ROQ_CE_RING_BUSY\0" /* 35421 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 35438 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 35460 */
	"SEMAPHORE_BUSY\0" /* 35482 */
	"INTERRUPT_BUSY\0" /* 35497 */
	"HQD_BUSY\0" /* 35512 */
	"PRT_BUSY\0" /* 35521 */
	"CPF_GFX_BUSY\0" /* 35530 */
	"CPF_CMP_BUSY\0" /* 35543 */
	"GRBM_CPF_STAT_BUSY\0" /* 35556 */
	"CPC_CPF_BUSY\0" /* 35575 */
	"REG_BUS_FIFO_BUSY\0" /* 35588 */
	"CSF_RING_BUSY\0" /* 35606 */
	"CSF_INDIRECT1_BUSY\0" /* 35620 */
	"CSF_INDIRECT2_BUSY\0" /* 35639 */
	"CSF_STATE_BUSY\0" /* 35658 */
	"CSF_CE_INDR1_BUSY\0" /* 35673 */
	"CSF_CE_INDR2_BUSY\0" /* 35691 */
	"CSF_ARBITER_BUSY\0" /* 35709 */
	"CSF_INPUT_BUSY\0" /* 35726 */
	"OUTSTANDING_READ_TAGS\0" /* 35741 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 35763 */
	"HQD_DISPATCH_BUSY\0" /* 35787 */
	"HQD_IQ_TIMER_BUSY\0" /* 35805 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 35823 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 35844 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 35868 */
	"HQD_MESSAGE_BUSY\0" /* 35894 */
	"HQD_PQ_FETCHER_BUSY\0" /* 35911 */
	"HQD_IB_FETCHER_BUSY\0" /* 35931 */
	"HQD_IQ_FETCHER_BUSY\0" /* 35951 */
	"HQD_EOP_FETCHER_BUSY\0" /* 35971 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 35992 */
	"HQD_FETCHER_ARB_BUSY\0" /* 36015 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 36036 */
	"HQD_ROQ_EOP_BUSY\0" /* 36055 */
	"HQD_ROQ_IQ_BUSY\0" /* 36072 */
	"HQD_ROQ_PQ_BUSY\0" /* 36088 */
	"HQD_ROQ_IB_BUSY\0" /* 36104 */
	"HQD_WPTR_POLL_BUSY\0" /* 36120 */
	"HQD_PQ_BUSY\0" /* 36139 */
	"HQD_IB_BUSY\0" /* 36151 */
	"RING_FETCHING_DATA\0" /* 36163 */
	"INDR1_FETCHING_DATA\0" /* 36182 */
	"INDR2_FETCHING_DATA\0" /* 36202 */
	"STATE_FETCHING_DATA\0" /* 36222 */
	"TCIU_WAITING_ON_FREE\0" /* 36242 */
	"TCIU_WAITING_ON_TAGS\0" /* 36263 */
	"COHER_SIZE_HI_256B\0" /* 36284 */
	"PRIM_COUNT\0" /* 36303 */
	"VS_NO_EXTRA_BUFFER\0" /* 36314 */
	"STREAMOUT_FULL_FLUSH\0" /* 36333 */
	"ES_LIMIT\0" /* 36354, 36357 */
	"VERT_REUSE\0" /* 36363 */
	"DI_PT_NONE\0" /* 36374 */
	"DI_PT_POINTLIST\0" /* 36385 */
	"DI_PT_LINELIST\0" /* 36401 */
	"DI_PT_LINESTRIP\0" /* 36416 */
	"DI_PT_TRILIST\0" /* 36432 */
	"DI_PT_TRIFAN\0" /* 36446 */
	"DI_PT_TRISTRIP\0" /* 36459 */
	"DI_PT_UNUSED_0\0" /* 36474 */
	"DI_PT_UNUSED_1\0" /* 36489 */
	"DI_PT_PATCH\0" /* 36504 */
	"DI_PT_LINELIST_ADJ\0" /* 36516 */
	"DI_PT_LINESTRIP_ADJ\0" /* 36535 */
	"DI_PT_TRILIST_ADJ\0" /* 36555 */
	"DI_PT_TRISTRIP_ADJ\0" /* 36573 */
	"DI_PT_UNUSED_3\0" /* 36592 */
	"DI_PT_UNUSED_4\0" /* 36607 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 36622 */
	"DI_PT_RECTLIST\0" /* 36644 */
	"DI_PT_LINELOOP\0" /* 36659 */
	"DI_PT_QUADLIST\0" /* 36674 */
	"DI_PT_QUADSTRIP\0" /* 36689 */
	"DI_PT_POLYGON\0" /* 36705 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 36719 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 36746 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 36773 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 36800 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 36827 */
	"DI_PT_2D_LINE_STRIP\0" /* 36851 */
	"DI_PT_2D_TRI_STRIP\0" /* 36871 */
	"DI_INDEX_SIZE_16_BIT\0" /* 36890 */
	"DI_INDEX_SIZE_32_BIT\0" /* 36911 */
	"OFFCHIP_BUFFERING\0" /* 36932 */
	"CLIP_VTX_REORDER_ENA\0" /* 36950 */
	"NUM_CLIP_SEQ\0" /* 36971 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 36984 */
	"VE_NAN_PROC_DISABLE\0" /* 37007 */
	"CURRENT_PTR\0" /* 37027 */
	"CURRENT_COUNT\0" /* 37039 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 37053 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 37078 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 37116 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 37157 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 37180 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 37203 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 37227 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 37257 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 37286 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 37312 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 37341 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 37366 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 37401 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37429 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 37459 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 37486 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 37513 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 37542 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 37571 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 37600 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37628 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 37658 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 37685 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 37713 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 37738 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 37764 */
	"RCIU_STALLED_ON_ME_READ\0" /* 37789 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 37813 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 37838 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 37866 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 37895 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 37921 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 37947 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 37974 */
	"PFP_RCIU_READ_PENDING\0" /* 38000 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 38022 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 38049 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 38071 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 38095 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 38120 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 38143 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 38170 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 38195 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38223 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38248 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 38273 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 38298 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 38327 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 38358 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 38386 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 38413 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 38443 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 38470, 38489 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 38497, 38516 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 38524 */
	"APPEND_ACTIVE_PARTITION\0" /* 38550 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 38574 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 38606 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 38633 */
	"DC_BUSY\0" /* 38659 */
	"PFP_BUSY\0" /* 38667 */
	"MEQ_BUSY\0" /* 38676 */
	"ME_BUSY\0" /* 38685 */
	"QUERY_BUSY\0" /* 38693 */
	"SURFACE_SYNC_BUSY\0" /* 38704 */
	"RCIU_BUSY\0" /* 38722 */
	"CPC_CPG_BUSY\0" /* 38732 */
	"CE_BUSY\0" /* 38745 */
	"X_8K_DWORDS\0" /* 38753 */
	"X_4K_DWORDS\0" /* 38765 */
	"X_2K_DWORDS\0" /* 38777 */
	"X_1K_DWORDS\0" /* 38789 */
	"OFFCHIP_GRANULARITY\0" /* 38801 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 38821 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 38847 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 38870 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 38895 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 38926 */
	"DISABLE_SCISSOR_FIX\0" /* 38960 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 38980 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 39007 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 39035 */
	"INST_INVALIDATE\0" /* 39070, 39075 */
	"DATA_INVALIDATE\0" /* 39086 */
	"INVALIDATE_VOLATILE\0" /* 39102 */
	"RET\0" /* 39122 */
	"RUI\0" /* 39126 */
	"RNG\0" /* 39130 */
	"SQ_EXP_MRT\0" /* 39134 */
	"SQ_EXP_MRTZ\0" /* 39145 */
	"SQ_EXP_NULL\0" /* 39157 */
	"SQ_EXP_POS\0" /* 39169 */
	"SQ_EXP_PARAM\0" /* 39180 */
	"TGT\0" /* 39193 */
	"COMPR\0" /* 39197 */
	"VM\0" /* 39203 */
	"SQ_ENC_EXP_FIELD\0" /* 39206 */
	"ENCODING\0" /* 39223 */
	"ADDRESS\0" /* 39232 */
	"BASE_ADDRESS_HI\0" /* 39240, 39245 */
	"CACHE_SWIZZLE\0" /* 39256 */
	"SWIZZLE_ENABLE\0" /* 39270 */
	"SQ_SEL_0\0" /* 39285 */
	"SQ_SEL_1\0" /* 39294 */
	"SQ_SEL_RESERVED_0\0" /* 39303, 39310 */
	"SQ_SEL_RESERVED_1\0" /* 39321, 39328 */
	"SQ_SEL_X\0" /* 39339 */
	"SQ_SEL_Y\0" /* 39348 */
	"SQ_SEL_Z\0" /* 39357 */
	"SQ_SEL_W\0" /* 39366 */
	"DST_SEL_X\0" /* 39375 */
	"DST_SEL_Y\0" /* 39385 */
	"DST_SEL_Z\0" /* 39395 */
	"DST_SEL_W\0" /* 39405 */
	"BUF_NUM_FORMAT_UNORM\0" /* 39415 */
	"BUF_NUM_FORMAT_SNORM\0" /* 39436 */
	"BUF_NUM_FORMAT_USCALED\0" /* 39457 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 39480 */
	"BUF_NUM_FORMAT_UINT\0" /* 39503 */
	"BUF_NUM_FORMAT_SINT\0" /* 39523 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 39543 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 39568 */
	"NUM_FORMAT\0" /* 39589 */
	"BUF_DATA_FORMAT_INVALID\0" /* 39600 */
	"BUF_DATA_FORMAT_8\0" /* 39624 */
	"BUF_DATA_FORMAT_16\0" /* 39642 */
	"BUF_DATA_FORMAT_8_8\0" /* 39661 */
	"BUF_DATA_FORMAT_32\0" /* 39681 */
	"BUF_DATA_FORMAT_16_16\0" /* 39700 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 39722 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 39747 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 39772 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 39799 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 39826 */
	"BUF_DATA_FORMAT_32_32\0" /* 39850 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 39872 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 39900 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 39925 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 39953 */
	"DATA_FORMAT\0" /* 39981 */
	"ELEMENT_SIZE\0" /* 39993 */
	"INDEX_STRIDE\0" /* 40006 */
	"ADD_TID_ENABLE\0" /* 40019 */
	"ATC\0" /* 40034 */
	"HASH_ENABLE\0" /* 40038 */
	"HEAP\0" /* 40050 */
	"MTYPE\0" /* 40055 */
	"SQ_RSRC_BUF\0" /* 40061 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 40073 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 40092 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 40111 */
	"MIN_LOD\0" /* 40130 */
	"IMG_DATA_FORMAT_INVALID\0" /* 40138 */
	"IMG_DATA_FORMAT_8\0" /* 40162 */
	"IMG_DATA_FORMAT_16\0" /* 40180 */
	"IMG_DATA_FORMAT_8_8\0" /* 40199 */
	"IMG_DATA_FORMAT_32\0" /* 40219 */
	"IMG_DATA_FORMAT_16_16\0" /* 40238 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 40260 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 40285 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 40310 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 40337 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 40364 */
	"IMG_DATA_FORMAT_32_32\0" /* 40388 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 40410 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 40438 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 40463 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 40491 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 40519 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 40541 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 40565 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 40589 */
	"IMG_DATA_FORMAT_8_24\0" /* 40613 */
	"IMG_DATA_FORMAT_24_8\0" /* 40634 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 40655 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 40680 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 40709 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 40734 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 40760 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 40783 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 40807 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 40834 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 40862 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 40890 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 40918 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 40940 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 40962 */
	"IMG_DATA_FORMAT_BC1\0" /* 40986 */
	"IMG_DATA_FORMAT_BC2\0" /* 41006 */
	"IMG_DATA_FORMAT_BC3\0" /* 41026 */
	"IMG_DATA_FORMAT_BC4\0" /* 41046 */
	"IMG_DATA_FORMAT_BC5\0" /* 41066 */
	"IMG_DATA_FORMAT_BC6\0" /* 41086 */
	"IMG_DATA_FORMAT_BC7\0" /* 41106 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX6\0" /* 41126 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX6\0" /* 41165 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 41204 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 41233 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 41262 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 41291 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 41320 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 41349 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 41378 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 41409 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 41439 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 41470 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 41500 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 41530 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 41561 */
	"IMG_DATA_FORMAT_4_4\0" /* 41592 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 41612 */
	"IMG_DATA_FORMAT_1\0" /* 41634 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 41652 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 41679 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 41703 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 41729 */
	"DATA_FORMAT_GFX6\0" /* 41763 */
	"IMG_NUM_FORMAT_UNORM\0" /* 41780 */
	"IMG_NUM_FORMAT_SNORM\0" /* 41801 */
	"IMG_NUM_FORMAT_USCALED\0" /* 41822 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 41845 */
	"IMG_NUM_FORMAT_UINT\0" /* 41868 */
	"IMG_NUM_FORMAT_SINT\0" /* 41888 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 41908 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 41933 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 41954 */
	"IMG_NUM_FORMAT_SRGB\0" /* 41980 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 42000 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 42022 */
	"IMG_NUM_FORMAT_UBINT\0" /* 42048 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 42069 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 42093 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 42120 */
	"NUM_FORMAT_GFX6\0" /* 42147 */
	"WIDTH\0" /* 42163 */
	"HEIGHT\0" /* 42169 */
	"PERF_MOD\0" /* 42176 */
	"INTERLACED\0" /* 42185 */
	"BASE_LEVEL\0" /* 42196 */
	"LAST_LEVEL\0" /* 42207 */
	"TILING_INDEX\0" /* 42218 */
	"POW2_PAD\0" /* 42231 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 42240 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 42259 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 42278 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 42297 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 42316 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 42335 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 42354 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 42373 */
	"SQ_RSRC_IMG_1D\0" /* 42392, 42404 */
	"SQ_RSRC_IMG_2D\0" /* 42407, 42419 */
	"SQ_RSRC_IMG_3D\0" /* 42422, 42434 */
	"SQ_RSRC_IMG_CUBE\0" /* 42437 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 42454 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 42475 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 42496 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 42516 */
	"PITCH_GFX6\0" /* 42542 */
	"BASE_ARRAY\0" /* 42553 */
	"LAST_ARRAY\0" /* 42564 */
	"MIN_LOD_WARN\0" /* 42575 */
	"COUNTER_BANK_ID\0" /* 42588 */
	"LOD_HDW_CNT_EN\0" /* 42604 */
	"COMPRESSION_EN\0" /* 42619 */
	"ALPHA_IS_ON_MSB\0" /* 42634 */
	"COLOR_TRANSFORM\0" /* 42650 */
	"LOST_ALPHA_BITS\0" /* 42666 */
	"LOST_COLOR_BITS\0" /* 42682 */
	"SQ_TEX_WRAP\0" /* 42698 */
	"SQ_TEX_MIRROR\0" /* 42710 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 42724 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 42748 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 42778 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 42803 */
	"SQ_TEX_CLAMP_BORDER\0" /* 42834 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 42854 */
	"CLAMP_X\0" /* 42880 */
	"CLAMP_Y\0" /* 42888 */
	"CLAMP_Z\0" /* 42896 */
	"MAX_ANISO_RATIO\0" /* 42904 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 42920 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 42947 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 42973 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 43000 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 43031 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 43060 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 43090 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 43124, 43145 */
	"DEPTH_COMPARE_FUNC\0" /* 43152 */
	"FORCE_UNNORMALIZED\0" /* 43171 */
	"ANISO_THRESHOLD\0" /* 43190 */
	"MC_COORD_TRUNC\0" /* 43206 */
	"FORCE_DEGAMMA\0" /* 43221 */
	"ANISO_BIAS\0" /* 43235 */
	"TRUNC_COORD\0" /* 43246 */
	"DISABLE_CUBE_WRAP\0" /* 43258 */
	"FILTER_MODE\0" /* 43276 */
	"COMPAT_MODE\0" /* 43288 */
	"MAX_LOD\0" /* 43300 */
	"PERF_MIP\0" /* 43308 */
	"PERF_Z\0" /* 43317 */
	"LOD_BIAS\0" /* 43324 */
	"LOD_BIAS_SEC\0" /* 43333 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 43346, 43360 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 43369, 43388 */
	"XY_MAG_FILTER\0" /* 43395 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 43409 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 43438 */
	"XY_MIN_FILTER\0" /* 43470 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 43484 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 43505 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 43527 */
	"Z_FILTER\0" /* 43550 */
	"MIP_FILTER\0" /* 43559 */
	"MIP_POINT_PRECLAMP\0" /* 43570 */
	"DISABLE_LSB_CEIL\0" /* 43589 */
	"FILTER_PREC_FIX\0" /* 43606 */
	"ANISO_OVERRIDE\0" /* 43622 */
	"BORDER_COLOR_PTR\0" /* 43637 */
	"UPGRADED_DEPTH\0" /* 43654 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 43669 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 43701 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 43734 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 43767 */
	"BORDER_COLOR_TYPE\0" /* 43796 */
	"VS_LOW_THRESHOLD\0" /* 43814 */
	"GS_LOW_THRESHOLD\0" /* 43831 */
	"ES_LOW_THRESHOLD\0" /* 43848 */
	"HS_LOW_THRESHOLD\0" /* 43865 */
	"LS_LOW_THRESHOLD\0" /* 43882 */
	"PS_CU_EN\0" /* 43899, 43902 */
	"VS_CU_EN\0" /* 43908 */
	"GS_CU_EN\0" /* 43917 */
	"ES_CU_EN\0" /* 43926 */
	"LSHS_CU_EN\0" /* 43935 */
	"X_R0\0" /* 43946 */
	"RING_ORDER_TS0\0" /* 43951 */
	"RING_ORDER_TS1\0" /* 43966 */
	"RING_ORDER_TS2\0" /* 43981 */
	"PIPE_ORDER_TS0\0" /* 43996 */
	"PIPE_ORDER_TS1\0" /* 44011 */
	"PIPE_ORDER_TS2\0" /* 44026 */
	"PIPE_ORDER_TS3\0" /* 44041 */
	"TS0_DUR_MULT\0" /* 44056 */
	"TS1_DUR_MULT\0" /* 44069 */
	"TS2_DUR_MULT\0" /* 44082 */
	"TS3_DUR_MULT\0" /* 44095 */
	"TS0_DURATION\0" /* 44108 */
	"TS1_DURATION\0" /* 44121 */
	"TS2_DURATION\0" /* 44134 */
	"GPR_WRITE_PRIORITY\0" /* 44147 */
	"EXP_PRIORITY_ORDER\0" /* 44166 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 44185 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 44207 */
	"RSRC_MGMT_RESET\0" /* 44229 */
	"X_DELAY_14_CLKS\0" /* 44245 */
	"X_DELAY_16_CLKS\0" /* 44261 */
	"X_DELAY_18_CLKS\0" /* 44277 */
	"X_DELAY_20_CLKS\0" /* 44293 */
	"X_DELAY_22_CLKS\0" /* 44309 */
	"X_DELAY_24_CLKS\0" /* 44325 */
	"X_DELAY_26_CLKS\0" /* 44341 */
	"X_DELAY_28_CLKS\0" /* 44357 */
	"X_DELAY_30_CLKS\0" /* 44373 */
	"X_DELAY_32_CLKS\0" /* 44389 */
	"X_DELAY_34_CLKS\0" /* 44405 */
	"X_DELAY_4_CLKS\0" /* 44421 */
	"X_DELAY_6_CLKS\0" /* 44436 */
	"X_DELAY_8_CLKS\0" /* 44451 */
	"X_DELAY_10_CLKS\0" /* 44466 */
	"X_DELAY_12_CLKS\0" /* 44482 */
	"VTX_DONE_DELAY\0" /* 44498 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 44513 */
	"PC_LIMIT_ENABLE\0" /* 44537 */
	"PC_LIMIT_STRICT\0" /* 44553 */
	"PC_LIMIT_SIZE\0" /* 44569 */
	"TYPE_A\0" /* 44583 */
	"VGPR_A\0" /* 44590 */
	"SGPR_A\0" /* 44597 */
	"LDS_A\0" /* 44604 */
	"WAVES_A\0" /* 44610 */
	"EN_A\0" /* 44618 */
	"TYPE_B\0" /* 44623 */
	"VGPR_B\0" /* 44630 */
	"SGPR_B\0" /* 44637 */
	"LDS_B\0" /* 44644 */
	"WAVES_B\0" /* 44650 */
	"EN_B\0" /* 44658 */
	"MSAA1_X\0" /* 44663 */
	"MSAA1_Y\0" /* 44671 */
	"MSAA2_X\0" /* 44679 */
	"MSAA2_Y\0" /* 44687 */
	"MSAA4_X\0" /* 44695 */
	"MSAA4_Y\0" /* 44703 */
	"MSAA8_X\0" /* 44711 */
	"MSAA8_Y\0" /* 44719 */
	"MSAA16_X\0" /* 44727 */
	"MSAA16_Y\0" /* 44736 */
	"NUM_PIPES\0" /* 44745 */
	"PIPE_INTERLEAVE_SIZE_GFX6\0" /* 44755 */
	"BANK_INTERLEAVE_SIZE\0" /* 44781 */
	"NUM_SHADER_ENGINES_GFX6\0" /* 44802 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 44826 */
	"NUM_GPUS_GFX6\0" /* 44850 */
	"MULTI_GPU_TILE_SIZE\0" /* 44864 */
	"ROW_SIZE\0" /* 44884 */
	"NUM_LOWER_PIPES\0" /* 44893 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 44909 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 44940 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 44968 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 44997 */
	"MICRO_TILE_MODE\0" /* 45026 */
	"ARRAY_LINEAR_GENERAL\0" /* 45042, 45048 */
	"ARRAY_LINEAR_ALIGNED\0" /* 45063 */
	"ARRAY_1D_TILED_THIN1\0" /* 45084 */
	"ARRAY_1D_TILED_THICK\0" /* 45105 */
	"ARRAY_2D_TILED_THIN1\0" /* 45126 */
	"ARRAY_2D_TILED_THICK\0" /* 45147 */
	"ARRAY_2D_TILED_XTHICK\0" /* 45168 */
	"ARRAY_3D_TILED_THIN1\0" /* 45190 */
	"ARRAY_3D_TILED_THICK\0" /* 45211 */
	"ARRAY_3D_TILED_XTHICK\0" /* 45232 */
	"ARRAY_POWER_SAVE\0" /* 45254 */
	"ARRAY_MODE\0" /* 45271 */
	"ADDR_SURF_P2\0" /* 45282 */
	"ADDR_SURF_P2_RESERVED0\0" /* 45295 */
	"ADDR_SURF_P2_RESERVED1\0" /* 45318 */
	"ADDR_SURF_P2_RESERVED2\0" /* 45341, 45354 */
	"X_ADDR_SURF_P4_8X16\0" /* 45364 */
	"X_ADDR_SURF_P4_16X16\0" /* 45384 */
	"X_ADDR_SURF_P4_16X32\0" /* 45405 */
	"X_ADDR_SURF_P4_32X32\0" /* 45426 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 45447 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 45473 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 45499 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 45525 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 45552 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 45579 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 45606 */
	"PIPE_CONFIG\0" /* 45633 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 45645 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 45670 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 45696 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 45722 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 45748 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 45773 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 45798 */
	"TILE_SPLIT\0" /* 45823 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 45834 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 45857 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 45880 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 45903 */
	"BANK_WIDTH\0" /* 45926 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 45937 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 45961 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 45985 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 46009 */
	"BANK_HEIGHT\0" /* 46033 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 46045 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 46070 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 46095 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 46120 */
	"MACRO_TILE_ASPECT\0" /* 46145 */
	"ADDR_SURF_2_BANK\0" /* 46163 */
	"ADDR_SURF_4_BANK\0" /* 46180 */
	"ADDR_SURF_8_BANK\0" /* 46197 */
	"ADDR_SURF_16_BANK\0" /* 46214 */
	"NUM_BANKS\0" /* 46232 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 46242 */
	"MICRO_TILE_MODE_NEW\0" /* 46273 */
	"SAMPLE_SPLIT\0" /* 46293 */
	"MEM_BASE\0" /* 46306 */
	"WAVE_LIMIT\0" /* 46315 */
	"LOCK_LOW_THRESHOLD\0" /* 46326 */
	"VGPRS\0" /* 46345 */
	"SGPRS\0" /* 46351 */
	"FP_32_DENORMS\0" /* 46357 */
	"FP_64_DENORMS\0" /* 46371 */
	"FP_ALL_DENORMS\0" /* 46385 */
	"FLOAT_MODE\0" /* 46400 */
	"PRIV\0" /* 46411 */
	"DX10_CLAMP\0" /* 46416 */
	"DEBUG_MODE\0" /* 46427 */
	"IEEE_MODE\0" /* 46438 */
	"CU_GROUP_DISABLE\0" /* 46448 */
	"CACHE_CTL\0" /* 46465 */
	"CDBG_USER\0" /* 46475 */
	"SCRATCH_EN\0" /* 46485 */
	"USER_SGPR\0" /* 46496 */
	"TRAP_PRESENT\0" /* 46506 */
	"WAVE_CNT_EN\0" /* 46519 */
	"EXTRA_LDS_SIZE\0" /* 46531, 46537 */
	"EXCP_EN_SI\0" /* 46546 */
	"EXCP_EN\0" /* 46557 */
	"VGPR_COMP_CNT\0" /* 46565 */
	"CU_GROUP_ENABLE\0" /* 46579 */
	"OC_LDS_EN\0" /* 46595 */
	"SO_BASE0_EN\0" /* 46605 */
	"SO_BASE1_EN\0" /* 46617 */
	"SO_BASE2_EN\0" /* 46629 */
	"SO_BASE3_EN\0" /* 46641 */
	"SO_EN\0" /* 46653 */
	"DISPATCH_DRAW_EN\0" /* 46659 */
	"GROUP_FIFO_DEPTH\0" /* 46676 */
	"TG_SIZE_EN\0" /* 46693 */
	"EXCP_EN_CIK_VI\0" /* 46704 */
	"COMPUTE_SHADER_EN\0" /* 46719 */
	"PARTIAL_TG_EN\0" /* 46737 */
	"FORCE_START_AT_000\0" /* 46751 */
	"ORDERED_APPEND_ENBL\0" /* 46770 */
	"ORDERED_APPEND_MODE\0" /* 46790 */
	"USE_THREAD_DIMENSIONS\0" /* 46810 */
	"ORDER_MODE\0" /* 46832 */
	"DISPATCH_CACHE_CNTL\0" /* 46843 */
	"SCALAR_L1_INV_VOL\0" /* 46863, 46877 */
	"VECTOR_L1_INV_VOL\0" /* 46881 */
	"DATA_ATC\0" /* 46899 */
	"RESTORE\0" /* 46908 */
	"NUM_THREAD_FULL\0" /* 46916 */
	"NUM_THREAD_PARTIAL\0" /* 46932 */
	"INST_ATC\0" /* 46951 */
	"BULKY\0" /* 46960 */
	"TGID_X_EN\0" /* 46966 */
	"TGID_Y_EN\0" /* 46976 */
	"TGID_Z_EN\0" /* 46986 */
	"TIDIG_COMP_CNT\0" /* 46996 */
	"EXCP_EN_MSB\0" /* 47011 */
	"WAVES_PER_SH_SI\0" /* 47023 */
	"WAVES_PER_SH\0" /* 47039 */
	"TG_PER_CU\0" /* 47052 */
	"LOCK_THRESHOLD\0" /* 47062 */
	"SIMD_DEST_CNTL\0" /* 47077 */
	"FORCE_SIMD_DIST\0" /* 47092 */
	"CU_GROUP_COUNT\0" /* 47108 */
	"SH0_CU_EN\0" /* 47123 */
	"SH1_CU_EN\0" /* 47133 */
	"WAVES\0" /* 47143 */
	"WAVESIZE\0" /* 47149 */
	"SEND_SEID\0" /* 47158 */
	"RESERVED3\0" /* 47168 */
	"RESERVED4\0" /* 47178 */
	"WAVE_ID_BASE\0" /* 47188 */
	"PAYLOAD\0" /* 47201 */
	"IS_EVENT\0" /* 47209 */
	"IS_STATE\0" /* 47218 */
	"PERF_SEL\0" /* 47227 */
	"PERF_SEL1\0" /* 47236 */
	"CNTR_MODE\0" /* 47246 */
	"PERF_SEL2\0" /* 47256 */
	"PERF_SEL3\0" /* 47266 */
	"DISABLE_AND_RESET\0" /* 47276 */
	"START_COUNTING\0" /* 47294 */
	"STOP_COUNTING\0" /* 47309 */
	"PERFMON_STATE\0" /* 47323 */
	"SPM_PERFMON_STATE\0" /* 47337 */
	"PERFMON_ENABLE_MODE\0" /* 47355 */
	"PERFMON_SAMPLE_ENABLE\0" /* 47375 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 47397 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 47424 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 47451 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 47478 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 47504 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 47530 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 47557 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 47583 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 47609 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 47637 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 47663 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 47689 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 47715 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 47741 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 47768 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 47795 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 47822 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 47848 */
	"PERF_MODE\0" /* 47874 */
	"PERF_MODE1\0" /* 47884 */
	"PERF_MODE3\0" /* 47895 */
	"PERF_MODE2\0" /* 47906 */
	"PERF_SEID_IGNORE_MASK\0" /* 47917 */
	"BIN0_MIN\0" /* 47939 */
	"BIN0_MAX\0" /* 47948 */
	"BIN1_MIN\0" /* 47957 */
	"BIN1_MAX\0" /* 47966 */
	"BIN2_MIN\0" /* 47975 */
	"BIN2_MAX\0" /* 47984 */
	"BIN3_MIN\0" /* 47993 */
	"BIN3_MAX\0" /* 48002 */
	"SQC_BANK_MASK\0" /* 48011 */
	"SQC_CLIENT_MASK\0" /* 48025 */
	"SPM_MODE\0" /* 48041 */
	"SIMD_MASK\0" /* 48050 */
	"PS_EN\0" /* 48060 */
	"VS_EN\0" /* 48066 */
	"GS_EN\0" /* 48072 */
	"HS_EN\0" /* 48078 */
	"LS_EN\0" /* 48084 */
	"CS_EN\0" /* 48090 */
	"CNTR_RATE\0" /* 48096 */
	"DISABLE_FLUSH\0" /* 48106 */
	"SH0_MASK\0" /* 48120 */
	"SH1_MASK\0" /* 48129 */
	"FORCE_EN\0" /* 48138 */
	"PERFCOUNTER_SELECT1\0" /* 48147 */
	"PERFCOUNTER_SELECT2\0" /* 48167 */
	"PERFCOUNTER_SELECT3\0" /* 48187 */
	"OP_FILTER_ENABLE\0" /* 48207 */
	"OP_FILTER_SEL\0" /* 48224 */
	"FORMAT_FILTER_ENABLE\0" /* 48238 */
	"FORMAT_FILTER_SEL\0" /* 48259 */
	"CLEAR_FILTER_ENABLE\0" /* 48277 */
	"CLEAR_FILTER_SEL\0" /* 48297 */
	"MRT_FILTER_ENABLE\0" /* 48314 */
	"MRT_FILTER_SEL\0" /* 48332 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 48347 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 48373 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 48396 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 48424 */
	"DEPTH_CLEAR_ENABLE\0" /* 48449 */
	"STENCIL_CLEAR_ENABLE\0" /* 48468 */
	"DEPTH_COPY\0" /* 48489 */
	"STENCIL_COPY\0" /* 48500 */
	"RESUMMARIZE_ENABLE\0" /* 48513 */
	"STENCIL_COMPRESS_DISABLE\0" /* 48532 */
	"DEPTH_COMPRESS_DISABLE\0" /* 48557 */
	"COPY_CENTROID\0" /* 48580 */
	"COPY_SAMPLE\0" /* 48594 */
	"DECOMPRESS_ENABLE\0" /* 48606 */
	"ZPASS_INCREMENT_DISABLE\0" /* 48624 */
	"PERFECT_ZPASS_COUNTS\0" /* 48648 */
	"SAMPLE_RATE\0" /* 48669 */
	"ZPASS_ENABLE\0" /* 48681 */
	"ZFAIL_ENABLE\0" /* 48694 */
	"SFAIL_ENABLE\0" /* 48707 */
	"DBFAIL_ENABLE\0" /* 48720 */
	"SLICE_EVEN_ENABLE\0" /* 48734 */
	"SLICE_ODD_ENABLE\0" /* 48752 */
	"SLICE_START\0" /* 48769 */
	"SLICE_MAX\0" /* 48781 */
	"Z_READ_ONLY\0" /* 48791 */
	"STENCIL_READ_ONLY\0" /* 48803 */
	"FORCE_OFF\0" /* 48821 */
	"FORCE_ENABLE\0" /* 48831 */
	"FORCE_DISABLE\0" /* 48844 */
	"FORCE_RESERVED\0" /* 48858 */
	"FORCE_HIZ_ENABLE\0" /* 48873, 48881 */
	"FORCE_HIS_ENABLE0\0" /* 48890, 48900 */
	"FORCE_HIS_ENABLE1\0" /* 48908, 48918 */
	"FORCE_SHADER_Z_ORDER\0" /* 48926, 48939 */
	"FAST_Z_DISABLE\0" /* 48947 */
	"FAST_STENCIL_DISABLE\0" /* 48962 */
	"NOOP_CULL_DISABLE\0" /* 48983 */
	"FORCE_COLOR_KILL\0" /* 49001 */
	"FORCE_Z_READ\0" /* 49018 */
	"FORCE_STENCIL_READ\0" /* 49031 */
	"FORCE_FULL_Z_RANGE\0" /* 49050 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 49069 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 49093 */
	"IGNORE_SC_ZRANGE\0" /* 49116 */
	"DISABLE_FULLY_COVERED\0" /* 49133 */
	"FORCE_SUMM_OFF\0" /* 49155 */
	"FORCE_SUMM_MINZ\0" /* 49170 */
	"FORCE_SUMM_MAXZ\0" /* 49186 */
	"FORCE_SUMM_BOTH\0" /* 49202 */
	"FORCE_Z_LIMIT_SUMM\0" /* 49218 */
	"MAX_TILES_IN_DTT\0" /* 49237 */
	"DISABLE_TILE_RATE_TILES\0" /* 49254 */
	"FORCE_Z_DIRTY\0" /* 49278, 49286 */
	"FORCE_STENCIL_DIRTY\0" /* 49292 */
	"FORCE_Z_VALID\0" /* 49312 */
	"FORCE_STENCIL_VALID\0" /* 49326 */
	"PRESERVE_COMPRESSION\0" /* 49346, 49355 */
	"PSLC_AUTO\0" /* 49367 */
	"PSLC_ON_HANG_ONLY\0" /* 49377 */
	"PSLC_ASAP\0" /* 49395 */
	"PSLC_COUNTDOWN\0" /* 49405 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 49420 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 49449 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 49480 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 49516 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 49551 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 49579 */
	"DISABLE_REG_SNOOP\0" /* 49601 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 49619 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 49651 */
	"HIZ_ZFUNC\0" /* 49677, 49681 */
	"HIS_SFUNC_FF\0" /* 49687 */
	"HIS_SFUNC_BF\0" /* 49700 */
	"PRESERVE_ZRANGE\0" /* 49713 */
	"PRESERVE_SRESULTS\0" /* 49729 */
	"DISABLE_FAST_PASS\0" /* 49747 */
	"TL_X\0" /* 49765 */
	"TL_Y\0" /* 49770 */
	"BR_X\0" /* 49775 */
	"BR_Y\0" /* 49780 */
	"ADDR5_SWIZZLE_MASK\0" /* 49785 */
	"ARRAY_PRT_TILED_THIN1\0" /* 49804 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 49826 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 49851 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 49878 */
	"Z_INVALID\0" /* 49906 */
	"Z_16\0" /* 49916 */
	"Z_24\0" /* 49921 */
	"Z_32_FLOAT\0" /* 49926 */
	"NUM_SAMPLES\0" /* 49937 */
	"TILE_MODE_INDEX\0" /* 49949 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 49965 */
	"ALLOW_EXPCLEAR\0" /* 49989 */
	"READ_SIZE\0" /* 50004 */
	"TILE_SURFACE_ENABLE\0" /* 50014 */
	"CLEAR_DISALLOWED\0" /* 50034 */
	"ZRANGE_PRECISION\0" /* 50051 */
	"STENCIL_INVALID\0" /* 50068 */
	"STENCIL_8\0" /* 50084 */
	"TILE_STENCIL_DISABLE\0" /* 50094 */
	"PITCH_TILE_MAX\0" /* 50115, 50121 */
	"HEIGHT_TILE_MAX\0" /* 50130 */
	"SLICE_TILE_MAX\0" /* 50146 */
	"WINDOW_X_OFFSET\0" /* 50161 */
	"WINDOW_Y_OFFSET\0" /* 50177, 50184 */
	"WINDOW_OFFSET_DISABLE\0" /* 50193 */
	"IN_20\0" /* 50215 */
	"IN_21\0" /* 50221 */
	"IN_210\0" /* 50227 */
	"IN_30\0" /* 50234 */
	"IN_31\0" /* 50240 */
	"IN_310\0" /* 50246 */
	"IN_320\0" /* 50253 */
	"IN_321\0" /* 50260 */
	"IN_3210\0" /* 50267 */
	"CLIP_RULE\0" /* 50275 */
	"ER_TRI\0" /* 50285 */
	"ER_RECT\0" /* 50292 */
	"ER_LINE_LR\0" /* 50300 */
	"ER_LINE_RL\0" /* 50311 */
	"ER_LINE_TB\0" /* 50322 */
	"ER_LINE_BT\0" /* 50333 */
	"HW_SCREEN_OFFSET_X\0" /* 50344 */
	"HW_SCREEN_OFFSET_Y\0" /* 50363 */
	"TARGET0_ENABLE\0" /* 50382 */
	"TARGET1_ENABLE\0" /* 50397 */
	"TARGET2_ENABLE\0" /* 50412 */
	"TARGET3_ENABLE\0" /* 50427 */
	"TARGET4_ENABLE\0" /* 50442 */
	"TARGET5_ENABLE\0" /* 50457 */
	"TARGET6_ENABLE\0" /* 50472 */
	"TARGET7_ENABLE\0" /* 50487 */
	"OUTPUT0_ENABLE\0" /* 50502 */
	"OUTPUT1_ENABLE\0" /* 50517 */
	"OUTPUT2_ENABLE\0" /* 50532 */
	"OUTPUT3_ENABLE\0" /* 50547 */
	"OUTPUT4_ENABLE\0" /* 50562 */
	"OUTPUT5_ENABLE\0" /* 50577 */
	"OUTPUT6_ENABLE\0" /* 50592 */
	"OUTPUT7_ENABLE\0" /* 50607 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 50622 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 50645 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 50668 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 50691 */
	"RB_MAP_PKR0\0" /* 50714 */
	"RB_MAP_PKR1\0" /* 50726 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 50738 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 50763 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 50788 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 50813 */
	"RB_XSEL2\0" /* 50838 */
	"RB_XSEL\0" /* 50847 */
	"RB_YSEL\0" /* 50855 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 50863 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 50887 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 50911 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 50935 */
	"PKR_MAP\0" /* 50959 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 50967 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 50992 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 51017 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 51042 */
	"PKR_XSEL\0" /* 51067 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 51076 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 51101 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 51126 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 51151 */
	"PKR_YSEL\0" /* 51176 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 51185 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 51211 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 51237 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 51263 */
	"PKR_XSEL2\0" /* 51289 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 51299 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 51322 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 51345 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 51368 */
	"SC_MAP\0" /* 51391 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 51398 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 51432 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 51467 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 51502 */
	"SC_XSEL\0" /* 51537 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 51545 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 51579 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 51614 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 51649 */
	"SC_YSEL\0" /* 51684 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 51692 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 51715 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 51738 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 51761 */
	"SE_MAP\0" /* 51784 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 51791 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 51825 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 51860 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 51895 */
	"SE_XSEL_GFX6\0" /* 51930 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 51943 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 51977 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 52012 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 52047 */
	"SE_YSEL_GFX6\0" /* 52082 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 52095 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 52123 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 52151 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 52179 */
	"SE_PAIR_MAP\0" /* 52207 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 52219 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 52258 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 52298 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 52338 */
	"SE_PAIR_XSEL_GFX6\0" /* 52378 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 52396 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 52435 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 52475 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 52515 */
	"SE_PAIR_YSEL_GFX6\0" /* 52555 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 52573 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 52600 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 52639 */
	"STENCIL_KEEP\0" /* 52668 */
	"STENCIL_ZERO\0" /* 52681 */
	"STENCIL_ONES\0" /* 52694 */
	"STENCIL_REPLACE_TEST\0" /* 52707 */
	"STENCIL_REPLACE_OP\0" /* 52728 */
	"STENCIL_ADD_CLAMP\0" /* 52747 */
	"STENCIL_SUB_CLAMP\0" /* 52765 */
	"STENCIL_INVERT\0" /* 52783 */
	"STENCIL_ADD_WRAP\0" /* 52798 */
	"STENCIL_SUB_WRAP\0" /* 52815 */
	"STENCIL_AND\0" /* 52832 */
	"STENCIL_OR\0" /* 52844 */
	"STENCIL_XOR\0" /* 52855 */
	"STENCIL_NAND\0" /* 52867 */
	"STENCIL_NOR\0" /* 52880 */
	"STENCIL_XNOR\0" /* 52892 */
	"STENCILFAIL\0" /* 52905 */
	"STENCILZPASS\0" /* 52917 */
	"STENCILZFAIL\0" /* 52930 */
	"STENCILFAIL_BF\0" /* 52943 */
	"STENCILZPASS_BF\0" /* 52958 */
	"STENCILZFAIL_BF\0" /* 52974 */
	"STENCILTESTVAL\0" /* 52990 */
	"STENCILMASK\0" /* 53005 */
	"STENCILWRITEMASK\0" /* 53017 */
	"STENCILOPVAL\0" /* 53034 */
	"STENCILTESTVAL_BF\0" /* 53047 */
	"STENCILMASK_BF\0" /* 53065 */
	"STENCILWRITEMASK_BF\0" /* 53080 */
	"STENCILOPVAL_BF\0" /* 53100 */
	"X_0_0F\0" /* 53116 */
	"DEFAULT_VAL\0" /* 53123 */
	"FLAT_SHADE\0" /* 53135 */
	"CYL_WRAP\0" /* 53146 */
	"PT_SPRITE_TEX\0" /* 53155 */
	"DUP\0" /* 53169 */
	"FP16_INTERP_MODE\0" /* 53173 */
	"USE_DEFAULT_ATTR1\0" /* 53190 */
	"DEFAULT_VAL_ATTR1\0" /* 53208 */
	"PT_SPRITE_TEX_ATTR1\0" /* 53226 */
	"ATTR0_VALID\0" /* 53246 */
	"ATTR1_VALID\0" /* 53258 */
	"VS_EXPORT_COUNT\0" /* 53270 */
	"VS_HALF_PACK\0" /* 53286 */
	"VS_EXPORTS_FOG\0" /* 53299 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 53314 */
	"PERSP_SAMPLE_ENA\0" /* 53334 */
	"PERSP_CENTER_ENA\0" /* 53351 */
	"PERSP_CENTROID_ENA\0" /* 53368 */
	"PERSP_PULL_MODEL_ENA\0" /* 53387 */
	"LINEAR_SAMPLE_ENA\0" /* 53408 */
	"LINEAR_CENTER_ENA\0" /* 53426 */
	"LINEAR_CENTROID_ENA\0" /* 53444 */
	"LINE_STIPPLE_TEX_ENA\0" /* 53464 */
	"POS_X_FLOAT_ENA\0" /* 53485 */
	"POS_Y_FLOAT_ENA\0" /* 53501 */
	"POS_Z_FLOAT_ENA\0" /* 53517 */
	"POS_W_FLOAT_ENA\0" /* 53533 */
	"FRONT_FACE_ENA\0" /* 53549 */
	"ANCILLARY_ENA\0" /* 53564 */
	"SAMPLE_COVERAGE_ENA\0" /* 53578 */
	"POS_FIXED_PT_ENA\0" /* 53598 */
	"FLAT_SHADE_ENA\0" /* 53615 */
	"PNT_SPRITE_ENA\0" /* 53630 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 53645 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 53666 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 53687 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 53708 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 53729 */
	"PNT_SPRITE_OVRD_X\0" /* 53753 */
	"PNT_SPRITE_OVRD_Y\0" /* 53771 */
	"PNT_SPRITE_OVRD_Z\0" /* 53789 */
	"PNT_SPRITE_OVRD_W\0" /* 53807 */
	"PNT_SPRITE_TOP_1\0" /* 53825 */
	"NUM_INTERP\0" /* 53842 */
	"PARAM_GEN\0" /* 53853 */
	"FOG_ADDR\0" /* 53863 */
	"BC_OPTIMIZE_DISABLE\0" /* 53872 */
	"PASS_FOG_THROUGH_PS\0" /* 53892 */
	"PERSP_CENTER_CNTL\0" /* 53912 */
	"PERSP_CENTROID_CNTL\0" /* 53930 */
	"LINEAR_CENTER_CNTL\0" /* 53950 */
	"LINEAR_CENTROID_CNTL\0" /* 53969 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 53990 */
	"POS_FLOAT_LOCATION\0" /* 54039 */
	"POS_FLOAT_ULC\0" /* 54058 */
	"FRONT_FACE_ALL_BITS\0" /* 54072 */
	"NUM_PS_WAVES\0" /* 54092 */
	"NUM_VS_WAVES\0" /* 54105 */
	"NUM_GS_WAVES\0" /* 54118 */
	"NUM_ES_WAVES\0" /* 54131 */
	"NUM_HS_WAVES\0" /* 54144 */
	"NUM_LS_WAVES\0" /* 54157 */
	"SPI_SHADER_NONE\0" /* 54170 */
	"SPI_SHADER_1COMP\0" /* 54186 */
	"SPI_SHADER_2COMP\0" /* 54203 */
	"SPI_SHADER_4COMPRESS\0" /* 54220 */
	"SPI_SHADER_4COMP\0" /* 54241 */
	"POS0_EXPORT_FORMAT\0" /* 54258 */
	"POS1_EXPORT_FORMAT\0" /* 54277 */
	"POS2_EXPORT_FORMAT\0" /* 54296 */
	"POS3_EXPORT_FORMAT\0" /* 54315 */
	"SPI_SHADER_ZERO\0" /* 54334 */
	"SPI_SHADER_32_R\0" /* 54350 */
	"SPI_SHADER_32_GR\0" /* 54366 */
	"SPI_SHADER_32_AR\0" /* 54383 */
	"SPI_SHADER_FP16_ABGR\0" /* 54400 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 54421 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 54445 */
	"SPI_SHADER_UINT16_ABGR\0" /* 54469 */
	"SPI_SHADER_SINT16_ABGR\0" /* 54492 */
	"SPI_SHADER_32_ABGR\0" /* 54515 */
	"Z_EXPORT_FORMAT\0" /* 54534 */
	"COL0_EXPORT_FORMAT\0" /* 54550 */
	"COL1_EXPORT_FORMAT\0" /* 54569 */
	"COL2_EXPORT_FORMAT\0" /* 54588 */
	"COL3_EXPORT_FORMAT\0" /* 54607 */
	"COL4_EXPORT_FORMAT\0" /* 54626 */
	"COL5_EXPORT_FORMAT\0" /* 54645 */
	"COL6_EXPORT_FORMAT\0" /* 54664 */
	"COL7_EXPORT_FORMAT\0" /* 54683 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 54702 */
	"SX_RT_EXPORT_32_R\0" /* 54729 */
	"SX_RT_EXPORT_32_A\0" /* 54747 */
	"SX_RT_EXPORT_10_11_11\0" /* 54765 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 54787 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 54811 */
	"SX_RT_EXPORT_5_6_5\0" /* 54832 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 54851 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 54872 */
	"SX_RT_EXPORT_16_16_GR\0" /* 54893 */
	"SX_RT_EXPORT_16_16_AR\0" /* 54915 */
	"MRT0\0" /* 54937 */
	"MRT1\0" /* 54942 */
	"MRT2\0" /* 54947 */
	"MRT3\0" /* 54952 */
	"MRT4\0" /* 54957 */
	"MRT5\0" /* 54962 */
	"MRT6\0" /* 54967 */
	"MRT7\0" /* 54972 */
	"EXACT\0" /* 54977 */
	"11BIT_FORMAT\0" /* 54983 */
	"10BIT_FORMAT\0" /* 54996 */
	"8BIT_FORMAT\0" /* 55009 */
	"6BIT_FORMAT\0" /* 55021 */
	"5BIT_FORMAT\0" /* 55033 */
	"4BIT_FORMAT\0" /* 55045 */
	"MRT0_EPSILON\0" /* 55057 */
	"MRT1_EPSILON\0" /* 55070 */
	"MRT2_EPSILON\0" /* 55083 */
	"MRT3_EPSILON\0" /* 55096 */
	"MRT4_EPSILON\0" /* 55109 */
	"MRT5_EPSILON\0" /* 55122 */
	"MRT6_EPSILON\0" /* 55135 */
	"MRT7_EPSILON\0" /* 55148 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 55161 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 55184 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 55207 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 55230 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 55253 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 55276 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 55299 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 55322 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 55345 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 55368 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 55391 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 55414 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 55437 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 55460 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 55483 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 55506 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 55529 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 55552 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 55587 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 55622 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 55654 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 55686 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 55718 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 55750 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 55784 */
	"COLOR_SRC_OPT\0" /* 55820 */
	"COLOR_DST_OPT\0" /* 55834 */
	"OPT_COMB_NONE\0" /* 55848 */
	"OPT_COMB_ADD\0" /* 55862 */
	"OPT_COMB_SUBTRACT\0" /* 55875 */
	"OPT_COMB_MIN\0" /* 55893 */
	"OPT_COMB_MAX\0" /* 55906 */
	"OPT_COMB_REVSUBTRACT\0" /* 55919 */
	"OPT_COMB_BLEND_DISABLED\0" /* 55940 */
	"OPT_COMB_SAFE_ADD\0" /* 55964 */
	"COLOR_COMB_FCN\0" /* 55982 */
	"ALPHA_SRC_OPT\0" /* 55997 */
	"ALPHA_DST_OPT\0" /* 56011 */
	"ALPHA_COMB_FCN\0" /* 56025 */
	"BLEND_ZERO\0" /* 56040 */
	"BLEND_ONE\0" /* 56051 */
	"BLEND_SRC_COLOR\0" /* 56061 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 56077 */
	"BLEND_SRC_ALPHA\0" /* 56103 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 56119 */
	"BLEND_DST_ALPHA\0" /* 56145 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 56161 */
	"BLEND_DST_COLOR\0" /* 56187 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 56203 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 56229 */
	"BLEND_CONSTANT_COLOR\0" /* 56254 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 56275 */
	"BLEND_SRC1_COLOR\0" /* 56306 */
	"BLEND_INV_SRC1_COLOR\0" /* 56323 */
	"BLEND_SRC1_ALPHA\0" /* 56344 */
	"BLEND_INV_SRC1_ALPHA\0" /* 56361 */
	"BLEND_CONSTANT_ALPHA\0" /* 56382 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 56403 */
	"COLOR_SRCBLEND\0" /* 56434 */
	"COMB_DST_PLUS_SRC\0" /* 56449 */
	"COMB_SRC_MINUS_DST\0" /* 56467 */
	"COMB_MIN_DST_SRC\0" /* 56486 */
	"COMB_MAX_DST_SRC\0" /* 56503 */
	"COMB_DST_MINUS_SRC\0" /* 56520 */
	"COLOR_DESTBLEND\0" /* 56539 */
	"ALPHA_SRCBLEND\0" /* 56555 */
	"ALPHA_DESTBLEND\0" /* 56570 */
	"SEPARATE_ALPHA_BLEND\0" /* 56586 */
	"DISABLE_ROP3\0" /* 56607, 56615 */
	"SRC_STATE_ID\0" /* 56620 */
	"BASE_ADDR_GFX6\0" /* 56633 */
	"DI_SRC_SEL_DMA\0" /* 56648 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 56663 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 56684 */
	"DI_SRC_SEL_RESERVED\0" /* 56706 */
	"SOURCE_SELECT\0" /* 56726 */
	"DI_MAJOR_MODE_0\0" /* 56740 */
	"DI_MAJOR_MODE_1\0" /* 56756 */
	"MAJOR_MODE\0" /* 56772 */
	"NOT_EOP\0" /* 56783 */
	"USE_OPAQUE\0" /* 56791 */
	"ADDRESS_LOW\0" /* 56802 */
	"STENCIL_ENABLE\0" /* 56814 */
	"Z_WRITE_ENABLE\0" /* 56829 */
	"DEPTH_BOUNDS_ENABLE\0" /* 56844 */
	"FRAG_NEVER\0" /* 56864 */
	"FRAG_LESS\0" /* 56875 */
	"FRAG_EQUAL\0" /* 56885 */
	"FRAG_LEQUAL\0" /* 56896 */
	"FRAG_GREATER\0" /* 56908 */
	"FRAG_NOTEQUAL\0" /* 56921 */
	"FRAG_GEQUAL\0" /* 56935 */
	"FRAG_ALWAYS\0" /* 56947 */
	"BACKFACE_ENABLE\0" /* 56959 */
	"REF_NEVER\0" /* 56975 */
	"REF_LESS\0" /* 56985 */
	"REF_EQUAL\0" /* 56994 */
	"REF_LEQUAL\0" /* 57004 */
	"REF_GREATER\0" /* 57015 */
	"REF_NOTEQUAL\0" /* 57027 */
	"REF_GEQUAL\0" /* 57040 */
	"REF_ALWAYS\0" /* 57051 */
	"STENCILFUNC\0" /* 57062 */
	"STENCILFUNC_BF\0" /* 57074 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 57089 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 57123 */
	"MAX_ANCHOR_SAMPLES\0" /* 57158 */
	"PS_ITER_SAMPLES\0" /* 57177 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 57193 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 57217 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 57243 */
	"INCOHERENT_EQAA_READS\0" /* 57270 */
	"INTERPOLATE_COMP_Z\0" /* 57292 */
	"INTERPOLATE_SRC_Z\0" /* 57311 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 57329 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 57356 */
	"OVERRASTERIZATION_AMOUNT\0" /* 57383 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 57408 */
	"DISABLE_DUAL_QUAD\0" /* 57439 */
	"DEGAMMA_ENABLE\0" /* 57457 */
	"CB_DISABLE\0" /* 57472 */
	"CB_NORMAL\0" /* 57483 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 57493, 57506 */
	"CB_RESOLVE\0" /* 57517 */
	"CB_FMASK_DECOMPRESS\0" /* 57528 */
	"CB_DCC_DECOMPRESS\0" /* 57548 */
	"ROP3_CLEAR\0" /* 57566 */
	"ROP3_NOR\0" /* 57577 */
	"ROP3_AND_INVERTED\0" /* 57586 */
	"ROP3_COPY_INVERTED\0" /* 57604 */
	"ROP3_AND_REVERSE\0" /* 57623 */
	"ROP3_INVERT\0" /* 57640 */
	"ROP3_XOR\0" /* 57652 */
	"ROP3_NAND\0" /* 57661 */
	"ROP3_AND\0" /* 57671 */
	"ROP3_EQUIVALENT\0" /* 57680 */
	"ROP3_NO_OP\0" /* 57696 */
	"ROP3_OR_INVERTED\0" /* 57707 */
	"ROP3_COPY\0" /* 57724 */
	"ROP3_OR_REVERSE\0" /* 57734 */
	"ROP3_OR\0" /* 57750 */
	"ROP3_SET\0" /* 57758 */
	"Z_EXPORT_ENABLE\0" /* 57767 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 57783 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 57814 */
	"LATE_Z\0" /* 57843 */
	"EARLY_Z_THEN_LATE_Z\0" /* 57850 */
	"RE_Z\0" /* 57870 */
	"EARLY_Z_THEN_RE_Z\0" /* 57875 */
	"KILL_ENABLE\0" /* 57893 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 57905 */
	"MASK_EXPORT_ENABLE\0" /* 57929 */
	"EXEC_ON_HIER_FAIL\0" /* 57948 */
	"EXEC_ON_NOOP\0" /* 57966 */
	"ALPHA_TO_MASK_DISABLE\0" /* 57979 */
	"DEPTH_BEFORE_SHADER\0" /* 58001 */
	"EXPORT_ANY_Z\0" /* 58021 */
	"EXPORT_LESS_THAN_Z\0" /* 58034 */
	"EXPORT_GREATER_THAN_Z\0" /* 58053 */
	"EXPORT_RESERVED\0" /* 58075 */
	"CONSERVATIVE_Z_EXPORT\0" /* 58091 */
	"DUAL_QUAD_DISABLE\0" /* 58113 */
	"UCP_ENA_0\0" /* 58131 */
	"UCP_ENA_1\0" /* 58141 */
	"UCP_ENA_2\0" /* 58151 */
	"UCP_ENA_3\0" /* 58161 */
	"UCP_ENA_4\0" /* 58171 */
	"UCP_ENA_5\0" /* 58181 */
	"PS_UCP_Y_SCALE_NEG\0" /* 58191 */
	"PS_UCP_MODE\0" /* 58210 */
	"CLIP_DISABLE\0" /* 58222 */
	"UCP_CULL_ONLY_ENA\0" /* 58235 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 58253 */
	"DX_CLIP_SPACE_DEF\0" /* 58276 */
	"DIS_CLIP_ERR_DETECT\0" /* 58294 */
	"VTX_KILL_OR\0" /* 58314 */
	"DX_RASTERIZATION_KILL\0" /* 58326 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 58348 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 58372 */
	"ZCLIP_NEAR_DISABLE\0" /* 58398 */
	"ZCLIP_FAR_DISABLE\0" /* 58417 */
	"CULL_FRONT\0" /* 58435 */
	"CULL_BACK\0" /* 58446 */
	"X_DISABLE_POLY_MODE\0" /* 58456, 58466 */
	"X_DUAL_MODE\0" /* 58476 */
	"X_DRAW_POINTS\0" /* 58488 */
	"X_DRAW_LINES\0" /* 58502 */
	"X_DRAW_TRIANGLES\0" /* 58515 */
	"POLYMODE_FRONT_PTYPE\0" /* 58532 */
	"POLYMODE_BACK_PTYPE\0" /* 58553 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 58573 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 58598 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 58622 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 58646 */
	"PROVOKING_VTX_LAST\0" /* 58671 */
	"PERSP_CORR_DIS\0" /* 58690 */
	"MULTI_PRIM_IB_ENA\0" /* 58705 */
	"VPORT_X_SCALE_ENA\0" /* 58723 */
	"VPORT_X_OFFSET_ENA\0" /* 58741 */
	"VPORT_Y_SCALE_ENA\0" /* 58760 */
	"VPORT_Y_OFFSET_ENA\0" /* 58778 */
	"VPORT_Z_SCALE_ENA\0" /* 58797 */
	"VPORT_Z_OFFSET_ENA\0" /* 58815 */
	"VTX_XY_FMT\0" /* 58834 */
	"VTX_Z_FMT\0" /* 58845 */
	"VTX_W0_FMT\0" /* 58855 */
	"CLIP_DIST_ENA_0\0" /* 58866 */
	"CLIP_DIST_ENA_1\0" /* 58882 */
	"CLIP_DIST_ENA_2\0" /* 58898 */
	"CLIP_DIST_ENA_3\0" /* 58914 */
	"CLIP_DIST_ENA_4\0" /* 58930 */
	"CLIP_DIST_ENA_5\0" /* 58946 */
	"CLIP_DIST_ENA_6\0" /* 58962 */
	"CLIP_DIST_ENA_7\0" /* 58978 */
	"CULL_DIST_ENA_0\0" /* 58994 */
	"CULL_DIST_ENA_1\0" /* 59010 */
	"CULL_DIST_ENA_2\0" /* 59026 */
	"CULL_DIST_ENA_3\0" /* 59042 */
	"CULL_DIST_ENA_4\0" /* 59058 */
	"CULL_DIST_ENA_5\0" /* 59074 */
	"CULL_DIST_ENA_6\0" /* 59090 */
	"CULL_DIST_ENA_7\0" /* 59106 */
	"USE_VTX_POINT_SIZE\0" /* 59122 */
	"USE_VTX_EDGE_FLAG\0" /* 59141 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 59159 */
	"USE_VTX_VIEWPORT_INDX\0" /* 59186 */
	"USE_VTX_KILL_FLAG\0" /* 59208 */
	"VS_OUT_MISC_VEC_ENA\0" /* 59226 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 59246 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 59269 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 59292 */
	"USE_VTX_GS_CUT_FLAG\0" /* 59317 */
	"USE_VTX_LINE_WIDTH\0" /* 59337 */
	"VTE_XY_INF_DISCARD\0" /* 59356 */
	"VTE_Z_INF_DISCARD\0" /* 59375 */
	"VTE_W_INF_DISCARD\0" /* 59393 */
	"VTE_0XNANINF_IS_0\0" /* 59411 */
	"VTE_XY_NAN_RETAIN\0" /* 59429 */
	"VTE_Z_NAN_RETAIN\0" /* 59447 */
	"VTE_W_NAN_RETAIN\0" /* 59464 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 59481 */
	"VS_XY_NAN_TO_INF\0" /* 59502 */
	"VS_XY_INF_RETAIN\0" /* 59519 */
	"VS_Z_NAN_TO_INF\0" /* 59536 */
	"VS_Z_INF_RETAIN\0" /* 59552 */
	"VS_W_NAN_TO_INF\0" /* 59568 */
	"VS_W_INF_RETAIN\0" /* 59584 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 59600 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 59625 */
	"LINE_STIPPLE_RESET\0" /* 59645 */
	"EXPAND_FULL_LENGTH\0" /* 59664 */
	"FRACTIONAL_ACCUM\0" /* 59683 */
	"DIAMOND_ADJUST\0" /* 59700 */
	"TRIANGLE_FILTER_DISABLE\0" /* 59715 */
	"LINE_FILTER_DISABLE\0" /* 59739 */
	"POINT_FILTER_DISABLE\0" /* 59759 */
	"RECTANGLE_FILTER_DISABLE\0" /* 59780 */
	"TRIANGLE_EXPAND_ENA\0" /* 59805 */
	"LINE_EXPAND_ENA\0" /* 59825 */
	"POINT_EXPAND_ENA\0" /* 59841 */
	"RECTANGLE_EXPAND_ENA\0" /* 59858 */
	"PRIM_EXPAND_CONSTANT\0" /* 59879 */
	"XMAX_RIGHT_EXCLUSION\0" /* 59900 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 59921 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 59943 */
	"MIN_SIZE\0" /* 59968 */
	"LINE_PATTERN\0" /* 59977 */
	"REPEAT_COUNT\0" /* 59990 */
	"PATTERN_BIT_ORDER\0" /* 60003 */
	"AUTO_RESET_CNTL\0" /* 60021 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 60037 */
	"VGT_OUTPATH_TESS_EN\0" /* 60059 */
	"VGT_OUTPATH_PASSTHRU\0" /* 60079 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 60100 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 60121 */
	"PATH_SELECT\0" /* 60142 */
	"TESS_MODE\0" /* 60154 */
	"VGT_GRP_3D_POINT\0" /* 60164 */
	"VGT_GRP_3D_LINE\0" /* 60181 */
	"VGT_GRP_3D_TRI\0" /* 60197 */
	"VGT_GRP_3D_RECT\0" /* 60212 */
	"VGT_GRP_3D_QUAD\0" /* 60228 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 60244 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 60268 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 60292 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 60316 */
	"VGT_GRP_2D_FILL_RECT\0" /* 60340 */
	"VGT_GRP_2D_LINE\0" /* 60361 */
	"VGT_GRP_2D_TRI\0" /* 60377 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 60392 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 60416 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 60439 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 60463 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 60483 */
	"VGT_GRP_3D_PATCH\0" /* 60502 */
	"RETAIN_ORDER\0" /* 60519 */
	"RETAIN_QUADS\0" /* 60532 */
	"VGT_GRP_LIST\0" /* 60545 */
	"VGT_GRP_STRIP\0" /* 60558 */
	"VGT_GRP_FAN\0" /* 60572 */
	"VGT_GRP_LOOP\0" /* 60584 */
	"VGT_GRP_POLYGON\0" /* 60597 */
	"PRIM_ORDER\0" /* 60613 */
	"COMP_X_EN\0" /* 60624 */
	"COMP_Y_EN\0" /* 60634 */
	"COMP_Z_EN\0" /* 60644 */
	"COMP_W_EN\0" /* 60654 */
	"SHIFT\0" /* 60664 */
	"VGT_GRP_INDEX_16\0" /* 60670 */
	"VGT_GRP_INDEX_32\0" /* 60687 */
	"VGT_GRP_UINT_16\0" /* 60704 */
	"VGT_GRP_UINT_32\0" /* 60720 */
	"VGT_GRP_SINT_16\0" /* 60736 */
	"VGT_GRP_SINT_32\0" /* 60752 */
	"VGT_GRP_FLOAT_32\0" /* 60768 */
	"VGT_GRP_AUTO_PRIM\0" /* 60785 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 60803 */
	"X_CONV\0" /* 60829, 60833 */
	"Y_CONV\0" /* 60836 */
	"Z_CONV\0" /* 60843 */
	"Z_OFFSET\0" /* 60850 */
	"W_CONV\0" /* 60859 */
	"GS_OFF\0" /* 60866 */
	"GS_SCENARIO_A\0" /* 60873 */
	"GS_SCENARIO_B\0" /* 60887 */
	"GS_SCENARIO_G\0" /* 60901 */
	"GS_SCENARIO_C\0" /* 60915 */
	"SPRITE_EN\0" /* 60929 */
	"GS_CUT_1024\0" /* 60939 */
	"GS_CUT_512\0" /* 60951 */
	"GS_CUT_256\0" /* 60962 */
	"GS_CUT_128\0" /* 60973 */
	"CUT_MODE\0" /* 60984 */
	"GS_C_PACK_EN\0" /* 60993 */
	"RESERVED_2\0" /* 61006 */
	"ES_PASSTHRU\0" /* 61017 */
	"COMPUTE_MODE\0" /* 61029 */
	"FAST_COMPUTE_MODE\0" /* 61042 */
	"ELEMENT_INFO_EN\0" /* 61060 */
	"PARTIAL_THD_AT_EOI\0" /* 61076 */
	"SUPPRESS_CUTS\0" /* 61095 */
	"ES_WRITE_OPTIMIZE\0" /* 61109 */
	"GS_WRITE_OPTIMIZE\0" /* 61127 */
	"X_0_OFFCHIP_GS\0" /* 61145 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 61160, 61178 */
	"ES_VERTS_PER_SUBGRP\0" /* 61185 */
	"GS_PRIMS_PER_SUBGRP\0" /* 61205 */
	"MSAA_ENABLE\0" /* 61225 */
	"VPORT_SCISSOR_ENABLE\0" /* 61237 */
	"LINE_STIPPLE_ENABLE\0" /* 61258 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 61278 */
	"WALK_SIZE\0" /* 61303 */
	"WALK_ALIGNMENT\0" /* 61313 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 61328 */
	"WALK_FENCE_ENABLE\0" /* 61353 */
	"WALK_FENCE_SIZE\0" /* 61371 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 61387, 61392 */
	"TILE_COVER_DISABLE\0" /* 61415 */
	"TILE_COVER_NO_SCISSOR\0" /* 61434 */
	"ZMM_LINE_EXTENT\0" /* 61456 */
	"ZMM_LINE_OFFSET\0" /* 61472 */
	"ZMM_RECT_EXTENT\0" /* 61488 */
	"KILL_PIX_POST_HI_Z\0" /* 61504 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 61523 */
	"PS_ITER_SAMPLE\0" /* 61549 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 61564 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 61604 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 61631 */
	"GPU_ID_OVERRIDE\0" /* 61654 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 61670 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 61700 */
	"FORCE_EOV_REZ_ENABLE\0" /* 61724 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 61745 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 61775 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 61799 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 61822 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 61845 */
	"OUTPRIM_TYPE\0" /* 61867 */
	"OUTPRIM_TYPE_1\0" /* 61880 */
	"OUTPRIM_TYPE_2\0" /* 61895 */
	"OUTPRIM_TYPE_3\0" /* 61910 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 61925 */
	"VGT_INDEX_16\0" /* 61948 */
	"VGT_INDEX_32\0" /* 61961 */
	"VGT_INDEX_8\0" /* 61974 */
	"VGT_DMA_SWAP_NONE\0" /* 61986 */
	"VGT_DMA_SWAP_16_BIT\0" /* 62004 */
	"VGT_DMA_SWAP_32_BIT\0" /* 62024 */
	"VGT_DMA_SWAP_WORD\0" /* 62044 */
	"SWAP_MODE\0" /* 62062 */
	"VGT_DMA_BUF_MEM\0" /* 62072 */
	"VGT_DMA_BUF_RING\0" /* 62088 */
	"VGT_DMA_BUF_SETUP\0" /* 62105 */
	"BUF_TYPE\0" /* 62123 */
	"VGT_POLICY_LRU\0" /* 62132 */
	"VGT_POLICY_STREAM\0" /* 62147 */
	"RDREQ_POLICY_CIK\0" /* 62165 */
	"RDREQ_POLICY\0" /* 62182 */
	"REQ_PATH\0" /* 62195 */
	"DISABLE_RESET_ON_EOI\0" /* 62204 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 62225 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 62248 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 62271 */
	"CACHE_FLUSH_TS\0" /* 62294 */
	"CONTEXT_DONE\0" /* 62309 */
	"CACHE_FLUSH\0" /* 62322 */
	"CS_PARTIAL_FLUSH\0" /* 62334 */
	"VGT_STREAMOUT_SYNC\0" /* 62351 */
	"VGT_STREAMOUT_RESET\0" /* 62370 */
	"END_OF_PIPE_INCR_DE\0" /* 62390 */
	"END_OF_PIPE_IB_END\0" /* 62410 */
	"RST_PIX_CNT\0" /* 62429 */
	"VS_PARTIAL_FLUSH\0" /* 62441 */
	"PS_PARTIAL_FLUSH\0" /* 62458 */
	"FLUSH_HS_OUTPUT\0" /* 62475 */
	"FLUSH_LS_OUTPUT\0" /* 62491 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 62507 */
	"ZPASS_DONE\0" /* 62536 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 62547 */
	"PERFCOUNTER_START\0" /* 62573 */
	"PERFCOUNTER_STOP\0" /* 62591 */
	"PIPELINESTAT_START\0" /* 62608 */
	"PIPELINESTAT_STOP\0" /* 62627 */
	"PERFCOUNTER_SAMPLE\0" /* 62645 */
	"FLUSH_ES_OUTPUT\0" /* 62664 */
	"FLUSH_GS_OUTPUT\0" /* 62680 */
	"SAMPLE_PIPELINESTAT\0" /* 62696 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 62716 */
	"SAMPLE_STREAMOUTSTATS\0" /* 62738 */
	"RESET_VTX_CNT\0" /* 62760 */
	"BLOCK_CONTEXT_DONE\0" /* 62774 */
	"CS_CONTEXT_DONE\0" /* 62793 */
	"VGT_FLUSH\0" /* 62809 */
	"SC_SEND_DB_VPZ\0" /* 62819 */
	"BOTTOM_OF_PIPE_TS\0" /* 62834 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 62852 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 62875 */
	"FLUSH_AND_INV_DB_META\0" /* 62900 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 62922 */
	"FLUSH_AND_INV_CB_META\0" /* 62947 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 62969 */
	"THREAD_TRACE_START\0" /* 62997 */
	"THREAD_TRACE_STOP\0" /* 63016 */
	"THREAD_TRACE_MARKER\0" /* 63034 */
	"THREAD_TRACE_FLUSH\0" /* 63054 */
	"THREAD_TRACE_FINISH\0" /* 63073 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 63093 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 63117 */
	"PIXEL_PIPE_STAT_RESET\0" /* 63138 */
	"EVENT_TYPE\0" /* 63160 */
	"ADDRESS_HI_GFX6\0" /* 63171 */
	"EXTENDED_EVENT\0" /* 63187 */
	"PRIMGROUP_SIZE\0" /* 63202 */
	"PARTIAL_VS_WAVE_ON\0" /* 63217 */
	"SWITCH_ON_EOP\0" /* 63236 */
	"PARTIAL_ES_WAVE_ON\0" /* 63250 */
	"SWITCH_ON_EOI\0" /* 63269 */
	"WD_SWITCH_ON_EOP\0" /* 63283 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 63300 */
	"FULL_CACHE\0" /* 63320 */
	"HTILE_USES_PRELOAD_WIN\0" /* 63331 */
	"PRELOAD\0" /* 63354 */
	"PREFETCH_WIDTH\0" /* 63362 */
	"PREFETCH_HEIGHT\0" /* 63377 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 63393 */
	"TC_COMPATIBLE\0" /* 63417 */
	"COMPAREFUNC0\0" /* 63431 */
	"COMPAREVALUE0\0" /* 63444 */
	"COMPAREMASK0\0" /* 63458 */
	"COMPAREFUNC1\0" /* 63471 */
	"COMPAREVALUE1\0" /* 63484 */
	"COMPAREMASK1\0" /* 63498 */
	"MAX_X\0" /* 63511 */
	"MAX_Y\0" /* 63517 */
	"ACCUM_ISOLINE\0" /* 63523 */
	"ACCUM_TRI\0" /* 63537 */
	"ACCUM_QUAD\0" /* 63547 */
	"DONUT_SPLIT\0" /* 63558 */
	"TRAP_SPLIT\0" /* 63570 */
	"LS_STAGE_OFF\0" /* 63581 */
	"LS_STAGE_ON\0" /* 63594 */
	"CS_STAGE_ON\0" /* 63606 */
	"ES_STAGE_OFF\0" /* 63618 */
	"ES_STAGE_DS\0" /* 63631 */
	"ES_STAGE_REAL\0" /* 63643 */
	"VS_STAGE_REAL\0" /* 63657 */
	"VS_STAGE_DS\0" /* 63671 */
	"VS_STAGE_COPY_SHADER\0" /* 63683 */
	"DYNAMIC_HS\0" /* 63704 */
	"DIS_DEALLOC_ACCUM_0\0" /* 63715 */
	"DIS_DEALLOC_ACCUM_1\0" /* 63735 */
	"VS_WAVE_ID_EN\0" /* 63755 */
	"NUM_PATCHES\0" /* 63769 */
	"HS_NUM_INPUT_CP\0" /* 63781 */
	"HS_NUM_OUTPUT_CP\0" /* 63797 */
	"TESS_ISOLINE\0" /* 63814 */
	"TESS_TRIANGLE\0" /* 63827 */
	"TESS_QUAD\0" /* 63841 */
	"PART_INTEGER\0" /* 63851 */
	"PART_POW2\0" /* 63864 */
	"PART_FRAC_ODD\0" /* 63874 */
	"PART_FRAC_EVEN\0" /* 63888 */
	"PARTITIONING\0" /* 63903 */
	"OUTPUT_POINT\0" /* 63916 */
	"OUTPUT_LINE\0" /* 63929 */
	"OUTPUT_TRIANGLE_CW\0" /* 63941 */
	"OUTPUT_TRIANGLE_CCW\0" /* 63960 */
	"TOPOLOGY\0" /* 63980 */
	"RESERVED_REDUC_AXIS\0" /* 63989 */
	"DEPRECATED\0" /* 64009 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 64020 */
	"DISABLE_DONUTS\0" /* 64042 */
	"VGT_POLICY_BYPASS\0" /* 64057 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 64075 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 64101 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 64127 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 64152 */
	"DISTRIBUTION_MODE\0" /* 64181 */
	"ALPHA_TO_MASK_ENABLE\0" /* 64199 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 64220 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 64242 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 64264 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 64286 */
	"OFFSET_ROUND\0" /* 64308 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 64321 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 64349 */
	"STREAMOUT_0_EN\0" /* 64377 */
	"STREAMOUT_1_EN\0" /* 64392 */
	"STREAMOUT_2_EN\0" /* 64407 */
	"STREAMOUT_3_EN\0" /* 64422 */
	"RAST_STREAM\0" /* 64437 */
	"RAST_STREAM_MASK\0" /* 64449 */
	"USE_RAST_STREAM_MASK\0" /* 64466 */
	"STREAM_0_BUFFER_EN\0" /* 64487 */
	"STREAM_1_BUFFER_EN\0" /* 64506 */
	"STREAM_2_BUFFER_EN\0" /* 64525 */
	"STREAM_3_BUFFER_EN\0" /* 64544 */
	"DISTANCE_0\0" /* 64563 */
	"DISTANCE_1\0" /* 64574 */
	"DISTANCE_2\0" /* 64585 */
	"DISTANCE_3\0" /* 64596 */
	"DISTANCE_4\0" /* 64607 */
	"DISTANCE_5\0" /* 64618 */
	"DISTANCE_6\0" /* 64629 */
	"DISTANCE_7\0" /* 64640 */
	"DISTANCE_8\0" /* 64651 */
	"DISTANCE_9\0" /* 64662 */
	"DISTANCE_10\0" /* 64673 */
	"DISTANCE_11\0" /* 64685 */
	"DISTANCE_12\0" /* 64697 */
	"DISTANCE_13\0" /* 64709 */
	"DISTANCE_14\0" /* 64721 */
	"DISTANCE_15\0" /* 64733 */
	"EXPAND_LINE_WIDTH\0" /* 64745 */
	"LAST_PIXEL\0" /* 64763 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 64774 */
	"DX10_DIAMOND_TEST_ENA\0" /* 64799 */
	"MSAA_NUM_SAMPLES\0" /* 64821 */
	"AA_MASK_CENTROID_DTMN\0" /* 64838 */
	"MAX_SAMPLE_DIST\0" /* 64860 */
	"MSAA_EXPOSED_SAMPLES\0" /* 64876 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 64897 */
	"PIX_CENTER\0" /* 64920 */
	"X_TRUNCATE\0" /* 64931 */
	"X_ROUND\0" /* 64942 */
	"X_ROUND_TO_EVEN\0" /* 64950 */
	"X_ROUND_TO_ODD\0" /* 64966 */
	"ROUND_MODE\0" /* 64981 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 64992 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 65018 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 65043 */
	"X_16_8_FIXED_POINT_1_2\0" /* 65068 */
	"X_16_8_FIXED_POINT_1\0" /* 65091 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 65112 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 65139 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 65168 */
	"QUANT_MODE\0" /* 65197 */
	"S0_X\0" /* 65208 */
	"S0_Y\0" /* 65213 */
	"S1_X\0" /* 65218 */
	"S1_Y\0" /* 65223 */
	"S2_X\0" /* 65228 */
	"S2_Y\0" /* 65233 */
	"S3_X\0" /* 65238 */
	"S3_Y\0" /* 65243 */
	"S4_X\0" /* 65248 */
	"S4_Y\0" /* 65253 */
	"S5_X\0" /* 65258 */
	"S5_Y\0" /* 65263 */
	"S6_X\0" /* 65268 */
	"S6_Y\0" /* 65273 */
	"S7_X\0" /* 65278 */
	"S7_Y\0" /* 65283 */
	"S8_X\0" /* 65288 */
	"S8_Y\0" /* 65293 */
	"S9_X\0" /* 65298 */
	"S9_Y\0" /* 65303 */
	"S10_X\0" /* 65308 */
	"S10_Y\0" /* 65314 */
	"S11_X\0" /* 65320 */
	"S11_Y\0" /* 65326 */
	"S12_X\0" /* 65332 */
	"S12_Y\0" /* 65338 */
	"S13_X\0" /* 65344 */
	"S13_Y\0" /* 65350 */
	"S14_X\0" /* 65356 */
	"S14_Y\0" /* 65362 */
	"S15_X\0" /* 65368 */
	"S15_Y\0" /* 65374 */
	"AA_MASK_X0Y0\0" /* 65380 */
	"AA_MASK_X1Y0\0" /* 65393 */
	"AA_MASK_X0Y1\0" /* 65406 */
	"AA_MASK_X1Y1\0" /* 65419 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 65432 */
	"VTX_REUSE_DEPTH\0" /* 65461 */
	"DEALLOC_DIST\0" /* 65477 */
	"FMASK_TILE_MAX\0" /* 65490 */
	"ENDIAN_NONE\0" /* 65505 */
	"ENDIAN_8IN16\0" /* 65517 */
	"ENDIAN_8IN32\0" /* 65530 */
	"ENDIAN_8IN64\0" /* 65543 */
	"ENDIAN\0" /* 65556 */
	"COLOR_INVALID\0" /* 65563 */
	"COLOR_8\0" /* 65577 */
	"COLOR_16\0" /* 65585 */
	"COLOR_8_8\0" /* 65594 */
	"COLOR_32\0" /* 65604 */
	"COLOR_16_16\0" /* 65613 */
	"COLOR_10_11_11\0" /* 65625 */
	"COLOR_11_11_10\0" /* 65640 */
	"COLOR_10_10_10_2\0" /* 65655 */
	"COLOR_2_10_10_10\0" /* 65672 */
	"COLOR_8_8_8_8\0" /* 65689 */
	"COLOR_32_32\0" /* 65703 */
	"COLOR_16_16_16_16\0" /* 65715 */
	"COLOR_32_32_32_32\0" /* 65733 */
	"COLOR_5_6_5\0" /* 65751 */
	"COLOR_1_5_5_5\0" /* 65763 */
	"COLOR_5_5_5_1\0" /* 65777 */
	"COLOR_4_4_4_4\0" /* 65791 */
	"COLOR_8_24\0" /* 65805 */
	"COLOR_24_8\0" /* 65816 */
	"COLOR_X24_8_32_FLOAT\0" /* 65827 */
	"NUMBER_UNORM\0" /* 65848 */
	"NUMBER_SNORM\0" /* 65861 */
	"NUMBER_UINT\0" /* 65874 */
	"NUMBER_SINT\0" /* 65886 */
	"NUMBER_SRGB\0" /* 65898 */
	"NUMBER_FLOAT\0" /* 65910 */
	"NUMBER_TYPE\0" /* 65923 */
	"SWAP_STD\0" /* 65935 */
	"SWAP_ALT\0" /* 65944 */
	"SWAP_STD_REV\0" /* 65953 */
	"SWAP_ALT_REV\0" /* 65966 */
	"COMP_SWAP\0" /* 65979 */
	"BLEND_CLAMP\0" /* 65989 */
	"BLEND_BYPASS\0" /* 66001 */
	"SIMPLE_FLOAT\0" /* 66014 */
	"CMASK_IS_LINEAR\0" /* 66027 */
	"FORCE_OPT_AUTO\0" /* 66043 */
	"FORCE_OPT_DISABLE\0" /* 66058 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 66076 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 66104 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 66134 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 66165 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 66193 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 66223 */
	"BLEND_OPT_DONT_RD_DST\0" /* 66254 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 66276 */
	"FMASK_COMPRESSION_DISABLE\0" /* 66300 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 66326 */
	"DCC_ENABLE\0" /* 66352 */
	"CMASK_ADDR_TYPE\0" /* 66363 */
	"FMASK_TILE_MODE_INDEX\0" /* 66379 */
	"FMASK_BANK_HEIGHT\0" /* 66401 */
	"NUM_FRAGMENTS\0" /* 66419 */
	"FORCE_DST_ALPHA_1\0" /* 66433 */
	"KEY_CLEAR_ENABLE\0" /* 66451 */
	"MAX_BLOCK_SIZE_64B\0" /* 66468 */
	"MAX_BLOCK_SIZE_128B\0" /* 66487 */
	"MAX_BLOCK_SIZE_256B\0" /* 66507 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 66527 */
	"MIN_BLOCK_SIZE_32B\0" /* 66555 */
	"MIN_BLOCK_SIZE_64B\0" /* 66574 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 66593 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 66619 */
	"INDEPENDENT_64B_BLOCKS\0" /* 66645 */
	"LOSSY_RGB_PRECISION\0" /* 66668 */
	"LOSSY_ALPHA_PRECISION\0" /* 66688 */
	"UTCL2_BUSY\0" /* 66710 */
	"EA_BUSY\0" /* 66721 */
	"RMI_BUSY\0" /* 66729 */
	"UTCL2_RQ_PENDING\0" /* 66738 */
	"CPF_RQ_PENDING\0" /* 66755 */
	"EA_LINK_BUSY\0" /* 66770 */
	"CPAXI_BUSY\0" /* 66783 */
	"RSMU_RQ_PENDING\0" /* 66794 */
	"TC_WC_ACTION_ENA\0" /* 66810 */
	"TC_INV_METADATA_ACTION_ENA\0" /* 66827 */
	"UTCL2IU_BUSY\0" /* 66854 */
	"SAVE_RESTORE_BUSY\0" /* 66867 */
	"UTCL2IU_WAITING_ON_FREE\0" /* 66885 */
	"UTCL2IU_WAITING_ON_TAGS\0" /* 66909 */
	"UTCL1_WAITING_ON_TRANS\0" /* 66933 */
	"GFX_UTCL1_WAITING_ON_TRANS\0" /* 66956 */
	"CMP_UTCL1_WAITING_ON_TRANS\0" /* 66983 */
	"RCIU_WAITING_ON_FREE\0" /* 67010 */
	"PRIMGEN_EN\0" /* 67031 */
	"MATCH_ALL_BITS\0" /* 67042 */
	"EN_INST_OPT_BASIC\0" /* 67057 */
	"EN_INST_OPT_ADV\0" /* 67075 */
	"HW_USE_ONLY\0" /* 67091 */
	"TARGET_INST\0" /* 67103 */
	"TARGET_DATA\0" /* 67115 */
	"COMPLETE\0" /* 67127 */
	"DWB\0" /* 67136 */
	"USER_VM_ENABLE\0" /* 67140 */
	"USER_VM_MODE\0" /* 67155 */
	"IMG_DATA_FORMAT_6E4\0" /* 67168 */
	"IMG_DATA_FORMAT_16_AS_32_32\0" /* 67188 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9\0" /* 67216 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9\0" /* 67255 */
	"IMG_DATA_FORMAT_FMASK\0" /* 67294 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR\0" /* 67316 */
	"IMG_DATA_FORMAT_ASTC_2D_HDR\0" /* 67344 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB\0" /* 67372 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR\0" /* 67405 */
	"IMG_DATA_FORMAT_ASTC_3D_HDR\0" /* 67433 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB\0" /* 67461 */
	"IMG_DATA_FORMAT_N_IN_16\0" /* 67494 */
	"IMG_DATA_FORMAT_N_IN_16_16\0" /* 67518 */
	"IMG_DATA_FORMAT_N_IN_16_16_16_16\0" /* 67545 */
	"IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16\0" /* 67578 */
	"IMG_DATA_FORMAT_RESERVED_56\0" /* 67617 */
	"IMG_DATA_FORMAT_S8_16\0" /* 67645 */
	"IMG_DATA_FORMAT_S8_32\0" /* 67667 */
	"IMG_DATA_FORMAT_8_AS_32\0" /* 67689 */
	"IMG_DATA_FORMAT_8_AS_32_32\0" /* 67713 */
	"DATA_FORMAT_GFX9\0" /* 67740 */
	"IMG_NUM_FORMAT_RESERVED_6\0" /* 67757 */
	"IMG_NUM_FORMAT_METADATA\0" /* 67783 */
	"IMG_NUM_FORMAT_UNORM_UINT\0" /* 67807 */
	"NUM_FORMAT_GFX9\0" /* 67833 */
	"IMG_FMASK_8_2_1\0" /* 67849 */
	"IMG_FMASK_8_4_1\0" /* 67865 */
	"IMG_FMASK_8_8_1\0" /* 67881 */
	"IMG_FMASK_8_2_2\0" /* 67897 */
	"IMG_FMASK_8_4_2\0" /* 67913 */
	"IMG_FMASK_8_4_4\0" /* 67929 */
	"IMG_FMASK_16_16_1\0" /* 67945 */
	"IMG_FMASK_16_8_2\0" /* 67963 */
	"IMG_FMASK_32_16_2\0" /* 67980 */
	"IMG_FMASK_32_8_4\0" /* 67998 */
	"IMG_FMASK_32_8_8\0" /* 68015 */
	"IMG_FMASK_64_16_4\0" /* 68032 */
	"IMG_FMASK_64_16_8\0" /* 68050 */
	"NUM_FORMAT_FMASK\0" /* 68068 */
	"IMG_ASTC_2D_4x4\0" /* 68085 */
	"IMG_ASTC_2D_5x4\0" /* 68101 */
	"IMG_ASTC_2D_5x5\0" /* 68117 */
	"IMG_ASTC_2D_6x5\0" /* 68133 */
	"IMG_ASTC_2D_6x6\0" /* 68149 */
	"IMG_ASTC_2D_8x5\0" /* 68165 */
	"IMG_ASTC_2D_8x6\0" /* 68181 */
	"IMG_ASTC_2D_8x8\0" /* 68197 */
	"IMG_ASTC_2D_10x5\0" /* 68213 */
	"IMG_ASTC_2D_10x6\0" /* 68230 */
	"IMG_ASTC_2D_10x8\0" /* 68247 */
	"IMG_ASTC_2D_10x10\0" /* 68264 */
	"IMG_ASTC_2D_12x10\0" /* 68282 */
	"IMG_ASTC_2D_12x12\0" /* 68300 */
	"NUM_FORMAT_ASTC_2D\0" /* 68318 */
	"IMG_ASTC_3D_3x3x3\0" /* 68337 */
	"IMG_ASTC_3D_4x3x3\0" /* 68355 */
	"IMG_ASTC_3D_4x4x3\0" /* 68373 */
	"IMG_ASTC_3D_4x4x4\0" /* 68391 */
	"IMG_ASTC_3D_5x4x4\0" /* 68409 */
	"IMG_ASTC_3D_5x5x4\0" /* 68427 */
	"IMG_ASTC_3D_5x5x5\0" /* 68445 */
	"IMG_ASTC_3D_6x5x5\0" /* 68463 */
	"IMG_ASTC_3D_6x6x5\0" /* 68481 */
	"IMG_ASTC_3D_6x6x6\0" /* 68499 */
	"NUM_FORMAT_ASTC_3D\0" /* 68517 */
	"META_DIRECT\0" /* 68536 */
	"SW_MODE\0" /* 68548 */
	"PITCH_GFX9\0" /* 68556 */
	"BC_SWIZZLE_XYZW\0" /* 68567 */
	"BC_SWIZZLE_XWYZ\0" /* 68583 */
	"BC_SWIZZLE_WZYX\0" /* 68599 */
	"BC_SWIZZLE_WXYZ\0" /* 68615 */
	"BC_SWIZZLE_ZYXW\0" /* 68631 */
	"BC_SWIZZLE_YXWZ\0" /* 68647 */
	"BC_SWIZZLE\0" /* 68663 */
	"ARRAY_PITCH\0" /* 68674 */
	"META_DATA_ADDRESS\0" /* 68686 */
	"META_LINEAR\0" /* 68704 */
	"META_PIPE_ALIGNED\0" /* 68716, 68721 */
	"META_RB_ALIGNED\0" /* 68734, 68739 */
	"MAX_MIP\0" /* 68750 */
	"BLEND_ZERO_PRT\0" /* 68758 */
	"SKIP_DEGAMMA\0" /* 68773 */
	"TTRACE_STALL_ALL\0" /* 68786 */
	"ALLOC_ARB_LRU_ENA\0" /* 68803 */
	"EXP_ARB_LRU_ENA\0" /* 68821 */
	"PS_PKR_PRIORITY_CNTL\0" /* 68837 */
	"BATON_RESET_DISABLE\0" /* 68858 */
	"CRC_SIMD_ID_WADDR_DISABLE\0" /* 68878 */
	"LBPW_CU_CHK_MODE\0" /* 68904 */
	"LBPW_CU_CHK_CNT\0" /* 68921 */
	"CSC_PWR_SAVE_DISABLE\0" /* 68937 */
	"CSG_PWR_SAVE_DISABLE\0" /* 68958 */
	"CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD\0" /* 68979 */
	"CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD\0" /* 69020 */
	"PIPE_INTERLEAVE_SIZE_GFX9\0" /* 69059 */
	"MAX_COMPRESSED_FRAGS\0" /* 69085 */
	"NUM_SHADER_ENGINES_GFX9\0" /* 69106 */
	"NUM_GPUS_GFX9\0" /* 69130 */
	"NUM_RB_PER_SE\0" /* 69144 */
	"SE_ENABLE\0" /* 69158 */
	"SIMD_DISABLE\0" /* 69168 */
	"FP16_OVFL\0" /* 69181 */
	"LOAD_COLLISION_WAVEID\0" /* 69191 */
	"LOAD_INTRAWAVE_COLLISION\0" /* 69213 */
	"SKIP_USGPR0\0" /* 69238 */
	"USER_SGPR_MSB\0" /* 69250 */
	"PC_BASE_EN\0" /* 69264 */
	"SPI_SHADER_LATE_ALLOC_GS\0" /* 69275 */
	"GS_VGPR_COMP_CNT\0" /* 69300 */
	"ES_VGPR_COMP_CNT\0" /* 69317 */
	"LS_VGPR_COMP_CNT\0" /* 69334 */
	"CNTR_SEL0\0" /* 69351 */
	"CNTR_SEL1\0" /* 69361 */
	"CNTR_MODE1\0" /* 69371 */
	"CNTR_MODE0\0" /* 69382 */
	"CNTR_SEL2\0" /* 69393 */
	"CNTR_SEL3\0" /* 69403 */
	"CNTR_MODE3\0" /* 69413 */
	"CNTR_MODE2\0" /* 69424 */
	"UTCL2_BUSY_USER_DEFINED_MASK\0" /* 69435 */
	"EA_BUSY_USER_DEFINED_MASK\0" /* 69464 */
	"RMI_BUSY_USER_DEFINED_MASK\0" /* 69490 */
	"MIPID\0" /* 69517 */
	"ALLOW_PARTIAL_RES_HIER_KILL\0" /* 69523 */
	"X_MAX\0" /* 69551 */
	"Y_MAX\0" /* 69557 */
	"PARTIALLY_RESIDENT\0" /* 69563 */
	"FAULT_BEHAVIOR\0" /* 69582 */
	"ITERATE_FLUSH\0" /* 69597 */
	"MAXMIP\0" /* 69611 */
	"FORCE_ON\0" /* 69618 */
	"PUNCHOUT_MODE\0" /* 69627 */
	"POPS_DRAIN_PS_ON_OVERLAP\0" /* 69641 */
	"DISALLOW_OVERFLOW\0" /* 69666 */
	"DEST_BASE_HI_256B\0" /* 69684 */
	"SE_XSEL_GFX9\0" /* 69702 */
	"SE_YSEL_GFX9\0" /* 69715 */
	"SE_PAIR_XSEL_GFX9\0" /* 69728 */
	"SE_PAIR_YSEL_GFX9\0" /* 69746 */
	"NUM_SE\0" /* 69764 */
	"PERFMON_ENABLE\0" /* 69771 */
	"LEFT_QTR\0" /* 69786 */
	"LEFT_HALF\0" /* 69795 */
	"RIGHT_HALF\0" /* 69805 */
	"RIGHT_QTR\0" /* 69816 */
	"TOP_QTR\0" /* 69826 */
	"TOP_HALF\0" /* 69834 */
	"BOT_HALF\0" /* 69843 */
	"BOT_QTR\0" /* 69852 */
	"DISABLE_CONSTANT_ENCODE_REG\0" /* 69860 */
	"OFFCHIP_PARAM_EN\0" /* 69888 */
	"LATE_PC_DEALLOC\0" /* 69905 */
	"BASE_ADDR_GFX9\0" /* 69921 */
	"SPRITE_EN_R6XX\0" /* 69936 */
	"UNROLLED_INST\0" /* 69951 */
	"GRBM_SKEW_NO_DEC\0" /* 69965 */
	"REG_RT_INDEX\0" /* 69982 */
	"PRIMITIVE_ORDERED_PIXEL_SHADER\0" /* 69995 */
	"EXEC_IF_OVERLAPPED\0" /* 70026 */
	"POPS_OVERLAP_NUM_SAMPLES\0" /* 70045 */
	"RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF\0" /* 70070 */
	"NEW_QUAD_DECOMPOSITION\0" /* 70108 */
	"PERFCOUNTER_REF\0" /* 70131 */
	"USE_VTX_SHD_OBJPRIM_ID\0" /* 70147 */
	"OBJ_ID_SEL\0" /* 70170 */
	"ADD_PIPED_PRIM_ID\0" /* 70181 */
	"EN_32BIT_OBJPRIMID\0" /* 70199 */
	"VERTEX_REUSE_OFF\0" /* 70218 */
	"INDEX_BUF_EDGE_FLAG_ENA\0" /* 70235 */
	"DISCARD_0_AREA_TRIANGLES\0" /* 70259 */
	"DISCARD_0_AREA_LINES\0" /* 70284 */
	"DISCARD_0_AREA_POINTS\0" /* 70305 */
	"DISCARD_0_AREA_RECTANGLES\0" /* 70327 */
	"USE_PROVOKING_ZW\0" /* 70353 */
	"RESERVED_3\0" /* 70370 */
	"RESERVED_4\0" /* 70381 */
	"RESERVED_5\0" /* 70392 */
	"GS_INST_PRIMS_IN_SUBGRP\0" /* 70403 */
	"SCALE_LINE_WIDTH_PAD\0" /* 70427 */
	"ALTERNATE_RBS_PER_TILE\0" /* 70448 */
	"COARSE_TILE_STARTS_ON_EVEN_RB\0" /* 70471 */
	"NGG_DISABLE_PROVOK_REUSE\0" /* 70501 */
	"BREAK_BATCH\0" /* 70526 */
	"FLUSH_DFSM\0" /* 70538 */
	"RESET_TO_LOWEST_VGT\0" /* 70549 */
	"TGID_ROLLOVER\0" /* 70569 */
	"ENABLE_NGG_PIPELINE\0" /* 70583 */
	"ENABLE_LEGACY_PIPELINE\0" /* 70603 */
	"ADDRESS_HI_GFX9\0" /* 70626 */
	"OBJPRIM_ID_EN\0" /* 70642 */
	"EN_REG_RT_INDEX\0" /* 70656 */
	"EN_PIPELINE_PRIMID\0" /* 70672 */
	"OBJECT_ID_INST_EN\0" /* 70691 */
	"ORDERED_ID_MODE\0" /* 70709 */
	"GS_FAST_LAUNCH\0" /* 70725 */
	"EN_PRIMS_NEEDED_CNT\0" /* 70740 */
	"COVERAGE_TO_SHADER_SELECT\0" /* 70760 */
	"BINNING_ALLOWED\0" /* 70786 */
	"FORCE_BINNING_ON\0" /* 70802 */
	"DISABLE_BINNING_USE_NEW_SC\0" /* 70819 */
	"DISABLE_BINNING_USE_LEGACY_SC\0" /* 70846 */
	"BINNING_MODE\0" /* 70876 */
	"BIN_SIZE_X\0" /* 70889 */
	"BIN_SIZE_Y\0" /* 70900 */
	"BIN_SIZE_X_EXTEND\0" /* 70911 */
	"BIN_SIZE_Y_EXTEND\0" /* 70929 */
	"CONTEXT_STATES_PER_BIN\0" /* 70947 */
	"PERSISTENT_STATES_PER_BIN\0" /* 70970 */
	"DISABLE_START_OF_PRIM\0" /* 70996 */
	"FPOVS_PER_BATCH\0" /* 71018 */
	"OPTIMAL_BIN_SELECTION\0" /* 71034 */
	"MAX_ALLOC_COUNT\0" /* 71056 */
	"MAX_PRIM_PER_BATCH\0" /* 71072 */
	"OVER_RAST_ENABLE\0" /* 71091 */
	"OVER_RAST_SAMPLE_SELECT\0" /* 71108 */
	"UNDER_RAST_ENABLE\0" /* 71132 */
	"UNDER_RAST_SAMPLE_SELECT\0" /* 71150 */
	"PBB_UNCERTAINTY_REGION_ENABLE\0" /* 71175 */
	"ZMM_TRI_EXTENT\0" /* 71205 */
	"ZMM_TRI_OFFSET\0" /* 71220 */
	"OVERRIDE_OVER_RAST_INNER_TO_NORMAL\0" /* 71235 */
	"OVERRIDE_UNDER_RAST_INNER_TO_NORMAL\0" /* 71270 */
	"DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE\0" /* 71306 */
	"UNCERTAINTY_REGION_MODE\0" /* 71350 */
	"OUTER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71374 */
	"INNER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71410 */
	"NULL_SQUAD_AA_MASK_ENABLE\0" /* 71446 */
	"COVERAGE_AA_MASK_ENABLE\0" /* 71472 */
	"PREZ_AA_MASK_ENABLE\0" /* 71496 */
	"POSTZ_AA_MASK_ENABLE\0" /* 71516 */
	"CENTROID_SAMPLE_OVERRIDE\0" /* 71537 */
	"MAX_DEALLOCS_IN_WAVE\0" /* 71562 */
	"BASE_256B\0" /* 71583 */
	"MIP0_HEIGHT\0" /* 71593 */
	"MIP0_WIDTH\0" /* 71605 */
	"MIP_LEVEL\0" /* 71616 */
	"MIP0_DEPTH\0" /* 71626 */
	"COLOR_SW_MODE\0" /* 71637 */
	"FMASK_SW_MODE\0" /* 71651 */
	"RESOURCE_TYPE\0" /* 71665 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 31681, 1768, 15296,
	/* 4 */ 31719, 31739, 31751, 31757, 8050, 31761,
	/* 10 */ 31807, 31757, 391, 31816,
	/* 14 */ 31846, 31757, 8540, 31855,
	/* 18 */ 31926, 31931, 31939, 31947,
	/* 22 */ 31973, 31730,
	/* 24 */ 31988, 31998,
	/* 26 */ 36374, 36385, 36401, 36416, 36432, 36446, 36459, 36474, 36489, 36504, 36516, 36535, 36555, 36573, 36592, 36607, 36622, 36644, 36659, 36674, 36689, 36705, 36719, 36746, 36773, 36800, 36827, 36851, 36871,
	/* 55 */ 36890, 36911,
	/* 57 */ 36374, 36385, 36401, 36416, 36432, 36446, 36459, -1, -1, 36504, 36516, 36535, 36555, 36573, -1, -1, 36622, 36644, 36659, 36674, 36689, 36705, 36719, 36746, 36773, 36800, 36827, 36851, 36871,
	/* 86 */ 38753, 38765, 38777, 38789,
	/* 90 */ 39134, -1, -1, -1, -1, -1, -1, -1, 39145, 39157, -1, -1, 39169, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39180,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39206,
	/* 186 */ 39285, 39294, 39303, 39321, 39339, 39348, 39357, 39366,
	/* 194 */ 39415, 39436, 39457, 39480, 39503, 39523, 39543, 39568,
	/* 202 */ 39600, 39624, 39642, 39661, 39681, 39700, 39722, 39747, 39772, 39799, 39826, 39850, 39872, 39900, 39925, 39953,
	/* 218 */ 40061, 40073, 40092, 40111,
	/* 222 */ 40138, 40162, 40180, 40199, 40219, 40238, 40260, 40285, 40310, 40337, 40364, 40388, 40410, 40438, 40463, 40491, 40519, 40541, 40565, 40589, 40613, 40634, 40655, 40680, 40709, 40734, 40760, 40783, 40807, 40834, 40862, 40890, 40918, 40940, 40962, 40986, 41006, 41026, 41046, 41066, 41086, 41106, 41126, 41165, 41204, 41233, 41262, 41291, 41320, 41349, 41378, 41409, 41439, 41470, 41500, 41530, 41561, 41592, 41612, 41634, 41652, 41679, 41703, 41729,
	/* 286 */ 41780, 41801, 41822, 41845, 41868, 41888, 41908, 41933, 41954, 41980, 42000, 42022, 42048, 42069, 42093, 42120,
	/* 302 */ 42240, 42259, 42278, 42297, 42316, 42335, 42354, 42373, 42392, 42407, 42422, 42437, 42454, 42475, 42496, 42516,
	/* 318 */ 42698, 42710, 42724, 42748, 42778, 42803, 42834, 42854,
	/* 326 */ 42920, 42947, 42973, 43000, 43031, 43060, 43090, 43124,
	/* 334 */ 43346, 43369,
	/* 336 */ 43346, 43369, 43409, 43438,
	/* 340 */ 43484, 43505, 43527,
	/* 343 */ 43669, 43701, 43734, 43767,
	/* 347 */ 43946,
	/* 348 */ 44245, 44261, 44277, 44293, 44309, 44325, 44341, 44357, 44373, 44389, 44405, 44421, 44436, 44451, 44466, 44482,
	/* 364 */ 44909, 44940, 44968, 44997,
	/* 368 */ 45042, 45063, 45084, 45105, 45126, -1, -1, 45147, 45168, -1, -1, -1, 45190, 45211, 45232, 45254,
	/* 384 */ 45282, 45295, 45318, 45341, 45364, 45384, 45405, 45426, 45447, 45473, 45499, 45525, 45552, 45579, 45606,
	/* 399 */ 45645, 45670, 45696, 45722, 45748, 45773, 45798,
	/* 406 */ 45834, 45857, 45880, 45903,
	/* 410 */ 45937, 45961, 45985, 46009,
	/* 414 */ 46045, 46070, 46095, 46120,
	/* 418 */ 46163, 46180, 46197, 46214,
	/* 422 */ 44909, 44940, 44968, 46242,
	/* 426 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46357, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46385,
	/* 667 */ 47276, 47294, 47309,
	/* 670 */ 48821, 48831, 48844, 48858,
	/* 674 */ 49155, 49170, 49186, 49202,
	/* 678 */ 49367, 49377, 49395, 49405,
	/* 682 */ 45042, 45063, 45084, -1, 45126, 49804, 49826,
	/* 689 */ 45282, -1, -1, -1, 45364, 45384, 45405, 45426, 45447, 45473, 45499, 45525, 45552, 45579, 45606, -1, 49851, 49878,
	/* 707 */ 49906, 49916, 49921, 49926,
	/* 711 */ 50068, 50084,
	/* 713 */ -1, 23342, 1901, -1, 1953, -1, -1, -1, 17370, -1, -1, -1, -1, -1, -1, -1, 17066, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50215, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50221, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50227, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17104, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50234, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50240, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50246, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31941, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50253, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50260, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50267,
	/* 33482 */ 50622, 50645, 50668, 50691,
	/* 33486 */ 50738, 50763, 50788, 50813,
	/* 33490 */ 50863, 50887, 50911, 50935,
	/* 33494 */ 50967, 50992, 51017, 51042,
	/* 33498 */ 51076, 51101, 51126, 51151,
	/* 33502 */ 51185, 51211, 51237, 51263,
	/* 33506 */ 51299, 51322, 51345, 51368,
	/* 33510 */ 51398, 51432, 51467, 51502,
	/* 33514 */ 51545, 51579, 51614, 51649,
	/* 33518 */ 51692, 51715, 51738, 51761,
	/* 33522 */ 51791, 51825, 51860, 51895,
	/* 33526 */ 51943, 51977, 52012, 52047,
	/* 33530 */ 52095, 52123, 52151, 52179,
	/* 33534 */ 52219, 52258, 52298, 52338,
	/* 33538 */ 52396, 52435, 52475, 52515,
	/* 33542 */ 52668, 52681, 52694, 52707, 52728, 52747, 52765, 52783, 52798, 52815, 52832, 52844, 52855, 52867, 52880, 52892,
	/* 33558 */ 53116,
	/* 33559 */ 53645, 53666, 53687, 53708, 53729,
	/* 33564 */ 53990,
	/* 33565 */ 54170, 54186, 54203, 54220, 54241,
	/* 33570 */ 54334, 54350, 54366, 54383, 54400, 54421, 54445, 54469, 54492, 54515,
	/* 33580 */ 54702, 54729, 54747, 54765, 54787, 54811, 54832, 54851, 54872, 54893, 54915,
	/* 33591 */ 54977, 54983, -1, 54996, -1, -1, -1, 55009, -1, -1, -1, 55021, -1, 55033, -1, 55045,
	/* 33607 */ 55552, 55587, 55622, 55654, 55686, 55718, 55750, 55784,
	/* 33615 */ 55848, 55862, 55875, 55893, 55906, 55919, 55940, 55964,
	/* 33623 */ 56040, 56051, 56061, 56077, 56103, 56119, 56145, 56161, 56187, 56203, 56229, -1, -1, 56254, 56275, 56306, 56323, 56344, 56361, 56382, 56403,
	/* 33644 */ 56449, 56467, 56486, 56503, 56520,
	/* 33649 */ 56648, 56663, 56684, 56706,
	/* 33653 */ 56740, 56756,
	/* 33655 */ 56864, 56875, 56885, 56896, 56908, 56921, 56935, 56947,
	/* 33663 */ 56975, 56985, 56994, 57004, 57015, 57027, 57040, 57051,
	/* 33671 */ 57472, 57483, 57493, 57517, -1, 57528, 57548,
	/* 33678 */ 57566, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57577, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57586, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57604, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57623, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57640, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57652, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57661, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57671, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57680, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57696, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57707, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57724, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57734, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57750, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57758,
	/* 33934 */ 57843, 57850, 57870, 57875,
	/* 33938 */ 58021, 58034, 58053, 58075,
	/* 33942 */ 58456, 58476,
	/* 33944 */ 58488, 58502, 58515,
	/* 33947 */ 60037, 60059, 60079, 60100, 60121,
	/* 33952 */ 60164, 60181, 60197, 60212, 60228, 60244, 60268, 60292, 60316, 60340, 60361, 60377, 60392, 60416, 60439, 60463, 60483, 60502,
	/* 33970 */ 60545, 60558, 60572, 60584, 60597,
	/* 33975 */ 60670, 60687, 60704, 60720, 60736, 60752, 60768, 60785, 60803,
	/* 33984 */ 60866, 60873, 60887, 60901, 60915, 60929,
	/* 33990 */ 60939, 60951, 60962, 60973,
	/* 33994 */ 61145, -1, -1, 61160,
	/* 33998 */ 61799, 61822, 61845,
	/* 34001 */ 61948, 61961, 61974,
	/* 34004 */ 61986, 62004, 62024, 62044,
	/* 34008 */ 62072, 62088, 62105,
	/* 34011 */ 62132, 62147,
	/* 34013 */ -1, 62225, 62248, 62271, 62294, 62309, 62322, 62334, 62351, -1, 62370, 62390, 62410, 62429, -1, 62441, 62458, 62475, 62491, -1, 62507, 62536, 62547, 62573, 62591, 62608, 62627, 62645, 62664, 62680, 62696, 62716, 62738, 62760, 62774, 62793, 62809, -1, -1, 62819, 62834, -1, 62852, 62875, 62900, 62922, 62947, 38489, 38516, 62969, -1, 62997, 63016, 63034, 63054, 63073, 63093, 63117, 63138,
	/* 34072 */ 63581, 63594, 63606,
	/* 34075 */ 63618, 63631, 63643,
	/* 34078 */ 63657, 63671, 63683,
	/* 34081 */ 63814, 63827, 63841,
	/* 34084 */ 63851, 63864, 63874, 63888,
	/* 34088 */ 63916, 63929, 63941, 63960,
	/* 34092 */ 62132, 62147, 64057,
	/* 34095 */ 64075, 64101, 64127, 64152,
	/* 34099 */ 64931, 64942, 64950, 64966,
	/* 34103 */ 64992, 65018, 65043, 65068, 65091, 65112, 65139, 65168,
	/* 34111 */ 65505, 65517, 65530, 65543,
	/* 34115 */ 65563, 65577, 65585, 65594, 65604, 65613, 65625, 65640, 65655, 65672, 65689, 65703, 65715, -1, 65733, -1, 65751, 65763, 65777, 65791, 65805, 65816, 65827,
	/* 34138 */ 65848, 65861, -1, -1, 65874, 65886, 65898, 65910,
	/* 34146 */ 65935, 65944, 65953, 65966,
	/* 34150 */ 66043, 66058, 66076, 66104, 66134, 66165, 66193, 66223,
	/* 34158 */ 66468, 66487, 66507,
	/* 34161 */ 66555, 66574,
	/* 34163 */ 40138, 40162, 40180, 40199, 40219, 40238, 40260, 40285, 40310, 40337, 40364, 40388, 40410, 40438, 40463, 40491, 40519, 40541, 40565, 40589, 40613, 40634, 40655, 40680, 40709, 40734, 40760, 40783, 40807, 40834, 40862, 67168, 40918, 40940, 40962, 40986, 41006, 41026, 41046, 41066, 41086, 41106, 67188, 67216, 67255, 67294, 67316, 67344, 67372, 67405, 67433, 67461, 67494, 67518, 67545, 67578, 67617, 41592, 41612, 67645, 67667, 67689, 67713, 41729,
	/* 34227 */ 41780, 41801, 41822, 41845, 41868, 41888, 67757, 41933, 67783, 41980, 67807,
	/* 34238 */ 67849, 67865, 67881, 67897, 67913, 67929, 67945, 67963, 67980, 67998, 68015, 68032, 68050,
	/* 34251 */ 68085, 68101, 68117, 68133, 68149, 68165, 68181, 68197, 68213, 68230, 68247, 68264, 68282, 68300,
	/* 34265 */ 68337, 68355, 68373, 68391, 68409, 68427, 68445, 68463, 68481, 68499,
	/* 34275 */ 68567, 68583, 68599, 68615, 68631, 68647,
	/* 34281 */ 245, 69618, 48821, 8050,
	/* 34285 */ -1, 62225, 62248, 62271, 62294, 62309, 62322, 62334, 62351, -1, 62370, 62390, 62410, 62429, 70526, 62441, 62458, 62475, 70538, 70549, 62507, 62536, 62547, 62573, 62591, 62608, 62627, 62645, -1, -1, 62696, 62716, 62738, 62760, 62774, 62793, 62809, 70569, -1, 62819, 62834, -1, 62852, 62875, 62900, 62922, 62947, 38489, 38516, 62969, -1, 62997, 63016, 63034, 63054, 63073, 63093, 63117, 63138, -1, -1, 70583, 70603,
	/* 34348 */ 70786, 70802, 70819, 70846,
	/* 34352 */ 42404, 42419, 42434, 8050,
};

#endif
