/*	File name	:	colors.h
 *  Version		:	2.0
 *
 *  Header file for display driver for Mesa 2.0  under 
 *	Windows95, WindowsNT and Win32
 *	This file defines macros and global variables  needed
 *	for converting color format
 *
 *	Copyright (C) 1996-  Li Wei
 *  Address		:		Institute of Artificial Intelligence
 *				:			& Robotics
 *				:		Xi'an Jiaotong University
 *  Email		:		liwei@aiar.xjtu.edu.cn
 *  Web page	:		http://sun.aiar.xjtu.edu.cn
 *
 *  This file and its associations are partially based on the 
 *  Windows NT driver for Mesa, written by Mark Leaming
 *  (mark@rsinc.com).
 */
 
/*
 * $Log: colors.h,v $
 * Revision 2.0  1996/11/15 10:55:00  CST by Li Wei(liwei@aiar.xjtu.edu.cn)
 * Initial revision
 */

char ColorMap16[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,
0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,
0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,
0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,
0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F};


#define BGR16(r,g,b)	((WORD)(((BYTE)(ColorMap16[b]) | ((BYTE)(ColorMap16[g]) << 5)) | (((WORD)(BYTE)(ColorMap16[r])) << 10)))
#define BGR24(r,g,b)	(((DWORD)(((BYTE)(b)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(r))<<16))) << 8)
#define BGR32(r,g,b)	((DWORD)(((BYTE)(b)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(r))<<16)))