.TH XTERM 1 "20 Apr 1987" "X Version 11"
.SH NAME
xterm \- X window system terminal emulator
.SH SYNOPSIS
.B xterm
[ option ] ...
.SH DESCRIPTION
.I Xterm
is the
.I X
window system terminal emulator.
It attempts to emulate a DEC VT102 terminal
to provide a standard terminal type for programs not aware of the window
system directly.
Under 4.3BSD, Ultrix 1.2 and other systems with the capability,
.I xterm
supports the terminal resizing facilities built into the system.
.PP
In addition,
.I xterm
emulates the Tektronix 4015 in a separate window.
.I Note: Tektronix mode is untested for X 11 and guaranteed not to work at this
.I time.
To maintain the correct aspect ratio (height/width), Tektronix graphics will
be restricted to the
largest box with a 4015's aspect ratio that will fit in the window.
This box is located in the upper left area of the window.
.PP
Both windows may be displayed at the same time, though only one window and
mode is active at a time.
Input will be displayed in the active window even if the mouse is in the other
window.
Switching between the active modes is possible under manual (menu) and program
(escape sequence) control.
.PP
.I Xterm
understands the following options.
If the option begins with a
.RB ` + '
instead of a
.RB ` \- ',
the option is restored to its default value.
These options override those set in the ``.Xdefaults'' file (see the
.B "X DEFAULTS"
section).
.TP 12
.B \-132
Normally, the VT102 DECCOLM escape sequence that switches between 80 and
132 column mode is ignored.
This option causes the DECCOLM escape sequence to be recognized, and the
.I xterm
window will resize appropriately.
.TP
.B \-L
indicates that
.I xterm
is being called by
.IR init (8),
and should presume that its file descriptors
are already open on a slave pseudo-tty, and that
.IR getty (8)
should be
run rather than the user's shell.
This option should only be used by
.IR init (8)
.TP
.BI \-b " border"
.I Xterm
maintains an inner border (distance between characters and the window's
border) of one pixel.
The
.B \-b
option allows you to set the size of this border to 
.I border.
.TP
.BI \-bd " color"
On color displays, determines the color of the (highlighted) border.
.TP
.BI \-bg " color"
On color displays, determines the color of the background.
.TP
.BI \-bw " borderwidth"
Allows you to specify the width of the window border in pixels.
.TP
.BI \-cr " color"
On color displays, determines the (highlighted) color of the text cursor;
default is the text (foreground) color.
.TP
.B \-cu
Several programs that use the
.IR curses (3x)
cursor motion package have some difficulties with VT102-compatible terminals.
The bug fixed with this option occurs with
.IR more (1)
on a file containing a line that is exactly the width of the window and
which is followed by line beginning with a tab.
Normally, the leading tabs disappear, but this option causes them to be
displayed correctly.
.TP
.BI \-e " command arguments"
The specified 
.I command
will be executed in the window, rather than
starting a shell.
The command and the optional arguments must appear last on the
.I xterm
command line.
.TP
.BI \-fb " font"
The specified
.I font
will be used instead of the default bold font (which is ``vtbold'').
This font must be the same height and width as the normal font.
If only one of the normal or bold fonts is specified, it will be used as the
normal font and the bold font will be produced by overstriking this font.
.TP
.BI \-fg " color"
On color displays, determines the color of the text (foreground).
.TP
.BI \-fn " font"
The specified
.I font
will be used instead of the default font (which is ``fixed'').
Any fixed width font may be used.
.TP
.B \-i
This option causes
.I xterm
to startup displaying the icon rather than the normal window.
.TP
.B \-j
.I Xterm
will `jump scroll'; when
.I xterm
falls behind scrolling
the screen, it will move multiple lines up at once.
The VT100 escape sequences for smooth scroll can be used to enable/disable
this feature from a program,
or the `Mode Menu' can be used to set it interactively.
.\"TP
.\"B \-k
.TP
.B \-l
Logging is turned on; all input from the pseudo tty is appended to the
logfile.
.TP
.BI \-lf " file"
This
.I file
specifies the file in which the log is written to, rather than the default
``\fBXtermLog.\fIXXXXX\fR'' where
.I XXXXX
is the process id of
.I xterm
(the file is created in the directory
.I xterm
is started in, or the home directory for a login
.IR xterm ).
If
.I file
begins with a ``|'' then the rest of the string is assumed to be a command
to be executed by the shell, and a pipe is opened to the process.
.TP
.B \-ls
This option causes the shell run under
.I xterm
to be a login shell (the user's .login file is read and the initial directory
will be the home directory).
.TP
.B \-mb
This option turns on the right margin bell.
.TP
.BI \-ms " color"
On color displays, determines the color of the mouse cursor; default is the
text cursor color.
.TP
.BI \-n " windowname"
Sets the name of the window for use by a window manager.
If no name is specified, the name "xterm" is used.
.TP
.BI \-nb " number"
This
.I number
is used as the right margin distance in which the margin bell will ring
(the default is 10).
.TP
.B \-r
The screen will be displayed with white characters on a black background,
rather than the default black on white.
This becomes the normal video mode, which is reversed by turning on the
reverse video mode.
.TP
.B \-rv
Same as
.BR \-r .
.TP
.B \-rw
This options turns on reverse-wraparound mode, that allows the cursor to
wraparound from the leftmost column to the rightmost column of the previous
line.
This is very useful in the shell to allow erasure backwards across the
previous line.
.TP
.B \-s
When this option is specified, xterm no longer scrolls synchronously
with the display.
.I Xterm
no longer attempts to keep the screen completely up to date while
scrolling, but can then run faster when network latencies are very high.
This is typically useful when using
.I xterm
across a very large internet or many hops.
.TP
.B \-sb
This option causes the scrollbar to be displayed during startup, with the
saving of lines scrolled off the top of the window being turned on.
.TP
.B \-si
When using the scrollbar to review previous lines of text, the window is
normally repositioned automatically at the
bottom of the scroll region when input has arrived.  This option disables
repositioning on input.
.TP
.B \-sk
When using the scrollbar to review pass lines of text, this option
causes the window to be repositioned automatically in the normal postion at the
bottom of the scroll region when a key is pressed.
.TP
.BI \-sl " number"
The
.I number
specifies the maximum number of lines to save that are scrolled off the top
of the window.
The default is 64 lines.
.TP
.B \-sn
By default, the status line is in revere-video (relative to the rest of the
window).
This option causes the status line to be in normal video (the status line
is still enclosed in a box).
.TP
.B \-st
This option causes the status line to be displayed on startup.
.TP
.B \-t
This option causes the initial
.I xterm
window to be the Tektronix window, rather than the normal VT102 window.
.TP
.B \-vb
This option turns on the visual bell mode, which flashes the window on
receipt of a CTRL-G.
.TP
.B \-w
Same as
.BR \-bw .
.TP
.BI = geometry
.I Xterm
will take a normal X geometry specification for the VT102 window.
This takes the form of ``\fB=\fIwidth\fBx\fIheight\fB+\fIxoff\fB+\fIyoff\fR''.
See
.IR X (1)
for details of this specification.
.TP
.BI % geometry
This geometry specification applies to the Tektronix window.
.TP
.BI # geometry
This geometry specification applies to the icon position (the width and
height information are optional and otherwise ignored).
.TP
.IB host : display
Normally,
.I xterm
gets the host and display number to use from the environment
variable ``DISPLAY''.
One can, however specify them explicitly.
The
.I host
specifies which machine to create the window on, and
the
.I display
argument specifies the display number.
For example,
``orpheus:1'' creates a shell window on display one on the machine
orpheus.
.SH "X DEFAULTS"
.I Xterm
allows you to preset defaults in a customization file in your home
directory, called
.BR .Xdefaults .
The format of the file is ``programname.keyword:string''.
See
.IR X (1)
for more details.
.I Xterm
obeys the convention for `MakeWindow' defaults.
Keywords recognized by
.I xterm
are listed below.
.TP 15
.B Background
Set the background color.
.TP
.B BodyFont
Set the default font.
.TP
.B BoldFont
Specify a default bold font.
.TP
.B Border
Set the border color.
.TP
.B BorderWidth
Set the border width of the window.
.TP
.B C132
If ``on'', allow the DECCOLM escape sequence to switch between 80 and 132
column mode.
.TP
.B Curses
If ``on'', enable the
.IR curses (3x)
fix.
.TP
.B Cursor
Set the text cursor color.
.TP
.B CursorShape
If ``arrow'', use the arrow mouse cursor rather than the I-beam mouse cursor.
.TP
.B Foreground
Set the text color.
.TP
.B Geometry
Set the window geometry (position and size).
.TP
.B IconStartup
If ``on'', initially display the icon rather than the normal window.
.TP
.B InternalBorder
Set the space between the text and window border.
This is called padding above.
.TP
.B JumpScroll
If ``on'', jump scroll is enabled.
.\"TP
.\"B KeyBoard
.TP
.B LogFile
Specifies the log file or command to pipe to when logging is activated.
.TP
.B Logging
If ``on'', turn logging on initially.
.TP
.B LogInhibit
If ``on'', totally inhibit logging from being turned on.
.TP
.B LoginShell
If ``on'', make the shell executed a login shell.
.TP
.B MarginBell
If ``on'', turn on the margin bell.
.TP
.B Mouse
Set the mouse cursor color.
.TP
.B MultiScroll
Allows xterm to scroll asynchronously with the display.
.TP
.B NMarginBell
Set the margin bell right margin distance.
.TP
.B ReverseVideo
If ``on'', reverse the definition of foreground and background color.
.TP
.B ReverseWrap
If ``on'', turn on the reverse wraparound mode.
.TP
.B SaveLines
Set the number of lines to save when scrolled of the top of the window.
.TP
.B ScrollBar
If ``on'', show the scrollbar initially.
.TP
.B ScrollInput
If ``off'', disable repositioning the scroll region at the bottom if
new input has arrived.
.TP
.B ScrollKey
If ``on'', reposition the scroll region at the bottom if
a key is pressed.
.TP
.B SignalInhibit
If ``on'', totally inhibit the sending of signals from the
.B xterm
menu.
.TP
.B StatusLine
If ``on'', show the status line on startup.
.TP
.B StatusNormal
If ``on'', make the status line normal video.
.TP
.B TekInhibit
If ``on'', totally inhibit going into Tektronix mode.
.TP
.B VisualBell
If ``on'', turn on visual bell mode at startup.
.SH EMULATIONS
The VT102 emulation is fairly complete, but does not support the blinking
character attribute nor the double-wide and double-size character sets.
.IR Termcap (5)
entries that work with
.I xterm
include ``xterm'', ``vt102'', ``vt100'' and ``ansi'', and
.I xterm
automatically searches the termcap file in this order for these entries and then
sets the ``TERM'' and the ``TERMCAP'' environment variables.
.PP
Many of the special
.I xterm
features (like logging) may be modified under program control
through a set of escape sequences different from the standard VT102 escape
sequences.  
(See the
.I ``Xterm Control Sequences''
document.)
.PP
The Tektronix 4015 emulation is also fairly good.
Four different font sizes and five different lines types are supported.
The Tektronix text and graphics commands are recorded internally by
.I xterm
and may be written to a file by sending the COPY escape sequence (or through
the
.B Tektronix
menu; see below).
The name of the file will be
``\fBCOPY\fIyy\fB\-\fIMM\fB\-\fIdd\fB.\fIhh\fB:\fImm\fB:\fIss\fR'', where
.IR yy ,
.IR MM ,
.IR dd ,
.IR hh ,
.I mm
and
.I ss
are the year, month, day, hour, minute and second when the COPY was performed
(the file is created in the directory
.I xterm
is started in, or the home directory for a login
.IR xterm ).
.SH "MOUSE USAGE"
.PP
Once the VT102 window is created,
.I xterm
allows you to select text and copy it within the same or other windows.
.PP
The selection functions are invoked when the mouse buttons are used with no
modifiers, and when they are used with the ``shift'' key.
.PP
The left button is used to save text into the cut buffer.
Move the cursor to beginning of the text,
and then hold the button down while moving the cursor to the end of the region
and releasing the button.
The selected text is highlighted and is saved in the global cut buffer when
the button is released.  Double-clicking selects by words.  Triple-clicking
selects by lines.  Quadruple-clicking goes back to characters, etc.
Multiple-click is determined by the time from button up to
button down, so you can change the selection unit in the middle of a selection.
.PP
The middle button `types' (pastes) the text from the cut buffer,
inserting it as keyboard input.
.PP
The right button extends the current selection.  (Without loss of generality,
that is you can swap ``right'' and ``left'' everywhere in the rest of this
paragraph...)  If pressed while closer to
the right edge of the selection than the left, it extends/contracts the
right edge of the selection.  If you contract the selection past
the left edge of the selection,
.I xterm
assumes you really meant the left edge, restores the original selection, then
extends/contracts the left edge of the selection.  Extension starts in the 
selection unit mode
that the last selection or extension was performed in; you can multiple-click
to cycle through them.
.PP
By cutting and pasting pieces of text without trailing new lines,
you can take text from several places in different windows and form a command
to the shell, for example, or take output from a program and insert it into
your favorite editor.
Since the cut buffer is globally shared among different applications,
you should regard it as a `file' whose contents you know.
The terminal emulator and other text programs should be treating it as if it
were a text file, i.e. the text is delimited by new lines.
.PP
The scroll region displays the position and amount of text currently showing
in the window (highlighted) relative to the amount of text actually saved.
As more text is saved (up to the maximum), the size of the highlighted area
decreases.  
.PP
Clicking the mouse with the left button in the scroll region moves the
corresponding line to the top of the display window.
.PP
Clicking the right button moves the top line of the display window down to the
mouse position.
.PP
Clicking the middle button moves the display to a position in the saved text
that corresponds to the mouse's position in the scrollbar.
.PP
.PP
Unlike the VT102 window, the Tektronix window dows not allow the copying of
text.
It does allow Tektronix GIN mode, and in this mode
the cursor will change from an arrow to a cross.
Pressing any key will send that key and the current coordinate of the
cross cursor.
Pressing the left, middle or right button will return the letters `l', `m', and
`r', respectively.
If the `shift' key is pressed when a mouse buton is pressed, the corresponding
upper case letter is sent.
To distinquish a mouse button from a key, the high bit of the character is
set (but this is bit is normally stripped unless the terminal mode is RAW;
see
.IR tty (4)
for details).
.SH MENUS
.PP
.I Xterm
has three different menus, named
.BR xterm ,
.BR Modes ,
and
.BR Tektronix.
Each menu pops up under the correct combinations of key and button presses.
Most menus are divided into two section, separated by a horizontal line.
The top portion contains various modes that can be altered.
A check mark appears next to a mode that is currently active.
Selecting one of these modes toggles its state.
The bottom portion of the menu are command entries; selecting one of these
performs the indicated function.
.PP
The
.B xterm
menu pops up when the ``control'' and ``shift'' keys and the left button are
pressed in a window.
The menu title gives the version number of
.IR xterm .
The modes section contains items that apply to both the VT102 and Tektronix
windows.
Notable entries in the command section of the menu are the
.BR Continue ,
.BR Suspend ,
.BR Interrupt ,
.BR Hangup ,
.B Terminate
and
.B Kill
which sends the SIGCONT, SIGTSTP, SIGINT, SIGHUP, SIGTERM and
SIGKILL signals, respectively, to the process group of the process running
under
.I xterm
(usually the shell).
The
.B Continue
function is especially useful if the user has accidentally typed CTRL-Z,
suspending the process.
.PP
The
.B Modes
menu sets various modes in the VT102 emulation, and is popped up with the
``control'', ``shift'', and middle button combination in the VT102 window.
In the command section of this menu, the soft reset entry will reset
scroll regions.
This can be convenient when some program has left the scroll regions
set incorrectly (often a problem when using VMS or TOPS-20).
The full reset entry will clear the screen, reset tabs to every
eight columns, and reset the terminal modes (such as wrap and smooth scroll)
to there initial states just after
.I xterm
has finish processing the command line options.
The
.B Tektronix
menu sets various modes in the Tektronix emulation, and is popped up with the
``control'', ``shift'',  and middle button combination in the Tektronix window.
The current font size is checked in the modes section of the menu.
The
.B PAGE
entry in the command section clears the Tektronix window.
.SH "OTHER FEATURES"
.I Xterm
automatically highlights the window border and text cursor when the
mouse enters the window (selected) and unhighlights them when the mouse
leaves the window (unselected).
If the window is the focus window, then the window is highlighted no matter
where the mouse is.
.PP
In VT102 mode, there are escape sequences to activate and deactivate
an alternate screen buffer, which is the same size as the display area
of the window.
When activated, the current screen is saved and replace with the alternate
screen.
Saving of lines scrolled off the top of the window is disabled until the
normal screen is restored.
The
.IR termcap (5)
entry for
.I xterm
allows the visual editor
.IR vi (1)
to switch to the alternate screen for editing, and restore the screen
on exit.  
.PP
In either VT102 or Tektronix mode, there are escape sequences to change the
name of the windows  to specify a new log file name.
.SH ENVIRONMENT
.I Xterm
sets the environment variables ``TERM'' and ``TERMCAP'' properly for the
size window you have created.
It also uses and sets the environment
variable ``DISPLAY'' to specify which bit map display terminal to use.
The environment variable ``WINDOWID'' is set to the X window id number
of the
.I xterm
window.
.SH "SEE ALSO"
resize(1), X(1), pty(4), tty(4)
.br
.I ``Xterm Control Sequences''
.SH BUGS
XTERM WILL HANG FOREVER IF YOU TRY TO PASTE TOO MUCH TEXT AT ONE TIME !!!  IT
IS BOTH PRODUCER AND CONSUMER FOR THE PTY AND SCREWS ITSELF.
Tektronix mode is **not** working in this version.
There is currently no way for a
.I xterm
window not to highlight itself when the mouse cursor enter it
while another window is the keyboard focus.
There needs to be a dialog box to allow entry of log file name
and the COPY file name.
Many of the options are not resettable after
.I xterm
starts.
.SH AUTHORS
Loretta Guarino Reid (DEC-UEG-WSL), 
Joel McCormack (DEC-UEG-WSL), Terry Weissman (DEC-UEG-WSL),
Edward Moy (Berkeley), Ralph R. Swick (MIT-Athena),
Mark Vandevoorde (MIT-Athena), Bob McNamara (DEC-MAD),
Jim Gettys (MIT-Athena), Bob Scheifler (MIT-LCS), Doug Mink (SAO).
.sp
VMS and TOPS-20 are trademarks of Digital Equipment Corporation.
.sp
Copyright (c) 1984, 1985, 1986, 1987 by Massachusetts Institute of Technology.
.br
See
.IR X (1)
for a full copyright notice.
