.TH XSERVER 1 "26 October 1988"  "X Version 11"
.SH NAME
X - X Window System server
.SH SYNOPSIS
.B X
[:displaynumber] [-option ...] [ttyname]
.SH DESCRIPTION
.I X
is the generic name for the X Window System server.  It is frequently a link
or a copy of the appropriate server binary for driving the most frequently
used server on a given machine.  The sample server from MIT supports the
following platforms:
.sp
.ta 1.25in
.in +4
.nf
Xqvss	Digital monochrome vaxstationII or II
Xqdss	Digital color vaxstationII or II
Xsun	Sun monochrome or color Sun 2, 3, or 4
Xhp	HP Topcat 9000s300
Xapollo	Apollo monochrome (Domain/IX 9.6)
Xibm	IBM APA and megapel PC/RT
XmacII	Apple monochrome Macintosh II
Xplx	Parallax color and video graphics controller
.fi
.in -4
.SH "STARTING THE SERVER"
The server is usually started from the X Display Manager program \fIxdm\fP.
This utility is run from the system boot files and takes care of keeping
the server running, prompting for usernames and passwords, and starting up
the user sessions.  It is easily configured for sites that wish to provide
nice, consistent interfaces for novice users (loading convenient sets of
resources, starting up a window manager, clock, and nice selection of 
terminal emulator windows).
.PP
Since \fIxdm\fP now handles automatic starting of the server in a portable
way, the \fI-L\fP option to \fIxterm\fP is now considered obsolete.  Support
for starting a login window from 4.3bsd-derived \fI/etc/ttys\fP files
may not be included in future releases.
.PP
Installations that run more than one window system will still need to use the
\fIxinit\fP utility.  However, \fIxinit\fP is to be considered a tool for
building startup scripts and is not intended for use by end users.  Site
adminstrators are \fBstrongly\fP urged to build nicer interfaces for novice
users.
.PP
When the sample server starts up, it takes over the display.  If you 
are running on a workstation whose console is the display, you cannot log into
the console while the server is running.
.SH "NETWORK CONNECTIONS"
The sample server supports connections made using the following reliable
byte-streams:
.TP 4
.I TCP\/IP
.br
The server listens on port htons(6000+\fIn\fP), where \fIn\fP is the 
display number.
.TP 4
.I "Unix Domain"
The sample server uses \fI/tmp/.X11-unix/X\fBn\fR as the filename for 
the socket, where \fIn\fP is the display number.
.TP 4
.I "DECnet"
.br
The server responds to connections to object \fIX$X\fBn\fR, where \fIn\fP
is the display number.
.SH OPTIONS
All of the sample servers accept the following command line options:
.TP 8
.B \-a \fInumber\fP
sets pointer acceleration (i.e. the ratio of how much is reported to how much
the user actually moved the pointer).
.TP 8
.B \-bs
disables backing store support on all screens.
.TP 8
.B \-c
turns off key-click.
.TP 8
.B c \fIvolume\fP
sets key-click volume (allowable range: 0-8).
.TP 8
.B \-f \fIvolume\fP
sets feep (bell) volume (allowable range: 0-7).
.TP 8
.B \-logo
turns on the X Window System logo display in the screen-saver.
There is currently no way to change this from a client.
.TP 8
.B nologo
turns off the X Window System logo display in the screen-saver.
There is currently no way to change this from a client.
.TP 8
.B \-p \fIminutes\fP
sets screen-saver pattern cycle time in minutes.
.TP 8
.B \-r
turns off auto-repeat.
.TP 8
.B r
turns on auto-repeat.
.TP 8
.B \-s \fIminutes\fP
sets screen-saver timeout time in minutes.
.TP 8
.B \-su
disables save under support on all screens.
.TP 8
.B \-t \fInumbers\fP
sets pointer acceleration threshold in pixels (i.e. after how many pixels
pointer acceleration should take effect).
.TP 8
.B \-to \fIseconds\fP
sets default screensaver timeout in seconds.
.TP 8
.B v
sets video-on screen-saver preference.
.TP 8
.B \-v
sets video-off screen-saver preference
.TP 8
.B \-co \fIfilename\fP
sets name of RGB color database
.TP 8
.B \-help
prints a usage message
.TP 8
.B \-fp \fIfontPath
sets the search path for fonts
.TP 8
.B \-fc \fIcursorFont\fP
sets default cursor font
.TP 8
.B \-fn \fIfont\fP
sets the default font
.TP 8
.B \-wm
forces the default backing-store of all windows to be WhenMapped;
a cheap trick way of getting backing-store to apply to all windows.
.PP
Many servers also have device-specific command line options.  See the
manual pages for the individual servers for more details.
.SH "SECURITY"
.PP
The sample server uses an access control list for deciding whether or not
to accept connections from clients on a particular machine.  This list
initially consists of the host on which the server is running as well as
any machines listed in the file \fI/etc/X\fBn\fI.hosts\fR, where \fBn\fP
is the display number of the server.  Each line of the file should contain
either an Internet hostname (e.g. expo.lcs.mit.edu) or a DECnet hostname
in double colon format (e.g. hydra::).  There should be no leading or
trailing spaces on any lines.  For example:
.sp
.in +8
.nf 
joesworkstation
corporate.company.com
star::
bigcpu::
.fi
.in -8
.PP
Users can add or remove hosts from this list and enable or disable access
control using the \fIxhost\fP command from the same machine as the server.
For example:
.sp
.in +8
.nf
%  xhost +janesworkstation
janesworkstation being added to access control list
%  xhost -star::
public:: being removed from access control list
%  xhost +
all hosts being allowed (access control disabled)
%  xhost -
all hosts being restricted (access control enabled)
%  xhost
access control enabled (only the following hosts are allowed)
joesworkstation
janesworkstation
corporate.company.com
bigcpu::
.fi
.in -8
.PP
Unlike some window systems, X does not have any notion of window operation
permissions or place any restrictions on what a client can do; if a program can
connect to a display, it has full run of the screen.  The core protocol does
have support for providing authentication information when establishing
connections, but is not used in the sample implementation.  Sites that have
authentication and authorization systems (such as Kerberos) might wish to make
use of the hooks in the libraries and the server to provide additional
security. 
.SH "SIGNALS"
The sample server attaches special meaning to the following signals:
.TP 8
.I SIGHUP
This signal causes the server to close all existing connections, free all
resources, and restore all defaults.  It is sent by the display manager
whenever the main user's main application (usually an \fIxterm\fP or window
manager) exits to force the server to clean up and prepare for the next
user.
.TP 8
.I SIGTERM
This signal causes the server to exit cleanly.
.SH "FONTS"
Fonts are usually stored as individual files in directories.  The list of
directories in which the server looks when trying to open a font is controlled
by the \fIfont path\fP.  Although most sites will choose to have the server
start up with the appropriate font path (using the \fI-fp\fP option mentioned
above), it can be overridden using the \fIxset\fP program.
.PP
The default font path for
the sample server contains three directories:
.TP 8
.I /usr/lib/X11/fonts/misc
This directory contains several miscellaneous fonts that are useful on all
systems.  It contains a very small family of fixed-width fonts (\fB6x10\fP, 
\fB6x12\fP, \fB6x13\fP, \fB8x13\fP, \fB8x13bold\fP, and \fB9x15\fP) and the
cursor font.  It also has font name aliases for the commonly used fonts
\fBfixed\fP and \fBvariable\fP.
.TP 8
.I /usr/lib/X11/fonts/75dpi
This directory contains fonts contributed by Adobe Systems, Inc. and
Digital Equipment Corporation and by Bitstream, Inc.
for 75 dots per inch displays.  An integrated selection of sizes, styles, 
and weights are provided for each family.
.TP 8
.I /usr/lib/X11/fonts/100dpi
This directory contains versions of some of 
the fonts in the \fI75dpi\fP directory
for 100 dots per inch displays.
.PP
Font databases are created by running the \fImkfontdir\fP program in the
directory containing the compiled versions of the fonts (the \fI.snf\fP files).
Whenever fonts are added to a directory, \fImkfontdir\fP should be rerun
so that the server can find the new fonts.  \fBIf \fImkfontdir\fP is not
run, the server will not be able to find any fonts in the directory.\fR
.SH DIAGNOSTICS
Too numerous to list them all.
If run from \fIinit(8)\fP, errors are logged in the file \fI/usr/adm/X*msgs\fP,
.SH FILES
.TP 30
/etc/X*.hosts
Initial access control list
.TP 30
/usr/lib/X11/fonts/misc, /usr/lib/X11/fonts/75dpi, /usr/lib/X11/fonts/100dpi 
Font directories
.TP 30
/usr/lib/X11/rgb.txt
Color database
.TP 30
/tmp/.X11-unix/X*
Unix domain socket
.TP 30
/usr/adm/X*msgs
Error log file
.SH "SEE ALSO"
X(1), xdm(1), mkfontdir(1),
xinit(1), xterm(1), uwm(1), xhost(1), xset(1), xsetroot(1), 
ttys(5), init(8), Xqdss(1), Xqvss(1), Xsun(1), Xapollo(1), XmacII(1)
.I "X Window System Protocol,"
.I "Definition of the Porting Layer for the X v11 Sample Server,"
.I "Strategies for Porting the X v11 Sample Server,"
.I "Godzilla's Guide to Porting the X V11 Sample Server"
.SH BUGS
The option syntax is inconsistent with itself and \fIxset(1)\fP.
.PP
The acceleration option should take a numerator and a denominator like the
protocol.
.PP
If
.I X
dies before its clients, new clients won't be able to connect until all
existing connections have their TCP TIME_WAIT timers expire.
.PP
The color database is missing a large number of colors.  However, there
doesn't seem to be a better one available that can generate RGB values
tailorable to particular displays.
.PP
The \fIxterm -L\fP method for starting an initial window from \fI/etc/ttys\fP
is completely inadequate and should be removed.  People should use \fIxdm\fP
instead.
.SH COPYRIGHT
Copyright 1984, 1985, 1986, 1987, 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
The sample server was originally written by
Susan Angebranndt, Raymond Drewry, Philip Karlton, and Todd Newman,
with support from a cast of thouands.  See also the file \fIdoc/contributors\fP
in the sample distribution for a more complete list.
