.\" $XConsortium: XF86VM.man /main/5 1996/12/09 17:45:43 kaleb $
.\"
.\"
.\"
.\"
.\" Copyright (c) 1996  Joe Moss, The XFree86 Project
.\" $XFree86: xc/programs/Xserver/hw/xfree86/doc/man/XF86VM.man,v 3.4 1996/10/26 09:38:04 dawes Exp $
.\" 
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.TH XF86VIDMODE 3X11 "Release 6.3 (XFree86 3.2)" "X Version 11" "X FUNCTIONS"
.SH NAME
XF86VidModeQueryExtension, XF86VidModeQueryVersion, XF86VidModeGetModeLine, XF86VidModeGetAllModeLines, XF86VidModeDeleteModeLine, XF86VidModeModModeLine, XF86VidModeValidateModeLine, XF86VidModeSwitchMode, XF86VidModeSwitchToMode, XF86VidModeLockModeSwitch, XF86VidModeGetMonitor, XF86VidModeGetViewPort, XF86VidModeSetViewPort \- XFree86-VidMode extension interface functions
.SH SYNTAX
.nf
.LP
#include <X11/extensions/xf86vmode.h>
.LP
Bool XF86VidModeQueryExtension(
    Display *\fIdisplay\fP\^,
    int *\fIevent_base_return\fP\^,
    int *\fIerror_base_return\fP\^);
.LP
Bool XF86VidModeQueryVersion(
    Display *\fIdisplay\fP\^,
    int *\fImajor_version_return\fP\^,
    int *\fIminor_version_return\fP\^);
.LP
Bool XF86VidModeGetModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIdotclock_return\fP\^,
    XF86VidModeModeLine *\fImodeline\fP\^);
.LP
Bool XF86VidModeGetAllModeLines(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fImodecount_return\fP\^,
    XF86VidModeModeInfo **\fImodesinfo\fP\^);
.ig
.LP
Bool XF86VidModeAddModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeInfo *\fImodeline\fP\,
    XF86VidModeModeInfo *\fIaftermode\fP\^);
..
.LP
Bool XF86VidModeDeleteModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeInfo *\fImodeline\fP\^);
.LP
Bool XF86VidModeModModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeLine *\fImodeline\fP\^);
.LP
Status XF86VidModeValidateModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeLine *\fImodeline\fP\^);
.LP
Bool XF86VidModeSwitchMode(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIzoom\fP\^);
.LP
Bool XF86VidModeSwitchToMode(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeInfo *\fImodeline\fP\^);
.LP
Bool XF86VidModeLockModeSwitch(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIlock\fP\^);
.LP
Bool XF86VidModeGetMonitor(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeMonitor *\fImonitor\fP\^);
.LP
Bool XF86VidModeGetViewPort(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIx_return\fP\^,
    int *\fIy_return\fP\^);
.LP
Bool XF86VidModeSetViewPort(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIx\fP\^,
    int \fIy\fP\^);
.fi
.SH ARGUMENTS
.IP \fIdisplay\fP 2i
Specifies the connection to the X server.
.IP \fIscreen\fP 2i
Specifies which screen number the setting apply to.
.IP \fIevent_base_return\fP 2i
Returns the base event number for the extension.
.IP \fIerror_base_return\fP 2i
Returns the base error number for the extension.
.IP \fImajor_version_return\fP 2i
Returns the major version number of the extension.
.IP \fIminor_version_return\fP 2i
Returns the minor version number of the extension.
.IP \fIdotclock_return\fP 2i
Returns the clock for the mode line.
.IP \fImodecount_return\fP 2i
Returns the number of video modes available in the server.
.IP \fIzoom\fP 2i
If greater than zero, indicates that the server should switch to
the next mode, otherwise switch to the previous mode.
.IP \fIlock\fP 2i
Indicates that mode switching should be locked, if non-zero.
.IP \fImodeline\fP 2i
Specifies or returns the timing values for a video mode.
.ig
.IP \fIaftermode\fP 2i
Specifies the timing values for the video mode after which the
new mode will added.
..
.IP \fImodesinfo\fP 2i
Returns the timing values and dotclocks for all of the available
video modes.
.IP \fImonitor\fP 2i
Returns information about the monitor.
.IP \fIx\fP 2i
Specifies the desired X location for the viewport.
.IP \fIx_return\fP 2i
Returns the current X location of the viewport.
.IP \fIy\fP 2i
Specifies the desired Y location for the viewport.
.IP \fIy_return\fP 2i
Returns the current Y location of the viewport.
.SH STRUCTURES
.nf
.ta 2.25i 3.5i
\fIVideo Mode Settings:\fP
typedef struct {
    unsigned short	hdisplay;	/* Number of display pixels horizontally */
    unsigned short	hsyncstart;	/* Horizontal sync start */
    unsigned short	hsyncend;	/* Horizontal sync end */
    unsigned short	htotal;	/* Total horizontal pixels */
    unsigned short	vdisplay;	/* Number of display pixels vertically */
    unsigned short	vsyncstart;	/* Vertical sync start */
    unsigned short	vsyncend;	/* Vertical sync start */
    unsigned short	vtotal;	/* Total vertical pixels */
    unsigned int	flags;	/* Mode flags */
    int	privsize;	/* Size of private */
    INT32	*private;	/* Server privates */
} XF86VidModeModeLine;
.sp
typedef struct {
    unsigned int	dotclock;	/* Pixel clock */
    unsigned short	hdisplay;	/* Number of display pixels horizontally */
    unsigned short	hsyncstart;	/* Horizontal sync start */
    unsigned short	hsyncend;	/* Horizontal sync end */
    unsigned short	htotal;	/* Total horizontal pixels */
    unsigned short	vdisplay;	/* Number of display pixels vertically */
    unsigned short	vsyncstart;	/* Vertical sync start */
    unsigned short	vsyncend;	/* Vertical sync start */
    unsigned short	vtotal;	/* Total vertical pixels */
    unsigned int	flags;	/* Mode flags */
    int	privsize;	/* Size of private */
    INT32	*private;	/* Server privates */
} XF86VidModeModeInfo;
.LP
\fIMonitor information:\fP
typedef struct {
    char*	vendor;	/* Name of manufacturer */
    char*	model;	/* Model name */
    float	bandwidth;	/* Monitor bandwidth */
    unsigned char	nhsync;	/* Number of horiz sync ranges */
    XF86VidModeSyncRange*	hsync;	/* Horizontal sync ranges */
    unsigned char	nvsync;	/* Number of vert sync ranges */
    XF86VidModeSyncRange*	vsync;	/* Vertical sync ranges */
} XF86VidModeMonitor;
.sp
typedef struct {
    float	hi;	/* Top of range */
    float	lo;	/* Bottom of range */
} XF86VidModeSyncRange;
.fi
.SH DESCRIPTION
These functions provide an interface to the server extension
\fIXFree86-VidModeExtension\fP
which allows the video modes to be
queried and adjusted dynamically and mode switching to be controlled.
Applications that use these functions must be linked with
.ZN -lXxf86vm
.SS "MODELINE FUNCTIONS"
The
.ZN XF86VidModeGetModeLine
function is used to query the settings for the currently selected
video mode.  The calling program should pass a pointer to a 
.ZN XF86VidModeModeLine
structure that it has already allocated.  The function fills in
the fields of the structure.
.PP
If there are any server private values (currently only applicable to
the S3 server) the function will allocate storage for them.
Therefore, if the
.ZN privsize
field is non-zero, the calling program should call
.ZN Xfree(private)
to free the storage.
.PP
.ZN XF86VidModeGetAllModeLines
returns the settings for all video modes.
The calling program supplies the address of a pointer which will be
set by the function to point to an array of
.ZN XF86VidModeModeInfo
structures.  The memory occupied by the array is dynamically allocated
by the
.ZN XF86VidModeGetAllModeLines
function and should be freed by the caller.
The first element of the array corresponds to the current video mode.
.PP
The
.ZN XF86VidModeModModeLine
function can be used to change the settings of the current video mode
provided the requested settings are valid (e.g. they don't exceed the
capabilities of the monitor).
.PP
.ig
To add a mode to the list of available modes, the
.ZN XF86VidModeAddModeLine
function can be used.
Assuming the settings are valid, the video mode will be added after
the existing mode which matches the timings specified by the
.ZN aftermode
parameter.
To be considered a match, all of the fields of the given
.ZN XF86VidModeModeInfo
structure must match, except the
.ZN privsize
and
.ZN private
fields.
If the
.ZN aftermode
parameter is zero, the mode will be added
after the current mode.
.PP
..
Modes can be deleted with the
.ZN XF86VidModeDeleteModeLine
function.  The specified mode must match an existing mode.
To be considered a match, all of the fields of the given
.ZN XF86VidModeModeInfo
structure must match, except the
.ZN privsize
and
.ZN private
fields.
If the mode to be deleted is the current mode, a mode switch
to the next mode will occur first.  The last remaining mode can not
be deleted.
.PP
The validity of a mode can be checked with the
.ZN XF86VidModeValidateModeLine
function.
If the specified mode can be used by the server (i.e. meets all the
constraints placed upon a mode by the combination of the server, card,
and monitor) the function returns
.ZN MODE_OK ,
otherwise it returns a value indicating the reason why the mode is
invalid (as defined in \fIxf86.h\fP)
.SS "MODE SWITCH FUNCTIONS"
When the function
.ZN XF86VidModeSwitchMode
is called, the server will change the video mode to next (or previous)
video mode. The
.ZN XF86VidModeSwitchToMode
function can be used to switch directly to the specified mode.
Matching is as specified in the description of the
.ZN XF86VidModeAddModeLine
function above.
The
.ZN XF86VidModeLockModeSwitch
function can be used to allow or disallow mode switching whether
the request to switch modes comes from a call to the
.ZN XF86VidModeSwitchMode
or
.ZN XF86VidModeSwitchToMode
functions or from one of the mode switch key sequences.
.SS "MONITOR FUNCTIONS"
Information known to the server about the monitor is returned by the
.ZN XF86VidModeGetMonitor
function.  The
.ZN hsync
and
.ZN vsync
fields each point to an array of
.ZN XF86VidModeSyncRange
structures.  The arrays contain
.ZN nhsync
and
.ZN nvsync
elements, respectively.
The
.ZN hi
and
.ZN low
values will be equal if a discreate value was given in the
.ZN XF86Config
file.
.PP
The
.ZN vendor ,
.ZN model ,
.ZN hsync ,
and
.ZN vsync
fields point to dynamically allocated storage that should be freed
by the caller.
.SS "VIEWPORT FUNCTIONS"
The
.ZN XF86VidModeGetViewPort
and
.ZN XF86VidModeSetViewPort
functions can be used to, respectively, query and change the location
of the upper left corner of the viewport into the virtual screen.
.SS "OTHER FUNCTIONS"
The
.ZN XF86VidModeQueryVersion
function can be used to determine the version of the extension
built into the server.
.PP
The function
.ZN XF86VidModeQueryExtension
returns the lowest numbered error and event values
assigned to the extension.
.SH SEE ALSO
XFree86(1), XF86Config(4/5), xvidtune(1)
.SH AUTHORS
Kaleb Keithley, Jon Tombs, David Dawes, and Joe Moss

