.\" $Xorg: rstartd.man,v 1.3 2000/08/17 19:54:01 cpqbld Exp $
.\" Copyright (c) 1993 Quarterdeck Office Systems
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and
.\" its documentation for any purpose is hereby granted without fee, provided
.\" that the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name Quarterdeck Office Systems, Inc. not
.\" be used in advertising or publicity pertaining to distribution of this
.\" software without specific, written prior permission.
.\" 
.\" THIS SOFTWARE IS PROVIDED `AS-IS'.  QUARTERDECK OFFICE SYSTEMS, INC.,
.\" DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL QUARTERDECK
.\" OFFICE SYSTEMS, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE,
.\" DATA, OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND
.\" REGARDLESS OF WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING
.\" OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.hy 0		\" I hate hyphenation.
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.ta .3i .6i .9i 1.2i 1.5i 1.8i
.TH RSTARTD 1 "Release 6.4" "X Version 11"
.SH NAME
rstartd - a sample implementation of a Remote Start rsh helper
.SH SYNOPSIS
.B "rstartd"
.PP
.B "rstartd.real"
[\-c \fIconfigfilename\fP]
.SH DESCRIPTION
.PP
\fIRstartd\fP is an implementation of a Remote Start "helper" as defined in
"A Flexible Remote Execution Protocol Based on \fBrsh\fP".
.PP
This document describes the peculiarities of \fIrstartd\fP and how it is
configured.
.SH OPTIONS
.TP 8
.B \-c \fIconfigfilename\fP
This option specifies the "global" configuration file that \fIrstartd\fP
is to read.  Normally, \fIrstartd\fP is a shell script that invokes
\fIrstartd.real\fP with the \fB-c\fP switch, allowing local configuration
of the location of the configuration file.  If \fIrstartd.real\fP is started
without the -c option, it reads <XRoot>/lib/X11/rstart/config, where 
<XRoot> refers to the root of the X11 install tree.
.SH INSTALLATION
It is critical to successful interoperation of the Remote Start protocol
that \fIrstartd\fP be installed in a directory which is in the "default"
search path, so that default rsh requests and the ilk will be able to
find it.
.SH "CONFIGURATION AND OPERATION"
\fIRstartd\fP is by design highly configurable.  One would like things like
configuration file locations to be fixed, so that users and administrators
can find them without searching, but reality is that no two vendors will
agree on where things should go, and nobody thinks the original location
is "right".  Thus, \fIrstartd\fP allows one to relocate \fBall\fP of its files and
directories.
.PP
\fIRstartd\fP has a hierarchy of configuration files which are executed in
order when a request is made.  They are:
.EX 0
global config
per-user ("local") config
global per-context config
per-user ("local") per-context config
config from request
.EE
As you might guess from the presence of "config from request", all of the
config files are in the format of an \fIrstart\fP request.  \fIRstartd\fP
defines a few additional keywords with the INTERNAL- prefix for specifying
its configuration.
.PP
\fIRstartd\fP starts by reading and executing the global config file.
This file will normally specify the locations of the other configuration
files and any systemwide defaults.
.PP
\fIRstartd\fP will then read the user's local config file, default name
$HOME/.rstart.
.PP
\fIRstartd\fP will then start interpreting the request.
.PP
Presumably one of the first lines in the request will be a CONTEXT line.
The context name is converted to lower case.
.PP
\fIRstartd\fP will read the global config file for that context, default name
<XRoot>/lib/X11/rstart/contexts/<name>, if any.
.PP
It will then read the user's config file for that context, default name
$HOME/.rstart.contexts/<name>, if any.
.PP
(If neither of these exists, \fIrstartd\fP aborts with a Failure message.)
.PP
\fIRstartd\fP will finish interpreting the request, and execute the program
specified.
.PP
This allows the system administrator and the user a large degree of control
over the operation of \fIrstartd\fP.  The administrator has final say, because
the global config file doesn't need to specify a per-user config file.
If it does, however, the user can override anything from the global file,
and can even completely replace the global context config files.
.PP
The config files have a somewhat more flexible format than requests do;
they are allowed to contain blank lines and lines beginning with "#"
are comments and ignored.  (#s in the middle of lines are data, not comment
markers.)
.PP
Any commands run are provided a few useful pieces of information in
environment variables.  The exact names are configurable, but the supplied
defaults are:
.EX 0
$RSTART_CONTEXT		the name of the context
$RSTART_GLOBAL_CONTEXTS	the global contexts directory
$RSTART_LOCAL_CONTEXTS	the local contexts directory
$RSTART_GLOBAL_COMMANDS	the global generic commands directory
$RSTART_LOCAL_COMMANDS	the local generic commands directory
.EE
$RSTART_{GLOBAL,LOCAL}_CONTEXTS should contain one special file, @List,
which contains a list of the contexts in that directory in the format
specified for ListContexts.  The supplied version of ListContexts will
cat both the global and local copies of @List.
.PP
Generic commands are searched for in several places: (defaults)
.EX 0
per-user per-context directory ($HOME/.rstart.commands/<context>)
global per-context directory (<XRoot>/lib/X11/rstart/commands/<context>)
per-user all-contexts directory ($HOME/.rstart.commands)
global all-contexts directory (<XRoot>/lib/X11/rstart/commands)
.EE
(Yes, this means you can't have an all-contexts generic command with the
same name as a context.  It didn't seem like a big deal.)
.PP
Each of these directories should have a file called @List that gives
the names and descriptions of the commands in that directory in the
format specified for ListGenericCommands.
.SH "CONFIGURATION KEYWORDS"
There are several "special" \fIrstart\fP keywords defined for \fIrstartd\fP
configuration.  Unless otherwise specified, there are no defaults; related
features are disabled in this case.
.PP
.TP 8
.B INTERNAL-REGISTRIES name ...
Gives a space-separated list of "MISC" registries that this system
understands.  (Registries other than this are accepted but generate
a Warning.)
.TP 8
.B INTERNAL-LOCAL-DEFAULT relative_filename
Gives the name ($HOME relative) of the per-user config file.
.TP 8
.B INTERNAL-GLOBAL-CONTEXTS absolute_directory_name
Gives the name of the system-wide contexts directory.
.TP 8
.B INTERNAL-LOCAL-CONTEXTS relative_directory_name
Gives the name ($HOME relative) of the per-user contexts directory.
.TP 8
.B INTERNAL-GLOBAL-COMMANDS absolute_directory_name
Gives the name of the system-wide generic commands directory.
.TP 8
.B INTERNAL-LOCAL-COMMANDS relative_directory_name
Gives the name ($HOME relative) of the per-user generic commands
directory.
.TP 8
.B INTERNAL-VARIABLE-PREFIX prefix
Gives the prefix for the configuration environment variables \fIrstartd\fP
passes to its kids.
.TP 8
.B INTERNAL-AUTH-PROGRAM authscheme program argv[0] argv[1] ...
Specifies the program to run to set up authentication for the
specified authentication scheme.  "program argv[0] ..." gives
the program to run and its arguments, in the same form as the
EXEC keyword.
.TP 8
.B INTERNAL-AUTH-INPUT authscheme
Specifies the data to be given to the authorization program as
its standard input.  Each argument is passed as a single line.
$n, where n is a number, is replaced by the n'th argument to the
"AUTH authscheme arg1 arg2 ..." line.
.TP 8
.B INTERNAL-PRINT arbitrary text
Prints its arguments as a Debug message.  Mostly for \fIrstartd\fP
debugging, but could be used to debug config files.
.SH NOTES
When using the C shell, or any other shell which runs a script every
time the shell is started, the script may get run several times.
In the worst case, the script may get run \fBthree\fP times:
.EX 0
By rsh, to run \fIrstartd\fP
By \fIrstartd\fP, to run the specified command
By the command, eg \fIxterm\fP
.EE
\fIrstartd\fP currently limits lines, both from config files and requests, to
BUFSIZ bytes.
.PP
DETACH is implemented by redirecting file descriptors 0,1, and 2 to
/dev/null and forking before executing the program.
.PP
CMD is implemented by invoking $SHELL (default /bin/sh) with "-c" and
the specified command as arguments.
.PP
POSIX-UMASK is implemented in the obvious way.
.PP
The authorization programs are run in the same context as the target
program - same environment variables, path, etc.  Long term this might
be a problem.
.PP
In the X context, GENERIC-CMD Terminal runs xterm.
In the OpenWindows context, GENERIC-CMD Terminal runs cmdtool.
.PP
In the X context, GENERIC-CMD LoadMonitor runs xload.
In the OpenWindows context, GENERIC-CMD LoadMonitor runs perfmeter.
.PP
\fBGENERIC-CMD ListContexts\fP lists the contents of @List in both the
system-wide and per-user contexts directories.  It is available in
all contexts.
.PP
\fBGENERIC-CMD ListGenericCommands\fP lists the contents of @List in the
system-wide and per-user commands directories, including the
per-context subdirectories for the current context.  It is available
in all contexts.
.PP
\fBCONTEXT None\fP is not implemented.
.PP
\fBCONTEXT Default\fP is really dull.
.PP
For installation ease, the "contexts" directory in the distribution contains
a file "@Aliases" which lists a context name and aliases for that context.
This file is used to make symlinks in the contexts and commands directories.
.PP
All \fBMISC\fP values are passed unmodified as environment variables.
.PP
One can mistreat \fIrstartd\fP in any number of ways, resulting in anything
from stupid behavior to core dumps.  Other than by explicitly running
programs I don't think it can write or delete any files, but there's
no guarantee of that.  The important thing is that (a) it probably won't
do anything REALLY stupid and (b) it runs with the user's permissions,
so it can't do anything catastrophic.
.PP
@List files need not be complete; contexts or commands which are dull
or which need not or should not be advertised need not be listed.
In particular, per-user @List files should not list things which are in
the system-wide @List files.  In the future, perhaps ListContexts and
ListGenericCommands will automatically suppress lines from the
system-wide files when there are per-user replacements for those lines.
.PP
Error handling is OK to weak.  In particular, no attempt is made to
properly report errors on the exec itself.  (Perversely, exec errors
could be reliably reported when detaching, but not when passing the
stdin/out socket to the app.)
.PP
If compiled with -DODT1_DISPLAY_HACK, \fIrstartd\fP will work around a bug in
SCO ODT version 1.  (1.1?)  (The bug is that the X clients are all compiled
with a bad library that doesn't know how to look host names up using DNS.
The fix is to look up a host name in $DISPLAY and substitute an IP address.)
This is a trivial example of an incompatibility that \fIrstart\fP can hide.
.SH "SEE ALSO"
rstart(1), rsh(1), A Flexible Remote Execution Protocol Based on \fBrsh\fP
.SH AUTHOR
Jordan Brown, Quarterdeck Office Systems
