.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH VIA __drivermansuffix__ __vendorversion__
.SH NAME
via \- VIA unichrome graphics driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qvia\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B via
is an __xservername__ driver for VIA chipsets with onboard unichrome graphics.
.PP
The
.B via
driver supports the VIA CLE266, KM400/KN400 chipsets, including 2D 
acceleration and the Xv video overlay extensions. Flat panel, TV and VGA
outputs are supported.
.PP
K8M800/K8N800, PM8X0 and CN400 support is still under development.
.PP
Direct rendering 3D is available using experimental drivers in Mesa, www.mesa3d.org.
Also there is an XvMC client library for hardware MPEG1 / MPEG2 decoding 
acceleration available on the CLE266 and K8M/N800 chipsets that uses the Direct
Rendering Infrastructure, DRI. The XvMC client library implements a nonstandard
\*qVLD\*q extension to the XvMC standard. The current Direct Rendering Manager 
Linux kernel module is available
at dri.sourceforge.net.
.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The following driver
.B options
are supported
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable acceleration. Default: acceleration is enabled.
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Disable or enable use of hardware cursors. The default is enabled.
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
Disable or enable the use of a software cursor. The default is disabled.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Use a shadow frame buffer. This is required when rotating the display,
but otherwise defaults to disabled.
.TP
.BI "Option \*qVideoRAM\*q \*q" boolean \*q
Override the VideoRAM auto detection. This should never be needed.
.TP
.BI "Option \*qRotate\*q \*q" string \*q
Rotate the display either clockwise (\*qCW\*q) or counter clockwise (\*qCCW\*q).
Rotation is only supported unaccelerated.
.TP
.BI "Option \*qActiveDevice\*q \*q" string \*q
Specify the active device combination. Any string containing \*qCRT\*q,
\*qLCD\*q, \*qTV\*q should be possible. The default is to use what is
detected. The driver is currently unable to use LCD and TV simultaneously,
and will favour the LCD.
.TP
.BI "Option \*qLCDDualEdge\*q \*q" boolean \*q
Use dual edge mode to set the LCD.
.TP
.BI "Option \*qCenter\*q \*q" boolean \*q
Disable or enable image centering on DVI displays.
.TP
.BI "Option \*qPanelSize\*q \*q" string \*q
Specify the size (width x height) of the LCD panel attached to the
system. Sizes 640x480, 800x600, 1024x768, 1280x1024, and 1400x1050
are supported.
.TP
.BI "Option \*qTVDotCrawl\*q \*q" boolean \*q
Disable or enable dotcrawl.
.TP
.BI "Option \*qTVDeflicker\*q \*q" integer \*q
Specify deflicker setting for TV output. Valid values are 0,1,2
0) No deflicker, 1) 1:1:1 deflicker, 2) 1:2:1 deflicker.
.TP
.BI "Option \*qTVType\*q \*q" string \*q
Specify TV output format. The driver currently supports \*qNTSC\*q and
\*qPAL\*q timings only.
.TP
.BI "Option \*qTVOutput\*q \*q" string \*q
Specify which TV output to use. The driver supports \*qS-Video\*q,
\*qComposite\*q, \*qSC\*q, \*qRGB\*q and \*qYCbCr\*q outputs. Note that on some
EPIA boards the composite video port is shared with audio out and jumper
selected.
.TP
.BI "Option \*qDisableVQ\*q \*q" boolean \*q
Disable or enable the use of VQ. VQ is enabled by default.
.TP
.BI "Option \*qDRIXINERAMA\*q \*q" boolean \*q
Set DRI Xinerama mode. Currently unsupported.
.TP
.BI "Option \*qEnableAGPDMA\*q \*q" boolean \*q
Enable the AGP DMA functionality in DRM. This requires that DRI is enabled
and will force 2D acceleration to use AGP DMA. The XvMC DRI client will also
make use of this to consume much less CPU. 
.TP
.BI "Option \*qNoAGPFor2D\*q \*q" boolean \*q
With this option on, 2D acceleration will not use AGP DMA even if it is enabled.
.TP
.BI "Option \*qVBEModes\*q \*q" boolean \*q
The driver will set modes using BIOS similar to the way the vesa driver does. This
is the default behaviour for Unichrome Pro in panel mode, which is otherwise not 
supported. Use this option only when the driver does not support your particular 
hardware.

.SH "Supported TV Encoders"
Unichromes tend to be paired with several different TV Encoders.
.TP
.BI "VIA Technologies VT1621"
Untested as no combination with Unichrome is known or available.
Supports the following normal modes: \*q640x480\*q and \*q800x600\*q. Use
\*q640x480Over\*q and \*q800x600Over\*q for vertical overscan. These modes
are made available by the driver and modelines provided in __xconfigfile__
will be ignored.
.TP
.BI "VIA Technologies VT1622, VT1622A, VT1623"
Supports the following modes: \*q640x480\*q, \*q800x600\*q, \*q1024x768\*q,
\*q848x480\*q, \*q720x480\*q (NTSC only) and \*q720x576\*q (PAL only). Use
\*q640x480Over\*q, \*q800x600Over\*q, \*q1024x768Over\*q, \*q848x480Over\*q,
\*q720x480Over\*q (NTSC) and \*q720x576Over\*q (PAL) for vertical overscan.
The modes \*q720x480Noscale\*q (NTSC VT1622 only) and \*q720x576Noscale\*q
(PAL VT1622 and VT1622a only) provide cleaner TV output (unscaled with only minimal overscan).
These modes are made available by the driver and modelines provided in
__xconfigfile__ will be ignored.

.SH "BUGS"
The driver is not fully 64 bit clean. In particular, 3D acceleration, XvMC and VBEModes do not
work properly in 64-bit mode.
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
Authors include: ...
