.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAllocKeyboard __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAllocKeyboard \-  Creates a keyboard description from scratch
.SH SYNOPSIS
.B XkbDescRec XkbAllocKeyboard
(
.I void
)
.if n .ti +5n
.if t .ti +.5i
.SH DESCRIPTION
.LP
Applications seldom need to directly allocate a keyboard description; calling
.I XkbGetKeyboard 
usually suffices. In the event you need to create a keyboard description from 
scratch, however, use 
.I XkbAllocKeyboard 
rather than directly calling 
.I malloc.

If 
.I XkbAllocKeyboard 
fails to allocate the keyboard description, it returns NULL. 
Otherwise, it returns a pointer to an empty keyboard description structure. The 
.I device_spec 
field will have been initialized to XkbUseCoreKbd. You may then 
either fill in the structure components or use Xkb functions to obtain values 
for the structure components from a keyboard device. 
.SH "SEE ALSO"
.BR malloc (3F),
.BR XkbUseCoreKbd (__libmansuffix__),
.BR XkbGetKeyboard (__libmansuffix__)


