.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbLookupKeyBinding __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbLookupKeyBinding \- Find the string bound to a key by XRebindKeySym
.SH SYNOPSIS
.HP
.B int XkbLookupKeyBinding
.BI "(\^Display *" "dpy" "\^,"
.BI "KeySym " "sym" "\^,"
.BI "unsigned int " "state" "\^,"
.BI "char *" "buf" "\^,"
.BI "int " "nbytes" "\^,"
.BI "int *" "extra_rtrn" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to server
.TP
.I \- sym
connection to server
.TP
.I \- state
state for which string is to be looked up
.TP
.I \- buf
buffer into which returned string is written
.TP
.I \- nbytes
size of buffer in bytes
.TP
.I \- extra_rtrn
backfilled with number bytes overflow
.SH DESCRIPTION
.LP
.I XkbLookupKeyBinding 
is the equivalent of the core 
.I XLookupString 
function.

.I XRebindKeysym 
binds an ASCII string to a specified keysym, so that the string and keysym are 
returned when the key is pressed and a specified list of modifiers are also 
being held down. 
.I XkbLookupKeyBinding 
returns in 
.I buf 
the string associated with the keysym 
.I sym 
and modifier state 
.I state. buf 
is NULL terminated unless there's an overflow. If the string returned is larger 
than 
.I nbytes, 
a count of bytes that does not fit into the buffer is returned in 
.I extra_rtrn. 
.I XkbTranslateKeySym 
returns the number of bytes that it placed into 
.I buf.
.SH "SEE ALSO"
.BR XkbTranslateKeySym (__libmansuffix__),
.BR XLookupString (__libmansuffix__),
.BR XRebindKeysym (__libmansuffix__)
