'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbSASetPtrDfltValue __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSASetPtrDfltValue \- Sets the valueXXX field of act from val
.SH SYNOPSIS
.HP
.B void XkbSASetPtrDfltValue
.BI "(\^XkbAction " "act" "\^,"
.BI "int " "val" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- act
action in which to set valueXXX
.TP
.I \- val
value to set in valueXXX
.SH DESCRIPTION
.LP
Actions associated with the XkbPtrDfltAction structure change the mk_dflt_btn 
attribute of the MouseKeys control.

If the MouseKeys control is not enabled, KeyPress and KeyRelease events are 
treated as though the action is XkbSA_NoAction. Otherwise, this action changes 
the 
.I mk_dflt_btn 
attribute of the MouseKeys control.

The 
.I type 
field of the XkbPtrDfltAction structure should always be XkbSA_SetPtrDflt.

The 
.I flags 
field is composed of the bitwise inclusive OR of the values shown in Table 1 
(currently there is only one value defined).

.TS
c s
l l
l lw(4i).
Table 1 Pointer Default Flags
_
Flag	Meaning
_
XkbSA_DfltBtnAbsolute	T{
If set, the value field represents an absolute pointer button. Otherwise, the 
value field represents the amount to be added to the current default button.
T}
.TE

The 
.I affect 
field specifies what changes as a result of this action. The only valid value 
for the 
.I affect 
field is XkbSA_AffectDfltBtn.

The 
.I valueXXX 
field is a signed character that represents the new button value for the
.I mk_dflt_btn 
attribute of the MouseKeys control. If XkbSA_DfltBtnAbsolute is set in 
.I flags, valueXXX 
specifies the button to be used; otherwise, 
.I valueXXX 
specifies the amount to be added to the current default button. In either case, 
illegal button choices are wrapped back around into range. Xkb provides macros, 
to convert between the integer and signed character values in XkbPtrDfltAction 
structures.
.SH STRUCTURES
.LP
.nf

    typedef struct _XkbPtrDfltAction {
        unsigned char    type;      /\(** XkbSA_SetPtrDflt */
        unsigned char    flags;     /\(** controls the pointer button number */
        unsigned char    affect;    /\(** XkbSA_AffectDfltBtn */
        char             valueXXX;  /\(** new default button member */
    } XkbPtrDfltAction;

.fi
