'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAllocGeometry __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAllocGeometry \- Allocate an entire geometry
.SH SYNOPSIS
.HP
.B Status XkbAllocGeometry
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "XkbGeometrySizesPtr " "sizes" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description for which geometry is to be allocated
.TP
.I \- sizes
initial sizes for all geometry components
.SH DESCRIPTION
.LP
Xkb provides a number of functions to allocate and free subcomponents of a 
keyboard geometry. Use these functions to create or modify keyboard geometries. 
Note that these functions merely allocate space for the new element(s), and it 
is up to you to fill in the values explicitly in your code. These allocation 
functions increase 
.I sz_* 
but never touch 
.I num_* 
(unless there is an allocation failure, in which case they reset both 
.I sz_* 
and 
.I num_* 
to zero). These functions return Success if they succeed, BadAlloc if they are 
not able to allocate space, or BadValue if a parameter is not as expected.

.I XkbAllocGeometry 
allocates a keyboard geometry and adds it to the keyboard description specified 
by 
.I xkb. 
The keyboard description should be obtained via the 
.I XkbGetKeyboard 
or 
.I XkbAllocKeyboard 
functions. The 
.I sizes 
parameter specifies the number of elements to be reserved for the subcomponents 
of the keyboard geometry and can be zero or more. These subcomponents include 
the 
.I properties, colors, shapes, sections, and doodads. 

To free an entire geometry, use 
.I XkbFreeGeometry.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbAllocKeyboard (__libmansuffix__),
.BR XkbFreeGeometry (__libmansuffix__),
.BR XkbGetKeyboard (__libmansuffix__)

