.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XcmsAllocColor __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XcmsAllocColor, XcmsAllocNamedColor \- allocate colors
.SH SYNTAX
.HP
Status XcmsAllocColor\^(\^Display *\fIdisplay\fP\^, Colormap \fIcolormap\fP\^,
XcmsColor *\fIcolor_in_out\fP\^, XcmsColorFormat \fIresult_format\fP\^); 
.HP
Status XcmsAllocNamedColor\^(\^Display *\fIdisplay\fP\^, Colormap
\fIcolormap\fP\^, char *\fIcolor_string\fP\^, XcmsColor
*\fIcolor_screen_return\fP\^, XcmsColor *\fIcolor_exact_return\fP\^, XcmsColorFormat \fIresult_format\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIcolormap\fP 1i
Specifies the colormap.
.IP \fIcolor_exact_return\fP 1i
Returns the color specification parsed from the color string
or parsed from the corresponding string found in a color-name database.
.IP \fIcolor_in_out\fP 1i
Specifies the color to allocate and returns the pixel and color 
that is actually used in the colormap.
.IP \fIcolor_screen_return\fP 1i
Returns the pixel value of the color cell and color specification 
that actually is stored for that cell.
.ds St \ whose color definition structure is to be returned
.IP \fIcolor_string\fP 1i
Specifies the color string\*(St.
.IP \fIresult_format\fP 1i
Specifies the color format for the returned color specification.
.SH DESCRIPTION
The
.ZN XcmsAllocColor
function is similar to
.ZN XAllocColor
except the color can be specified in any format.
The
.ZN XcmsAllocColor
function ultimately calls 
.ZN XAllocColor
to allocate a read-only color cell (colormap entry) with the specified color.
.ZN XcmsAllocColor
first converts the color specified
to an RGB value and then passes this to
.ZN XAllocColor .
.ZN XcmsAllocColor
returns the pixel value of the color cell and the color specification
actually allocated.
This returned color specification is the result of converting the RGB value
returned by 
.ZN XAllocColor 
into the format specified with the result_format argument.
If there is no interest in a returned color specification, 
unnecessary computation can be bypassed if result_format is set to
.ZN XcmsRGBFormat .
The corresponding colormap cell is read-only.
If this routine returns 
.ZN XcmsFailure , 
the color_in_out color specification is left unchanged.
.LP
.ZN XcmsAllocColor
can generate a
.ZN BadColor
errors.
.LP
The
.ZN XcmsAllocNamedColor
function is similar to
.ZN XAllocNamedColor
except that the color returned can be in any format specified.
This function
ultimately calls
.ZN XAllocColor
to allocate a read-only color cell with
the color specified by a color string.
The color string is parsed into an
.ZN XcmsColor
structure (see
.ZN XcmsLookupColor ),
converted
to an RGB value, and finally passed to
.ZN XAllocColor .
If the color name is not in the Host Portable Character Encoding, 
the result is implementation-dependent.
Use of uppercase or lowercase does not matter.
.LP
This function returns both the color specification as a result
of parsing (exact specification) and the actual color specification
stored (screen specification).
This screen specification is the result of converting the RGB value
returned by
.ZN XAllocColor
into the format specified in result_format.
If there is no interest in a returned color specification,
unnecessary computation can be bypassed if result_format is set to
.ZN XcmsRGBFormat .
If color_screen_return and color_exact_return
point to the same structure, the pixel field will be set correctly,
but the color values are undefined.
.LP
.LP
.ZN XcmsAllocNamedColor
can generate a
.ZN BadColor
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadColor
A value for a Colormap argument does not name a defined Colormap.
.SH "SEE ALSO"
XcmsQueryColor(__libmansuffix__),
XcmsStoreColor(__libmansuffix__)
.br
\fI\*(xL\fP
