'\" t
.\"     Title: xisetfocus
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.74.3 <http://docbook.sf.net/>
.\"      Date: 10/02/2009
.\"    Manual: [FIXME: manual]
.\"    Source: [FIXME: source]
.\"  Language: English
.\"
.TH "XISETFOCUS" "libmansuffix" "10/02/2009" "[FIXME: source]" "[FIXME: manual]"
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XISetFocus, XIGetFocus \- set or get the device\'s focus\&.
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput2\&.h>
.fi
.sp
.nf
Status XISetFocus( Display *display,
                   int deviceid,
                   Window focus,
                   Time time);
.fi
.sp
.nf
Status XIGetFocus( Display *display,
                   Window *focus_return);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
deviceid
       Specifies the device whose focus is to be queried or
       changed\&.
.fi
.sp
.nf
focus
       The new focus window\&.
.fi
.sp
.nf
focus_return
       Returns the current focus window\&.
.fi
.sp
.nf
time
       A valid timestamp or CurrentTime\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
XISetFocus changes the focus of the specified device ans its
last\-focus\-change time\&. It has no effect if the specified time
is earlier than the current last\-focus\-change time or is later
than the current X server time\&. Otherwise, the
last\-focus\-change time is set to the specified time\&.
CurrentTime is replaced by the current X server time)\&.
XISetFocus causes the X server to generate core, XI and XI2
focus events\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If the focus window is None all keyboard events by this device
are discarded until a new focus window is set\&. Otherwise, if
focus is a window, it becomes the device\'s focus window\&. If a
generated device event would normally be reported to this
window or one of its inferiors, the event is reported as usual\&.
Otherwise, the event is reported relative to the focus window\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The specified focus window must be viewable at the time
XISetFocus is called, or a BadMatch error results\&. If the focus
window later becomes not viewable, the focus reverts to the
parent (or the closest viewable ancestor\&. When the focus
reverts, the X server generates core, XI and XI2 focus events
but the last\-focus\-change time is not affected\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
Attempting to set the focus on a master pointer device or an
attached slave device will result in a BadDevice error\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XISetFocus can generate BadDevice, BadMatch, BadValue, and
BadWindow errors\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       A value is outside of the permitted range\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The device does not
       exist or is not a appropriate for the type of change\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       The window is not viewable\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadWindow
       A value for a Window argument does not name a defined
       Window\&.
.fi
.if n \{\
.RE
.\}
