.\" $XFree86$
.\"
.\" Copyright 2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" he above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH DMXGetWindowAttributes 3X __vendorversion__
.SH NAME
DMXGetWindowAttributes \- determine back-end window attributes
.SH SYNOPSIS
.B #include <X11/extensions/dmxext.h>
.sp
.nf
.BI "Bool DMXGetWindowAttributes(Display " *dpy ,
.BI "                            Window " window ,
.BI "                            int " *screen_count ,
.BI "                            int " available_count ,
.BI "                            DMXWindowAttributes " *attr );
.fi
.SH DESCRIPTION
When calling
.BR DMXGetWindowAttributes() ,
.I window
specifies the window ID of a window on the
.BR Xdmx (1)
server and
.I available_count
specifies the length of
.I attr.
.PP
The number of screens for which information is available will be
returned in
.I screen_count
and information about those screen will be returned in
.IR attr .
If
.I screen_count
is less than
.IR available_count ,
then information for all of the screens will be returned.  Otherwise,
information for the first
.I available_count
screens will be returned.
.PP
The
.I DMXWindowAttributes
structure is:
.sp
.nf
typedef struct {
    int          screen;
    Window       window;
    XRectangle   pos, vis;
} DMXWindowAttributes;
.fi
.PP
For each back-end X server that displays a portion of
.IR window ,
this structure contains the physical
.I screen
containing that portion, the
.I window
ID on the back-end X server of the window containing that portion, the
position and dimensions of the window on the back-end
.RI ( pos ,
in screen coordinates), and the visible area of the window on the
back-end
.RI ( vis ,
in window-relative coordinates -- all zeros if the window is not visible
on the backend).
.PP
To obtain more information about the physical screen use the
.BR DMXGetScreenAttributes (3X)
call.
.PP
Note that DMX allows multiple back-end windows to overlap in their
view of the DMX logical window.  Further, a logical window does not
have to be completely covered by back-end windows -- there may be
gaps.
.PP
As an example, consider a 500x500 window that spans the top two
1024x768 back-end displays (A and B) of a 2048x1536 DMX display
composed of 4 1024x768 back-end displays arranged in a cube:
.sp
.nf
    A B
    C D
.fi
.sp
In this case, the DMXGetWindowAttributes call would return the
following information for the 500x500 window:
.sp
.nf
display A: 500x500 window at 1024-250,0 (relative to back end)
           with 250x500 visible at 0,0 (relative to window origin)

display B: 500x500 window at -250,0 (relative to back end)
           with 250x500 visible at 250,0 (relative to window origin)

display C: 500x500 window at 1024-250,-768 with 0x0 visible at 0,0

display D: 500x500 window at -250,-768 with 0x0 visible at 0,0
.fi
.SH "RETURN VALUE"
.B DMXGetWindowAttributes()
returns
.B True
unless there is a protocol error.
.PP
.B DMXGetWindowAttributes()
can generate
.B BadWindow
and
.B BadAlloc
errors.
.SH NOTES
Because this call transports a great deal of information over the wire,
please call
.BR DMXGetScreenCount (3X)
first, and make sure
.I attr
is sufficiently large.
.PP
On a particular back-end server, it is possible that the associated
window has not yet been mapped because the
.BR XMapWindow (3X)
call that will eventually map the window had been buffered by Xlib's
normal buffering system.  To avoid this race condition, please call
.BR DMXSync (3X)
before communicating directly with the back-end X server.
.SH "SEE ALSO"
.BR DMXGetScreenCount "(3X), "
.BR DMXSync "(3X), "
.BR DMXGetScreenAttributes "(3X), "
.BR DMX "(3X), " Xdmx (1)
