/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code)
 *   Display	*display;
 *   XDevice *device;
 *   KeyCode first;
 *   int keycount;
 *   int *syms_per_code;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetDeviceKeyMapping	1
char    *TestName = "XGetDeviceKeyMapping";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XGetDeviceKeyMapping function
 */
static Display	*display;
static XDevice *device;
static KeyCode first;
static int keycount;
static int *syms_per_code;


static int Min_KeyCode, Max_KeyCode;
extern ExtDeviceInfo Devs;
static int ksym_cnt;

#define	MAXKPK	5	/* Maximum keysyms_per_keyocde we will use */
#define	MAXCODES 255	/* Max number of keycodes we will use */

static	int 	ncodes;
static	int 	oldkpk;	/* old Keysyms per keycode */
static	KeySym	*oldkeym;

/*
 * Can't really assume that there are any particular keysym names defined so
 * we use our own arbitrary values.
 */
#define	XT_KSYM1	0x5678
#define	XT_KSYM2	0x9228
#define	XT_KSYM3	0x4425
#define	XT_KSYM4	0x5326

static	KeySym	Keys[MAXKPK*MAXCODES];

/*
 * Set startup and cleanup functions to save and restore
 * the original keyboard map.
 */
static void
savekeymap()
{
int 	i;
int 	numkeys;

	startup();

	if (Dsp==(Display *)NULL)
		return;

	if (!Setup_Extension_DeviceInfo(KeyMask))
	    return;
	MinMaxKeys(Dsp, Devs.Key, &Min_KeyCode, &Max_KeyCode, &numkeys);
	device = Devs.Key;
	ncodes = Max_KeyCode-Min_KeyCode;
	oldkeym = XGetDeviceKeyMapping(Dsp, device, Min_KeyCode, ncodes, &oldkpk);

	/*
	 * Initialise the keysym table.
	 */
	for (i = 0; i < MAXKPK*MAXCODES-4; i += 4) {
		Keys[i] = XT_KSYM1;
		Keys[i+1] = XT_KSYM2;
		Keys[i+2] = XT_KSYM3;
		Keys[i+3] = XT_KSYM4;
	}
}

static void
cleankeymap()
{
	if (Dsp && Devs.Key) {
		XChangeDeviceKeyMapping(Dsp, Devs.Key, Min_KeyCode, oldkpk, oldkeym, ncodes);
		XSync(Dsp,0);
		XFree((char*) oldkeym);
	}

	cleanup();
}



int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = Devs.Key;
	first = Min_KeyCode;
	keycount = 1;
	syms_per_code = &ksym_cnt;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	i, j;
int 	SymsPerCode;
KeySym	*newmap;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetDeviceKeyMapping-1.(A)");
	report_assertion("A call to XGetDeviceKeyMapping returns an array, that can");
	report_assertion("be freed with XFree, of KeySyms associated with the");
	report_assertion("specified number, keycode_count, of KeyCodes starting with");
	report_assertion("first_keycode.");

	report_strategy("Set some KeySyms with XChangeDeviceKeyMapping.");
	report_strategy("Call XGetDeviceKeyMapping to get KeySyms.");
	report_strategy("Verify they are as set.");
	report_strategy("Free returned array with XFree.");

	tpstartup();
	setargs();
	if (!Devs.Key) {
	    untested("%s: Required input devices not present\n",TestName);
	    return;
	    }
	first = Min_KeyCode+3;
	SymsPerCode = 3;
	keycount = 9;

	XChangeDeviceKeyMapping(display, device, first, SymsPerCode, Keys, keycount);
	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	newmap = XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 0; i < keycount; i++) {
		for (j = 0; j < SymsPerCode; j++) {
			if (Keys[i*SymsPerCode+j] ==
				  newmap[i*syms_per_code[0]+j])
				CHECK;
			else {
				report("Keysym for keycode %d was 0x%x, expecting 0x%x",
					first+i,
					newmap[i*syms_per_code[0]+j],
					Keys[i*SymsPerCode+j]
					);
				FAIL;
				break;	/* probably pointless to continue */
			}
		}
	}

	XFree((char*)newmap);

	CHECKPASS(SymsPerCode*keycount);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion XGetDeviceKeyMapping-2.(-)");
	report_assertion("On a call to XGetDeviceKeyMapping the returned KeySyms list");
	report_assertion("contains keycode_count*keysyms_per_keycode_return");
	report_assertion("elements.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

int 	SymsPerCode = 6;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetDeviceKeyMapping-3.(A)");
	report_assertion("On a call to XGetDeviceKeyMapping");
	report_assertion("keysyms_per_keycode_return is set to a value that is large");
	report_assertion("enough to report all of the KeySyms for any of the requested");
	report_assertion("KeyCodes.");

	report_strategy("Set KeySyms with XChangeDeviceKeyMapping.");
	report_strategy("Call XGetDeviceKeyMapping to get new value of this parameter.");
	report_strategy("Verify that it is at least as large as set.");

	tpstartup();
	setargs();
	if (!Devs.Key) {
	    untested("%s: Required input devices not present\n",TestName);
	    return;
	    }
	first = Min_KeyCode;
	/*
	 * I don't know a really good test for this.
	 */
	XChangeDeviceKeyMapping(display, device, first, SymsPerCode, Keys, keycount);
	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (syms_per_code[0] >= SymsPerCode)
		CHECK;
	else {
		report("syms_per_code was unexpected");
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion XGetDeviceKeyMapping-4.(-)");
	report_assertion("When an element for a particular KeyCode is unused, then a");
	report_assertion("KeySym value of NoSymbol is used in the returned array.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGetDeviceKeyMapping-5.(A)");
	report_assertion("When the value specified in first_keycode is less than the");
	report_assertion("minimum keycode as returned by XListInputDevices, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set first_keycode to less than the minimum keycode.");
	report_strategy("Call XGetDeviceKeyMapping.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Devs.Key) {
	    untested("%s: Required input devices not present\n",TestName);
	    return;
	    }
	device = Devs.Key;
	first = Min_KeyCode-1;

	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

KeySym *ret;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGetDeviceKeyMapping-6.(A)");
	report_assertion("When the expression first_keycode+keycode_count-1 is");
	report_assertion("greater than the maximum keycode as returned by");
	report_assertion("XListInputDevices, then a BadValue error occurs.");

	report_strategy("Set first keycode to greater than the maximum keycode.");
	report_strategy("Call XGetDeviceKeyMapping.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Devs.Key) {
	    untested("%s: Required input devices not present\n",TestName);
	    return;
	    }
	first = Max_KeyCode+1;

	startcall(display);
	if (isdeleted())
		return;
	ret = XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	else
	    FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int count=0;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XGetDeviceKeyMapping-7.(B)");
	report_assertion("A call to XGetDeviceKeyMapping will fail with a BadValue");
	report_assertion("error if a firstkeycode value that is out of the range of");
	report_assertion("valid values is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with a firstkeycode value that is out of range.");

	tpstartup();
	setargs();
	if (!Devs.Key) {
	    untested("%s: Required input devices not present\n",TestName);
	    return;
	    }
	device = Devs.Key;
	first = Min_KeyCode;
	if (Max_KeyCode < 255)
	    {
	    first = Max_KeyCode + 1;
	    startcall(display);
	    if (isdeleted())
	    	return;
	    XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	    endcall(display);
	    if (geterr() != BadValue) {
	    	report("Got %s, Expecting BadValue", errorname(geterr()));
	    	FAIL;
	    }
	    if (geterr() == BadValue)
		CHECK;
	    else
		FAIL;
	    count++;
	    }

	if (Min_KeyCode > 0)
	    {
	    first = Min_KeyCode - 1;
	    startcall(display);
	    if (isdeleted())
	    	return;
	    XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	    endcall(display);
	    if (geterr() != BadValue) {
	    	report("Got %s, Expecting BadValue", errorname(geterr()));
	    	FAIL;
	    }
	    if (geterr() == BadValue)
		CHECK;
	    else
		FAIL;
	    count++;
	    }
	CHECKPASS(count);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XGetDeviceKeyMapping-8.(B)");
	report_assertion("A call to XGetDeviceKeyMapping will fail with a BadValue");
	report_assertion("error if the expression firstkeycode+ count is >");
	report_assertion("Max_KeyCode+ 1;");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with a too many keycodes.");

	tpstartup();
	setargs();
	if (!Devs.Key) {
	    untested("%s: Required input devices not present\n",TestName);
	    return;
	    }
	first = Max_KeyCode;
	keycount = 2;
	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadValue)
	    PASS;
	else
	    FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XGetDeviceKeyMapping-9.(B)");
	report_assertion("A call to XGetDeviceKeyMapping will fail with a BadMatch");
	report_assertion("error if a valid device with no keys is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with a valid device that has no keys.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NKeysMask))
	    {
	    untested("%s: Required extension device not present\n",TestName);
	    return;
	    }
	device = Devs.NoKeys;
	first = Min_KeyCode;

	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

XDevice nodevice;
XID baddevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XGetDeviceKeyMapping-10.(B)");
	report_assertion("A call to XGetDeviceKeyMapping will fail with a BadDevice");
	report_assertion("error if an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	    {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;
	first = Min_KeyCode;

	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceKeyMapping(display, device, first, keycount, syms_per_code);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	device = Devs.Key;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = savekeymap;
void	(*tet_cleanup)() = cleankeymap;
