/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2001 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetInputFocus(display, focus, revert_to, thetime)
 *   Display	*display;
 *   Window	focus;
 *   int 	revert_to;
 *   Time	thetime;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetInputFocus	1
char    *TestName = "XSetInputFocus";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW focus
#define A_DRAWABLE focus


/*
 * Arguments to the XSetInputFocus function
 */
static Display	*display;
static Window	focus;
static int 	revert_to;
static Time	thetime;


/*
 * NOTE: This test should not be run with a window manager as some
 * window managers interfere with the test.
 */


static char	*WindowTree[]= {
	"toplevel",
		"child1 toplevel (10,10) 30x30",
		"child2 toplevel (50,50) 30x30",
			"grandchild child2 (2,2) 20x20",
};

static int NWindowTree = NELEM(WindowTree);



/* Value list for use in test t012 */
static int 	revert_tovallist[] = {
	RevertToParent,
	RevertToPointerRoot,
	RevertToNone,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	focus = 0;
	revert_to = RevertToNone;
	thetime = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	focus = ErrdefWindow;
}

static void t001(){

Window	newfocus;
int 	newrevert;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetInputFocus-1.(A)");
	report_assertion("A call to XSetInputFocus changes the input focus window to");
	report_assertion("that specified in the focus argument.");

	report_strategy("Create window.");
	report_strategy("Set input focus with that window.");
	report_strategy("Verify that input focus has been set with XGetInputFocus.");

	tpstartup();
	setargs();
	focus = defwin(display);

	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetInputFocus(display, &newfocus, &newrevert);
	if (newfocus != focus) {
		report("Focus window was 0x%x, expecting 0x%x", newfocus, focus);
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	win;
XEvent	ev;
int	n;
long	mask;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetInputFocus-2.(B)");
	report_assertion("When the focus argument is None, then all keyboard events");
	report_assertion("are discarded until a new focus window is set.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Create a window and select KeyPress and KeyRelease events.");
	report_strategy("  Call XSetInputFocus with focus = None.");
	report_strategy("  Warp pointer into window and simulate keypress using extension.");
	report_strategy("  Ensure no event received.");
	report_strategy("  Call XSetInputFocus with focus = window.");
	report_strategy("  Simulate key release.");
	report_strategy("  Ensure event now received.");
	report_strategy("else");
	report_strategy("  report untested.");

	tpstartup();
	setargs();
	if (noext(0))
		return;
	else
		CHECK;

	win = defwin(display);
	XSelectInput(display, win, mask = KeyPressMask|KeyReleaseMask);
	focus = None;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	warppointer(display, win, 2, 2);
	XSync(display, True); /* clear out event queue */
	keypress(display, getkeycode(display));
	if (n=getevent(display, &ev)) /* assignment intentional */ {
		report("Got %d events instead of 0, first was type %s.",
			n, eventname(ev.type));
		FAIL;
	} else
		CHECK;
	focus = win;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display, True); /* clear out event queue */
	relalldev();
	if (!XCheckWindowEvent(display, win, mask, &ev)) {
		report("Normal event processing not restored.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int	keycode;
XEvent	ev;
int	n;
long	mask;
Window	parent,child2,gchild;
Window	windows[6]; /* root + 4 + None stopper */
Window	root;
Window	*wp;
struct buildtree *tree;
char	*wname;
char	*evwname;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetInputFocus-3.(B)");
	report_assertion("When the focus argument is a window, then keyboard events");
	report_assertion("that would normally be reported to the focus window or one");
	report_assertion("of its inferiors are reported as usual and all other");
	report_assertion("keyboard events are reported relative to the focus window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Create a window tree and select KeyPress and KeyRelease events on all.");
	report_strategy("  Call XSetInputFocus with focus = window in tree with child (child2, with child");
	report_strategy("    grandchild).");
	report_strategy("  Warp pointer into all windows, and root, and simulate keypress/release using");
	report_strategy("    extension in each.");
	report_strategy("  Ensure event.xany.window is focus (child2) in all cases except grandchild,");
	report_strategy("    when it should be grandchild.");
	report_strategy("  Release any remaining keys.");
	report_strategy("else");
	report_strategy("  report untested.");

	tpstartup();
	setargs();
	if (noext(0))
		return;
	else
		CHECK;
	wp = windows;
	*wp++ = root = DRW(display);
	*wp++ = parent = defwin(display);
	tree = buildtree(display, parent, WindowTree, NWindowTree);
	*wp++ = btntow(tree, "child1");
	*wp++ = child2 = btntow(tree, "child2");
	*wp++ = gchild = btntow(tree, "grandchild");
	*wp = None;

	keycode=getkeycode(display);
	mask = KeyPressMask|KeyReleaseMask;
	for(wp=windows; *wp != None; wp++)
		XSelectInput(display, *wp, mask);

	focus = child2;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for(wp=windows; *wp != None; wp++) { /* around 5 times */
		(void)warppointer(display, *wp, 0,0);
		/* use 0,0 as window making stuff keeps away from there on
		 * root. All of our tree windows are not at 0,0 either
		 */
		XSync(display, True); /* clear out event queue */
		keypress(display, keycode);
		relalldev();
		if (!(wname = btwton(tree,*wp)))
			wname = (*wp == root) ? "ROOT" : "<Unknown>";
		if (!(n=XCheckMaskEvent(display, mask, &ev))) {
			report("No event received after keypress/release in window %s.", (*wp==focus)?"focus":wname);
			FAIL;
		} else
			CHECK;
		if (n && !(evwname = btwton(tree,ev.xany.window)))
			evwname = (ev.xany.window == root) ? "ROOT" :
				((ev.xany.window == None) ? "None" : "<Unknown>");
		if (*wp == focus || *wp == gchild) {
			if (n && ev.xany.window != *wp) {
				report("Event window was %s instead of %s for focus window or child.", evwname, wname);
				FAIL;
			} else
				CHECK;
		} else {
			if (n && ev.xany.window != focus) {
				report("Event window was %s instead of focus window.", evwname);
				FAIL;
			} else
				CHECK;
		}
	}

	CHECKPASS(1+2*5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Window	win, root, altroot;
int	keycode;
XEvent	ev;
long	mask;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetInputFocus-4.(B)");
	report_assertion("When the focus argument is PointerRoot, then the focus");
	report_assertion("window is taken to be the root window of the screen the");
	report_assertion("pointer is on at each keyboard event.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Create a toplevel window and select KeyPress and KeyRelease events.");
	report_strategy("  Select KeyPress and KeyRelease events in root window.");
	report_strategy("  Call XSetInputFocus with focus = PointerRoot.");
	report_strategy("  Warp pointer into window and simulate keypress using extension.");
	report_strategy("  Ensure event received and that event.xany.window = window.");
	report_strategy("  Warp pointer into root window.");
	report_strategy("  Simulate key release.");
	report_strategy("  Ensure event received and that event.xany.window = root (focus).");
	report_strategy("  If more than one screen:");
	report_strategy("    Select KeyPress and KeyRelease events in root window of alternate screen.");
	report_strategy("    Warp pointer into root window of alternate screen.");
	report_strategy("    Simulate KeyPress/KeyRelease.");
	report_strategy("    Ensure event received and that event.xany.window = altroot (focus) and");
	report_strategy("      event.xkey.same_screen is True and event.xkey.root is altroot.");
	report_strategy("  else");
	report_strategy("    Issue incomplete testing message and report untested.");
	report_strategy("else");
	report_strategy("  report untested.");

	tpstartup();
	setargs();
	if (noext(0))
		return;
	else
		CHECK;

	win = defwin(display);
	XSelectInput(display, win, mask = KeyPressMask|KeyReleaseMask);
	XSelectInput(display, root = DRW(display), mask);
	trace("Test with toplevel window and PointerRoot.");
	focus = PointerRoot;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	warppointer(display, win, 2, 2);
	XSync(display, True); /* clear out event queue */
	keypress(display, keycode=getkeycode(display));
	if (!getevent(display, &ev)) {
		report("No event received.");
		FAIL;
	} else if (ev.type != KeyPress && ev.type != KeyRelease) {
		report("First event was of unexpected type: %s.", eventname(ev.type));
		FAIL;
	} else if (ev.xkey.window != win) {
		report("First event had unexpected window: 0x%x instead of 0x%x.",
			(unsigned)ev.xkey.window, (unsigned)win);
		FAIL;
	} else
		CHECK;
	trace("Test with root and PointerRoot.");
	warppointer(display, root, 0,0);
	XSync(display, True); /* clear out event queue */
	relalldev();
	if (!getevent(display, &ev)) {
		report("No event received.");
		FAIL;
	} else if (ev.type != KeyPress && ev.type != KeyRelease) {
		report("First event was of unexpected type: %s.", eventname(ev.type));
		FAIL;
	} else if (ev.xkey.window != root) {
		report("First event had unexpected window: 0x%x instead of 0x%x.",
			(unsigned)ev.xkey.window, (unsigned)root);
		FAIL;
	} else
		CHECK;

	if (config.alt_screen != -1) {
		altroot = RootWindow(display, config.alt_screen);
		trace("Testing with root of alternate screen as source (0x%x) and PointerRoot.",
				(unsigned)altroot);
		XSelectInput(display, altroot, mask);
		warppointer(display, altroot, 0,0);
		XSync(display, True); /* clear out event queue */
		keypress(display, keycode);
		relalldev();

		if (!getevent(display, &ev)) {
			report("No event received.");
			FAIL;
		} else if (ev.type != KeyPress && ev.type != KeyRelease) {
			report("First event was of unexpected type: %s.", eventname(ev.type));
			FAIL;
		} else if (ev.xkey.window != altroot) {
			report("First event had unexpected window: 0x%x instead of focus (altroot) 0x%x.",
				(unsigned)ev.xkey.window, (unsigned)altroot);
			FAIL;
		} else if (!ev.xkey.same_screen) {
			report("same_screen unexpectedly False.");
			FAIL;
		} else if (ev.xkey.root != altroot) {
			report("First event had unexpected root window: 0x%x instead of 0x%x.",
				(unsigned)ev.xkey.root, (unsigned)altroot);
			FAIL;
		} else
			CHECK;
		CHECKPASS(4);
	} else {
		report("Tested as far as possible with just one screen.");
		CHECKUNTESTED(3);
	}

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window	base;
XFocusInEvent	figood;
XFocusOutEvent	fogood;
XEvent	ev;
Window	newfocus;
int 	newrevert;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetInputFocus-5.(A)");
	report_assertion("When the focus window later becomes not viewable and");
	report_assertion("revert_to is RevertToParent, then the focus reverts to the");
	report_assertion("closest viewable ancestor of the focus window, the revert_to");
	report_assertion("value is changed to RevertToNone and FocusIn and FocusOut");
	report_assertion("events are generated.");

	report_strategy("Create base window");
	report_strategy("Create child of this window and set focus argument to it.");
	report_strategy("Set revert_to argument to RevertToParent.");
	report_strategy("Call XSetInputFocus.");
	report_strategy("Enable events on windows.");
	report_strategy("Unmap focus window.");
	report_strategy("Verify that focus is the base window.");
	report_strategy("Verify that revert_to is RevertToNone.");
	report_strategy("Verify that Focus events are generated.");

	tpstartup();
	setargs();
	base = defwin(display);
	focus = crechild(display, base, (struct area *)0);
	revert_to = RevertToParent;

	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, base, FocusChangeMask);
	XSelectInput(display, focus, FocusChangeMask);

	XUnmapWindow(display, focus);
	XGetInputFocus(display, &newfocus, &newrevert);
	if (isdeleted())
		return;

	if (newfocus != base) {
		report("Focus window was 0x%x, expecting 0x%x", newfocus, base);
		FAIL;
	} else
		CHECK;

	if (newrevert != RevertToNone) {
		report("New revert_to value was %s, expecting RevertToNone",
			reverttoname(newrevert));
		FAIL;
	} else
		CHECK;

	/*
	 * Event testing. In this case there should be a FocusOut on the
	 * focus window, followed by a FocusIn on the base window.
	 */
	defsetevent(fogood, display, FocusOut);
	fogood.window = focus;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyAncestor;

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Was expecting a FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	defsetevent(figood, display, FocusIn);
	figood.window = base;
	figood.mode = NotifyNormal;
	figood.detail = NotifyInferior;

	if (getevent(display, &ev) == 0 || ev.type != FocusIn) {
		report("Was expecting a FocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Window	base;
XFocusInEvent	figood;
XFocusOutEvent	fogood;
XEvent	ev;
Window	newfocus;
int 	newrevert;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetInputFocus-6.(A)");
	report_assertion("When the focus window later becomes not viewable and");
	report_assertion("revert_to is RevertToPointerRoot, then the focus window");
	report_assertion("reverts to PointerRoot and FocusIn and FocusOut events are");
	report_assertion("generated.");

	report_strategy("Create base window");
	report_strategy("Create child of this window and set focus argument to it.");
	report_strategy("Set revert_to argument to RevertToPointerRoot.");
	report_strategy("Warp pointer to 0,0 (guaranteed none of our windows are here)");
	report_strategy("Call XSetInputFocus.");
	report_strategy("Unmap focus window.");
	report_strategy("Verify that focus is PointerRoot.");
	report_strategy("Verify that revert_to is RevertToPointerRoot.");
	report_strategy("Verify that Focus events are generated.");

	tpstartup();
	setargs();
	/*
	 * Use a non-default display, because we are setting the event mask
	 * on the root window, which would mess up things for the next tests.
	 */
	display = opendisplay();

	base = defwin(display);
	focus = crechild(display, base, (struct area *)0);
	revert_to = RevertToPointerRoot;

	warppointer(display, DRW(display), 0, 0);

	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, base, FocusChangeMask);
	XSelectInput(display, focus, FocusChangeMask);
	XSelectInput(display, DRW(display), FocusChangeMask);

	XUnmapWindow(display, focus);
	XGetInputFocus(display, &newfocus, &newrevert);
	if (isdeleted())
		return;

	if (newfocus != PointerRoot) {
		report("Focus window was 0x%x, expecting 0x%x", newfocus, PointerRoot);
		FAIL;
	} else
		CHECK;

	if (newrevert != RevertToPointerRoot) {
		report("New revert_to value was %s, expecting RevertToPointerRoot",
			reverttoname(newrevert));
		FAIL;
	} else
		CHECK;

	/* FocusOut from focus window */
	defsetevent(fogood, display, FocusOut);
	fogood.window = focus;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyNonlinear;

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Was expecting a FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	/* FocusOut on the base window */
	fogood.window = base;
	fogood.detail = NotifyNonlinearVirtual;

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Was expecting a FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusOut on the root window */
	fogood.window = DRW(display);

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Was expecting a FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusIn on the root window */
	defsetevent(figood, display, FocusIn);
	figood.window = DRW(display);
	figood.mode = NotifyNormal;
	figood.detail = NotifyPointerRoot;

	if (getevent(display, &ev) == 0 || ev.type != FocusIn) {
		report("Was expecting a FocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	figood.window = DRW(display);
	figood.detail = NotifyPointer;

	/* FocusIn for the pointer */
	if (getevent(display, &ev) == 0 || ev.type != FocusIn) {
		report("Was expecting a FocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;
	
	CHECKPASS(12);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Window	base;
XFocusInEvent	figood;
XFocusOutEvent	fogood;
XEvent	ev;
Window	newfocus;
int 	newrevert;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetInputFocus-7.(A)");
	report_assertion("When the focus window later becomes not viewable and");
	report_assertion("revert_to is RevertToNone, then the focus window reverts to");
	report_assertion("None and FocusIn and FocusOut events are generated.");

	report_strategy("Create base window");
	report_strategy("Create child of this window and set focus argument to it.");
	report_strategy("Set revert_to argument to RevertToNone.");
	report_strategy("Call XSetInputFocus.");
	report_strategy("Unmap focus window.");
	report_strategy("Verify that focus is None");
	report_strategy("Verify that revert_to is RevertToNone.");
	report_strategy("Verify that Focus events are generated.");

	tpstartup();
	setargs();
	/*
	 * Use a non-default display, because we are setting the event mask
	 * on the root window, which would mess up things for the next tests.
	 */
	display = opendisplay();

	base = defwin(display);
	focus = crechild(display, base, (struct area *)0);
	revert_to = RevertToNone;

	warppointer(display, DRW(display), 0, 0);

	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, base, FocusChangeMask);
	XSelectInput(display, focus, FocusChangeMask);
	XSelectInput(display, DRW(display), FocusChangeMask);

	XUnmapWindow(display, focus);
	XGetInputFocus(display, &newfocus, &newrevert);
	if (isdeleted())
		return;

	if (newfocus != None) {
		report("Focus window was 0x%x, expecting None", newfocus);
		FAIL;
	} else
		CHECK;

	if (newrevert != RevertToNone) {
		report("New revert_to value was %s, expecting RevertToNone",
			reverttoname(newrevert));
		FAIL;
	} else
		CHECK;

	/* FocusOut from focus window */
	defsetevent(fogood, display, FocusOut);
	fogood.window = focus;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyNonlinear;

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Was expecting a FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	/* FocusOut on the base window */
	fogood.window = base;
	fogood.detail = NotifyNonlinearVirtual;

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Was expecting a FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusOut on the root window */
	fogood.window = DRW(display);

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Was expecting a FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusIn on the root window */
	defsetevent(figood, display, FocusIn);
	figood.window = DRW(display);
	figood.mode = NotifyNormal;
	figood.detail = NotifyDetailNone;

	if (getevent(display, &ev) == 0 || ev.type != FocusIn) {
		report("Was expecting a FocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(10);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Window	win;
Window	newfocus;
int 	newrevert;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSetInputFocus-8.(A)");
	report_assertion("When the specified time is earlier than the current");
	report_assertion("last-focus-change time or is later than the current X server");
	report_assertion("time, then a call to XSetInputFocus has no effect.");

	report_strategy("Create window.");
	report_strategy("Get current X server time with gettime().");
	report_strategy("Set focus to None using this time.");
	report_strategy("");
	report_strategy("Attempt to set the focus window with a time less than the previous time.");
	report_strategy("Verify that focus is still None.");
	report_strategy("");
	report_strategy("Get current time again.");
	report_strategy("Add amount to get time in the future.");
	report_strategy("Attempt to set the focus window with this time.");
	report_strategy("Verify that focus is still None.");

	tpstartup();
	setargs();
	win = defwin(display);

	thetime = gettime(display);
	focus = None;

	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	thetime -= 12;
	focus = win;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetInputFocus(display, &newfocus, &newrevert);
	if (newfocus == None)
		CHECK;
	else {
		report("Focus was changed when time was earlier than last-focus-change time");
		FAIL;
	}

	thetime = gettime(display);
	thetime += ((config.speedfactor+1) * 1000000);

	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetInputFocus(display, &newfocus, &newrevert);
	if (newfocus == None)
		CHECK;
	else {
		report("Focus was changed when time was later than current X server time");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Time	t1,t2;
Window	win;
Window	focus_return;
int	junk;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XSetInputFocus-9.(A)");
	report_assertion("A successful call to XSetInputFocus sets the");
	report_assertion("last-focus-change time to the specified time with");
	report_assertion("CurrentTime being replaced by the current X server time.");

	report_strategy("Create toplevel window.");
	report_strategy("Call XSetInputFocus with time = gettime(display) and focus = window.");
	report_strategy("Call XGetInputFocus and verify that focus_return is window.");
	report_strategy("Attempt XSetInputFocus at time just before time with focus = root.");
	report_strategy("Check focus is still window.");
	report_strategy("Attempt XSetInputFocus at time equal to time and focus = root.");
	report_strategy("Check focus is now root.");
	report_strategy("");
	report_strategy("Get time before with gettime(display).");
	report_strategy("Sleep for 1 second.");
	report_strategy("Call XSetInputFocus with time = CurrentTime and focus = window.");
	report_strategy("Call XGetInputFocus and verify that focus_return is window.");
	report_strategy("Attempt XSetInputFocus at time before with focus = root.");
	report_strategy("Check focus is still window.");
	report_strategy("Attempt XSetInputFocus at CurrentTime and focus = root.");
	report_strategy("Check focus is now root.");

	tpstartup();
	setargs();
	win = defwin(display);
	XSync(display, True);
	t1 = gettime(display);
	if (t1 == CurrentTime) {
		delete("Could not get server time.");
		return;
	} else
		CHECK;

	thetime = t1;
	focus = win;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetInputFocus(display, &focus_return, &junk);
	if (focus_return != win) {
		report("Failed to change focus with time = 0x%lx.", (unsigned long)thetime);
		FAIL;
	} else
		CHECK;
	trace("Focus set at time 0x%lx.",(unsigned long)thetime);
	thetime--;
	focus = DRW(display);
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetInputFocus(display, &focus_return, &junk);
	if (focus_return != win) {
		report("Last focus change time set earlier than specified time.");
		FAIL;
	} else
		CHECK;
	thetime = t1;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetInputFocus(display, &focus_return, &junk);
	if (focus_return != focus) {
		report("Last focus change time set later than specified time.");
		FAIL;
	} else
		CHECK;

	/* last despairing attempt */
	thetime = CurrentTime;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetInputFocus(display, &focus_return, &junk);
	if (focus_return != focus) {
		delete("Cannot restore focus to perform CurrentTime tests.");
		return;
	} else
		CHECK;

	XSync(display, True);
	t1 = gettime(display);
	if (t1 == CurrentTime) {
		delete("Could not get earlier server time.");
		return;
	} else
		CHECK;

	sleep(1);  /* make sure the current time is != t1 */

	thetime = CurrentTime;
	focus = win;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetInputFocus(display, &focus_return, &junk);
	if (focus_return != focus) {
		delete("Failed to change focus at CurrentTime.");
		return;
	} else
		CHECK;
	/* now set up OK */
	t2 = gettime(display);
	if (t2 == CurrentTime) {
		delete("Could not get later server time.");
		return;
	} else
		CHECK;

	trace("Focus changed at time between 0x%lx and 0x%lx (diff = %ld).",t1,t2,t2-t1);
	thetime = t1;
	focus = DRW(display);
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetInputFocus(display, &focus_return, &junk);
	if (focus_return != win) {
		report("Last focus change time set earlier than 0x%lx.",t1);
		FAIL;
	} else
		CHECK;
	thetime = t2;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetInputFocus(display, &focus_return, &junk);
	if (focus_return != focus) {
		report("Last focus change time set later than 0x%lx.", t2);
		FAIL;
	} else
		CHECK;

	CHECKPASS(10);
	
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Window	base;
Window	ch1;
Window	ch2;
struct	area	area;
XFocusInEvent	figood;
XFocusOutEvent	fogood;
XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XSetInputFocus-10.(A)");
	report_assertion("When the focus changes, then FocusIn and FocusOut events");
	report_assertion("are generated.");

	report_strategy("Create base window.");
	report_strategy("Create two subwindows on base.");
	report_strategy("Set focus to first subwindow.");
	report_strategy("Enable events on all three windows.");
	report_strategy("Call XSetInputFocus to change focus to second subwindow.");
	report_strategy("Verify that focus events are generated.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 0, 0, 2, 2);
	ch1 = crechild(display, base, &area);
	setarea(&area, 20, 20, 2, 2);
	ch2 = crechild(display, base, &area);

	focus = ch1;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, ch1, FocusChangeMask);
	XSelectInput(display, ch2, FocusChangeMask);
	XSelectInput(display, base, FocusChangeMask);

	focus = ch2;
	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* FocusOut from old focus window, ch1 */
	defsetevent(fogood, display, FocusOut);
	fogood.window = ch1;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyNonlinear;

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Was expecting a FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	/* FocusIn on the new focus window, ch2 */
	defsetevent(figood, display, FocusIn);
	figood.window = ch2;
	figood.mode = NotifyNormal;
	figood.detail = NotifyNonlinear;

	if (getevent(display, &ev) == 0 || ev.type != FocusIn) {
		report("Was expecting a FocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

Window	base;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XSetInputFocus-11.(A)");
	report_assertion("When the specified focus window is not viewable, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Create unmapped window.");
	report_strategy("Attempt to set focus to it.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	base = defwin(display);
	focus = creunmapchild(display, base, (struct area *)0);

	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;	/* Already done */
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.27982 */
/* End of included file Mval.tmc.27982 */

/* Including from file error/EVal.mc */
static void t012(){

#undef	VALUE_ARG
#define	VALUE_ARG revert_to
#undef	VALUE_LIST
#define	VALUE_LIST revert_tovallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XSetInputFocus-12.(A)");
	report_assertion("When the value of revert_to is other than RevertToParent,");
	report_assertion("RevertToPointerRoot or RevertToNone, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XSetInputFocus(display, focus, revert_to, thetime);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XSetInputFocus-13.(A)");
	report_assertion("When a window argument does not name a valid Window,");
	report_assertion("PointerRoot or None, then a BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XSetInputFocus(display, focus, revert_to, thetime);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = focusstartup;
void	(*tet_cleanup)() = focuscleanup;
