/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* 
* SCCS:  @(#)  kysymdf.m Rel 1.13	    (7/17/92)
* 
* 	UniSoft Ltd., London, England
* 
* (C) Copyright 1991 X/Open Company Limited
* 
* All rights reserved.  No part of this source code may be reproduced,
* stored in a retrieval system, or transmitted, in any form or by any
* means, electronic, mechanical, photocopying, recording or otherwise,
* except as stated in the end-user licence agreement, without the prior
* permission of the copyright owners.
* 
* X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
* the UK and other countries.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_keysymdef	1
char    *TestName = "keysymdef";



int 	tet_thistest;

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion keysymdef-1.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_LATIN1 is defined, then the");
	report_assertion("symbols in the table which have code 1 are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_LATIN1.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code 1:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf1();

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion keysymdef-2.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_LATIN2 is defined, then the");
	report_assertion("symbols in the table which have code 2 are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_LATIN2.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code 2:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf2();

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion keysymdef-3.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_LATIN3 is defined, then the");
	report_assertion("symbols in the table which have code 3 are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_LATIN3.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code 3:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf3();

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion keysymdef-4.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_LATIN4 is defined, then the");
	report_assertion("symbols in the table which have code 4 are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_LATIN4.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code 4:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf4();

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion keysymdef-5.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_ARABIC is defined, then the");
	report_assertion("symbols in the table which have code A are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_ARABIC.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code A:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf5();

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion keysymdef-6.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_CYRILLIC is defined, then the");
	report_assertion("symbols in the table which have code C are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_CYRILLIC.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code C:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf6();

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion keysymdef-7.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_GREEK is defined, then the symbols");
	report_assertion("in the table which have code G are defined to have the");
	report_assertion("hexadecimal values given in the table.");

	report_strategy("Define symbol XK_GREEK.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code G:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf7();

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion keysymdef-8.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_HEBREW is defined, then the");
	report_assertion("symbols in the table which have code H are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_HEBREW.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code H:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf8();

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion keysymdef-9.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_KATAKANA is defined, then the");
	report_assertion("symbols in the table which have code K are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_KATAKANA.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code K:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf9();

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion keysymdef-10.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_APL is defined, then the symbols");
	report_assertion("in the table which have code L are defined to have the");
	report_assertion("hexadecimal values given in the table.");

	report_strategy("Define symbol XK_APL.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code L:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf10();

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion keysymdef-11.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_MISCELLANY is defined, then the");
	report_assertion("symbols in the table which have code M are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_MISCELLANY.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code M:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf11();

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion keysymdef-12.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_PUBLISHING is defined, then the");
	report_assertion("symbols in the table which have code P are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_PUBLISHING.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code P:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf12();

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion keysymdef-13.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_SPECIAL is defined, then the");
	report_assertion("symbols in the table which have code S are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_SPECIAL.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code S:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf13();

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion keysymdef-14.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included while");
	report_assertion("the feature test macro XK_TECHNICAL is defined, then the");
	report_assertion("symbols in the table which have code T are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Define symbol XK_TECHNICAL.");
	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table with code T:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf14();

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion keysymdef-15.(A)");
	report_assertion("When the header file <X11/keysymdef.h> is included, then");
	report_assertion("the symbols in the table are defined to have the hexadecimal");
	report_assertion("values given in the table.");

	report_strategy("Include header file <X11/keysymdef.h>");
	report_strategy("For each KeySym in table:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymdf0();
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
