/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetWMColormapWindows(display, w, colormap_windows_return, count_return)
 *   Display	*display;
 *   Window	w;
 *   Window	**colormap_windows_return;
 *   int	*count_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetWMColormapWindows	1
char    *TestName = "XGetWMColormapWindows";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XGetWMColormapWindows function
 */
static Display	*display;
static Window	w;
static Window	**colormap_windows_return;
static int	*count_return;


static int 	StatusReturn;

#include	"X11/Xatom.h"
Window	*window;
int	count;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(display);
	colormap_windows_return = &window;
	count_return = &count;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status		status;
XVisualInfo	*vp;
int		nwins = 7;
Window		pwins[7];
Window		*rwins = NULL;
Window		*wp;
int		rcnt = 0;
int		i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetWMColormapWindows-1.(A)");
	report_assertion("When the WM_COLORMAP_WINDOWS property is set on the window");
	report_assertion("w, the property is of type WINDOW, and is of format 32,");
	report_assertion("then a call to XGetWMColormapWindows returns the list of");
	report_assertion("window identifiers stored in the property, which can be");
	report_assertion("freed with XFree, in the colormap_windows_return argument");
	report_assertion("and the number of windows in the count_return argument and");
	report_assertion("returns non-zero.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Set the WM_COLORMAP_WINDOWS property using XSetWMColormapWindows.");
	report_strategy("Obtain the WM_COLORMAP_WINDOWS property using XGetWMColormapWindows.");
	report_strategy("Verify that the call did not return False.");
	report_strategy("Verify that the value of the property is correct.");
	report_strategy("Release the allocated memory using XFree.");

	tpstartup();
	setargs();
	for(i=0; i<nwins; i++)
		pwins[i] = (Window) i;

	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);
	
	XSetWMColormapWindows(display, w, pwins, nwins);

	colormap_windows_return = &rwins;
	count_return = &rcnt;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMColormapWindows(display, w, colormap_windows_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == False) {
		report("%s() returned False.", TestName);
		FAIL;
	} else
		CHECK;

	if(rcnt != nwins) {
		report("The number of elements set for the WM_COLORMAP_WINDOWS property was %d instead of %d", rcnt, nwins);
		FAIL;
	} else
		CHECK;

	if(rwins == (Window *) NULL) {
		report("The WM_COLORMAP_WINDOWS property had no associated value.");
		FAIL;
	} else {

		CHECK;
		for(i = 0, wp = rwins; i < nwins; i++, wp++)
			if( *wp != pwins[i]) {
				report("Element %d of the WM_COLORMAP_WINDOWS value was %lu instead of %lu", i+1, (long) *wp, (long) pwins[i]);
				FAIL;
			} else
				CHECK;

		XFree((char*)rwins);
	}

	CHECKPASS(nwins + 3);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.9711 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetWMColormapWindows-2.(B)");
	report_assertion("When the atom name (lqWM_COLORMAP_WINDOWS(rq cannot be");
	report_assertion("interned, then a call to XGetWMColormapWindows does not set");
	report_assertion("the colormap_windows_return or count_return arguments and");
	report_assertion("returns zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.9711 */

static void t003(){

Status		status;
Atom		xa_wm_colormap_windows;
Atom		*rat;
int		rcnt;
XVisualInfo	*vp;
Window		wdw;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetWMColormapWindows-3.(A)");
	report_assertion("When the WM_COLORMAP_WINDOWS property is not set on the");
	report_assertion("window w, or is not of type WINDOW, or is not of format 32,");
	report_assertion("then a call to XGetWMColormapWindows does not set the");
	report_assertion("colormap_windows_return or count_return arguments and");
	report_assertion("returns zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Insure that the name \"WM_COLOMAP_WINDOWS\" is interned using XSetWMColormapWindows.");
	report_strategy("Obtain the WM_COLORMAP_WINDOWS atom using XInternAtom.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Initialise the colormap_windows_return and count_return arguments.");
	report_strategy("Obtain the value of the WM_COLORMAP_WINDOWS property with XGetWMColormapWindows.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that colormap_windows_return and count_return arguments were unchanged.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_COLORMAP_WINDOWS property with format 8 and type WINDOW using XChangeProperty.");
	report_strategy("Initialise the colormap_windows_return and count_return arguments.");
	report_strategy("Obtain the value of the WM_COLORMAP_WINDOWS property with XGetWMColormapWindows.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that colormap_windows_return and count_return arguments were unchanged.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Initialise the colormap_windows_return and count_return arguments.");
	report_strategy("Set the WM_COLORMAP_WINDOWS property with format 32 type ATOM using XChangeProperty.");
	report_strategy("Obtain the value of the WM_COLORMAP_WINDOWS property with XGetWMColormapWindows.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that colormap_windows_return and count_return arguments were unchanged.");
	report_strategy("");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);

	colormap_windows_return = &rat;
	count_return = &rcnt;
	w = makewin(display, vp);
	
	if(XSetWMColormapWindows(display, w, &wdw, 1) == False) {
		delete("XSetWMColormapWindows() returned False.");
		return;
	} else
		CHECK;

	if( (xa_wm_colormap_windows = XInternAtom(display, "WM_COLORMAP_WINDOWS", True)) == None) {
		delete("The \"WM_COLORMAP_WINDOWS\" string was not interned.");
		return;
	} else
		CHECK;

	w = makewin(display, vp);

/* property unset */

	rat = (Atom *) -1;
	rcnt = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMColormapWindows(display, w, colormap_windows_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the WM_COLORMAP_WINDOWS property was not set.", TestName);
		FAIL;
	} else
		CHECK;

	if( rat != (Atom *) -1) {
		report("Atom list pointer variable was updated when the WM_COLORMAP_WINDOWS property was not set.");
		FAIL;
	} else
		CHECK;

	if( rcnt != -1) {
		report("Atom count variable was updated when the WM_COLORMAP_WINDOWS property was not set.");
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);

/* format 8 */
 	XChangeProperty(display, w, xa_wm_colormap_windows, XA_WINDOW, 8, PropModeReplace, (unsigned char *) &wdw, 1);

	rat = (Atom *) -1;
	rcnt = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMColormapWindows(display, w, colormap_windows_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the WM_COLORMAP_WINDOWS property had format 8.", TestName);
		FAIL;
	} else
		CHECK;

	if( rat != (Atom *) -1) {
		report("Atom list pointer variable was updated when the WM_COLORMAP_WINDOWS property had format 8.");
		FAIL;
	} else
		CHECK;

	if( rcnt != -1) {
		report("Atom count variable was updated when the WM_COLORMAP_WINDOWS property had format 8.");
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);

/* type  ATOM */
 	XChangeProperty(display, w, xa_wm_colormap_windows, XA_ATOM, 32, PropModeReplace, (unsigned char *) &wdw, 1);

	rat = (Atom *) -1;
	rcnt = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMColormapWindows(display, w, colormap_windows_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the WM_COLORMAP_WINDOWS property had type ATOM.", TestName);
		FAIL;
	} else
		CHECK;

	if( rat != (Atom *) -1) {
		report("Atom list pointer variable was updated when the WM_COLORMAP_WINDOWS property had type ATOM.");
		FAIL;
	} else
		CHECK;

	if( rcnt != -1) {
		report("Atom count variable was updated when the WM_COLORMAP_WINDOWS property had type ATOM.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(11);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetWMColormapWindows-4.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetWMColormapWindows(display, w, colormap_windows_return, count_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
