/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Cursor
 *   XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color)
 *   Display *display;
 *   Font source_font;
 *   Font mask_font;
 *   unsigned int source_char;
 *   unsigned int mask_char;
 *   XColor *foreground_color;
 *   XColor *background_color;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreateGlyphCursor	1
char    *TestName = "XCreateGlyphCursor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_FONT source_font


/*
 * Arguments to the XCreateGlyphCursor function
 */
static Display *display;
static Font source_font;
static Font mask_font;
static unsigned int source_char;
static unsigned int mask_char;
static XColor *foreground_color;
static XColor *background_color;


static char xtfont0[] = "xtfont0";	/* known font, used for source font */
static unsigned int good_char0 = 1;	/* known defined glyph in xtfont0 */
static unsigned int goodblank_char0 = 1;/* blank defined glyph in xtfont0  */
static unsigned int bad_char0 = 0;	/* undefined glyph xtfont0 */
static unsigned int bounding0 = 4;	/* diff. bounding box than good_char0 */

static char xtfont1[] = "xtfont1";	/* font sometimes used for mask font */
static unsigned int good_char1 = 1;	/* known defined glyph in xtfont1 */

static char xtfont6[] = "xtfont6";	/* known 2-byte matrix font */
static unsigned int good_char6 = 504;	/* known defined glyph in xtfont6 */

/*
 * mkcolor() -	return a pointer to a color structure.
 *		flag indicates whether or not color is foreground
 */
static XColor *
mkcolor(flag)
{
	static	XColor	fore;
	static	XColor	back;
	static	int	first = 1;

	if (first)
	{
		first = 0;

		fore.pixel = BlackPixel(display, DefaultScreen(display));
		XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &fore);
		back.pixel = WhitePixel(display, DefaultScreen(display));
		XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &back);
	}
	return(flag ? &fore : &back);
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	source_font = 0;
	mask_font = 0;
	source_char = 0;
	mask_char = 0;
	foreground_color = mkcolor(1);
	background_color = mkcolor(0);
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	source_font = ErrdefFont;
	mask_font = ErrdefFont;
}

static void t001(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreateGlyphCursor-1.(B)");
	report_assertion("A call to XCreateGlyphCursor creates a Cursor with colours");
	report_assertion("defined by foreground_color and background_color and returns");
	report_assertion("its ID.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with foreground colour W_FG and");
	report_strategy("background colour W_BG.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
	mask_font = source_font;
	source_char = good_char0;
	mask_char = good_char0;

/* Call XCreateGlyphCursor with foreground colour W_FG and */
/* background colour W_BG. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreateGlyphCursor-2.(B)");
	report_assertion("The source_char specifies the glyph in the source_font from");
	report_assertion("which the source bitmap is obtained.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with source_char set to");
	report_strategy("a known defined glyph in font xtfont0.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
	mask_font = source_font;
	source_char = good_char0;
	mask_char = good_char0;

/* Call XCreateGlyphCursor with source_char set to */
/* a known defined glyph in font xtfont0. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreateGlyphCursor-3.(B)");
	report_assertion("The mask_char specifies the glyph in the mask_font from");
	report_assertion("which the mask bitmap is obtained.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Load xtfont1 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with mask_char set to");
	report_strategy("a known defined glyph in font xtfont1.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
/* Load xtfont1 using XLoadFont. */
	mask_font = XLoadFont(display, xtfont1);

	source_char = good_char0;
	mask_char = good_char1;

/* Call XCreateGlyphCursor with mask_char set to */
/* a known defined glyph in font xtfont1. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreateGlyphCursor-4.(B)");
	report_assertion("When mask_char is zero, then all pixels of the source are");
	report_assertion("displayed.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Load xtfont1 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with mask_char set to zero.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
/* Load xtfont1 using XLoadFont. */
	mask_font = XLoadFont(display, xtfont1);

	source_char = good_char0;
	mask_char = 0;

/* Call XCreateGlyphCursor with mask_char set to zero. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreateGlyphCursor-5.(B)");
	report_assertion("When mask_char and mask_font are non-zero and a given bit");
	report_assertion("in the mask bitmap is 1, then the corresponding pixel of the");
	report_assertion("source is displayed.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Load xtfont1 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with mask_font set to non-zero and");
	report_strategy("mask_char corresponding to a glyph in mask_font which");
	report_strategy("has at least one bit set to non-zero.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
/* Load xtfont1 using XLoadFont. */
	mask_font = XLoadFont(display, xtfont1);

	source_char = good_char0;
	mask_char = good_char1;

/* Call XCreateGlyphCursor with mask_font set to non-zero and */
/* mask_char corresponding to a glyph in mask_font which */
/* has at least one bit set to non-zero. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCreateGlyphCursor-6.(B)");
	report_assertion("When mask_char and mask_font are non-zero and a given bit");
	report_assertion("in the mask bitmap is 0, then the corresponding pixel of the");
	report_assertion("source is not displayed.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Load xtfont1 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with mask_font set to non-zero and");
	report_strategy("mask_char corresponding to a glyph in mask_font which");
	report_strategy("has at least one bit set to zero.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
/* Load xtfont1 using XLoadFont. */
	mask_font = XLoadFont(display, xtfont1);

	source_char = good_char0;
	mask_char = good_char1;

/* Call XCreateGlyphCursor with mask_font set to non-zero and */
/* mask_char corresponding to a glyph in mask_font which */
/* has at least one bit set to zero. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCreateGlyphCursor-7.(B)");
	report_assertion("When a bit in the source bitmap is 1, then foreground_color");
	report_assertion("is used.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Load xtfont1 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with glyph with at least");
	report_strategy("one bit in the source bitmap set to 1.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
/* Load xtfont1 using XLoadFont. */
	mask_font = XLoadFont(display, xtfont1);

	source_char = good_char0;
	mask_char = good_char1;

/* Call XCreateGlyphCursor with glyph with at least */
/* one bit in the source bitmap set to 1. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XCreateGlyphCursor-8.(B)");
	report_assertion("When a bit in the source bitmap is 0, then background_color");
	report_assertion("is used.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Load xtfont1 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with source char corresponding to glyph which");
	report_strategy("has at least one bit set to zero.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
/* Load xtfont1 using XLoadFont. */
	mask_font = XLoadFont(display, xtfont1);

	source_char = goodblank_char0;
	mask_char = good_char1;

/* Call XCreateGlyphCursor with source char corresponding to glyph which */
/* has at least one bit set to zero. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XCreateGlyphCursor-9.(B)");
	report_assertion("When mask_char is non-zero, then its glyph origin is");
	report_assertion("positioned coincidently with that of source_char.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Load xtfont1 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with non-zero mask_char.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
/* Load xtfont1 using XLoadFont. */
	mask_font = XLoadFont(display, xtfont1);

	source_char = goodblank_char0;
	mask_char = good_char1;

/* Call XCreateGlyphCursor with non-zero mask_char. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.7750 */
static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XCreateGlyphCursor-10.(B)");
	report_assertion("The origin of the source_char defines the hotspot.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.7750 */

static void t011(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XCreateGlyphCursor-11.(B)");
	report_assertion("The source_char and mask_char need not have the same");
	report_assertion("bounding box metrics.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with source_char and mask_char");
	report_strategy("with different bounding boxes.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
	mask_font = source_font;
	source_char = good_char0;
	mask_char = bounding0;
/* Call XCreateGlyphCursor with source_char and mask_char */
/* with different bounding boxes. */

	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Cursor qstat;
XFontStruct *font_struct0;
XFontStruct *font_struct1;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XCreateGlyphCursor-12.(B)");
	report_assertion("When a cursor is created by a call to XCreateGlyphCursor,");
	report_assertion("and the source_font or mask_font argument is freed be a");
	report_assertion("subsequent call to XFreeFont, then the cursor is");
	report_assertion("unaffected.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load xtfont0 using XLoadQueryFont.");
	report_strategy("Verify that XLoadQueryFont returns non-zero.");
	report_strategy("Load xtfont1 using XLoadQueryFont.");
	report_strategy("Verify that XLoadQueryFont returns non-zero.");
	report_strategy("Call XCreateGlyphCursor with foreground colour W_FG and background colour W_BG.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");
	report_strategy("Call XFreeFont for xtfont0.");
	report_strategy("Call XFreeFont for xtfont1.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadQueryFont. */
	font_struct0 = XLoadQueryFont(display, xtfont0);
/* Verify that XLoadQueryFont returns non-zero. */
	if (font_struct0 == (XFontStruct *) 0) {
		delete("Could not load and query font \"%s\".", xtfont0);
		return;
	}
	else
		CHECK;
/* Load xtfont1 using XLoadQueryFont. */
	font_struct1 = XLoadQueryFont(display, xtfont1);
/* Verify that XLoadQueryFont returns non-zero. */
	if (font_struct1 == (XFontStruct *) 0) {
		delete("Could not load and query font \"%s\".", xtfont1);
		return;
	}
	else
		CHECK;
	source_font = font_struct0->fid;
	mask_font = font_struct1->fid;
	source_char = good_char0;
	mask_char = good_char1;
/* Call XCreateGlyphCursor with foreground colour W_FG and background colour W_BG. */

	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

/* Call XFreeFont for xtfont0. */
	XFreeFont(display, font_struct0);
/* Call XFreeFont for xtfont1. */
	XFreeFont(display, font_struct1);

	CHECKUNTESTED(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XCreateGlyphCursor-13.(B)");
	report_assertion("For 2-byte matrix fonts, the 16-bit value should be formed");
	report_assertion("with the byte1 member in the most significant byte and the");
	report_assertion("byte2 member in the least significant byte.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Load 2-byte matrix font xtfont6 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with foreground colour W_FG and");
	report_strategy("background colour W_BG.");
	report_strategy("Verify that XCreateGlyphCursor returns non-zero.");

	tpstartup();
	setargs();
/* Load 2-byte matrix font xtfont6 using XLoadFont. */
	source_font = XLoadFont(display, xtfont6);
	mask_font = source_font;
	source_char = good_char6;
	mask_char = good_char6;
/* Call XCreateGlyphCursor with foreground colour W_FG and */
/* background colour W_BG. */

	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreateGlyphCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XCreateGlyphCursor-14.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XCreateGlyphCursor-15.(A)");
	report_assertion("When the source_char argument is not a defined glyph in");
	report_assertion("source_font, then a BadValue error occurs.");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with a source_char which is");
	report_strategy("an undefined glyph in source_font.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
	mask_font = source_font;
	source_char = bad_char0;
	mask_char = good_char0;

/* Call XCreateGlyphCursor with a source_char which is */
/* an undefined glyph in source_font. */
	startcall(display);
	if (isdeleted())
		return;
	XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

/* Verify that a BadValue error occurs. */
	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XCreateGlyphCursor-16.(A)");
	report_assertion("When mask_font is non-zero and mask_char is non-zero and");
	report_assertion("not a defined glyph in mask_font, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Load xtfont0 using XLoadFont.");
	report_strategy("Call XCreateGlyphCursor with a mask_char which is");
	report_strategy("an undefined glyph in mask_font.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
/* Load xtfont0 using XLoadFont. */
	source_font = XLoadFont(display, xtfont0);
	mask_font = source_font;
	source_char = good_char0;
	mask_char = bad_char0;

/* Call XCreateGlyphCursor with a mask_char which is */
/* an undefined glyph in mask_font. */
	startcall(display);
	if (isdeleted())
		return;
	XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

/* Verify that a BadValue error occurs. */
	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EFon1.mc */
/* End of included file error/EFon1.mc */

/* Including from file error/EFon1.mc */
static void t017(){

int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XCreateGlyphCursor-17.(A)");
	report_assertion("When a font argument does not name a valid font, then a");
	report_assertion("BadFont error occurs.");

	report_strategy("Create a bad font by loading and freeing a font.");
	report_strategy("Call test function using bad font as the font argument.");
	report_strategy("Verify that a BadFont error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_FONT = (Font) badfont(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, background_color);
	endcall(display);
	if (geterr() != BadFont) {
		report("Got %s, Expecting BadFont", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadFont)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EFon1.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
