/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtCvtColorToPixel()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtCvtColorToPixel	1
char    *TestName = "XtCvtColorToPixel";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

/* Conversion arguments and results */
#if XT_X_RELEASE > 4
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* Color to Pixel specific */
Screen *screen;
Colormap colormap;
int colnum = 0;
XColor color;
Pixel res;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCvtColorToPixel-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtCvtColorToPixel(display, args, num_args, from,");
	report_assertion("to, converter_data) when to->addr is not NULL and to->size");
	report_assertion("is large enough to store an XtRPixel type shall convert the");
	report_assertion("XtRColor value specified in from to an XtRPixel type, store");
	report_assertion("it at the location specified by to->addr, set to->size to");
	report_assertion("the actual size of the converted data, and return True.");
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tccolpix1", "XtCvtColorToPixel");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Get a valid Color");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	fromVal.addr = (XtPointer) &colnum;
	fromVal.size = sizeof(int);
	toVal.addr = (XtPointer) &color;
	toVal.size = sizeof(XColor);
	status = XtCvtIntToColor(display,
			 &args[0],
			 &num_args,
			 &fromVal,
			 &toVal,
			 closure_ret);
	if (!status) {
		sprintf(ebuf, "ERROR: Could not get a Color");
		tet_infoline(ebuf);
		tet_result(TET_UNRESOLVED);
		exit(0);
	}
	tet_infoline("PREP: Set up required conversion args");
	num_args = 0;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = (XtPointer) &color;
	fromVal.size = sizeof(XColor);
	toVal.addr = (XtPointer) &res;
	toVal.size = sizeof(Pixel);
	status = XtCvtColorToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(True, status, "XtCvtColorToPixel return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11628 */
/* End of included file Mdefcode.tmc.11628 */

static void t002(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* Color to Pixel specific */
Screen *screen;
Colormap colormap;
int colnum = 0;
XColor color;
Pixel res;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCvtColorToPixel-2.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtColorToPixel(display, args, num_args, from, to,");
	report_assertion("converter_data) when to->addr is not NULL and to->size is");
	report_assertion("too small for an XtRPixel type shall not perform a");
	report_assertion("conversion, set the to->size field to the number of bytes");
	report_assertion("required to store the converted data, and return False.");
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tccolpix3", "XtCvtColorToPixel");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Get a valid Color");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	fromVal.addr = (XtPointer) &colnum;
	fromVal.size = sizeof(int);
	toVal.addr = (XtPointer) &color;
	toVal.size = sizeof(XColor);
	status = XtCvtIntToColor(display,
			 &args[0],
			 &num_args,
			 &fromVal,
			 &toVal,
			 closure_ret);
	if (!status) {
		sprintf(ebuf, "ERROR: Could not get a Color");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Set up required conversion args");
	num_args = 0;
	tet_infoline("TEST: Conversion fails");
	fromVal.addr = (XtPointer) &color;
	fromVal.size = sizeof(XColor);
	toVal.addr = (XtPointer) &res;
	toVal.size = 0;
	status = XtCvtColorToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(False, status, "XtCvtColorToPixel return valueconversion status");
	tet_infoline("TEST: to_size");
	if (toVal.size != sizeof(Pixel)) {
		sprintf(ebuf, "ERROR: to_size not set correctly, expected %d, received %d", sizeof(Pixel), toVal.size);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11628 */
/* End of included file Mdefcode.tmc.11628 */

static void t003(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* Color to Pixel specific */
Screen *screen;
Colormap colormap;
int colnum = 0;
XColor color;
Pixel res;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCvtColorToPixel-3.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtCvtColorToPixel(display, args, num_args, from,");
	report_assertion("to, converter_data) when to->addr is NULL shall convert the");
	report_assertion("XtRColor value specified in from to an XtRPixel type,");
	report_assertion("allocate space for the converted data, set to->addr to");
	report_assertion("specify the location of the data, set to->size to the size");
	report_assertion("of the coverted data, and return True.");
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tccolpix2", "XtCvtColorToPixel");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Get a valid Color");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	fromVal.addr = (XtPointer) &colnum;
	fromVal.size = sizeof(int);
	toVal.addr = (XtPointer) &color;
	toVal.size = sizeof(XColor);
	status = XtCvtIntToColor(display, &args[0], &num_args, &fromVal, &toVal, closure_ret);
	if (!status) {
		sprintf(ebuf, "ERROR: Could not get a Color");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Set up required conversion args");
	num_args = 0;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = (XtPointer) &color;
	fromVal.size = sizeof(XColor);
	toVal.addr = (XtPointer)0;
	toVal.size = 0;
	status = XtCvtColorToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(True, status, "XtCvtColorToPixel return valueconversion status");
	tet_infoline("TEST: to->addr and to->size are set");
	if (!toVal.addr) {
		sprintf(ebuf, "ERROR: to->addr was not set");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (toVal.size != sizeof(Pixel)) {
		sprintf(ebuf, "ERROR: to_size not set correctly, expected %d, received %d", sizeof(Pixel), toVal.size);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11628 */
/* End of included file Mdefcode.tmc.11628 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
