/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtCvtStringToFont()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

static void XtWMH_Proc(name_good, type_good, class_good, defaultp, params, num_params)
String name_good;
String type_good;
String class_good;
String defaultp;
String *params;
Cardinal *num_params;
{
	avs_set_event(1,1);
}


#define T_XtCvtStringToFont	1
char    *TestName = "XtCvtStringToFont";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to Font specific */
char *fontName = "fixed";
Font font;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCvtStringToFont-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtCvtStringToFont(display, args, num_args, from,");
	report_assertion("to, converter_data) when to->addr is not NULL and to->size");
	report_assertion("is large enough to store an XtRFont type shall convert the");
	report_assertion("string specified in from to an XtRFont type, store it at the");
	report_assertion("location specified by to->addr, set to->size to the actual");
	report_assertion("size of the converted data, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfont1", "XtCvtStringToFont");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	args[0].addr = (XtPointer )&display;
	args[0].size = sizeof(Display*);
	num_args = 1;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = fontName;
	fromVal.size = strlen(fontName)+1;
	toVal.addr = (XtPointer) &font;
	toVal.size = sizeof(Font);
	status = XtCvtStringToFont(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(True, status, "XtCvtStringToFont return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11671 */
/* End of included file Mdefcode.tmc.11671 */

static void t002(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to Font specific */
char *fontName = "fixed";
Font font;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCvtStringToFont-2.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToFont(display, args, num_args, from, to,");
	report_assertion("converter_data) when to->addr is not NULL and to->size is");
	report_assertion("too small for an XtRFont type shall not perform a");
	report_assertion("conversion, set the to->size field to the number of bytes");
	report_assertion("required to store the converted data, and return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfont2", "XtCvtStringToFont");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	args[0].addr = (XtPointer )&display;
	args[0].size = sizeof(Display*);
	num_args = 1;
	tet_infoline("TEST: Conversion fails");
	fromVal.addr = fontName;
	fromVal.size = strlen(fontName)+1;
	toVal.addr = (XtPointer) &font;
	toVal.size = 0;
	status = XtCvtStringToFont(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(False, status, "XtCvtStringToFont return value");
	tet_infoline("TEST: to_size");
	if (toVal.size != sizeof(Font)) {
		sprintf(ebuf, "ERROR: to_size not set correctly, expected %d, received %d", sizeof(Font), toVal.size);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11671 */
/* End of included file Mdefcode.tmc.11671 */

static void t003(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to Font specific */
char *fontName = "fixed";
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCvtStringToFont-3.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtCvtStringToFont(display, args, num_args, from,");
	report_assertion("to, converter_data) when to->addr is NULL shall convert the");
	report_assertion("string specified in from to an XtRFont type, allocate space");
	report_assertion("for the converted data, set to->addr to specify the location");
	report_assertion("of the data, set to->size to the size of the converted data,");
	report_assertion("and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfont3", "XtCvtStringToFont");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	args[0].addr = (XtPointer )&display;
	args[0].size = sizeof(Display*);
	num_args = 1;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = fontName;
	fromVal.size = strlen(fontName)+1;
	toVal.addr = (XtPointer)0;
	toVal.size = 0;
	status = XtCvtStringToFont(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(True, status, "XtCvtStringToFont return value");
	tet_infoline("TEST: to->addr and to->size are set");
	if (!toVal.addr) {
		sprintf(ebuf, "ERROR: to->addr was not set");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
	}
	if (toVal.size != sizeof(Font)) {
		sprintf(ebuf, "ERROR: to_size not set correctly, expected %d, received %d", sizeof(Font), toVal.size);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11671 */
/* End of included file Mdefcode.tmc.11671 */

static void t004(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to Font specific */
char *fontName = "fixed";
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtCvtStringToFont-4.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToFont(display, args, num_args, from, to,");
	report_assertion("converter_data) when args specifies an improper value shall");
	report_assertion("not perform a conversion, issue a warning message, and");
	report_assertion("return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfont4", "XtCvtStringToFont");
	avs_set_event(1,0);
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args incorrectly");
	num_args = 0;
	tet_infoline("TEST: Conversion fails");
	fromVal.addr = fontName;
	fromVal.size = strlen(fontName)+1;
	toVal.addr = (XtPointer)0;
	toVal.size = 0;
	status = XtCvtStringToFont(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(False, status, "conversion status");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler is called");
	status = avs_get_event(1);
	check_dec(1, status, "calls to warning handler count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11671 */
/* End of included file Mdefcode.tmc.11671 */

static void t005(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to Font specific */
char *fontName = XtDefaultFont;
Font font;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtCvtStringToFont-5.(C)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToFont(display, args, num_args,");
	report_assertion("from, to, converter_data) when from specifies the constant");
	report_assertion("XtDefaultFont and the application resource database contains");
	report_assertion("the resource name xtDefaultFont, class XtDefaultFont the");
	report_assertion("converted data shall specify the value of this resource.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfont5", "XtCvtStringToFont");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	args[0].addr = (XtPointer )&display;
	args[0].size = sizeof(Display*);
	num_args = 1;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = fontName;
	fromVal.size = strlen(fontName)+1;
	toVal.addr = (XtPointer) &font;
	toVal.size = sizeof(Font);
	status = XtCvtStringToFont(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(True, status, "XtCvtStringToFont return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11671 */
/* End of included file Mdefcode.tmc.11671 */

/* Including from file Mdefcode.tmc.11671 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtCvtStringToFont-6.(D)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToFont(display, args, num_args,");
	report_assertion("from, to, converter_data) when from specifies the constant");
	report_assertion("XtDefaultFont, the application resource database does not");
	report_assertion("contain the resource name xtDefaultFont, class");
	report_assertion("XtDefaultFont the converted data shall specify a font in an");
	report_assertion("implementation-defined ISO 8859-1 character set encoding.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11671 */

/* Including from file Mdefcode.tmc.11671 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtCvtStringToFont-7.(D)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToFont(display, args, num_args,");
	report_assertion("from, to, converter_data) when from specifies the constant");
	report_assertion("XtDefaultFont, the application resource database contains");
	report_assertion("the resource name xtDefaultFont, class XtDefaultFont, and");
	report_assertion("the font name specified in this resource cannot be");
	report_assertion("successfully opened the converted data shall specify a font");
	report_assertion("in an implementation-defined ISO 8859-1 character set");
	report_assertion("encoding.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11671 */

/* Including from file Mdefcode.tmc.11671 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtCvtStringToFont-8.(D)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToFont(display, args, num_args, from, to,");
	report_assertion("converter_data) when from specifies the constant");
	report_assertion("XtDefaultFont, the application resource database contains");
	report_assertion("the resource name xtDefaultFont, class XtDefaultFont, the");
	report_assertion("font name specified in this resource cannot be successfully");
	report_assertion("opened, and a font in an implementation-defined ISO 8859-1");
	report_assertion("character set encoding is not found shall issue a warning");
	report_assertion("message and return False.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11671 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
