/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtDisplayStringConversionWarning()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
#ifndef XavsRChar
#define XavsRChar "Char"
#endif

void XTWHMProc(name, type, class, defaultp, params, num_params)
String name;
String type;
String class;
String defaultp ;
String *params ;
Cardinal *num_params ;
{
String par[10];
int i;
char buffer[1000];

	avs_set_event(1,1);
	tet_infoline("TEST: Warning message contents");
	XtGetErrorDatabaseText(name, type, class, defaultp, buffer, 1000);
	if (params == NULL || num_params == NULL || *num_params == 0) {
		sprintf(ebuf, "%s", buffer);
	}
	else {
		i = *num_params;
		if (i > 10)
			i = 10;
		memcpy((char *)par, (char *)params, i*sizeof(String));
		memset(&par[i], 0, (10-i)*sizeof(String));
		sprintf(ebuf, buffer, par[0], par[1], par[2], par[3], par[4], par[5], par[6], par[7], par[8],par[9]);
	}
	check_str(ebuf, "Cannot convert string \"String\" to type Int", "Warning message");
}
void XTEHMProc(name, type, class, defaultp, params, num_params)
String name;
String type;
String class;
String defaultp ;
String *params ;
Cardinal *num_params ;
{
String par[10];
int i;
char buffer[1000];

	avs_set_event(2,1);
	tet_infoline("TEST: Warning message contents");
	XtGetErrorDatabaseText(name, type, class, defaultp, buffer, 1000);
	if (params == NULL || num_params == NULL || *num_params == 0) {
		sprintf(ebuf, "%s", buffer);
	}
	else {
		i = *num_params;
		if (i > 10)
			i = 10;
		memcpy((char *)par, (char *)params, i*sizeof(String));
		memset(&par[i], 0, (10-i)*sizeof(String));
		sprintf(ebuf, buffer, par[0], par[1], par[2], par[3], par[4], par[5], par[6], par[7], par[8],par[9]);
	}
	check_str(ebuf, "Cannot convert string \"Not a real type\" to type Int", "Warning message");
}


Boolean XtCVT_StringToChar(display, args, num_args, from_val, to_val, convertor_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *convertor_data;
{
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
	/*
	** Force a warning message
	*/
	XtDisplayStringConversionWarning(display, "String", "Int");
}

Boolean XtCVT_StringToChar2(display, args, num_args, from_val, to_val, convertor_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *convertor_data;
{
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
	/*
	** Force an error message
	*/
	XtDisplayStringConversionWarning(display, "Not a real type", "Int");
}


#define T_XtDisplayStringConversionWarning	1
char    *TestName = "XtDisplayStringConversionWarning";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
char line[80], buf[80];
FILE *stream;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtDisplayStringConversionWarning-1.(A)");
	report_assertion("A call to void XtDisplayStringConversionWarning(display,");
	report_assertion("from_value, to_type) when an entry exists in the error");
	report_assertion("database for the error name conversionError, type string,");
	report_assertion("and class XtToolkitError shall display the error message");
	report_assertion("text associated with that entry.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tdisplscw1", "XtDisplayStringConversionWarning");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Catch warning messages");
	XtAppSetWarningMsgHandler(app_ctext, XTWHMProc);
	tet_infoline("PREP: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll,
		 (XtDestructor)NULL);
	tet_infoline("PREP: Invoke resource converter XtCVT_StringToChar");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtCallConverter(display_good,
		XtCVT_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "Warning handler invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11694 */
/* End of included file Mdefcode.tmc.11694 */

static void t002(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
char line[80], buf[80];
FILE *stream;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtDisplayStringConversionWarning-2.(A)");
	report_assertion("On a call to void XtDisplayStringConversionWarning(display,");
	report_assertion("from_value, to_type) when an entry does not exist in the");
	report_assertion("error database for the error name conversionError, type");
	report_assertion("string, and class XtToolkitError it shall display the error");
	report_assertion("message: Cannot convert from_value to type to_type.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tdisplscw1", "XtDisplayStringConversionWarning");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Catch warning messages");
	XtAppSetWarningMsgHandler(app_ctext, XTEHMProc);
	tet_infoline("PREP: Register resource converter XtCVT_StringToChar2");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar2,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll,
		 (XtDestructor)NULL);
	tet_infoline("PREP: Invoke resource converter XtCVT_StringToChar2");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtCallConverter(display_good,
		XtCVT_StringToChar2,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler was invoked");
	invoked = avs_get_event(2);
	check_dec(1, invoked, "Warning handler invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11694 */
/* End of included file Mdefcode.tmc.11694 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
