/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtIsSubclass()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtIsSubclass	1
char    *TestName = "XtIsSubclass";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Boolean status;
Widget labelw_msg;
char *msg = "Test widget";
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtIsSubclass-1.(A)");
	report_assertion("A call to Boolean XtIsSubclass(w, widget_class) when the");
	report_assertion("class of the widget w is equal to or is a subclass of the");
	report_assertion("class widget_class shall return True.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tissbclass1", "XtIsSubclass");
	tet_infoline("PREP: Create test label widget in box widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1); 
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Check boxw2 widget is subclass of Composite widget");
	status = XtIsSubclass(boxw2, compositeWidgetClass);
	check_dec(True, status, "Return value");
   
	tet_infoline("TEST: Check labelw_msg widget is subclass of Core widget");
	status = XtIsSubclass(labelw_msg, coreWidgetClass);
	check_dec(True, status, "Return value");

	tet_infoline("TEST: Check labelw_msg widget is subclass of Label widget");
	status = XtIsSubclass(labelw_msg, labelWidgetClass);
	check_dec(True, status, "Return value");
   
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.10805 */
/* End of included file Mdefcode.tmc.10805 */

static void t002(){

Boolean status;
Widget labelw_msg;
char *msg = "Test widget";
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtIsSubclass-2.(A)");
	report_assertion("A call to Boolean XtIsSubclass(w, widget_class) when the");
	report_assertion("class of the widget w is neither equal to nor is a subclass");
	report_assertion("of the class widget_class shall return a value other than");
	report_assertion("True.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tissbclass2", "XtIsSubclass");
	tet_infoline("PREP: Create test label widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1); 
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Labelw_msg widget is NOT a subclass of commandWidgetClass");
	status = XtIsSubclass(labelw_msg, commandWidgetClass);
	check_not_dec(True, status, "Return value");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.10805 */
/* End of included file Mdefcode.tmc.10805 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
