/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   unsigned long
 *   XtGetSelectionTimeout()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtGetSelectionTimeout	1
char    *TestName = "XtGetSelectionTimeout";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

unsigned long value_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetSelectionTimeout-1.(A)");
	report_assertion("A call to unsigned long XtGetSelectionTimeout() shall");
	report_assertion("return the current selection timeout value for the default");
	report_assertion("application context in milliseconds.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtstmout1", "XtGetSelectionTimeout");
	tet_infoline("PREP: Set the selection time out value of 10000 milliseconds");
	XtSetSelectionTimeout((unsigned long )10000);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: SelectionTimeout is 10000 milliseconds");
	if ((value_good = XtGetSelectionTimeout()) != (unsigned long)10000) {
		sprintf(ebuf, "ERROR: Expected 10000 returned %ld", value_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12332 */
/* End of included file Mdefcode.tmc.12332 */

static void t002(){

unsigned long value_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetSelectionTimeout-2.(A)");
	report_assertion("When the initial timeout for the calling process has not");
	report_assertion("been set with the application resource selectionTimeout or");
	report_assertion("with a prior call to XtAppSetSelectionTimeout a call to");
	report_assertion("unsigned long XtGetSelectionTimeout() shall return a value");
	report_assertion("of 5000 milliseconds.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtstmout2", "XtGetSelectionTimeout");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Default selectionTimeout is 5000 milliseconds");
	if ((value_good = XtGetSelectionTimeout()) != (unsigned long)5000) {
		sprintf(ebuf, "ERROR: Expected 5000 returned %ld", value_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12332 */
/* End of included file Mdefcode.tmc.12332 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
