/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XChangeKeyboardControl(display, value_mask, values)
 *   Display	*display;
 *   unsigned long	value_mask;
 *   XKeyboardControl	*values;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangeKeyboardControl	1
char    *TestName = "XChangeKeyboardControl";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XChangeKeyboardControl function
 */
static Display	*display;
static unsigned long	value_mask;
static XKeyboardControl	*values;



/* For the argument */
static XKeyboardControl Kcval;



/*
 * Functions to save and restore the old keyboard control values across TP's
 * This also makes the current values available for use in tests.
 */
static XKeyboardState	oldstate;

static void
savekey()
{
	startup();
	if(Dsp)
		XGetKeyboardControl(Dsp, &oldstate);
}

static void
restorekey()
{
XKeyboardControl	ctr;
int 	led;
int 	key;
int 	minkc, maxkc;

	if(!Dsp) {
		cleanup();
		return;
	}

	/*
	 * It is not easy to restore a previously saved keyboard state.
	 */
	ctr.key_click_percent = oldstate.key_click_percent;
	ctr.bell_percent = oldstate.bell_percent;
	ctr.bell_pitch = oldstate.bell_pitch;
	ctr.bell_duration = oldstate.bell_duration;
	XChangeKeyboardControl(Dsp, KBKeyClickPercent|KBBellPercent|KBBellPitch|KBBellDuration, &ctr);

	ctr.auto_repeat_mode = oldstate.global_auto_repeat;
	XChangeKeyboardControl(Dsp, KBAutoRepeatMode, &ctr);
	XFlush(Dsp);

	for (led = 1; led <= 32; led++) {
		ctr.led = led;
		ctr.led_mode = (oldstate.led_mask & (1<<(led-1)))? LedModeOn:LedModeOff;
		XChangeKeyboardControl(Dsp, KBLed|KBLedMode, &ctr);
	}
	XFlush(Dsp);

	XDisplayKeycodes(Dsp, &minkc, &maxkc);
	for (key = minkc; key < maxkc; key++) {
		ctr.key = key;
		ctr.auto_repeat_mode = (oldstate.auto_repeats[key/8] & (1<<(key%8)))?
			AutoRepeatModeOn: AutoRepeatModeOff;
		XChangeKeyboardControl(Dsp, KBAutoRepeatMode|KBKey, &ctr);
		XFlush(Dsp);
	}
	cleanup();
}


#define	NLEDS	32	/* Number of leds that the protocol allows */
#define	NLEDMASK 0xffffffff	/* Mask of all leds */

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	value_mask = KBBellPercent;
	values = &Kcval;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	i;
XKeyboardState	newks;
static int 	vals[] = {
	0, 100, 50};
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangeKeyboardControl-1.(A)");
	report_assertion("If the key click loudness can be set: When the");
	report_assertion("KBKeyClickPercent bit is set in value_mask, then the volume");
	report_assertion("of the key click is set to the value specified in");
	report_assertion("key_click_percent, which is between 0, signifying off, and");
	report_assertion("100, signifying loud.");

	report_strategy("Set value_mask to KBKeyClickPercent.");
	report_strategy("Set key_click_percent value.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Get new keyboard state.");
	report_strategy("Verify that change occurred.");

	tpstartup();
	setargs();
	value_mask = KBKeyClickPercent;
	for (i = 0; i < NELEM(vals); i++) {

		values->key_click_percent = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XGetKeyboardControl(display, &newks);

		if (newks.key_click_percent == vals[i])
			CHECK;
		else {
			report("Key click percent was %d, expecting %d",
				newks.key_click_percent, vals[i]);
			FAIL;
		}
	}

	CHECKPASS(NELEM(vals));
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangeKeyboardControl-2.(B)");
	report_assertion("When the KBKeyClickPercent bit is set in value_mask and");
	report_assertion("key_click_percent is -1, then the default key click volume");
	report_assertion("is restored.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("Set value_mask to KBKeyClickPercent.");
	report_strategy("Set key_click_percent to -1.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("UNTESTED.");

	tpstartup();
	setargs();
	/*
	 * Since the default isn't specified there is no useful test that
	 * can be done.  However touch test with -1 to make sure that it
	 * doesn't blow up.
	 */
	value_mask = KBKeyClickPercent;
	values->key_click_percent = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardControl(display, value_mask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	report("There is no complete test method, but a touch test was performed");

	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	i;
XKeyboardState	newks;
static int 	vals[] = {
	0, 12, 20, 32, 47, 61, 100};
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangeKeyboardControl-3.(A)");
	report_assertion("If the bell loudness can be set: When the KBBellPercent bit");
	report_assertion("is set in value_mask, then the base volume of the bell is");
	report_assertion("set to the value specified in bell_percent, which is");
	report_assertion("between 0, signifying off, to 100, signifying loud.");

	report_strategy("Set value_mask to KBBellPercent.");
	report_strategy("Set bell_percent value.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Get new keyboard state.");
	report_strategy("Verify that change occurred.");

	tpstartup();
	setargs();
	value_mask = KBBellPercent;
	for (i = 0; i < NELEM(vals); i++) {

		values->bell_percent = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		/* Do the bell so that you can check audibly if you wish */
		XBell(display, 0);

		XGetKeyboardControl(display, &newks);

		if (newks.bell_percent == vals[i])
			CHECK;
		else {
			report("Key bell percent was %d, expecting %d",
				newks.key_click_percent, vals[i]);
			FAIL;
		}
	}

	/*
	 * Allow time for bells to happen before going on to next test.
	 */
	sleep(2);

	CHECKPASS(NELEM(vals));
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangeKeyboardControl-4.(B)");
	report_assertion("When the KBBellPercent bit is set in value_mask and");
	report_assertion("bell_percent is -1, then the base volume of the bell is set");
	report_assertion("to the default.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("Set value_mask to KBBellPercent.");
	report_strategy("Set bell_percent value to -1.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("UNTESTED.");

	tpstartup();
	setargs();
	value_mask = KBBellPercent;
	values->bell_percent = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardControl(display, value_mask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	report("There is no complete test method, but a touch test was performed");

	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	i;
XKeyboardState	newks;
static int 	vals[] = {
	440, 528, 400, 294, 300, 800, 640};
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangeKeyboardControl-5.(A)");
	report_assertion("If the bell pitch can be set: When the KBBellPitch bit is");
	report_assertion("set in value_mask, then the bell pitch in Hz is set to the");
	report_assertion("value specified in bell_pitch.");

	report_strategy("Set value_mask to KBBellPitch.");
	report_strategy("Set bell_pitch value.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Get new keyboard state.");
	report_strategy("Verify that change occurred.");

	tpstartup();
	setargs();
	value_mask = KBBellPitch;
	for (i = 0; i < NELEM(vals); i++) {

		values->bell_pitch = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XBell(Dsp, 0);

		XGetKeyboardControl(display, &newks);

		if (newks.bell_pitch == vals[i])
			CHECK;
		else {
			report("Bell pitch was %d, expecting %d",
				newks.bell_pitch, vals[i]);
			FAIL;
		}
	}

	/*
	 * Allow time for bells to happen before going on to next test.
	 */
	sleep(2);

	CHECKPASS(NELEM(vals));
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangeKeyboardControl-6.(B)");
	report_assertion("When the KBBellPitch bit is set in value_mask and");
	report_assertion("bell_pitch is -1, then the bell pitch is set to the default.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("Set value_mask to KBBellPitch.");
	report_strategy("Set bell_pitch value to -1.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("UNTESTED.");

	tpstartup();
	setargs();
	value_mask = KBBellPitch;
	values->bell_pitch = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardControl(display, value_mask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	report("There is no complete test method, but a touch test was performed");

	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	i;
XKeyboardState	newks;
static int 	vals[] = {
	10, 200, 600, 1000, 50};
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangeKeyboardControl-7.(A)");
	report_assertion("If the bell duration can be set: When the KBBellDuration");
	report_assertion("bit is set in value_mask, then the bell duration in");
	report_assertion("milliseconds is set to the value specified in bell_duration.");

	report_strategy("Set value_mask to KBBellDuration.");
	report_strategy("Set bell_duration value to -1.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Get new keyboard state.");
	report_strategy("Verify that change occurred.");

	tpstartup();
	setargs();
	value_mask = KBBellDuration;
	for (i = 0; i < NELEM(vals); i++) {

		values->bell_duration = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XBell(display, 0);
		XGetKeyboardControl(display, &newks);

		if (newks.bell_duration == vals[i])
			CHECK;
		else {
			report("Bell duration was %d, expecting %d",
				newks.bell_duration, vals[i]);
			FAIL;
		}
	}

	/*
	 * Allow time for bells to happen before going on to next test.
	 */
	sleep(5);

	CHECKPASS(NELEM(vals));
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XChangeKeyboardControl-8.(B)");
	report_assertion("When the KBBellDuration bit is set in value_mask and");
	report_assertion("bell_duration is -1, then the bell duration is set to the");
	report_assertion("default.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("Set value_mask to KBBellDuration.");
	report_strategy("Set bell_duration value to -1.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("UNTESTED.");

	tpstartup();
	setargs();
	value_mask = KBBellDuration;
	values->bell_duration = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardControl(display, value_mask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	report("There is no complete test method, but a touch test was performed");

	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	i, j;
unsigned long	onmask;
XKeyboardState	newks;
static int 	vals[] = {
	1, 3, 2, 4, 20, NLEDS};
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XChangeKeyboardControl-9.(A)");
	report_assertion("If LED s are supported: When both KBLed and KBLedMode are");
	report_assertion("specified, then the state of the LED specified by led is");
	report_assertion("changed to the state specified by led_mode.");

	report_strategy("Set value_mask to KBLed | KBLedMode.");
	report_strategy("Set led value.");
	report_strategy("Set led_mode value.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Get new keyboard state.");
	report_strategy("Verify that change occurred.");

	tpstartup();
	setargs();
	value_mask = KBLed|KBLedMode;
	onmask = 0;
	for (i = 1; i <= NLEDS; i++) {

		values->led_mode = LedModeOff;
		for (j = 0; j < NELEM(vals); j++) {
			if (vals[j] == i) {
				onmask |= (1L<<(i-1));
				values->led_mode = LedModeOn;
				break;
			}
		}
		values->led = i;

		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	}

	XGetKeyboardControl(display, &newks);

	if (newks.led_mask == onmask)
		CHECK;
	else {
		report("Led mask was %lx, expecting %lx",
			newks.led_mask, onmask);
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

XKeyboardState	newks;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XChangeKeyboardControl-10.(A)");
	report_assertion("If LED s are supported: When KBLedMode is specified and");
	report_assertion("KBLed is not specified, then the state of all LED s is");
	report_assertion("changed to the mode specified by led_mode.");

	report_strategy("Set value_mask to KBLed.");
	report_strategy("Set led_mode value.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Get new keyboard state.");
	report_strategy("Verify that change occurred.");

	tpstartup();
	setargs();
	value_mask = KBLedMode;
	values->led_mode = LedModeOn;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardControl(display, value_mask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetKeyboardControl(display, &newks);

	if (newks.led_mask == (unsigned)NLEDMASK)
		CHECK;
	else {
		report("All leds were not set to correct value");
		report("  led_mask was 0x%x, expecting 0x%x", newks.led_mask, NLEDMASK);
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	i;
int 	minkc, maxkc;
int 	onoff;
XKeyboardState	newks;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XChangeKeyboardControl-11.(A)");
	report_assertion("When KBKey and KBAutoRepeatMode are specified, then the");
	report_assertion("auto repeat mode of key is changed to the mode specified by");
	report_assertion("auto_repeat_mode.");

	report_strategy("Set value_mask to KBKey | KBAutoRepeatMode.");
	report_strategy("Get current value for key.");
	report_strategy("Set auto_repeat_mode to opposite of current value.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that auto_repeat_mode for the key has changed.");

	tpstartup();
	setargs();
#define	NKEYSTOTRY	12

	value_mask = KBKey | KBAutoRepeatMode;
	XDisplayKeycodes(display, &minkc, &maxkc);
	/*
	 * Try out the first few keycodes.
	 */
	for (i = minkc; i < minkc+NKEYSTOTRY; i++) {

		values->key = i;
		onoff = (oldstate.auto_repeats[i/8] & (1<<(i%8)))?
			AutoRepeatModeOff: AutoRepeatModeOn;
		values->auto_repeat_mode = onoff;
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XGetKeyboardControl(display, &newks);

		if (((newks.auto_repeats[i/8] & (1<<(i%8))) != 0) == ((onoff==AutoRepeatModeOn)? 1: 0))
			CHECK;
		else {
			report("Key auto repeat was not set to %d", onoff);
			FAIL;
		}
	}

	CHECKPASS(NKEYSTOTRY);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

XKeyboardState	newks;
int 	mode;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XChangeKeyboardControl-12.(A)");
	report_assertion("When KBAutoRepeatMode is specified and KBKey is not");
	report_assertion("specified, then the per-key settings are unchanged and the");
	report_assertion("auto repeat mode for the whole keyboard is changed to that");
	report_assertion("specified by auto_repeat_mode.");

	report_strategy("Set value_mask to KBAutoRepeatMode.");
	report_strategy("Get current global auto repeat mode.");
	report_strategy("Set auto_repeat_mode to different value.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that global auto repeat mode changed.");

	tpstartup();
	setargs();
	value_mask = KBAutoRepeatMode;
	mode = (oldstate.global_auto_repeat==AutoRepeatModeOn)?
		AutoRepeatModeOff: AutoRepeatModeOn;
	values->auto_repeat_mode = mode;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardControl(display, value_mask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetKeyboardControl(display, &newks);

	if (newks.global_auto_repeat == mode)
		CHECK;
	else {
		report("global auto repeat mode was not set");
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	i;
static	int 	badvals[] = {
	-100, -2, 101, 203};
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XChangeKeyboardControl-13.(A)");
	report_assertion("When the KBKeyClickPercent bit is set in value_mask and");
	report_assertion("key_click_percent is not between 0 and 100 inclusive or -1,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Set value_mask to KBKeyClickPercent.");
	report_strategy("Set out of range key_click_percent.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	value_mask = KBKeyClickPercent;
	for (i = 0; i < NELEM(badvals); i++) {
		values->key_click_percent = badvals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			report("No BadValue for key_click_percent of %d", badvals[i]);
			FAIL;
		}
	}
	CHECKPASS(NELEM(badvals));
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	i;
static	int 	badvals[] = {
	-100, -2, 101, 203};
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XChangeKeyboardControl-14.(A)");
	report_assertion("When the KBBellPercent bit is set in value_mask and");
	report_assertion("bell_percent is not between 0 and 100 inclusive or -1, then");
	report_assertion("a BadValue error occurs.");

	report_strategy("Set value_mask to KBBellPercent.");
	report_strategy("Set out of range bell_percent.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	value_mask = KBBellPercent;
	for (i = 0; i < NELEM(badvals); i++) {
		values->bell_percent = badvals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			report("No BadValue for bell_percent of %d", badvals[i]);
			FAIL;
		}
	}
	CHECKPASS(NELEM(badvals));
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int 	i;
static	int 	badvals[] = {
	-9012, -100, -2};
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XChangeKeyboardControl-15.(A)");
	report_assertion("When the KBBellPitch bit is set in value_mask and");
	report_assertion("bell_pitch is a negative number other than -1, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set value_mask to KBBellPitch.");
	report_strategy("Set out of range bell_pitch.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	value_mask = KBBellPitch;
	for (i = 0; i < NELEM(badvals); i++) {
		values->bell_pitch = badvals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			report("No BadValue for bell_pitch of %d", badvals[i]);
			FAIL;
		}
	}
	CHECKPASS(NELEM(badvals));
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int 	i;
static	int 	badvals[] = {
	-3456, -100, -2};
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XChangeKeyboardControl-16.(A)");
	report_assertion("When the KBBellDuration bit is set in value_mask and");
	report_assertion("bell_duration is a negative number other than -1, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set value_mask to KBBellDuration.");
	report_strategy("Set out of range bell_duration.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	value_mask = KBBellDuration;
	for (i = 0; i < NELEM(badvals); i++) {
		values->bell_duration = badvals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			report("No BadValue for bell_duration of %d", badvals[i]);
			FAIL;
		}
	}
	CHECKPASS(NELEM(badvals));
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XChangeKeyboardControl-17.(A)");
	report_assertion("When KBLed is specified and KBLedMode is not specified,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("Set value_mask to KBLed.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	value_mask = KBLed;
	values->led = 1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardControl(display, value_mask, values);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;	/* safe */
	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XChangeKeyboardControl-18.(A)");
	report_assertion("When KBKey is specified and KBAutoRepeatMode is not");
	report_assertion("specified, then a BadMatch error occurs.");

	report_strategy("Set value_mask to KBKey.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	value_mask = KBKey;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardControl(display, value_mask, values);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

static	int 	lmodes[] = {
	LedModeOn, LedModeOff};
long	badvals[NM_LEN];
int 	i, n;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XChangeKeyboardControl-19.(A)");
	report_assertion("When the value of led_mode is other than LedModeOn or");
	report_assertion("LedModeOff, then a BadValue error occurs.");

	report_strategy("Set value_mask to KBLedMode.");
	report_strategy("Set led_mode to other than LedModeOn or LedModeOff.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	n = notmember(lmodes, NELEM(lmodes), badvals);

	value_mask = KBLedMode;

	for (i = 0; i < n; i++) {
		values->led_mode = badvals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			report("A led_mode of %d did not give BadValue", badvals[i]);
		}
	}
	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

static	int 	armodes[] = {
	AutoRepeatModeOff, AutoRepeatModeOn, AutoRepeatModeDefault};
long	badvals[NM_LEN];
int 	i, n;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XChangeKeyboardControl-20.(A)");
	report_assertion("When the value of auto_repeat_mode is other than");
	report_assertion("AutoRepeatModeOff, AutoRepeatModeOn or");
	report_assertion("AutoRepeatModeDefault, then a BadValue error occurs.");

	report_strategy("Set value_mask to KBAutoRepeatMode.");
	report_strategy("Set auto_repeat_mode to invalid value.");
	report_strategy("Call XChangeKeyboardControl.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	n = notmember(armodes, NELEM(armodes), badvals);

	value_mask = KBAutoRepeatMode;

	for (i = 0; i < n; i++) {
		values->auto_repeat_mode = badvals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeKeyboardControl(display, value_mask, values);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			report("A auto_repeat_mode of %d did not give a BadValue", badvals[i]);
		}
	}
	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = savekey;
void	(*tet_cleanup)() = restorekey;
