/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XTextPropertyToStringList(text_prop, list_return, count_return)
 *   XTextProperty	*text_prop;
 *   char		***list_return;
 *   int		*count_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XTextPropertyToStringList	1
char    *TestName = "XTextPropertyToStringList";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XTextPropertyToStringList function
 */
static XTextProperty	*text_prop;
static char		***list_return;
static int		*count_return;


static int 	StatusReturn;

#include	"X11/Xatom.h"
char		*nullstr = "<NULL>";
char		*str1 = "Xtest_._.";
char		*str2 = "test._";
char		*str3 = "string._..";

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	text_prop = 0;
	list_return = 0;
	count_return = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status		status;
XTextProperty	tp;
char		**list;
int		count;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XTextPropertyToStringList-1.(A)");
	report_assertion("When the encoding component of the text_prop argument is");
	report_assertion("STRING and the format component is 8, then a call to");
	report_assertion("XTextPropertyToStringList returns in the list_string");
	report_assertion("argument the list of strings representing the null-separated");
	report_assertion("elements of the XTextProperty structure named by the");
	report_assertion("text_prop argument, returns in count_return the number of");
	report_assertion("strings and returns non-zero.");

	report_strategy("Create an XTextProperty structure.");
	report_strategy("Extract the strings using XTextPropertyToStringList.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Verify that the returned string count is correct.");
	report_strategy("Verify that the returned string list is correct.");

	tpstartup();
	setargs();
	tp.value = (unsigned char *) "Xtest_._.\0test._\0string._..";
	tp.nitems = 27;
	tp.format = 8;
	tp.encoding = XA_STRING;
	text_prop = &tp;
	list_return = &list;
	count_return = &count;
	startcall(Dsp);
	if (isdeleted())
		return;
	status = XTextPropertyToStringList(text_prop, list_return, count_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == 0) {
		delete("%s() returned zero.", TestName);
		return;
	} else
		CHECK;

	if(count != 3) {
		report("The returned number of strings was %d instead of %d", count, 3);
		FAIL;
	} else {
		CHECK;

		if(strcmp(list[0], str1) != 0 ||strcmp(list[1], str2) != 0 || strcmp(list[2], str3)) {
			report("The returned strings were:");
			report("\"%s\"", list[0] == NULL ? nullstr : list[0]);
			report("\"%s\"", list[1] == NULL ? nullstr : list[1]);
			report("\"%s\"", list[2] == NULL ? nullstr : list[2]);
			report("instead of:");
			report("\"%s\"", str1);
			report("\"%s\"", str2);
			report("\"%s\"", str3);
		} else
			CHECK;

	}

	XFreeStringList(list);
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status		status;
XTextProperty	tp;
char		**list = (char **) -1;
int		count = -1;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XTextPropertyToStringList-2.(A)");
	report_assertion("When the encoding component of the text_prop argument is");
	report_assertion("not STRING, then a call to XTextPropertyToStringList sets no");
	report_assertion("return values and returns zero.");

	report_strategy("Create an XTextProperty structure with encoding component set to XA_WINDOW.");
	report_strategy("Call XTextPropertyToStringList.");
	report_strategy("Verify that the call returned zero.");
	report_strategy("Verify that the list_return argument was not changed.");
	report_strategy("Verify that the count_return argument was not changed.");

	tpstartup();
	setargs();
	tp.value = (unsigned char *) "Xtest_._.\0test._\0string._..";
	tp.nitems = 27;
	tp.format = 8;
	tp.encoding = XA_WINDOW;
	text_prop = &tp;
	list_return = &list;
	count_return = &count;
	startcall(Dsp);
	if (isdeleted())
		return;
	status = XTextPropertyToStringList(text_prop, list_return, count_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != 0) {
		report("%s() did not return zero.", TestName);
		FAIL;
	} else
		CHECK;

	if(list != (char**) -1) {
		report("The list_return argument was altered.");
		FAIL;
	} else
		CHECK;

	if(count != -1) {
		report("The count_return argument was altered.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Status		status;
XTextProperty	tp;
char		**list = (char **) -1;
int		count = -1;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XTextPropertyToStringList-3.(A)");
	report_assertion("When the format component of the text_prop argument is not");
	report_assertion("8, then a call to XTextPropertyToStringList sets no return");
	report_assertion("values and returns zero.");

	report_strategy("Create an XTextProperty structure with format component set to 16.");
	report_strategy("Call XTextPropertyToStringList.");
	report_strategy("Verify that the call returned zero.");
	report_strategy("Verify that the list_return argument was not changed.");
	report_strategy("Verify that the count_return argument was not changed.");

	tpstartup();
	setargs();
	tp.value = (unsigned char *) "Xtest_._.\0test._\0string._..";
	tp.nitems = 27;
	tp.format = 16;
	tp.encoding = XA_STRING;
	text_prop = &tp;
	list_return = &list;
	count_return = &count;
	startcall(Dsp);
	if (isdeleted())
		return;
	status = XTextPropertyToStringList(text_prop, list_return, count_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != 0) {
		report("%s() did not return zero.", TestName);
		FAIL;
	} else
		CHECK;

	if(list != (char**) -1) {
		report("The list_return argument was altered.");
		FAIL;
	} else
		CHECK;

	if(count != -1) {
		report("The count_return argument was altered.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.9763 */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XTextPropertyToStringList-4.(B)");
	report_assertion("When insufficient memory is available for the list and its");
	report_assertion("elements, then a call to XTextPropertyToStringList sets no");
	report_assertion("return values and returns zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.9763 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
