.TH XQUARTZ 1 __vendorversion__
.SH NAME
Xquartz \- X window system server for Mac OSX
.SH SYNOPSIS
.B Xquartz
[ options ] ...
.SH DESCRIPTION
.I Xquartz
is the X window server for Mac OS X provided by Apple.
.I Xquartz
runs in parallel with Aqua in rootless mode. In rootless mode, the X
window system and Mac OS X share your display.  The root window of the
X11 display is the size of the screen and contains all the other
windows. The X11 root window is not displayed in rootless mode as Mac
OS X handles the desktop background.
.SH CUSTOMIZATION
\fIXquartz\fP can be customized using the defaults(1) command. The available options are:
.TP 8
.B defaults write __bundle_id_prefix__.X11 enable_fake_buttons -boolean true
Emulates a 3 button mouse using modifier keys. By default, the Command modifier
is used to emulate button 2 and Option is used for button 3. Thus, clicking the
first mouse button while holding down Command will act like clicking
button 2. Holding down Option will simulate button 3.
.TP 8
.B defaults write __bundle_id_prefix__.X11 fake_button2 \fImodifiers\fP
Change the modifier keys used to emulate the second mouse button. By default,
Command is used to emulate the second button. Any combination of the following
modifier names may be used: {l,r,}shift, {l,r,}option, {l,r,}control, {l,r,}command, fn
.TP 8
.B defaults write __bundle_id_prefix__.X11 fake_button3 \fImodifiers\fP
Change the modifier keys used to emulate the second mouse button. By default,
Command is used to emulate the second button. Any combination of the following
modifier names may be used: {l,r,}shift, {l,r,}option, {l,r,}control, {l,r,}command, fn
.TP 8
.B defaults write __bundle_id_prefix__.X11 fullscreen_hotkeys -boolean true
Enable OSX hotkeys while in fullscreen
.TP 8
.B defaults write __bundle_id_prefix__.X11 fullscreen_menu -boolean true
Show the OSX menu while in fullscreen
.TP 8
.B defaults write __bundle_id_prefix__.X11 no_quit_alert -boolean true
Disables the alert dialog displayed when attempting to quit X11.
.TP 8
.B defaults write __bundle_id_prefix__.X11 no_auth -boolean true
Stops the X server requiring that clients authenticate themselves when
connecting.  See Xsecurity(__miscmansuffix__).
.TP 8
.B defaults write __bundle_id_prefix__.X11 nolisten_tcp -boolean false
This will tell the server to listen and accept TCP connections.  Doing this without enabling
xauth is a possible security concern.  See Xsecurity(__miscmansuffix__).
.TP 8
.B defaults write __bundle_id_prefix__.X11 enable_system_beep -boolean false
Don't use the standard system beep effect for X11 alerts.
.TP 8
.B defaults write __bundle_id_prefix__.X11 enable_key_equivalents -boolean false
Disable menu keyboard equivalents while X11 windows are focused.
.TP 8
.B defaults write __bundle_id_prefix__.X11 depth \fIdepth\fP
Specifies the color bit depth to use. Currently only 15, and 24 color
bits per pixel are supported. If not specified, or a value of -1 is specified,
defaults to the depth of the main display.
.TP 8
.B defaults write __bundle_id_prefix__.X11 sync_keymap -boolean true
Keep the X11 keymap up to date with the OSX system keymap.
.TP 8
.B defaults write __bundle_id_prefix__.X11 option_sends_alt -boolean true
The Option key will send Alt_L and Alt_R instead of Mode_switch.
.TP 8
.B defaults write __bundle_id_prefix__.X11 sync_pasteboard -boolean true
Enable syncing between the OSX pasteboard and clipboard/primary selection buffers in X11.  This option needs to be true for any of the other pasteboard sync options to have an effect.
.TP 8
.B defaults write __bundle_id_prefix__.X11 sync_pasteboard_to_clipboard -boolean true
Update the X11 CLIPBOARD when the OSX NSPasteboard is updated.
.TP 8
.B defaults write __bundle_id_prefix__.X11 sync_pasteboard_to_primary -boolean true
Update the the X11 PRIMARY buffer when the OSX NSPasteboard is updated.
.TP 8
.B defaults write __bundle_id_prefix__.X11 sync_clipboard_to_pasteboard -boolean true
Update the the OSX NSPasteboard when the X11 CLIPBOARD is updated.  Note that enabling this option causes the clipboard synchronization to act as a clipboard manager in X11.  This makes it impossible to use xclipboard, klipper, or any other such clipboard managers.  If you want to use any of these programs, you must disable this option.
.TP 8
.B defaults write __bundle_id_prefix__.X11 sync_primary_on_select -boolean true
This option defaults to false and is provided only "for experts."  It updates the NSPasteboard whenever a new X11 selection is made (rather than requiring you to hit cmd-c to copy the selection to the NSPasteboard).  Since the X11 protocol does not require applications to send notification when they change selection, this might not work in all cases (if you run into this problem, try selecting text in another application first, then selecting the text you want).
.TP 8
.B defaults write __bundle_id_prefix__.X11 enable_test_extensions -boolean true
This option defaults to false and is only accessible through the command line.  Enable this option to turn on the DEC-XTRAP, RECORD, and XTEST extensions in the server.
.SH OPTIONS
.PP
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXquartz\fP accepts the following command line switches:
.TP 8
.B \-fakebuttons
Same as enable_fake_buttons above with value true.
.TP 8
.B \-nofakebuttons
Same as enable_fake_buttons above with value false.
.TP 8
.B "\-fakemouse2 \fImodifiers\fP"
Same as fake_button2 above.
.TP 8
.B "\-fakemouse3 \fImodifiers\fP"
Same as fake_button3 above.
.TP 8
.B "\-depth \fIdepth\fP"
Same as depth above.
.SH LOGGING
XQuartz stores a server log at ~/Library/Logs/X11.__bundle_id_prefix__.log which
is analogous to /var/log/Xorg.#.log on systems that use the XFree86 DDX such as
Linux, BSD, and Solaris.
.PP
In addition to this server log, XQuartz sends messages to syslogd(8) using
asl(3).  These logs are sent to the __bundle_id_prefix__ facility, and you can
watch these logs using the following syslog(1) command:
.TP 8
.B $ syslog -w -k Facility eq __bundle_id_prefix__
.PP
or you can include extra information such as the file, line, and function where the message originated:
.TP 8
.B $ syslog -w -F '$(Time) $(Sender) <$(Level)> $(File):$(Line) $(Function) :: $(Message)' -k Facility eq __bundle_id_prefix__
.PP
By default, XQaurtz sets an ASL mask which prevents it from logging messages
below the ASL_LEVEL_WARNING level (meaning almost all logging is done strictly
to the file referenced above).  To force XQuartz to send all log messages to
syslogd(8), you can adjust this mask using the following syslog(1) command:
.TP 8
.B $ syslog -c X11.bin -d
.PP
The stdout and stderr messages printed by any process launched by XQuartz will
be redirected to this syslog facility with a priority level of ASL_LEVEL_INFO
and ASL_LEVEL_NOTICE respectively.  In order to see these messages in syslog,
you will need to adjust XQuartz's asl mask as above but using -i or -n
instead of -d.
.SH "SEE ALSO"
.PP
X(__miscmansuffix__), Xserver(1), xdm(1), xinit(1), syslog(1), syslogd(8)
.PP
http://xquartz.macosforge.org
.PP
.SH AUTHORS / HISTORY
X11 was originally ported to Mac OS X Server by John Carmack.  Dave
Zarzycki used this as the basis of his port of XFree86 4.0 to Darwin 1.0.
Torrey T. Lyons improved and integrated this code into the XFree86
Project's mainline for the 4.0.2 release.
.PP
The following members of the XonX Team contributed to the following
releases (in alphabetical order):
.TP 4
XFree86 4.1.0:
.br
Rob Braun - Darwin x86 support
.br
Torrey T. Lyons - Project Lead
.br
Andreas Monitzer - Cocoa version of XDarwin front end
.br
Gregory Robert Parker - Original Quartz implementation
.br
Christoph Pfisterer - Dynamic shared X libraries
.br
Toshimitsu Tanaka - Japanese localization
.TP 4
XFree86 4.2.0:
.br
Rob Braun - Darwin x86 support
.br
Pablo Di Noto - Spanish localization
.br
Paul Edens - Dutch localization
.br
Kyunghwan Kim - Korean localization
.br
Mario Klebsch - Non-US keyboard support
.br
Torrey T. Lyons - Project Lead
.br
Andreas Monitzer - German localization
.br
Patrik Montgomery - Swedish localization
.br
Greg Parker - Rootless support
.br
Toshimitsu Tanaka - Japanese localization
.br
Olivier Verdier - French localization
.PP
Code from Apple's X11.app (which was based on XFree86 4.1) was integrated into X.org's XDarwin DDX by Ben Byer for xorg-server-1.2.
The XDarwin DDX was renamed Xquartz to more accurately reflect its state (the pure-darwin backend was removed).
Jeremy Huddleston took over as project lead and brought the project up to the X.org 1.4 server branch.
.PP
Jeremy Huddleston <jeremyhu@apple.com> is the current maintainer.
